package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PostRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdonbehalfby_value", 
    "_createdby_value", 
    "createdon", 
    "_postid_value", 
    "postlikeid", 
    "_organizationid_value", 
    "timezoneruleversionnumber", 
    "utcconversiontimezonecode"})
@JsonInclude(Include.NON_NULL)
public class Postlike extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.postlike";
    }

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_postid_value")
    protected UUID _postid_value;

    @JsonProperty("postlikeid")
    protected UUID postlikeid;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    protected Postlike() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPostlike() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _createdonbehalfby_value;
        private UUID _createdby_value;
        private OffsetDateTime createdon;
        private UUID _postid_value;
        private UUID postlikeid;
        private UUID _organizationid_value;
        private Integer timezoneruleversionnumber;
        private Integer utcconversiontimezonecode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _postid_value(UUID _postid_value) {
            this._postid_value = _postid_value;
            this.changedFields = changedFields.add("_postid_value");
            return this;
        }

        public Builder postlikeid(UUID postlikeid) {
            this.postlikeid = postlikeid;
            this.changedFields = changedFields.add("postlikeid");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Postlike build() {
            Postlike _x = new Postlike();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.postlike";
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._createdby_value = _createdby_value;
            _x.createdon = createdon;
            _x._postid_value = _postid_value;
            _x.postlikeid = postlikeid;
            _x._organizationid_value = _organizationid_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && postlikeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(postlikeid, UUID.class));
        }
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Postlike with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Postlike with_createdby_value(UUID _createdby_value) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Postlike withCreatedon(OffsetDateTime createdon) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_postid_value")
    @JsonIgnore
    public Optional<UUID> get_postid_value() {
        return Optional.ofNullable(_postid_value);
    }

    public Postlike with_postid_value(UUID _postid_value) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("_postid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x._postid_value = _postid_value;
        return _x;
    }

    @Property(name="postlikeid")
    @JsonIgnore
    public Optional<UUID> getPostlikeid() {
        return Optional.ofNullable(postlikeid);
    }

    public Postlike withPostlikeid(UUID postlikeid) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("postlikeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x.postlikeid = postlikeid;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Postlike with_organizationid_value(UUID _organizationid_value) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Postlike withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Postlike withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Postlike _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.postlike");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    public Postlike withUnmappedField(String name, Object value) {
        Postlike _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="postid")
    @JsonIgnore
    public PostRequest getPostid() {
        return new PostRequest(contextPath.addSegment("postid"), RequestHelper.getValue(unmappedFields, "postid"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Postlike patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Postlike _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Postlike put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Postlike _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Postlike _copy() {
        Postlike _x = new Postlike();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._createdby_value = _createdby_value;
        _x.createdon = createdon;
        _x._postid_value = _postid_value;
        _x.postlikeid = postlikeid;
        _x._organizationid_value = _organizationid_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Postlike[");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_postid_value=");
        b.append(this._postid_value);
        b.append(", ");
        b.append("postlikeid=");
        b.append(this.postlikeid);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
