package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.PlugintypestatisticCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.PluginassemblyRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "versionnumber", 
    "overwritetime", 
    "isworkflowactivity", 
    "_createdonbehalfby_value", 
    "workflowactivitygroupname", 
    "_organizationid_value", 
    "minor", 
    "_createdby_value", 
    "createdon", 
    "culture", 
    "version", 
    "ismanaged", 
    "plugintypeid", 
    "description", 
    "_modifiedby_value", 
    "_modifiedonbehalfby_value", 
    "friendlyname", 
    "customizationlevel", 
    "solutionid", 
    "plugintypeidunique", 
    "name", 
    "publickeytoken", 
    "componentstate", 
    "assemblyname", 
    "customworkflowactivityinfo", 
    "_pluginassemblyid_value", 
    "typename", 
    "modifiedon", 
    "major"})
@JsonInclude(Include.NON_NULL)
public class Plugintype extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.plugintype";
    }

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("isworkflowactivity")
    protected Boolean isworkflowactivity;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("workflowactivitygroupname")
    protected String workflowactivitygroupname;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("minor")
    protected Integer minor;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("culture")
    protected String culture;

    @JsonProperty("version")
    protected String version;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("plugintypeid")
    protected UUID plugintypeid;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("friendlyname")
    protected String friendlyname;

    @JsonProperty("customizationlevel")
    protected Integer customizationlevel;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("plugintypeidunique")
    protected UUID plugintypeidunique;

    @JsonProperty("name")
    protected String name;

    @JsonProperty("publickeytoken")
    protected String publickeytoken;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("assemblyname")
    protected String assemblyname;

    @JsonProperty("customworkflowactivityinfo")
    protected String customworkflowactivityinfo;

    @JsonProperty("_pluginassemblyid_value")
    protected UUID _pluginassemblyid_value;

    @JsonProperty("typename")
    protected String typename;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("major")
    protected Integer major;

    protected Plugintype() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderPlugintype() {
        return new Builder();
    }

    public static final class Builder {
        private Long versionnumber;
        private OffsetDateTime overwritetime;
        private Boolean isworkflowactivity;
        private UUID _createdonbehalfby_value;
        private String workflowactivitygroupname;
        private UUID _organizationid_value;
        private Integer minor;
        private UUID _createdby_value;
        private OffsetDateTime createdon;
        private String culture;
        private String version;
        private Boolean ismanaged;
        private UUID plugintypeid;
        private String description;
        private UUID _modifiedby_value;
        private UUID _modifiedonbehalfby_value;
        private String friendlyname;
        private Integer customizationlevel;
        private UUID solutionid;
        private UUID plugintypeidunique;
        private String name;
        private String publickeytoken;
        private Integer componentstate;
        private String assemblyname;
        private String customworkflowactivityinfo;
        private UUID _pluginassemblyid_value;
        private String typename;
        private OffsetDateTime modifiedon;
        private Integer major;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder isworkflowactivity(Boolean isworkflowactivity) {
            this.isworkflowactivity = isworkflowactivity;
            this.changedFields = changedFields.add("isworkflowactivity");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder workflowactivitygroupname(String workflowactivitygroupname) {
            this.workflowactivitygroupname = workflowactivitygroupname;
            this.changedFields = changedFields.add("workflowactivitygroupname");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder minor(Integer minor) {
            this.minor = minor;
            this.changedFields = changedFields.add("minor");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder culture(String culture) {
            this.culture = culture;
            this.changedFields = changedFields.add("culture");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder plugintypeid(UUID plugintypeid) {
            this.plugintypeid = plugintypeid;
            this.changedFields = changedFields.add("plugintypeid");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder friendlyname(String friendlyname) {
            this.friendlyname = friendlyname;
            this.changedFields = changedFields.add("friendlyname");
            return this;
        }

        public Builder customizationlevel(Integer customizationlevel) {
            this.customizationlevel = customizationlevel;
            this.changedFields = changedFields.add("customizationlevel");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder plugintypeidunique(UUID plugintypeidunique) {
            this.plugintypeidunique = plugintypeidunique;
            this.changedFields = changedFields.add("plugintypeidunique");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("name");
            return this;
        }

        public Builder publickeytoken(String publickeytoken) {
            this.publickeytoken = publickeytoken;
            this.changedFields = changedFields.add("publickeytoken");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder assemblyname(String assemblyname) {
            this.assemblyname = assemblyname;
            this.changedFields = changedFields.add("assemblyname");
            return this;
        }

        public Builder customworkflowactivityinfo(String customworkflowactivityinfo) {
            this.customworkflowactivityinfo = customworkflowactivityinfo;
            this.changedFields = changedFields.add("customworkflowactivityinfo");
            return this;
        }

        public Builder _pluginassemblyid_value(UUID _pluginassemblyid_value) {
            this._pluginassemblyid_value = _pluginassemblyid_value;
            this.changedFields = changedFields.add("_pluginassemblyid_value");
            return this;
        }

        public Builder typename(String typename) {
            this.typename = typename;
            this.changedFields = changedFields.add("typename");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder major(Integer major) {
            this.major = major;
            this.changedFields = changedFields.add("major");
            return this;
        }

        public Plugintype build() {
            Plugintype _x = new Plugintype();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.plugintype";
            _x.versionnumber = versionnumber;
            _x.overwritetime = overwritetime;
            _x.isworkflowactivity = isworkflowactivity;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.workflowactivitygroupname = workflowactivitygroupname;
            _x._organizationid_value = _organizationid_value;
            _x.minor = minor;
            _x._createdby_value = _createdby_value;
            _x.createdon = createdon;
            _x.culture = culture;
            _x.version = version;
            _x.ismanaged = ismanaged;
            _x.plugintypeid = plugintypeid;
            _x.description = description;
            _x._modifiedby_value = _modifiedby_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.friendlyname = friendlyname;
            _x.customizationlevel = customizationlevel;
            _x.solutionid = solutionid;
            _x.plugintypeidunique = plugintypeidunique;
            _x.name = name;
            _x.publickeytoken = publickeytoken;
            _x.componentstate = componentstate;
            _x.assemblyname = assemblyname;
            _x.customworkflowactivityinfo = customworkflowactivityinfo;
            _x._pluginassemblyid_value = _pluginassemblyid_value;
            _x.typename = typename;
            _x.modifiedon = modifiedon;
            _x.major = major;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && plugintypeid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(plugintypeid, UUID.class));
        }
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Plugintype withVersionnumber(Long versionnumber) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Plugintype withOverwritetime(OffsetDateTime overwritetime) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="isworkflowactivity")
    @JsonIgnore
    public Optional<Boolean> getIsworkflowactivity() {
        return Optional.ofNullable(isworkflowactivity);
    }

    public Plugintype withIsworkflowactivity(Boolean isworkflowactivity) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("isworkflowactivity");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.isworkflowactivity = isworkflowactivity;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Plugintype with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="workflowactivitygroupname")
    @JsonIgnore
    public Optional<String> getWorkflowactivitygroupname() {
        return Optional.ofNullable(workflowactivitygroupname);
    }

    public Plugintype withWorkflowactivitygroupname(String workflowactivitygroupname) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("workflowactivitygroupname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.workflowactivitygroupname = workflowactivitygroupname;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Plugintype with_organizationid_value(UUID _organizationid_value) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="minor")
    @JsonIgnore
    public Optional<Integer> getMinor() {
        return Optional.ofNullable(minor);
    }

    public Plugintype withMinor(Integer minor) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("minor");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.minor = minor;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Plugintype with_createdby_value(UUID _createdby_value) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Plugintype withCreatedon(OffsetDateTime createdon) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="culture")
    @JsonIgnore
    public Optional<String> getCulture() {
        return Optional.ofNullable(culture);
    }

    public Plugintype withCulture(String culture) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("culture");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.culture = culture;
        return _x;
    }

    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    public Plugintype withVersion(String version) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.version = version;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Plugintype withIsmanaged(Boolean ismanaged) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="plugintypeid")
    @JsonIgnore
    public Optional<UUID> getPlugintypeid() {
        return Optional.ofNullable(plugintypeid);
    }

    public Plugintype withPlugintypeid(UUID plugintypeid) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("plugintypeid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.plugintypeid = plugintypeid;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Plugintype withDescription(String description) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.description = description;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Plugintype with_modifiedby_value(UUID _modifiedby_value) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Plugintype with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="friendlyname")
    @JsonIgnore
    public Optional<String> getFriendlyname() {
        return Optional.ofNullable(friendlyname);
    }

    public Plugintype withFriendlyname(String friendlyname) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("friendlyname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.friendlyname = friendlyname;
        return _x;
    }

    @Property(name="customizationlevel")
    @JsonIgnore
    public Optional<Integer> getCustomizationlevel() {
        return Optional.ofNullable(customizationlevel);
    }

    public Plugintype withCustomizationlevel(Integer customizationlevel) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("customizationlevel");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.customizationlevel = customizationlevel;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Plugintype withSolutionid(UUID solutionid) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="plugintypeidunique")
    @JsonIgnore
    public Optional<UUID> getPlugintypeidunique() {
        return Optional.ofNullable(plugintypeidunique);
    }

    public Plugintype withPlugintypeidunique(UUID plugintypeidunique) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("plugintypeidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.plugintypeidunique = plugintypeidunique;
        return _x;
    }

    @Property(name="name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public Plugintype withName(String name) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.name = name;
        return _x;
    }

    @Property(name="publickeytoken")
    @JsonIgnore
    public Optional<String> getPublickeytoken() {
        return Optional.ofNullable(publickeytoken);
    }

    public Plugintype withPublickeytoken(String publickeytoken) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("publickeytoken");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.publickeytoken = publickeytoken;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Plugintype withComponentstate(Integer componentstate) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="assemblyname")
    @JsonIgnore
    public Optional<String> getAssemblyname() {
        return Optional.ofNullable(assemblyname);
    }

    public Plugintype withAssemblyname(String assemblyname) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("assemblyname");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.assemblyname = assemblyname;
        return _x;
    }

    @Property(name="customworkflowactivityinfo")
    @JsonIgnore
    public Optional<String> getCustomworkflowactivityinfo() {
        return Optional.ofNullable(customworkflowactivityinfo);
    }

    public Plugintype withCustomworkflowactivityinfo(String customworkflowactivityinfo) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("customworkflowactivityinfo");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.customworkflowactivityinfo = customworkflowactivityinfo;
        return _x;
    }

    @Property(name="_pluginassemblyid_value")
    @JsonIgnore
    public Optional<UUID> get_pluginassemblyid_value() {
        return Optional.ofNullable(_pluginassemblyid_value);
    }

    public Plugintype with_pluginassemblyid_value(UUID _pluginassemblyid_value) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("_pluginassemblyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x._pluginassemblyid_value = _pluginassemblyid_value;
        return _x;
    }

    @Property(name="typename")
    @JsonIgnore
    public Optional<String> getTypename() {
        return Optional.ofNullable(typename);
    }

    public Plugintype withTypename(String typename) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("typename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.typename = typename;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Plugintype withModifiedon(OffsetDateTime modifiedon) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="major")
    @JsonIgnore
    public Optional<Integer> getMajor() {
        return Optional.ofNullable(major);
    }

    public Plugintype withMajor(Integer major) {
        Plugintype _x = _copy();
        _x.changedFields = changedFields.add("major");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.plugintype");
        _x.major = major;
        return _x;
    }

    public Plugintype withUnmappedField(String name, Object value) {
        Plugintype _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="pluginassemblyid")
    @JsonIgnore
    public PluginassemblyRequest getPluginassemblyid() {
        return new PluginassemblyRequest(contextPath.addSegment("pluginassemblyid"), RequestHelper.getValue(unmappedFields, "pluginassemblyid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="organizationid")
    @JsonIgnore
    public OrganizationRequest getOrganizationid() {
        return new OrganizationRequest(contextPath.addSegment("organizationid"), RequestHelper.getValue(unmappedFields, "organizationid"));
    }

    @NavigationProperty(name="plugintypeid_sdkmessageprocessingstep")
    @JsonIgnore
    public SdkmessageprocessingstepCollectionRequest getPlugintypeid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("plugintypeid_sdkmessageprocessingstep"), RequestHelper.getValue(unmappedFields, "plugintypeid_sdkmessageprocessingstep"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="plugintype_sdkmessageprocessingstep")
    @JsonIgnore
    public SdkmessageprocessingstepCollectionRequest getPlugintype_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("plugintype_sdkmessageprocessingstep"), RequestHelper.getValue(unmappedFields, "plugintype_sdkmessageprocessingstep"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="plugintype_plugintypestatistic")
    @JsonIgnore
    public PlugintypestatisticCollectionRequest getPlugintype_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("plugintype_plugintypestatistic"), RequestHelper.getValue(unmappedFields, "plugintype_plugintypestatistic"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Plugintype patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Plugintype _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Plugintype put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Plugintype _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Plugintype _copy() {
        Plugintype _x = new Plugintype();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.versionnumber = versionnumber;
        _x.overwritetime = overwritetime;
        _x.isworkflowactivity = isworkflowactivity;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.workflowactivitygroupname = workflowactivitygroupname;
        _x._organizationid_value = _organizationid_value;
        _x.minor = minor;
        _x._createdby_value = _createdby_value;
        _x.createdon = createdon;
        _x.culture = culture;
        _x.version = version;
        _x.ismanaged = ismanaged;
        _x.plugintypeid = plugintypeid;
        _x.description = description;
        _x._modifiedby_value = _modifiedby_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.friendlyname = friendlyname;
        _x.customizationlevel = customizationlevel;
        _x.solutionid = solutionid;
        _x.plugintypeidunique = plugintypeidunique;
        _x.name = name;
        _x.publickeytoken = publickeytoken;
        _x.componentstate = componentstate;
        _x.assemblyname = assemblyname;
        _x.customworkflowactivityinfo = customworkflowactivityinfo;
        _x._pluginassemblyid_value = _pluginassemblyid_value;
        _x.typename = typename;
        _x.modifiedon = modifiedon;
        _x.major = major;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Plugintype[");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("isworkflowactivity=");
        b.append(this.isworkflowactivity);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("workflowactivitygroupname=");
        b.append(this.workflowactivitygroupname);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("minor=");
        b.append(this.minor);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("culture=");
        b.append(this.culture);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("plugintypeid=");
        b.append(this.plugintypeid);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("friendlyname=");
        b.append(this.friendlyname);
        b.append(", ");
        b.append("customizationlevel=");
        b.append(this.customizationlevel);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("plugintypeidunique=");
        b.append(this.plugintypeidunique);
        b.append(", ");
        b.append("name=");
        b.append(this.name);
        b.append(", ");
        b.append("publickeytoken=");
        b.append(this.publickeytoken);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("assemblyname=");
        b.append(this.assemblyname);
        b.append(", ");
        b.append("customworkflowactivityinfo=");
        b.append(this.customworkflowactivityinfo);
        b.append(", ");
        b.append("_pluginassemblyid_value=");
        b.append(this._pluginassemblyid_value);
        b.append(", ");
        b.append("typename=");
        b.append(this.typename);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("major=");
        b.append(this.major);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
