package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_ismanaged", 
    "msdyn_endtime", 
    "msdyn_correlationid", 
    "msdyn_status", 
    "msdyn_activityid", 
    "msdyn_totaltime", 
    "msdyn_solutionid", 
    "msdyn_operation", 
    "msdyn_starttime", 
    "msdyn_exceptionmessage", 
    "msdyn_result", 
    "msdyn_packagename", 
    "msdyn_publishername", 
    "msdyn_ispatch", 
    "msdyn_publisherid", 
    "msdyn_isoverwritecustomizations", 
    "msdyn_suboperation", 
    "msdyn_packageversion", 
    "msdyn_exceptionstack", 
    "msdyn_solutionversion", 
    "msdyn_name", 
    "msdyn_errorcode", 
    "msdyn_solutionhistoryid"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_solutionhistory extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_solutionhistory";
    }

    @JsonProperty("msdyn_ismanaged")
    protected Boolean msdyn_ismanaged;

    @JsonProperty("msdyn_endtime")
    protected OffsetDateTime msdyn_endtime;

    @JsonProperty("msdyn_correlationid")
    protected String msdyn_correlationid;

    @JsonProperty("msdyn_status")
    protected Integer msdyn_status;

    @JsonProperty("msdyn_activityid")
    protected String msdyn_activityid;

    @JsonProperty("msdyn_totaltime")
    protected Integer msdyn_totaltime;

    @JsonProperty("msdyn_solutionid")
    protected String msdyn_solutionid;

    @JsonProperty("msdyn_operation")
    protected Integer msdyn_operation;

    @JsonProperty("msdyn_starttime")
    protected OffsetDateTime msdyn_starttime;

    @JsonProperty("msdyn_exceptionmessage")
    protected String msdyn_exceptionmessage;

    @JsonProperty("msdyn_result")
    protected Boolean msdyn_result;

    @JsonProperty("msdyn_packagename")
    protected String msdyn_packagename;

    @JsonProperty("msdyn_publishername")
    protected String msdyn_publishername;

    @JsonProperty("msdyn_ispatch")
    protected Boolean msdyn_ispatch;

    @JsonProperty("msdyn_publisherid")
    protected String msdyn_publisherid;

    @JsonProperty("msdyn_isoverwritecustomizations")
    protected Boolean msdyn_isoverwritecustomizations;

    @JsonProperty("msdyn_suboperation")
    protected Integer msdyn_suboperation;

    @JsonProperty("msdyn_packageversion")
    protected String msdyn_packageversion;

    @JsonProperty("msdyn_exceptionstack")
    protected String msdyn_exceptionstack;

    @JsonProperty("msdyn_solutionversion")
    protected String msdyn_solutionversion;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_errorcode")
    protected String msdyn_errorcode;

    @JsonProperty("msdyn_solutionhistoryid")
    protected UUID msdyn_solutionhistoryid;

    protected Msdyn_solutionhistory() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_solutionhistory() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean msdyn_ismanaged;
        private OffsetDateTime msdyn_endtime;
        private String msdyn_correlationid;
        private Integer msdyn_status;
        private String msdyn_activityid;
        private Integer msdyn_totaltime;
        private String msdyn_solutionid;
        private Integer msdyn_operation;
        private OffsetDateTime msdyn_starttime;
        private String msdyn_exceptionmessage;
        private Boolean msdyn_result;
        private String msdyn_packagename;
        private String msdyn_publishername;
        private Boolean msdyn_ispatch;
        private String msdyn_publisherid;
        private Boolean msdyn_isoverwritecustomizations;
        private Integer msdyn_suboperation;
        private String msdyn_packageversion;
        private String msdyn_exceptionstack;
        private String msdyn_solutionversion;
        private String msdyn_name;
        private String msdyn_errorcode;
        private UUID msdyn_solutionhistoryid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_ismanaged(Boolean msdyn_ismanaged) {
            this.msdyn_ismanaged = msdyn_ismanaged;
            this.changedFields = changedFields.add("msdyn_ismanaged");
            return this;
        }

        public Builder msdyn_endtime(OffsetDateTime msdyn_endtime) {
            this.msdyn_endtime = msdyn_endtime;
            this.changedFields = changedFields.add("msdyn_endtime");
            return this;
        }

        public Builder msdyn_correlationid(String msdyn_correlationid) {
            this.msdyn_correlationid = msdyn_correlationid;
            this.changedFields = changedFields.add("msdyn_correlationid");
            return this;
        }

        public Builder msdyn_status(Integer msdyn_status) {
            this.msdyn_status = msdyn_status;
            this.changedFields = changedFields.add("msdyn_status");
            return this;
        }

        public Builder msdyn_activityid(String msdyn_activityid) {
            this.msdyn_activityid = msdyn_activityid;
            this.changedFields = changedFields.add("msdyn_activityid");
            return this;
        }

        public Builder msdyn_totaltime(Integer msdyn_totaltime) {
            this.msdyn_totaltime = msdyn_totaltime;
            this.changedFields = changedFields.add("msdyn_totaltime");
            return this;
        }

        public Builder msdyn_solutionid(String msdyn_solutionid) {
            this.msdyn_solutionid = msdyn_solutionid;
            this.changedFields = changedFields.add("msdyn_solutionid");
            return this;
        }

        public Builder msdyn_operation(Integer msdyn_operation) {
            this.msdyn_operation = msdyn_operation;
            this.changedFields = changedFields.add("msdyn_operation");
            return this;
        }

        public Builder msdyn_starttime(OffsetDateTime msdyn_starttime) {
            this.msdyn_starttime = msdyn_starttime;
            this.changedFields = changedFields.add("msdyn_starttime");
            return this;
        }

        public Builder msdyn_exceptionmessage(String msdyn_exceptionmessage) {
            this.msdyn_exceptionmessage = msdyn_exceptionmessage;
            this.changedFields = changedFields.add("msdyn_exceptionmessage");
            return this;
        }

        public Builder msdyn_result(Boolean msdyn_result) {
            this.msdyn_result = msdyn_result;
            this.changedFields = changedFields.add("msdyn_result");
            return this;
        }

        public Builder msdyn_packagename(String msdyn_packagename) {
            this.msdyn_packagename = msdyn_packagename;
            this.changedFields = changedFields.add("msdyn_packagename");
            return this;
        }

        public Builder msdyn_publishername(String msdyn_publishername) {
            this.msdyn_publishername = msdyn_publishername;
            this.changedFields = changedFields.add("msdyn_publishername");
            return this;
        }

        public Builder msdyn_ispatch(Boolean msdyn_ispatch) {
            this.msdyn_ispatch = msdyn_ispatch;
            this.changedFields = changedFields.add("msdyn_ispatch");
            return this;
        }

        public Builder msdyn_publisherid(String msdyn_publisherid) {
            this.msdyn_publisherid = msdyn_publisherid;
            this.changedFields = changedFields.add("msdyn_publisherid");
            return this;
        }

        public Builder msdyn_isoverwritecustomizations(Boolean msdyn_isoverwritecustomizations) {
            this.msdyn_isoverwritecustomizations = msdyn_isoverwritecustomizations;
            this.changedFields = changedFields.add("msdyn_isoverwritecustomizations");
            return this;
        }

        public Builder msdyn_suboperation(Integer msdyn_suboperation) {
            this.msdyn_suboperation = msdyn_suboperation;
            this.changedFields = changedFields.add("msdyn_suboperation");
            return this;
        }

        public Builder msdyn_packageversion(String msdyn_packageversion) {
            this.msdyn_packageversion = msdyn_packageversion;
            this.changedFields = changedFields.add("msdyn_packageversion");
            return this;
        }

        public Builder msdyn_exceptionstack(String msdyn_exceptionstack) {
            this.msdyn_exceptionstack = msdyn_exceptionstack;
            this.changedFields = changedFields.add("msdyn_exceptionstack");
            return this;
        }

        public Builder msdyn_solutionversion(String msdyn_solutionversion) {
            this.msdyn_solutionversion = msdyn_solutionversion;
            this.changedFields = changedFields.add("msdyn_solutionversion");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_errorcode(String msdyn_errorcode) {
            this.msdyn_errorcode = msdyn_errorcode;
            this.changedFields = changedFields.add("msdyn_errorcode");
            return this;
        }

        public Builder msdyn_solutionhistoryid(UUID msdyn_solutionhistoryid) {
            this.msdyn_solutionhistoryid = msdyn_solutionhistoryid;
            this.changedFields = changedFields.add("msdyn_solutionhistoryid");
            return this;
        }

        public Msdyn_solutionhistory build() {
            Msdyn_solutionhistory _x = new Msdyn_solutionhistory();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_solutionhistory";
            _x.msdyn_ismanaged = msdyn_ismanaged;
            _x.msdyn_endtime = msdyn_endtime;
            _x.msdyn_correlationid = msdyn_correlationid;
            _x.msdyn_status = msdyn_status;
            _x.msdyn_activityid = msdyn_activityid;
            _x.msdyn_totaltime = msdyn_totaltime;
            _x.msdyn_solutionid = msdyn_solutionid;
            _x.msdyn_operation = msdyn_operation;
            _x.msdyn_starttime = msdyn_starttime;
            _x.msdyn_exceptionmessage = msdyn_exceptionmessage;
            _x.msdyn_result = msdyn_result;
            _x.msdyn_packagename = msdyn_packagename;
            _x.msdyn_publishername = msdyn_publishername;
            _x.msdyn_ispatch = msdyn_ispatch;
            _x.msdyn_publisherid = msdyn_publisherid;
            _x.msdyn_isoverwritecustomizations = msdyn_isoverwritecustomizations;
            _x.msdyn_suboperation = msdyn_suboperation;
            _x.msdyn_packageversion = msdyn_packageversion;
            _x.msdyn_exceptionstack = msdyn_exceptionstack;
            _x.msdyn_solutionversion = msdyn_solutionversion;
            _x.msdyn_name = msdyn_name;
            _x.msdyn_errorcode = msdyn_errorcode;
            _x.msdyn_solutionhistoryid = msdyn_solutionhistoryid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_solutionhistoryid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_solutionhistoryid, UUID.class));
        }
    }

    @Property(name="msdyn_ismanaged")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_ismanaged() {
        return Optional.ofNullable(msdyn_ismanaged);
    }

    public Msdyn_solutionhistory withMsdyn_ismanaged(Boolean msdyn_ismanaged) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_ismanaged = msdyn_ismanaged;
        return _x;
    }

    @Property(name="msdyn_endtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMsdyn_endtime() {
        return Optional.ofNullable(msdyn_endtime);
    }

    public Msdyn_solutionhistory withMsdyn_endtime(OffsetDateTime msdyn_endtime) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_endtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_endtime = msdyn_endtime;
        return _x;
    }

    @Property(name="msdyn_correlationid")
    @JsonIgnore
    public Optional<String> getMsdyn_correlationid() {
        return Optional.ofNullable(msdyn_correlationid);
    }

    public Msdyn_solutionhistory withMsdyn_correlationid(String msdyn_correlationid) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_correlationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_correlationid = msdyn_correlationid;
        return _x;
    }

    @Property(name="msdyn_status")
    @JsonIgnore
    public Optional<Integer> getMsdyn_status() {
        return Optional.ofNullable(msdyn_status);
    }

    public Msdyn_solutionhistory withMsdyn_status(Integer msdyn_status) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_status");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_status = msdyn_status;
        return _x;
    }

    @Property(name="msdyn_activityid")
    @JsonIgnore
    public Optional<String> getMsdyn_activityid() {
        return Optional.ofNullable(msdyn_activityid);
    }

    public Msdyn_solutionhistory withMsdyn_activityid(String msdyn_activityid) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_activityid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_activityid = msdyn_activityid;
        return _x;
    }

    @Property(name="msdyn_totaltime")
    @JsonIgnore
    public Optional<Integer> getMsdyn_totaltime() {
        return Optional.ofNullable(msdyn_totaltime);
    }

    public Msdyn_solutionhistory withMsdyn_totaltime(Integer msdyn_totaltime) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_totaltime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_totaltime = msdyn_totaltime;
        return _x;
    }

    @Property(name="msdyn_solutionid")
    @JsonIgnore
    public Optional<String> getMsdyn_solutionid() {
        return Optional.ofNullable(msdyn_solutionid);
    }

    public Msdyn_solutionhistory withMsdyn_solutionid(String msdyn_solutionid) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_solutionid = msdyn_solutionid;
        return _x;
    }

    @Property(name="msdyn_operation")
    @JsonIgnore
    public Optional<Integer> getMsdyn_operation() {
        return Optional.ofNullable(msdyn_operation);
    }

    public Msdyn_solutionhistory withMsdyn_operation(Integer msdyn_operation) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_operation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_operation = msdyn_operation;
        return _x;
    }

    @Property(name="msdyn_starttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMsdyn_starttime() {
        return Optional.ofNullable(msdyn_starttime);
    }

    public Msdyn_solutionhistory withMsdyn_starttime(OffsetDateTime msdyn_starttime) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_starttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_starttime = msdyn_starttime;
        return _x;
    }

    @Property(name="msdyn_exceptionmessage")
    @JsonIgnore
    public Optional<String> getMsdyn_exceptionmessage() {
        return Optional.ofNullable(msdyn_exceptionmessage);
    }

    public Msdyn_solutionhistory withMsdyn_exceptionmessage(String msdyn_exceptionmessage) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_exceptionmessage");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_exceptionmessage = msdyn_exceptionmessage;
        return _x;
    }

    @Property(name="msdyn_result")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_result() {
        return Optional.ofNullable(msdyn_result);
    }

    public Msdyn_solutionhistory withMsdyn_result(Boolean msdyn_result) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_result");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_result = msdyn_result;
        return _x;
    }

    @Property(name="msdyn_packagename")
    @JsonIgnore
    public Optional<String> getMsdyn_packagename() {
        return Optional.ofNullable(msdyn_packagename);
    }

    public Msdyn_solutionhistory withMsdyn_packagename(String msdyn_packagename) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_packagename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_packagename = msdyn_packagename;
        return _x;
    }

    @Property(name="msdyn_publishername")
    @JsonIgnore
    public Optional<String> getMsdyn_publishername() {
        return Optional.ofNullable(msdyn_publishername);
    }

    public Msdyn_solutionhistory withMsdyn_publishername(String msdyn_publishername) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_publishername");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_publishername = msdyn_publishername;
        return _x;
    }

    @Property(name="msdyn_ispatch")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_ispatch() {
        return Optional.ofNullable(msdyn_ispatch);
    }

    public Msdyn_solutionhistory withMsdyn_ispatch(Boolean msdyn_ispatch) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_ispatch");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_ispatch = msdyn_ispatch;
        return _x;
    }

    @Property(name="msdyn_publisherid")
    @JsonIgnore
    public Optional<String> getMsdyn_publisherid() {
        return Optional.ofNullable(msdyn_publisherid);
    }

    public Msdyn_solutionhistory withMsdyn_publisherid(String msdyn_publisherid) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_publisherid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_publisherid = msdyn_publisherid;
        return _x;
    }

    @Property(name="msdyn_isoverwritecustomizations")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isoverwritecustomizations() {
        return Optional.ofNullable(msdyn_isoverwritecustomizations);
    }

    public Msdyn_solutionhistory withMsdyn_isoverwritecustomizations(Boolean msdyn_isoverwritecustomizations) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isoverwritecustomizations");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_isoverwritecustomizations = msdyn_isoverwritecustomizations;
        return _x;
    }

    @Property(name="msdyn_suboperation")
    @JsonIgnore
    public Optional<Integer> getMsdyn_suboperation() {
        return Optional.ofNullable(msdyn_suboperation);
    }

    public Msdyn_solutionhistory withMsdyn_suboperation(Integer msdyn_suboperation) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_suboperation");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_suboperation = msdyn_suboperation;
        return _x;
    }

    @Property(name="msdyn_packageversion")
    @JsonIgnore
    public Optional<String> getMsdyn_packageversion() {
        return Optional.ofNullable(msdyn_packageversion);
    }

    public Msdyn_solutionhistory withMsdyn_packageversion(String msdyn_packageversion) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_packageversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_packageversion = msdyn_packageversion;
        return _x;
    }

    @Property(name="msdyn_exceptionstack")
    @JsonIgnore
    public Optional<String> getMsdyn_exceptionstack() {
        return Optional.ofNullable(msdyn_exceptionstack);
    }

    public Msdyn_solutionhistory withMsdyn_exceptionstack(String msdyn_exceptionstack) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_exceptionstack");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_exceptionstack = msdyn_exceptionstack;
        return _x;
    }

    @Property(name="msdyn_solutionversion")
    @JsonIgnore
    public Optional<String> getMsdyn_solutionversion() {
        return Optional.ofNullable(msdyn_solutionversion);
    }

    public Msdyn_solutionhistory withMsdyn_solutionversion(String msdyn_solutionversion) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_solutionversion = msdyn_solutionversion;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_solutionhistory withMsdyn_name(String msdyn_name) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_errorcode")
    @JsonIgnore
    public Optional<String> getMsdyn_errorcode() {
        return Optional.ofNullable(msdyn_errorcode);
    }

    public Msdyn_solutionhistory withMsdyn_errorcode(String msdyn_errorcode) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_errorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_errorcode = msdyn_errorcode;
        return _x;
    }

    @Property(name="msdyn_solutionhistoryid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_solutionhistoryid() {
        return Optional.ofNullable(msdyn_solutionhistoryid);
    }

    public Msdyn_solutionhistory withMsdyn_solutionhistoryid(UUID msdyn_solutionhistoryid) {
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutionhistoryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutionhistory");
        _x.msdyn_solutionhistoryid = msdyn_solutionhistoryid;
        return _x;
    }

    public Msdyn_solutionhistory withUnmappedField(String name, Object value) {
        Msdyn_solutionhistory _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutionhistory patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutionhistory put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutionhistory _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_solutionhistory _copy() {
        Msdyn_solutionhistory _x = new Msdyn_solutionhistory();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_ismanaged = msdyn_ismanaged;
        _x.msdyn_endtime = msdyn_endtime;
        _x.msdyn_correlationid = msdyn_correlationid;
        _x.msdyn_status = msdyn_status;
        _x.msdyn_activityid = msdyn_activityid;
        _x.msdyn_totaltime = msdyn_totaltime;
        _x.msdyn_solutionid = msdyn_solutionid;
        _x.msdyn_operation = msdyn_operation;
        _x.msdyn_starttime = msdyn_starttime;
        _x.msdyn_exceptionmessage = msdyn_exceptionmessage;
        _x.msdyn_result = msdyn_result;
        _x.msdyn_packagename = msdyn_packagename;
        _x.msdyn_publishername = msdyn_publishername;
        _x.msdyn_ispatch = msdyn_ispatch;
        _x.msdyn_publisherid = msdyn_publisherid;
        _x.msdyn_isoverwritecustomizations = msdyn_isoverwritecustomizations;
        _x.msdyn_suboperation = msdyn_suboperation;
        _x.msdyn_packageversion = msdyn_packageversion;
        _x.msdyn_exceptionstack = msdyn_exceptionstack;
        _x.msdyn_solutionversion = msdyn_solutionversion;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_errorcode = msdyn_errorcode;
        _x.msdyn_solutionhistoryid = msdyn_solutionhistoryid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_solutionhistory[");
        b.append("msdyn_ismanaged=");
        b.append(this.msdyn_ismanaged);
        b.append(", ");
        b.append("msdyn_endtime=");
        b.append(this.msdyn_endtime);
        b.append(", ");
        b.append("msdyn_correlationid=");
        b.append(this.msdyn_correlationid);
        b.append(", ");
        b.append("msdyn_status=");
        b.append(this.msdyn_status);
        b.append(", ");
        b.append("msdyn_activityid=");
        b.append(this.msdyn_activityid);
        b.append(", ");
        b.append("msdyn_totaltime=");
        b.append(this.msdyn_totaltime);
        b.append(", ");
        b.append("msdyn_solutionid=");
        b.append(this.msdyn_solutionid);
        b.append(", ");
        b.append("msdyn_operation=");
        b.append(this.msdyn_operation);
        b.append(", ");
        b.append("msdyn_starttime=");
        b.append(this.msdyn_starttime);
        b.append(", ");
        b.append("msdyn_exceptionmessage=");
        b.append(this.msdyn_exceptionmessage);
        b.append(", ");
        b.append("msdyn_result=");
        b.append(this.msdyn_result);
        b.append(", ");
        b.append("msdyn_packagename=");
        b.append(this.msdyn_packagename);
        b.append(", ");
        b.append("msdyn_publishername=");
        b.append(this.msdyn_publishername);
        b.append(", ");
        b.append("msdyn_ispatch=");
        b.append(this.msdyn_ispatch);
        b.append(", ");
        b.append("msdyn_publisherid=");
        b.append(this.msdyn_publisherid);
        b.append(", ");
        b.append("msdyn_isoverwritecustomizations=");
        b.append(this.msdyn_isoverwritecustomizations);
        b.append(", ");
        b.append("msdyn_suboperation=");
        b.append(this.msdyn_suboperation);
        b.append(", ");
        b.append("msdyn_packageversion=");
        b.append(this.msdyn_packageversion);
        b.append(", ");
        b.append("msdyn_exceptionstack=");
        b.append(this.msdyn_exceptionstack);
        b.append(", ");
        b.append("msdyn_solutionversion=");
        b.append(this.msdyn_solutionversion);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_errorcode=");
        b.append(this.msdyn_errorcode);
        b.append(", ");
        b.append("msdyn_solutionhistoryid=");
        b.append(this.msdyn_solutionhistoryid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
