package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "msdyn_solutioncomponentdatasourceid", 
    "msdyn_name", 
    "organizationid"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_solutioncomponentdatasource extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_solutioncomponentdatasource";
    }

    @JsonProperty("msdyn_solutioncomponentdatasourceid")
    protected UUID msdyn_solutioncomponentdatasourceid;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("organizationid")
    protected UUID organizationid;

    protected Msdyn_solutioncomponentdatasource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_solutioncomponentdatasource() {
        return new Builder();
    }

    public static final class Builder {
        private UUID msdyn_solutioncomponentdatasourceid;
        private String msdyn_name;
        private UUID organizationid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder msdyn_solutioncomponentdatasourceid(UUID msdyn_solutioncomponentdatasourceid) {
            this.msdyn_solutioncomponentdatasourceid = msdyn_solutioncomponentdatasourceid;
            this.changedFields = changedFields.add("msdyn_solutioncomponentdatasourceid");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder organizationid(UUID organizationid) {
            this.organizationid = organizationid;
            this.changedFields = changedFields.add("organizationid");
            return this;
        }

        public Msdyn_solutioncomponentdatasource build() {
            Msdyn_solutioncomponentdatasource _x = new Msdyn_solutioncomponentdatasource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_solutioncomponentdatasource";
            _x.msdyn_solutioncomponentdatasourceid = msdyn_solutioncomponentdatasourceid;
            _x.msdyn_name = msdyn_name;
            _x.organizationid = organizationid;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_solutioncomponentdatasourceid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_solutioncomponentdatasourceid, UUID.class));
        }
    }

    @Property(name="msdyn_solutioncomponentdatasourceid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_solutioncomponentdatasourceid() {
        return Optional.ofNullable(msdyn_solutioncomponentdatasourceid);
    }

    public Msdyn_solutioncomponentdatasource withMsdyn_solutioncomponentdatasourceid(UUID msdyn_solutioncomponentdatasourceid) {
        Msdyn_solutioncomponentdatasource _x = _copy();
        _x.changedFields = changedFields.add("msdyn_solutioncomponentdatasourceid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentdatasource");
        _x.msdyn_solutioncomponentdatasourceid = msdyn_solutioncomponentdatasourceid;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_solutioncomponentdatasource withMsdyn_name(String msdyn_name) {
        Msdyn_solutioncomponentdatasource _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentdatasource");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="organizationid")
    @JsonIgnore
    public Optional<UUID> getOrganizationid() {
        return Optional.ofNullable(organizationid);
    }

    public Msdyn_solutioncomponentdatasource withOrganizationid(UUID organizationid) {
        Msdyn_solutioncomponentdatasource _x = _copy();
        _x.changedFields = changedFields.add("organizationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_solutioncomponentdatasource");
        _x.organizationid = organizationid;
        return _x;
    }

    public Msdyn_solutioncomponentdatasource withUnmappedField(String name, Object value) {
        Msdyn_solutioncomponentdatasource _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutioncomponentdatasource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutioncomponentdatasource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_solutioncomponentdatasource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_solutioncomponentdatasource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_solutioncomponentdatasource _copy() {
        Msdyn_solutioncomponentdatasource _x = new Msdyn_solutioncomponentdatasource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.msdyn_solutioncomponentdatasourceid = msdyn_solutioncomponentdatasourceid;
        _x.msdyn_name = msdyn_name;
        _x.organizationid = organizationid;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_solutioncomponentdatasource[");
        b.append("msdyn_solutioncomponentdatasourceid=");
        b.append(this.msdyn_solutioncomponentdatasourceid);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("organizationid=");
        b.append(this.organizationid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
