package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SubjectRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_owningbusinessunit_value", 
    "versionnumber", 
    "createdon", 
    "_owninguser_value", 
    "msdyn_languagelocaleid", 
    "msdyn_knowledgearticletemplateid", 
    "modifiedon", 
    "msdyn_name", 
    "msdyn_description", 
    "_ownerid_value", 
    "timezoneruleversionnumber", 
    "utcconversiontimezonecode", 
    "msdyn_isinternal", 
    "_createdby_value", 
    "_msdyn_subjectid_value", 
    "statecode", 
    "_createdonbehalfby_value", 
    "msdyn_content", 
    "msdyn_LanguageLocaleIdName", 
    "msdyn_keywords", 
    "_owningteam_value", 
    "overriddencreatedon", 
    "_modifiedonbehalfby_value", 
    "importsequencenumber", 
    "msdyn_title", 
    "statuscode", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_knowledgearticletemplate extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate";
    }

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("msdyn_languagelocaleid")
    protected String msdyn_languagelocaleid;

    @JsonProperty("msdyn_knowledgearticletemplateid")
    protected UUID msdyn_knowledgearticletemplateid;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("msdyn_isinternal")
    protected Boolean msdyn_isinternal;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_msdyn_subjectid_value")
    protected UUID _msdyn_subjectid_value;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("msdyn_content")
    protected String msdyn_content;

    @JsonProperty("msdyn_LanguageLocaleIdName")
    protected String msdyn_LanguageLocaleIdName;

    @JsonProperty("msdyn_keywords")
    protected String msdyn_keywords;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("msdyn_title")
    protected String msdyn_title;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    protected Msdyn_knowledgearticletemplate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_knowledgearticletemplate() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _owningbusinessunit_value;
        private Long versionnumber;
        private OffsetDateTime createdon;
        private UUID _owninguser_value;
        private String msdyn_languagelocaleid;
        private UUID msdyn_knowledgearticletemplateid;
        private OffsetDateTime modifiedon;
        private String msdyn_name;
        private String msdyn_description;
        private UUID _ownerid_value;
        private Integer timezoneruleversionnumber;
        private Integer utcconversiontimezonecode;
        private Boolean msdyn_isinternal;
        private UUID _createdby_value;
        private UUID _msdyn_subjectid_value;
        private Integer statecode;
        private UUID _createdonbehalfby_value;
        private String msdyn_content;
        private String msdyn_LanguageLocaleIdName;
        private String msdyn_keywords;
        private UUID _owningteam_value;
        private OffsetDateTime overriddencreatedon;
        private UUID _modifiedonbehalfby_value;
        private Integer importsequencenumber;
        private String msdyn_title;
        private Integer statuscode;
        private UUID _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder msdyn_languagelocaleid(String msdyn_languagelocaleid) {
            this.msdyn_languagelocaleid = msdyn_languagelocaleid;
            this.changedFields = changedFields.add("msdyn_languagelocaleid");
            return this;
        }

        public Builder msdyn_knowledgearticletemplateid(UUID msdyn_knowledgearticletemplateid) {
            this.msdyn_knowledgearticletemplateid = msdyn_knowledgearticletemplateid;
            this.changedFields = changedFields.add("msdyn_knowledgearticletemplateid");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder msdyn_isinternal(Boolean msdyn_isinternal) {
            this.msdyn_isinternal = msdyn_isinternal;
            this.changedFields = changedFields.add("msdyn_isinternal");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _msdyn_subjectid_value(UUID _msdyn_subjectid_value) {
            this._msdyn_subjectid_value = _msdyn_subjectid_value;
            this.changedFields = changedFields.add("_msdyn_subjectid_value");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder msdyn_content(String msdyn_content) {
            this.msdyn_content = msdyn_content;
            this.changedFields = changedFields.add("msdyn_content");
            return this;
        }

        public Builder msdyn_LanguageLocaleIdName(String msdyn_LanguageLocaleIdName) {
            this.msdyn_LanguageLocaleIdName = msdyn_LanguageLocaleIdName;
            this.changedFields = changedFields.add("msdyn_LanguageLocaleIdName");
            return this;
        }

        public Builder msdyn_keywords(String msdyn_keywords) {
            this.msdyn_keywords = msdyn_keywords;
            this.changedFields = changedFields.add("msdyn_keywords");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder msdyn_title(String msdyn_title) {
            this.msdyn_title = msdyn_title;
            this.changedFields = changedFields.add("msdyn_title");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Msdyn_knowledgearticletemplate build() {
            Msdyn_knowledgearticletemplate _x = new Msdyn_knowledgearticletemplate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate";
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.versionnumber = versionnumber;
            _x.createdon = createdon;
            _x._owninguser_value = _owninguser_value;
            _x.msdyn_languagelocaleid = msdyn_languagelocaleid;
            _x.msdyn_knowledgearticletemplateid = msdyn_knowledgearticletemplateid;
            _x.modifiedon = modifiedon;
            _x.msdyn_name = msdyn_name;
            _x.msdyn_description = msdyn_description;
            _x._ownerid_value = _ownerid_value;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.msdyn_isinternal = msdyn_isinternal;
            _x._createdby_value = _createdby_value;
            _x._msdyn_subjectid_value = _msdyn_subjectid_value;
            _x.statecode = statecode;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.msdyn_content = msdyn_content;
            _x.msdyn_LanguageLocaleIdName = msdyn_LanguageLocaleIdName;
            _x.msdyn_keywords = msdyn_keywords;
            _x._owningteam_value = _owningteam_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.importsequencenumber = importsequencenumber;
            _x.msdyn_title = msdyn_title;
            _x.statuscode = statuscode;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_knowledgearticletemplateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class));
        }
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_knowledgearticletemplate with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_knowledgearticletemplate withVersionnumber(Long versionnumber) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_knowledgearticletemplate withCreatedon(OffsetDateTime createdon) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_knowledgearticletemplate with_owninguser_value(UUID _owninguser_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="msdyn_languagelocaleid")
    @JsonIgnore
    public Optional<String> getMsdyn_languagelocaleid() {
        return Optional.ofNullable(msdyn_languagelocaleid);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_languagelocaleid(String msdyn_languagelocaleid) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_languagelocaleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_languagelocaleid = msdyn_languagelocaleid;
        return _x;
    }

    @Property(name="msdyn_knowledgearticletemplateid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_knowledgearticletemplateid() {
        return Optional.ofNullable(msdyn_knowledgearticletemplateid);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_knowledgearticletemplateid(UUID msdyn_knowledgearticletemplateid) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_knowledgearticletemplateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_knowledgearticletemplateid = msdyn_knowledgearticletemplateid;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_knowledgearticletemplate withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_name(String msdyn_name) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_description(String msdyn_description) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_knowledgearticletemplate with_ownerid_value(UUID _ownerid_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_knowledgearticletemplate withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_knowledgearticletemplate withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="msdyn_isinternal")
    @JsonIgnore
    public Optional<Boolean> getMsdyn_isinternal() {
        return Optional.ofNullable(msdyn_isinternal);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_isinternal(Boolean msdyn_isinternal) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_isinternal");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_isinternal = msdyn_isinternal;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_knowledgearticletemplate with_createdby_value(UUID _createdby_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_msdyn_subjectid_value")
    @JsonIgnore
    public Optional<UUID> get_msdyn_subjectid_value() {
        return Optional.ofNullable(_msdyn_subjectid_value);
    }

    public Msdyn_knowledgearticletemplate with_msdyn_subjectid_value(UUID _msdyn_subjectid_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_msdyn_subjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._msdyn_subjectid_value = _msdyn_subjectid_value;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_knowledgearticletemplate withStatecode(Integer statecode) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_knowledgearticletemplate with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_content")
    @JsonIgnore
    public Optional<String> getMsdyn_content() {
        return Optional.ofNullable(msdyn_content);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_content(String msdyn_content) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_content");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_content = msdyn_content;
        return _x;
    }

    @Property(name="msdyn_LanguageLocaleIdName")
    @JsonIgnore
    public Optional<String> getMsdyn_LanguageLocaleIdName() {
        return Optional.ofNullable(msdyn_LanguageLocaleIdName);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_LanguageLocaleIdName(String msdyn_LanguageLocaleIdName) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_LanguageLocaleIdName");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_LanguageLocaleIdName = msdyn_LanguageLocaleIdName;
        return _x;
    }

    @Property(name="msdyn_keywords")
    @JsonIgnore
    public Optional<String> getMsdyn_keywords() {
        return Optional.ofNullable(msdyn_keywords);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_keywords(String msdyn_keywords) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_keywords");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_keywords = msdyn_keywords;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_knowledgearticletemplate with_owningteam_value(UUID _owningteam_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_knowledgearticletemplate withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_knowledgearticletemplate with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_knowledgearticletemplate withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="msdyn_title")
    @JsonIgnore
    public Optional<String> getMsdyn_title() {
        return Optional.ofNullable(msdyn_title);
    }

    public Msdyn_knowledgearticletemplate withMsdyn_title(String msdyn_title) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("msdyn_title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.msdyn_title = msdyn_title;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_knowledgearticletemplate withStatuscode(Integer statuscode) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_knowledgearticletemplate with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_knowledgearticletemplate");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Msdyn_knowledgearticletemplate withUnmappedField(String name, Object value) {
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_knowledgearticletemplate_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_knowledgearticletemplate_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_knowledgearticletemplate_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_SharePointDocumentLocations")
    @JsonIgnore
    public SharepointdocumentlocationCollectionRequest getMsdyn_knowledgearticletemplate_SharePointDocumentLocations() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_SharePointDocumentLocations"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_SharePointDocumentLocations"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_knowledgearticletemplate_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_knowledgearticletemplate_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_knowledgearticletemplate_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_knowledgearticletemplate_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_knowledgearticletemplate_QueueItems")
    @JsonIgnore
    public QueueitemCollectionRequest getMsdyn_knowledgearticletemplate_QueueItems() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("msdyn_knowledgearticletemplate_QueueItems"), RequestHelper.getValue(unmappedFields, "msdyn_knowledgearticletemplate_QueueItems"));
    }

    @NavigationProperty(name="msdyn_subjectid")
    @JsonIgnore
    public SubjectRequest getMsdyn_subjectid() {
        return new SubjectRequest(contextPath.addSegment("msdyn_subjectid"), RequestHelper.getValue(unmappedFields, "msdyn_subjectid"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_knowledgearticletemplate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_knowledgearticletemplate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_knowledgearticletemplate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_knowledgearticletemplate _copy() {
        Msdyn_knowledgearticletemplate _x = new Msdyn_knowledgearticletemplate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.versionnumber = versionnumber;
        _x.createdon = createdon;
        _x._owninguser_value = _owninguser_value;
        _x.msdyn_languagelocaleid = msdyn_languagelocaleid;
        _x.msdyn_knowledgearticletemplateid = msdyn_knowledgearticletemplateid;
        _x.modifiedon = modifiedon;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_description = msdyn_description;
        _x._ownerid_value = _ownerid_value;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.msdyn_isinternal = msdyn_isinternal;
        _x._createdby_value = _createdby_value;
        _x._msdyn_subjectid_value = _msdyn_subjectid_value;
        _x.statecode = statecode;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.msdyn_content = msdyn_content;
        _x.msdyn_LanguageLocaleIdName = msdyn_LanguageLocaleIdName;
        _x.msdyn_keywords = msdyn_keywords;
        _x._owningteam_value = _owningteam_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.importsequencenumber = importsequencenumber;
        _x.msdyn_title = msdyn_title;
        _x.statuscode = statuscode;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_knowledgearticletemplate[");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("msdyn_languagelocaleid=");
        b.append(this.msdyn_languagelocaleid);
        b.append(", ");
        b.append("msdyn_knowledgearticletemplateid=");
        b.append(this.msdyn_knowledgearticletemplateid);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("msdyn_isinternal=");
        b.append(this.msdyn_isinternal);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_msdyn_subjectid_value=");
        b.append(this._msdyn_subjectid_value);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("msdyn_content=");
        b.append(this.msdyn_content);
        b.append(", ");
        b.append("msdyn_LanguageLocaleIdName=");
        b.append(this.msdyn_LanguageLocaleIdName);
        b.append(", ");
        b.append("msdyn_keywords=");
        b.append(this.msdyn_keywords);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("msdyn_title=");
        b.append(this.msdyn_title);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
