package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statecode", 
    "msdyn_dataflowid", 
    "msdyn_mashupdocument", 
    "msdyn_emailsettings", 
    "timezoneruleversionnumber", 
    "msdyn_name", 
    "_createdonbehalfby_value", 
    "statuscode", 
    "msdyn_mashupsettings", 
    "msdyn_gatewayobjectid", 
    "_createdby_value", 
    "componentidunique", 
    "msdyn_description", 
    "_modifiedonbehalfby_value", 
    "overwritetime", 
    "_modifiedby_value", 
    "iscustomizable", 
    "msdyn_internalversion", 
    "solutionid", 
    "createdon", 
    "utcconversiontimezonecode", 
    "ismanaged", 
    "importsequencenumber", 
    "_owninguser_value", 
    "componentstate", 
    "_owningbusinessunit_value", 
    "msdyn_originaldataflowid", 
    "_owningteam_value", 
    "modifiedon", 
    "overriddencreatedon", 
    "msdyn_destinationadls", 
    "_ownerid_value", 
    "versionnumber", 
    "msdyn_refreshsettings"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_dataflow extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_dataflow";
    }

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_dataflowid")
    protected UUID msdyn_dataflowid;

    @JsonProperty("msdyn_mashupdocument")
    protected String msdyn_mashupdocument;

    @JsonProperty("msdyn_emailsettings")
    protected String msdyn_emailsettings;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("msdyn_mashupsettings")
    protected String msdyn_mashupsettings;

    @JsonProperty("msdyn_gatewayobjectid")
    protected String msdyn_gatewayobjectid;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("componentidunique")
    protected UUID componentidunique;

    @JsonProperty("msdyn_description")
    protected String msdyn_description;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("iscustomizable")
    protected BooleanManagedProperty iscustomizable;

    @JsonProperty("msdyn_internalversion")
    protected String msdyn_internalversion;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("msdyn_originaldataflowid")
    protected String msdyn_originaldataflowid;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_destinationadls")
    protected String msdyn_destinationadls;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("msdyn_refreshsettings")
    protected String msdyn_refreshsettings;

    protected Msdyn_dataflow() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_dataflow() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statecode;
        private UUID msdyn_dataflowid;
        private String msdyn_mashupdocument;
        private String msdyn_emailsettings;
        private Integer timezoneruleversionnumber;
        private String msdyn_name;
        private UUID _createdonbehalfby_value;
        private Integer statuscode;
        private String msdyn_mashupsettings;
        private String msdyn_gatewayobjectid;
        private UUID _createdby_value;
        private UUID componentidunique;
        private String msdyn_description;
        private UUID _modifiedonbehalfby_value;
        private OffsetDateTime overwritetime;
        private UUID _modifiedby_value;
        private BooleanManagedProperty iscustomizable;
        private String msdyn_internalversion;
        private UUID solutionid;
        private OffsetDateTime createdon;
        private Integer utcconversiontimezonecode;
        private Boolean ismanaged;
        private Integer importsequencenumber;
        private UUID _owninguser_value;
        private Integer componentstate;
        private UUID _owningbusinessunit_value;
        private String msdyn_originaldataflowid;
        private UUID _owningteam_value;
        private OffsetDateTime modifiedon;
        private OffsetDateTime overriddencreatedon;
        private String msdyn_destinationadls;
        private UUID _ownerid_value;
        private Long versionnumber;
        private String msdyn_refreshsettings;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_dataflowid(UUID msdyn_dataflowid) {
            this.msdyn_dataflowid = msdyn_dataflowid;
            this.changedFields = changedFields.add("msdyn_dataflowid");
            return this;
        }

        public Builder msdyn_mashupdocument(String msdyn_mashupdocument) {
            this.msdyn_mashupdocument = msdyn_mashupdocument;
            this.changedFields = changedFields.add("msdyn_mashupdocument");
            return this;
        }

        public Builder msdyn_emailsettings(String msdyn_emailsettings) {
            this.msdyn_emailsettings = msdyn_emailsettings;
            this.changedFields = changedFields.add("msdyn_emailsettings");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder msdyn_mashupsettings(String msdyn_mashupsettings) {
            this.msdyn_mashupsettings = msdyn_mashupsettings;
            this.changedFields = changedFields.add("msdyn_mashupsettings");
            return this;
        }

        public Builder msdyn_gatewayobjectid(String msdyn_gatewayobjectid) {
            this.msdyn_gatewayobjectid = msdyn_gatewayobjectid;
            this.changedFields = changedFields.add("msdyn_gatewayobjectid");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder componentidunique(UUID componentidunique) {
            this.componentidunique = componentidunique;
            this.changedFields = changedFields.add("componentidunique");
            return this;
        }

        public Builder msdyn_description(String msdyn_description) {
            this.msdyn_description = msdyn_description;
            this.changedFields = changedFields.add("msdyn_description");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder iscustomizable(BooleanManagedProperty iscustomizable) {
            this.iscustomizable = iscustomizable;
            this.changedFields = changedFields.add("iscustomizable");
            return this;
        }

        public Builder msdyn_internalversion(String msdyn_internalversion) {
            this.msdyn_internalversion = msdyn_internalversion;
            this.changedFields = changedFields.add("msdyn_internalversion");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder msdyn_originaldataflowid(String msdyn_originaldataflowid) {
            this.msdyn_originaldataflowid = msdyn_originaldataflowid;
            this.changedFields = changedFields.add("msdyn_originaldataflowid");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_destinationadls(String msdyn_destinationadls) {
            this.msdyn_destinationadls = msdyn_destinationadls;
            this.changedFields = changedFields.add("msdyn_destinationadls");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder msdyn_refreshsettings(String msdyn_refreshsettings) {
            this.msdyn_refreshsettings = msdyn_refreshsettings;
            this.changedFields = changedFields.add("msdyn_refreshsettings");
            return this;
        }

        public Msdyn_dataflow build() {
            Msdyn_dataflow _x = new Msdyn_dataflow();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_dataflow";
            _x.statecode = statecode;
            _x.msdyn_dataflowid = msdyn_dataflowid;
            _x.msdyn_mashupdocument = msdyn_mashupdocument;
            _x.msdyn_emailsettings = msdyn_emailsettings;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x.msdyn_name = msdyn_name;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.statuscode = statuscode;
            _x.msdyn_mashupsettings = msdyn_mashupsettings;
            _x.msdyn_gatewayobjectid = msdyn_gatewayobjectid;
            _x._createdby_value = _createdby_value;
            _x.componentidunique = componentidunique;
            _x.msdyn_description = msdyn_description;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.overwritetime = overwritetime;
            _x._modifiedby_value = _modifiedby_value;
            _x.iscustomizable = iscustomizable;
            _x.msdyn_internalversion = msdyn_internalversion;
            _x.solutionid = solutionid;
            _x.createdon = createdon;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.ismanaged = ismanaged;
            _x.importsequencenumber = importsequencenumber;
            _x._owninguser_value = _owninguser_value;
            _x.componentstate = componentstate;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.msdyn_originaldataflowid = msdyn_originaldataflowid;
            _x._owningteam_value = _owningteam_value;
            _x.modifiedon = modifiedon;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_destinationadls = msdyn_destinationadls;
            _x._ownerid_value = _ownerid_value;
            _x.versionnumber = versionnumber;
            _x.msdyn_refreshsettings = msdyn_refreshsettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_dataflowid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_dataflowid, UUID.class));
        }
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_dataflow withStatecode(Integer statecode) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_dataflowid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_dataflowid() {
        return Optional.ofNullable(msdyn_dataflowid);
    }

    public Msdyn_dataflow withMsdyn_dataflowid(UUID msdyn_dataflowid) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_dataflowid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_dataflowid = msdyn_dataflowid;
        return _x;
    }

    @Property(name="msdyn_mashupdocument")
    @JsonIgnore
    public Optional<String> getMsdyn_mashupdocument() {
        return Optional.ofNullable(msdyn_mashupdocument);
    }

    public Msdyn_dataflow withMsdyn_mashupdocument(String msdyn_mashupdocument) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_mashupdocument");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_mashupdocument = msdyn_mashupdocument;
        return _x;
    }

    @Property(name="msdyn_emailsettings")
    @JsonIgnore
    public Optional<String> getMsdyn_emailsettings() {
        return Optional.ofNullable(msdyn_emailsettings);
    }

    public Msdyn_dataflow withMsdyn_emailsettings(String msdyn_emailsettings) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_emailsettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_emailsettings = msdyn_emailsettings;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_dataflow withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_dataflow withMsdyn_name(String msdyn_name) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_dataflow with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_dataflow withStatuscode(Integer statuscode) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="msdyn_mashupsettings")
    @JsonIgnore
    public Optional<String> getMsdyn_mashupsettings() {
        return Optional.ofNullable(msdyn_mashupsettings);
    }

    public Msdyn_dataflow withMsdyn_mashupsettings(String msdyn_mashupsettings) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_mashupsettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_mashupsettings = msdyn_mashupsettings;
        return _x;
    }

    @Property(name="msdyn_gatewayobjectid")
    @JsonIgnore
    public Optional<String> getMsdyn_gatewayobjectid() {
        return Optional.ofNullable(msdyn_gatewayobjectid);
    }

    public Msdyn_dataflow withMsdyn_gatewayobjectid(String msdyn_gatewayobjectid) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_gatewayobjectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_gatewayobjectid = msdyn_gatewayobjectid;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_dataflow with_createdby_value(UUID _createdby_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="componentidunique")
    @JsonIgnore
    public Optional<UUID> getComponentidunique() {
        return Optional.ofNullable(componentidunique);
    }

    public Msdyn_dataflow withComponentidunique(UUID componentidunique) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("componentidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.componentidunique = componentidunique;
        return _x;
    }

    @Property(name="msdyn_description")
    @JsonIgnore
    public Optional<String> getMsdyn_description() {
        return Optional.ofNullable(msdyn_description);
    }

    public Msdyn_dataflow withMsdyn_description(String msdyn_description) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_description = msdyn_description;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_dataflow with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Msdyn_dataflow withOverwritetime(OffsetDateTime overwritetime) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_dataflow with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="iscustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIscustomizable() {
        return Optional.ofNullable(iscustomizable);
    }

    public Msdyn_dataflow withIscustomizable(BooleanManagedProperty iscustomizable) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("iscustomizable");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.iscustomizable = iscustomizable;
        return _x;
    }

    @Property(name="msdyn_internalversion")
    @JsonIgnore
    public Optional<String> getMsdyn_internalversion() {
        return Optional.ofNullable(msdyn_internalversion);
    }

    public Msdyn_dataflow withMsdyn_internalversion(String msdyn_internalversion) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_internalversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_internalversion = msdyn_internalversion;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Msdyn_dataflow withSolutionid(UUID solutionid) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_dataflow withCreatedon(OffsetDateTime createdon) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_dataflow withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Msdyn_dataflow withIsmanaged(Boolean ismanaged) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_dataflow withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_dataflow with_owninguser_value(UUID _owninguser_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Msdyn_dataflow withComponentstate(Integer componentstate) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_dataflow with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="msdyn_originaldataflowid")
    @JsonIgnore
    public Optional<String> getMsdyn_originaldataflowid() {
        return Optional.ofNullable(msdyn_originaldataflowid);
    }

    public Msdyn_dataflow withMsdyn_originaldataflowid(String msdyn_originaldataflowid) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_originaldataflowid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_originaldataflowid = msdyn_originaldataflowid;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_dataflow with_owningteam_value(UUID _owningteam_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_dataflow withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_dataflow withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_destinationadls")
    @JsonIgnore
    public Optional<String> getMsdyn_destinationadls() {
        return Optional.ofNullable(msdyn_destinationadls);
    }

    public Msdyn_dataflow withMsdyn_destinationadls(String msdyn_destinationadls) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_destinationadls");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_destinationadls = msdyn_destinationadls;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_dataflow with_ownerid_value(UUID _ownerid_value) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_dataflow withVersionnumber(Long versionnumber) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="msdyn_refreshsettings")
    @JsonIgnore
    public Optional<String> getMsdyn_refreshsettings() {
        return Optional.ofNullable(msdyn_refreshsettings);
    }

    public Msdyn_dataflow withMsdyn_refreshsettings(String msdyn_refreshsettings) {
        Msdyn_dataflow _x = _copy();
        _x.changedFields = changedFields.add("msdyn_refreshsettings");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_dataflow");
        _x.msdyn_refreshsettings = msdyn_refreshsettings;
        return _x;
    }

    public Msdyn_dataflow withUnmappedField(String name, Object value) {
        Msdyn_dataflow _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_dataflow_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_dataflow_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_dataflow_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_dataflow_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_dataflow_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_dataflow_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_dataflow_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_dataflow_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_dataflow_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_dataflow_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_dataflow_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_dataflow_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_dataflow_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_dataflow_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_dataflow_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_dataflow_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_dataflow_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_dataflow_PrincipalObjectAttributeAccesses"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_dataflow patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_dataflow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_dataflow put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_dataflow _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_dataflow _copy() {
        Msdyn_dataflow _x = new Msdyn_dataflow();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statecode = statecode;
        _x.msdyn_dataflowid = msdyn_dataflowid;
        _x.msdyn_mashupdocument = msdyn_mashupdocument;
        _x.msdyn_emailsettings = msdyn_emailsettings;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x.msdyn_name = msdyn_name;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.statuscode = statuscode;
        _x.msdyn_mashupsettings = msdyn_mashupsettings;
        _x.msdyn_gatewayobjectid = msdyn_gatewayobjectid;
        _x._createdby_value = _createdby_value;
        _x.componentidunique = componentidunique;
        _x.msdyn_description = msdyn_description;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.overwritetime = overwritetime;
        _x._modifiedby_value = _modifiedby_value;
        _x.iscustomizable = iscustomizable;
        _x.msdyn_internalversion = msdyn_internalversion;
        _x.solutionid = solutionid;
        _x.createdon = createdon;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.ismanaged = ismanaged;
        _x.importsequencenumber = importsequencenumber;
        _x._owninguser_value = _owninguser_value;
        _x.componentstate = componentstate;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.msdyn_originaldataflowid = msdyn_originaldataflowid;
        _x._owningteam_value = _owningteam_value;
        _x.modifiedon = modifiedon;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_destinationadls = msdyn_destinationadls;
        _x._ownerid_value = _ownerid_value;
        _x.versionnumber = versionnumber;
        _x.msdyn_refreshsettings = msdyn_refreshsettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_dataflow[");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_dataflowid=");
        b.append(this.msdyn_dataflowid);
        b.append(", ");
        b.append("msdyn_mashupdocument=");
        b.append(this.msdyn_mashupdocument);
        b.append(", ");
        b.append("msdyn_emailsettings=");
        b.append(this.msdyn_emailsettings);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("msdyn_mashupsettings=");
        b.append(this.msdyn_mashupsettings);
        b.append(", ");
        b.append("msdyn_gatewayobjectid=");
        b.append(this.msdyn_gatewayobjectid);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("componentidunique=");
        b.append(this.componentidunique);
        b.append(", ");
        b.append("msdyn_description=");
        b.append(this.msdyn_description);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("iscustomizable=");
        b.append(this.iscustomizable);
        b.append(", ");
        b.append("msdyn_internalversion=");
        b.append(this.msdyn_internalversion);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("msdyn_originaldataflowid=");
        b.append(this.msdyn_originaldataflowid);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_destinationadls=");
        b.append(this.msdyn_destinationadls);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("msdyn_refreshsettings=");
        b.append(this.msdyn_refreshsettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
