package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "statuscode", 
    "msdyn_displaystatus", 
    "statecode", 
    "msdyn_analysisjobid", 
    "msdyn_exception", 
    "_modifiedby_value", 
    "_createdonbehalfby_value", 
    "msdyn_starttime", 
    "utcconversiontimezonecode", 
    "msdyn_tenantid", 
    "msdyn_errorcount", 
    "importsequencenumber", 
    "versionnumber", 
    "_owninguser_value", 
    "msdyn_sevcriticalcount", 
    "modifiedon", 
    "msdyn_rulepasscount", 
    "msdyn_ruleruncount", 
    "_createdby_value", 
    "_owningbusinessunit_value", 
    "overriddencreatedon", 
    "msdyn_sevhighcount", 
    "createdon", 
    "_owningteam_value", 
    "msdyn_sevlowcount", 
    "msdyn_endtime", 
    "timezoneruleversionnumber", 
    "_ownerid_value", 
    "msdyn_customdetails", 
    "msdyn_warningcount", 
    "msdyn_runcorrelationid", 
    "msdyn_name", 
    "msdyn_sevmediumcount", 
    "msdyn_rulefailcount", 
    "_modifiedonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Msdyn_analysisjob extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.msdyn_analysisjob";
    }

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("msdyn_displaystatus")
    protected String msdyn_displaystatus;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("msdyn_analysisjobid")
    protected UUID msdyn_analysisjobid;

    @JsonProperty("msdyn_exception")
    protected String msdyn_exception;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("msdyn_starttime")
    protected OffsetDateTime msdyn_starttime;

    @JsonProperty("utcconversiontimezonecode")
    protected Integer utcconversiontimezonecode;

    @JsonProperty("msdyn_tenantid")
    protected String msdyn_tenantid;

    @JsonProperty("msdyn_errorcount")
    protected Integer msdyn_errorcount;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("msdyn_sevcriticalcount")
    protected Integer msdyn_sevcriticalcount;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("msdyn_rulepasscount")
    protected Integer msdyn_rulepasscount;

    @JsonProperty("msdyn_ruleruncount")
    protected Integer msdyn_ruleruncount;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("msdyn_sevhighcount")
    protected Integer msdyn_sevhighcount;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("msdyn_sevlowcount")
    protected Integer msdyn_sevlowcount;

    @JsonProperty("msdyn_endtime")
    protected OffsetDateTime msdyn_endtime;

    @JsonProperty("timezoneruleversionnumber")
    protected Integer timezoneruleversionnumber;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("msdyn_customdetails")
    protected String msdyn_customdetails;

    @JsonProperty("msdyn_warningcount")
    protected Integer msdyn_warningcount;

    @JsonProperty("msdyn_runcorrelationid")
    protected String msdyn_runcorrelationid;

    @JsonProperty("msdyn_name")
    protected String msdyn_name;

    @JsonProperty("msdyn_sevmediumcount")
    protected Integer msdyn_sevmediumcount;

    @JsonProperty("msdyn_rulefailcount")
    protected Integer msdyn_rulefailcount;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    protected Msdyn_analysisjob() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderMsdyn_analysisjob() {
        return new Builder();
    }

    public static final class Builder {
        private Integer statuscode;
        private String msdyn_displaystatus;
        private Integer statecode;
        private UUID msdyn_analysisjobid;
        private String msdyn_exception;
        private UUID _modifiedby_value;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime msdyn_starttime;
        private Integer utcconversiontimezonecode;
        private String msdyn_tenantid;
        private Integer msdyn_errorcount;
        private Integer importsequencenumber;
        private Long versionnumber;
        private UUID _owninguser_value;
        private Integer msdyn_sevcriticalcount;
        private OffsetDateTime modifiedon;
        private Integer msdyn_rulepasscount;
        private Integer msdyn_ruleruncount;
        private UUID _createdby_value;
        private UUID _owningbusinessunit_value;
        private OffsetDateTime overriddencreatedon;
        private Integer msdyn_sevhighcount;
        private OffsetDateTime createdon;
        private UUID _owningteam_value;
        private Integer msdyn_sevlowcount;
        private OffsetDateTime msdyn_endtime;
        private Integer timezoneruleversionnumber;
        private UUID _ownerid_value;
        private String msdyn_customdetails;
        private Integer msdyn_warningcount;
        private String msdyn_runcorrelationid;
        private String msdyn_name;
        private Integer msdyn_sevmediumcount;
        private Integer msdyn_rulefailcount;
        private UUID _modifiedonbehalfby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder msdyn_displaystatus(String msdyn_displaystatus) {
            this.msdyn_displaystatus = msdyn_displaystatus;
            this.changedFields = changedFields.add("msdyn_displaystatus");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder msdyn_analysisjobid(UUID msdyn_analysisjobid) {
            this.msdyn_analysisjobid = msdyn_analysisjobid;
            this.changedFields = changedFields.add("msdyn_analysisjobid");
            return this;
        }

        public Builder msdyn_exception(String msdyn_exception) {
            this.msdyn_exception = msdyn_exception;
            this.changedFields = changedFields.add("msdyn_exception");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder msdyn_starttime(OffsetDateTime msdyn_starttime) {
            this.msdyn_starttime = msdyn_starttime;
            this.changedFields = changedFields.add("msdyn_starttime");
            return this;
        }

        public Builder utcconversiontimezonecode(Integer utcconversiontimezonecode) {
            this.utcconversiontimezonecode = utcconversiontimezonecode;
            this.changedFields = changedFields.add("utcconversiontimezonecode");
            return this;
        }

        public Builder msdyn_tenantid(String msdyn_tenantid) {
            this.msdyn_tenantid = msdyn_tenantid;
            this.changedFields = changedFields.add("msdyn_tenantid");
            return this;
        }

        public Builder msdyn_errorcount(Integer msdyn_errorcount) {
            this.msdyn_errorcount = msdyn_errorcount;
            this.changedFields = changedFields.add("msdyn_errorcount");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder msdyn_sevcriticalcount(Integer msdyn_sevcriticalcount) {
            this.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
            this.changedFields = changedFields.add("msdyn_sevcriticalcount");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder msdyn_rulepasscount(Integer msdyn_rulepasscount) {
            this.msdyn_rulepasscount = msdyn_rulepasscount;
            this.changedFields = changedFields.add("msdyn_rulepasscount");
            return this;
        }

        public Builder msdyn_ruleruncount(Integer msdyn_ruleruncount) {
            this.msdyn_ruleruncount = msdyn_ruleruncount;
            this.changedFields = changedFields.add("msdyn_ruleruncount");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder msdyn_sevhighcount(Integer msdyn_sevhighcount) {
            this.msdyn_sevhighcount = msdyn_sevhighcount;
            this.changedFields = changedFields.add("msdyn_sevhighcount");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder msdyn_sevlowcount(Integer msdyn_sevlowcount) {
            this.msdyn_sevlowcount = msdyn_sevlowcount;
            this.changedFields = changedFields.add("msdyn_sevlowcount");
            return this;
        }

        public Builder msdyn_endtime(OffsetDateTime msdyn_endtime) {
            this.msdyn_endtime = msdyn_endtime;
            this.changedFields = changedFields.add("msdyn_endtime");
            return this;
        }

        public Builder timezoneruleversionnumber(Integer timezoneruleversionnumber) {
            this.timezoneruleversionnumber = timezoneruleversionnumber;
            this.changedFields = changedFields.add("timezoneruleversionnumber");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder msdyn_customdetails(String msdyn_customdetails) {
            this.msdyn_customdetails = msdyn_customdetails;
            this.changedFields = changedFields.add("msdyn_customdetails");
            return this;
        }

        public Builder msdyn_warningcount(Integer msdyn_warningcount) {
            this.msdyn_warningcount = msdyn_warningcount;
            this.changedFields = changedFields.add("msdyn_warningcount");
            return this;
        }

        public Builder msdyn_runcorrelationid(String msdyn_runcorrelationid) {
            this.msdyn_runcorrelationid = msdyn_runcorrelationid;
            this.changedFields = changedFields.add("msdyn_runcorrelationid");
            return this;
        }

        public Builder msdyn_name(String msdyn_name) {
            this.msdyn_name = msdyn_name;
            this.changedFields = changedFields.add("msdyn_name");
            return this;
        }

        public Builder msdyn_sevmediumcount(Integer msdyn_sevmediumcount) {
            this.msdyn_sevmediumcount = msdyn_sevmediumcount;
            this.changedFields = changedFields.add("msdyn_sevmediumcount");
            return this;
        }

        public Builder msdyn_rulefailcount(Integer msdyn_rulefailcount) {
            this.msdyn_rulefailcount = msdyn_rulefailcount;
            this.changedFields = changedFields.add("msdyn_rulefailcount");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Msdyn_analysisjob build() {
            Msdyn_analysisjob _x = new Msdyn_analysisjob();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.msdyn_analysisjob";
            _x.statuscode = statuscode;
            _x.msdyn_displaystatus = msdyn_displaystatus;
            _x.statecode = statecode;
            _x.msdyn_analysisjobid = msdyn_analysisjobid;
            _x.msdyn_exception = msdyn_exception;
            _x._modifiedby_value = _modifiedby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.msdyn_starttime = msdyn_starttime;
            _x.utcconversiontimezonecode = utcconversiontimezonecode;
            _x.msdyn_tenantid = msdyn_tenantid;
            _x.msdyn_errorcount = msdyn_errorcount;
            _x.importsequencenumber = importsequencenumber;
            _x.versionnumber = versionnumber;
            _x._owninguser_value = _owninguser_value;
            _x.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
            _x.modifiedon = modifiedon;
            _x.msdyn_rulepasscount = msdyn_rulepasscount;
            _x.msdyn_ruleruncount = msdyn_ruleruncount;
            _x._createdby_value = _createdby_value;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.msdyn_sevhighcount = msdyn_sevhighcount;
            _x.createdon = createdon;
            _x._owningteam_value = _owningteam_value;
            _x.msdyn_sevlowcount = msdyn_sevlowcount;
            _x.msdyn_endtime = msdyn_endtime;
            _x.timezoneruleversionnumber = timezoneruleversionnumber;
            _x._ownerid_value = _ownerid_value;
            _x.msdyn_customdetails = msdyn_customdetails;
            _x.msdyn_warningcount = msdyn_warningcount;
            _x.msdyn_runcorrelationid = msdyn_runcorrelationid;
            _x.msdyn_name = msdyn_name;
            _x.msdyn_sevmediumcount = msdyn_sevmediumcount;
            _x.msdyn_rulefailcount = msdyn_rulefailcount;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && msdyn_analysisjobid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(msdyn_analysisjobid, UUID.class));
        }
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Msdyn_analysisjob withStatuscode(Integer statuscode) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="msdyn_displaystatus")
    @JsonIgnore
    public Optional<String> getMsdyn_displaystatus() {
        return Optional.ofNullable(msdyn_displaystatus);
    }

    public Msdyn_analysisjob withMsdyn_displaystatus(String msdyn_displaystatus) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_displaystatus");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_displaystatus = msdyn_displaystatus;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Msdyn_analysisjob withStatecode(Integer statecode) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="msdyn_analysisjobid")
    @JsonIgnore
    public Optional<UUID> getMsdyn_analysisjobid() {
        return Optional.ofNullable(msdyn_analysisjobid);
    }

    public Msdyn_analysisjob withMsdyn_analysisjobid(UUID msdyn_analysisjobid) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_analysisjobid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_analysisjobid = msdyn_analysisjobid;
        return _x;
    }

    @Property(name="msdyn_exception")
    @JsonIgnore
    public Optional<String> getMsdyn_exception() {
        return Optional.ofNullable(msdyn_exception);
    }

    public Msdyn_analysisjob withMsdyn_exception(String msdyn_exception) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_exception");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_exception = msdyn_exception;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Msdyn_analysisjob with_modifiedby_value(UUID _modifiedby_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Msdyn_analysisjob with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="msdyn_starttime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMsdyn_starttime() {
        return Optional.ofNullable(msdyn_starttime);
    }

    public Msdyn_analysisjob withMsdyn_starttime(OffsetDateTime msdyn_starttime) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_starttime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_starttime = msdyn_starttime;
        return _x;
    }

    @Property(name="utcconversiontimezonecode")
    @JsonIgnore
    public Optional<Integer> getUtcconversiontimezonecode() {
        return Optional.ofNullable(utcconversiontimezonecode);
    }

    public Msdyn_analysisjob withUtcconversiontimezonecode(Integer utcconversiontimezonecode) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("utcconversiontimezonecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        return _x;
    }

    @Property(name="msdyn_tenantid")
    @JsonIgnore
    public Optional<String> getMsdyn_tenantid() {
        return Optional.ofNullable(msdyn_tenantid);
    }

    public Msdyn_analysisjob withMsdyn_tenantid(String msdyn_tenantid) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_tenantid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_tenantid = msdyn_tenantid;
        return _x;
    }

    @Property(name="msdyn_errorcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_errorcount() {
        return Optional.ofNullable(msdyn_errorcount);
    }

    public Msdyn_analysisjob withMsdyn_errorcount(Integer msdyn_errorcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_errorcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_errorcount = msdyn_errorcount;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Msdyn_analysisjob withImportsequencenumber(Integer importsequencenumber) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Msdyn_analysisjob withVersionnumber(Long versionnumber) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Msdyn_analysisjob with_owninguser_value(UUID _owninguser_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="msdyn_sevcriticalcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevcriticalcount() {
        return Optional.ofNullable(msdyn_sevcriticalcount);
    }

    public Msdyn_analysisjob withMsdyn_sevcriticalcount(Integer msdyn_sevcriticalcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevcriticalcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Msdyn_analysisjob withModifiedon(OffsetDateTime modifiedon) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="msdyn_rulepasscount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_rulepasscount() {
        return Optional.ofNullable(msdyn_rulepasscount);
    }

    public Msdyn_analysisjob withMsdyn_rulepasscount(Integer msdyn_rulepasscount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rulepasscount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_rulepasscount = msdyn_rulepasscount;
        return _x;
    }

    @Property(name="msdyn_ruleruncount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_ruleruncount() {
        return Optional.ofNullable(msdyn_ruleruncount);
    }

    public Msdyn_analysisjob withMsdyn_ruleruncount(Integer msdyn_ruleruncount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_ruleruncount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_ruleruncount = msdyn_ruleruncount;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Msdyn_analysisjob with_createdby_value(UUID _createdby_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Msdyn_analysisjob with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Msdyn_analysisjob withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="msdyn_sevhighcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevhighcount() {
        return Optional.ofNullable(msdyn_sevhighcount);
    }

    public Msdyn_analysisjob withMsdyn_sevhighcount(Integer msdyn_sevhighcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevhighcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_sevhighcount = msdyn_sevhighcount;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Msdyn_analysisjob withCreatedon(OffsetDateTime createdon) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Msdyn_analysisjob with_owningteam_value(UUID _owningteam_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="msdyn_sevlowcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevlowcount() {
        return Optional.ofNullable(msdyn_sevlowcount);
    }

    public Msdyn_analysisjob withMsdyn_sevlowcount(Integer msdyn_sevlowcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevlowcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_sevlowcount = msdyn_sevlowcount;
        return _x;
    }

    @Property(name="msdyn_endtime")
    @JsonIgnore
    public Optional<OffsetDateTime> getMsdyn_endtime() {
        return Optional.ofNullable(msdyn_endtime);
    }

    public Msdyn_analysisjob withMsdyn_endtime(OffsetDateTime msdyn_endtime) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_endtime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_endtime = msdyn_endtime;
        return _x;
    }

    @Property(name="timezoneruleversionnumber")
    @JsonIgnore
    public Optional<Integer> getTimezoneruleversionnumber() {
        return Optional.ofNullable(timezoneruleversionnumber);
    }

    public Msdyn_analysisjob withTimezoneruleversionnumber(Integer timezoneruleversionnumber) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("timezoneruleversionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Msdyn_analysisjob with_ownerid_value(UUID _ownerid_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="msdyn_customdetails")
    @JsonIgnore
    public Optional<String> getMsdyn_customdetails() {
        return Optional.ofNullable(msdyn_customdetails);
    }

    public Msdyn_analysisjob withMsdyn_customdetails(String msdyn_customdetails) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_customdetails");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_customdetails = msdyn_customdetails;
        return _x;
    }

    @Property(name="msdyn_warningcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_warningcount() {
        return Optional.ofNullable(msdyn_warningcount);
    }

    public Msdyn_analysisjob withMsdyn_warningcount(Integer msdyn_warningcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_warningcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_warningcount = msdyn_warningcount;
        return _x;
    }

    @Property(name="msdyn_runcorrelationid")
    @JsonIgnore
    public Optional<String> getMsdyn_runcorrelationid() {
        return Optional.ofNullable(msdyn_runcorrelationid);
    }

    public Msdyn_analysisjob withMsdyn_runcorrelationid(String msdyn_runcorrelationid) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_runcorrelationid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_runcorrelationid = msdyn_runcorrelationid;
        return _x;
    }

    @Property(name="msdyn_name")
    @JsonIgnore
    public Optional<String> getMsdyn_name() {
        return Optional.ofNullable(msdyn_name);
    }

    public Msdyn_analysisjob withMsdyn_name(String msdyn_name) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_name");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_name = msdyn_name;
        return _x;
    }

    @Property(name="msdyn_sevmediumcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_sevmediumcount() {
        return Optional.ofNullable(msdyn_sevmediumcount);
    }

    public Msdyn_analysisjob withMsdyn_sevmediumcount(Integer msdyn_sevmediumcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_sevmediumcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_sevmediumcount = msdyn_sevmediumcount;
        return _x;
    }

    @Property(name="msdyn_rulefailcount")
    @JsonIgnore
    public Optional<Integer> getMsdyn_rulefailcount() {
        return Optional.ofNullable(msdyn_rulefailcount);
    }

    public Msdyn_analysisjob withMsdyn_rulefailcount(Integer msdyn_rulefailcount) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("msdyn_rulefailcount");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x.msdyn_rulefailcount = msdyn_rulefailcount;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Msdyn_analysisjob with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.msdyn_analysisjob");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    public Msdyn_analysisjob withUnmappedField(String name, Object value) {
        Msdyn_analysisjob _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="msdyn_analysisjob_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getMsdyn_analysisjob_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_SyncErrors"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_SyncErrors"));
    }

    @NavigationProperty(name="msdyn_analysisjob_DuplicateMatchingRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysisjob_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_DuplicateMatchingRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_DuplicateMatchingRecord"));
    }

    @NavigationProperty(name="msdyn_analysisjob_DuplicateBaseRecord")
    @JsonIgnore
    public DuplicaterecordCollectionRequest getMsdyn_analysisjob_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_DuplicateBaseRecord"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_DuplicateBaseRecord"));
    }

    @NavigationProperty(name="msdyn_analysisjob_AsyncOperations")
    @JsonIgnore
    public AsyncoperationCollectionRequest getMsdyn_analysisjob_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_AsyncOperations"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_AsyncOperations"));
    }

    @NavigationProperty(name="msdyn_analysisjob_MailboxTrackingFolders")
    @JsonIgnore
    public MailboxtrackingfolderCollectionRequest getMsdyn_analysisjob_MailboxTrackingFolders() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_MailboxTrackingFolders"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_MailboxTrackingFolders"));
    }

    @NavigationProperty(name="msdyn_analysisjob_ProcessSession")
    @JsonIgnore
    public ProcesssessionCollectionRequest getMsdyn_analysisjob_ProcessSession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_ProcessSession"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_ProcessSession"));
    }

    @NavigationProperty(name="msdyn_analysisjob_BulkDeleteFailures")
    @JsonIgnore
    public BulkdeletefailureCollectionRequest getMsdyn_analysisjob_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_BulkDeleteFailures"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_BulkDeleteFailures"));
    }

    @NavigationProperty(name="msdyn_analysisjob_PrincipalObjectAttributeAccesses")
    @JsonIgnore
    public PrincipalobjectattributeaccessCollectionRequest getMsdyn_analysisjob_PrincipalObjectAttributeAccesses() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_PrincipalObjectAttributeAccesses"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_PrincipalObjectAttributeAccesses"));
    }

    @NavigationProperty(name="msdyn_analysisjob_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentCollectionRequest getMsdyn_analysisjob_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="msdyn_analysisjob_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultCollectionRequest getMsdyn_analysisjob_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("msdyn_analysisjob_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "msdyn_analysisjob_msdyn_analysisresult"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysisjob patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Msdyn_analysisjob put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Msdyn_analysisjob _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Msdyn_analysisjob _copy() {
        Msdyn_analysisjob _x = new Msdyn_analysisjob();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.statuscode = statuscode;
        _x.msdyn_displaystatus = msdyn_displaystatus;
        _x.statecode = statecode;
        _x.msdyn_analysisjobid = msdyn_analysisjobid;
        _x.msdyn_exception = msdyn_exception;
        _x._modifiedby_value = _modifiedby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.msdyn_starttime = msdyn_starttime;
        _x.utcconversiontimezonecode = utcconversiontimezonecode;
        _x.msdyn_tenantid = msdyn_tenantid;
        _x.msdyn_errorcount = msdyn_errorcount;
        _x.importsequencenumber = importsequencenumber;
        _x.versionnumber = versionnumber;
        _x._owninguser_value = _owninguser_value;
        _x.msdyn_sevcriticalcount = msdyn_sevcriticalcount;
        _x.modifiedon = modifiedon;
        _x.msdyn_rulepasscount = msdyn_rulepasscount;
        _x.msdyn_ruleruncount = msdyn_ruleruncount;
        _x._createdby_value = _createdby_value;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.msdyn_sevhighcount = msdyn_sevhighcount;
        _x.createdon = createdon;
        _x._owningteam_value = _owningteam_value;
        _x.msdyn_sevlowcount = msdyn_sevlowcount;
        _x.msdyn_endtime = msdyn_endtime;
        _x.timezoneruleversionnumber = timezoneruleversionnumber;
        _x._ownerid_value = _ownerid_value;
        _x.msdyn_customdetails = msdyn_customdetails;
        _x.msdyn_warningcount = msdyn_warningcount;
        _x.msdyn_runcorrelationid = msdyn_runcorrelationid;
        _x.msdyn_name = msdyn_name;
        _x.msdyn_sevmediumcount = msdyn_sevmediumcount;
        _x.msdyn_rulefailcount = msdyn_rulefailcount;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Msdyn_analysisjob[");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("msdyn_displaystatus=");
        b.append(this.msdyn_displaystatus);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("msdyn_analysisjobid=");
        b.append(this.msdyn_analysisjobid);
        b.append(", ");
        b.append("msdyn_exception=");
        b.append(this.msdyn_exception);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("msdyn_starttime=");
        b.append(this.msdyn_starttime);
        b.append(", ");
        b.append("utcconversiontimezonecode=");
        b.append(this.utcconversiontimezonecode);
        b.append(", ");
        b.append("msdyn_tenantid=");
        b.append(this.msdyn_tenantid);
        b.append(", ");
        b.append("msdyn_errorcount=");
        b.append(this.msdyn_errorcount);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("msdyn_sevcriticalcount=");
        b.append(this.msdyn_sevcriticalcount);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("msdyn_rulepasscount=");
        b.append(this.msdyn_rulepasscount);
        b.append(", ");
        b.append("msdyn_ruleruncount=");
        b.append(this.msdyn_ruleruncount);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("msdyn_sevhighcount=");
        b.append(this.msdyn_sevhighcount);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("msdyn_sevlowcount=");
        b.append(this.msdyn_sevlowcount);
        b.append(", ");
        b.append("msdyn_endtime=");
        b.append(this.msdyn_endtime);
        b.append(", ");
        b.append("timezoneruleversionnumber=");
        b.append(this.timezoneruleversionnumber);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("msdyn_customdetails=");
        b.append(this.msdyn_customdetails);
        b.append(", ");
        b.append("msdyn_warningcount=");
        b.append(this.msdyn_warningcount);
        b.append(", ");
        b.append("msdyn_runcorrelationid=");
        b.append(this.msdyn_runcorrelationid);
        b.append(", ");
        b.append("msdyn_name=");
        b.append(this.msdyn_name);
        b.append(", ");
        b.append("msdyn_sevmediumcount=");
        b.append(this.msdyn_sevmediumcount);
        b.append(", ");
        b.append("msdyn_rulefailcount=");
        b.append(this.msdyn_rulefailcount);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
