package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "objecttypecode", 
    "modifiedon", 
    "lastsyncerroroccurredon", 
    "objectid", 
    "_owninguser_value", 
    "tocrmchangetype", 
    "itemsubject", 
    "isdeletedinexchange", 
    "versionnumber", 
    "fromcrmchangetype", 
    "_owningbusinessunit_value", 
    "_ownerid_value", 
    "retries", 
    "_owningteam_value", 
    "exchangesyncidmappingid", 
    "isunlinkedincrm", 
    "lastsyncerrorcode", 
    "userdecision", 
    "exchangeentryid", 
    "lastsyncerror", 
    "createdon"})
@JsonInclude(Include.NON_NULL)
public class Exchangesyncidmapping extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.exchangesyncidmapping";
    }

    @JsonProperty("objecttypecode")
    protected Integer objecttypecode;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("lastsyncerroroccurredon")
    protected OffsetDateTime lastsyncerroroccurredon;

    @JsonProperty("objectid")
    protected UUID objectid;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("tocrmchangetype")
    protected Integer tocrmchangetype;

    @JsonProperty("itemsubject")
    protected String itemsubject;

    @JsonProperty("isdeletedinexchange")
    protected Boolean isdeletedinexchange;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("fromcrmchangetype")
    protected Integer fromcrmchangetype;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("retries")
    protected Integer retries;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("exchangesyncidmappingid")
    protected UUID exchangesyncidmappingid;

    @JsonProperty("isunlinkedincrm")
    protected Boolean isunlinkedincrm;

    @JsonProperty("lastsyncerrorcode")
    protected Integer lastsyncerrorcode;

    @JsonProperty("userdecision")
    protected Integer userdecision;

    @JsonProperty("exchangeentryid")
    protected String exchangeentryid;

    @JsonProperty("lastsyncerror")
    protected String lastsyncerror;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    protected Exchangesyncidmapping() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderExchangesyncidmapping() {
        return new Builder();
    }

    public static final class Builder {
        private Integer objecttypecode;
        private OffsetDateTime modifiedon;
        private OffsetDateTime lastsyncerroroccurredon;
        private UUID objectid;
        private UUID _owninguser_value;
        private Integer tocrmchangetype;
        private String itemsubject;
        private Boolean isdeletedinexchange;
        private Long versionnumber;
        private Integer fromcrmchangetype;
        private UUID _owningbusinessunit_value;
        private UUID _ownerid_value;
        private Integer retries;
        private UUID _owningteam_value;
        private UUID exchangesyncidmappingid;
        private Boolean isunlinkedincrm;
        private Integer lastsyncerrorcode;
        private Integer userdecision;
        private String exchangeentryid;
        private String lastsyncerror;
        private OffsetDateTime createdon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder objecttypecode(Integer objecttypecode) {
            this.objecttypecode = objecttypecode;
            this.changedFields = changedFields.add("objecttypecode");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder lastsyncerroroccurredon(OffsetDateTime lastsyncerroroccurredon) {
            this.lastsyncerroroccurredon = lastsyncerroroccurredon;
            this.changedFields = changedFields.add("lastsyncerroroccurredon");
            return this;
        }

        public Builder objectid(UUID objectid) {
            this.objectid = objectid;
            this.changedFields = changedFields.add("objectid");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder tocrmchangetype(Integer tocrmchangetype) {
            this.tocrmchangetype = tocrmchangetype;
            this.changedFields = changedFields.add("tocrmchangetype");
            return this;
        }

        public Builder itemsubject(String itemsubject) {
            this.itemsubject = itemsubject;
            this.changedFields = changedFields.add("itemsubject");
            return this;
        }

        public Builder isdeletedinexchange(Boolean isdeletedinexchange) {
            this.isdeletedinexchange = isdeletedinexchange;
            this.changedFields = changedFields.add("isdeletedinexchange");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder fromcrmchangetype(Integer fromcrmchangetype) {
            this.fromcrmchangetype = fromcrmchangetype;
            this.changedFields = changedFields.add("fromcrmchangetype");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder retries(Integer retries) {
            this.retries = retries;
            this.changedFields = changedFields.add("retries");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder exchangesyncidmappingid(UUID exchangesyncidmappingid) {
            this.exchangesyncidmappingid = exchangesyncidmappingid;
            this.changedFields = changedFields.add("exchangesyncidmappingid");
            return this;
        }

        public Builder isunlinkedincrm(Boolean isunlinkedincrm) {
            this.isunlinkedincrm = isunlinkedincrm;
            this.changedFields = changedFields.add("isunlinkedincrm");
            return this;
        }

        public Builder lastsyncerrorcode(Integer lastsyncerrorcode) {
            this.lastsyncerrorcode = lastsyncerrorcode;
            this.changedFields = changedFields.add("lastsyncerrorcode");
            return this;
        }

        public Builder userdecision(Integer userdecision) {
            this.userdecision = userdecision;
            this.changedFields = changedFields.add("userdecision");
            return this;
        }

        public Builder exchangeentryid(String exchangeentryid) {
            this.exchangeentryid = exchangeentryid;
            this.changedFields = changedFields.add("exchangeentryid");
            return this;
        }

        public Builder lastsyncerror(String lastsyncerror) {
            this.lastsyncerror = lastsyncerror;
            this.changedFields = changedFields.add("lastsyncerror");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Exchangesyncidmapping build() {
            Exchangesyncidmapping _x = new Exchangesyncidmapping();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.exchangesyncidmapping";
            _x.objecttypecode = objecttypecode;
            _x.modifiedon = modifiedon;
            _x.lastsyncerroroccurredon = lastsyncerroroccurredon;
            _x.objectid = objectid;
            _x._owninguser_value = _owninguser_value;
            _x.tocrmchangetype = tocrmchangetype;
            _x.itemsubject = itemsubject;
            _x.isdeletedinexchange = isdeletedinexchange;
            _x.versionnumber = versionnumber;
            _x.fromcrmchangetype = fromcrmchangetype;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x._ownerid_value = _ownerid_value;
            _x.retries = retries;
            _x._owningteam_value = _owningteam_value;
            _x.exchangesyncidmappingid = exchangesyncidmappingid;
            _x.isunlinkedincrm = isunlinkedincrm;
            _x.lastsyncerrorcode = lastsyncerrorcode;
            _x.userdecision = userdecision;
            _x.exchangeentryid = exchangeentryid;
            _x.lastsyncerror = lastsyncerror;
            _x.createdon = createdon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && exchangesyncidmappingid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(exchangesyncidmappingid, UUID.class));
        }
    }

    @Property(name="objecttypecode")
    @JsonIgnore
    public Optional<Integer> getObjecttypecode() {
        return Optional.ofNullable(objecttypecode);
    }

    public Exchangesyncidmapping withObjecttypecode(Integer objecttypecode) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("objecttypecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.objecttypecode = objecttypecode;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Exchangesyncidmapping withModifiedon(OffsetDateTime modifiedon) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="lastsyncerroroccurredon")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastsyncerroroccurredon() {
        return Optional.ofNullable(lastsyncerroroccurredon);
    }

    public Exchangesyncidmapping withLastsyncerroroccurredon(OffsetDateTime lastsyncerroroccurredon) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("lastsyncerroroccurredon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.lastsyncerroroccurredon = lastsyncerroroccurredon;
        return _x;
    }

    @Property(name="objectid")
    @JsonIgnore
    public Optional<UUID> getObjectid() {
        return Optional.ofNullable(objectid);
    }

    public Exchangesyncidmapping withObjectid(UUID objectid) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("objectid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.objectid = objectid;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Exchangesyncidmapping with_owninguser_value(UUID _owninguser_value) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="tocrmchangetype")
    @JsonIgnore
    public Optional<Integer> getTocrmchangetype() {
        return Optional.ofNullable(tocrmchangetype);
    }

    public Exchangesyncidmapping withTocrmchangetype(Integer tocrmchangetype) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("tocrmchangetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.tocrmchangetype = tocrmchangetype;
        return _x;
    }

    @Property(name="itemsubject")
    @JsonIgnore
    public Optional<String> getItemsubject() {
        return Optional.ofNullable(itemsubject);
    }

    public Exchangesyncidmapping withItemsubject(String itemsubject) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("itemsubject");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.itemsubject = itemsubject;
        return _x;
    }

    @Property(name="isdeletedinexchange")
    @JsonIgnore
    public Optional<Boolean> getIsdeletedinexchange() {
        return Optional.ofNullable(isdeletedinexchange);
    }

    public Exchangesyncidmapping withIsdeletedinexchange(Boolean isdeletedinexchange) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("isdeletedinexchange");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.isdeletedinexchange = isdeletedinexchange;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Exchangesyncidmapping withVersionnumber(Long versionnumber) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="fromcrmchangetype")
    @JsonIgnore
    public Optional<Integer> getFromcrmchangetype() {
        return Optional.ofNullable(fromcrmchangetype);
    }

    public Exchangesyncidmapping withFromcrmchangetype(Integer fromcrmchangetype) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("fromcrmchangetype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.fromcrmchangetype = fromcrmchangetype;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Exchangesyncidmapping with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Exchangesyncidmapping with_ownerid_value(UUID _ownerid_value) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="retries")
    @JsonIgnore
    public Optional<Integer> getRetries() {
        return Optional.ofNullable(retries);
    }

    public Exchangesyncidmapping withRetries(Integer retries) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("retries");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.retries = retries;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Exchangesyncidmapping with_owningteam_value(UUID _owningteam_value) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="exchangesyncidmappingid")
    @JsonIgnore
    public Optional<UUID> getExchangesyncidmappingid() {
        return Optional.ofNullable(exchangesyncidmappingid);
    }

    public Exchangesyncidmapping withExchangesyncidmappingid(UUID exchangesyncidmappingid) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("exchangesyncidmappingid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.exchangesyncidmappingid = exchangesyncidmappingid;
        return _x;
    }

    @Property(name="isunlinkedincrm")
    @JsonIgnore
    public Optional<Boolean> getIsunlinkedincrm() {
        return Optional.ofNullable(isunlinkedincrm);
    }

    public Exchangesyncidmapping withIsunlinkedincrm(Boolean isunlinkedincrm) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("isunlinkedincrm");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.isunlinkedincrm = isunlinkedincrm;
        return _x;
    }

    @Property(name="lastsyncerrorcode")
    @JsonIgnore
    public Optional<Integer> getLastsyncerrorcode() {
        return Optional.ofNullable(lastsyncerrorcode);
    }

    public Exchangesyncidmapping withLastsyncerrorcode(Integer lastsyncerrorcode) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("lastsyncerrorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.lastsyncerrorcode = lastsyncerrorcode;
        return _x;
    }

    @Property(name="userdecision")
    @JsonIgnore
    public Optional<Integer> getUserdecision() {
        return Optional.ofNullable(userdecision);
    }

    public Exchangesyncidmapping withUserdecision(Integer userdecision) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("userdecision");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.userdecision = userdecision;
        return _x;
    }

    @Property(name="exchangeentryid")
    @JsonIgnore
    public Optional<String> getExchangeentryid() {
        return Optional.ofNullable(exchangeentryid);
    }

    public Exchangesyncidmapping withExchangeentryid(String exchangeentryid) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("exchangeentryid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.exchangeentryid = exchangeentryid;
        return _x;
    }

    @Property(name="lastsyncerror")
    @JsonIgnore
    public Optional<String> getLastsyncerror() {
        return Optional.ofNullable(lastsyncerror);
    }

    public Exchangesyncidmapping withLastsyncerror(String lastsyncerror) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("lastsyncerror");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.lastsyncerror = lastsyncerror;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Exchangesyncidmapping withCreatedon(OffsetDateTime createdon) {
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.exchangesyncidmapping");
        _x.createdon = createdon;
        return _x;
    }

    public Exchangesyncidmapping withUnmappedField(String name, Object value) {
        Exchangesyncidmapping _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="owninguser")
    @JsonIgnore
    public SystemuserRequest getOwninguser() {
        return new SystemuserRequest(contextPath.addSegment("owninguser"), RequestHelper.getValue(unmappedFields, "owninguser"));
    }

    @NavigationProperty(name="owningteam")
    @JsonIgnore
    public TeamRequest getOwningteam() {
        return new TeamRequest(contextPath.addSegment("owningteam"), RequestHelper.getValue(unmappedFields, "owningteam"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Exchangesyncidmapping patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Exchangesyncidmapping put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Exchangesyncidmapping _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Exchangesyncidmapping _copy() {
        Exchangesyncidmapping _x = new Exchangesyncidmapping();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.objecttypecode = objecttypecode;
        _x.modifiedon = modifiedon;
        _x.lastsyncerroroccurredon = lastsyncerroroccurredon;
        _x.objectid = objectid;
        _x._owninguser_value = _owninguser_value;
        _x.tocrmchangetype = tocrmchangetype;
        _x.itemsubject = itemsubject;
        _x.isdeletedinexchange = isdeletedinexchange;
        _x.versionnumber = versionnumber;
        _x.fromcrmchangetype = fromcrmchangetype;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x._ownerid_value = _ownerid_value;
        _x.retries = retries;
        _x._owningteam_value = _owningteam_value;
        _x.exchangesyncidmappingid = exchangesyncidmappingid;
        _x.isunlinkedincrm = isunlinkedincrm;
        _x.lastsyncerrorcode = lastsyncerrorcode;
        _x.userdecision = userdecision;
        _x.exchangeentryid = exchangeentryid;
        _x.lastsyncerror = lastsyncerror;
        _x.createdon = createdon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Exchangesyncidmapping[");
        b.append("objecttypecode=");
        b.append(this.objecttypecode);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("lastsyncerroroccurredon=");
        b.append(this.lastsyncerroroccurredon);
        b.append(", ");
        b.append("objectid=");
        b.append(this.objectid);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("tocrmchangetype=");
        b.append(this.tocrmchangetype);
        b.append(", ");
        b.append("itemsubject=");
        b.append(this.itemsubject);
        b.append(", ");
        b.append("isdeletedinexchange=");
        b.append(this.isdeletedinexchange);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("fromcrmchangetype=");
        b.append(this.fromcrmchangetype);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("retries=");
        b.append(this.retries);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("exchangesyncidmappingid=");
        b.append(this.exchangesyncidmappingid);
        b.append(", ");
        b.append("isunlinkedincrm=");
        b.append(this.isunlinkedincrm);
        b.append(", ");
        b.append("lastsyncerrorcode=");
        b.append(this.lastsyncerrorcode);
        b.append(", ");
        b.append("userdecision=");
        b.append(this.userdecision);
        b.append(", ");
        b.append("exchangeentryid=");
        b.append(this.exchangeentryid);
        b.append(", ");
        b.append("lastsyncerror=");
        b.append(this.lastsyncerror);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
