package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "operatorcode", 
    "duplicateruleconditionid", 
    "createdon", 
    "_modifiedonbehalfby_value", 
    "owningbusinessunit", 
    "_createdonbehalfby_value", 
    "owninguser", 
    "ignoreblankvalues", 
    "baseattributename", 
    "matchingattributename", 
    "_ownerid_value", 
    "operatorparam", 
    "_createdby_value", 
    "_regardingobjectid_value", 
    "modifiedon", 
    "_modifiedby_value"})
@JsonInclude(Include.NON_NULL)
public class Duplicaterulecondition extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.duplicaterulecondition";
    }

    @JsonProperty("operatorcode")
    protected Integer operatorcode;

    @JsonProperty("duplicateruleconditionid")
    protected UUID duplicateruleconditionid;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("owningbusinessunit")
    protected UUID owningbusinessunit;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("owninguser")
    protected UUID owninguser;

    @JsonProperty("ignoreblankvalues")
    protected Boolean ignoreblankvalues;

    @JsonProperty("baseattributename")
    protected String baseattributename;

    @JsonProperty("matchingattributename")
    protected String matchingattributename;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("operatorparam")
    protected Integer operatorparam;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    protected Duplicaterulecondition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDuplicaterulecondition() {
        return new Builder();
    }

    public static final class Builder {
        private Integer operatorcode;
        private UUID duplicateruleconditionid;
        private OffsetDateTime createdon;
        private UUID _modifiedonbehalfby_value;
        private UUID owningbusinessunit;
        private UUID _createdonbehalfby_value;
        private UUID owninguser;
        private Boolean ignoreblankvalues;
        private String baseattributename;
        private String matchingattributename;
        private UUID _ownerid_value;
        private Integer operatorparam;
        private UUID _createdby_value;
        private UUID _regardingobjectid_value;
        private OffsetDateTime modifiedon;
        private UUID _modifiedby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder operatorcode(Integer operatorcode) {
            this.operatorcode = operatorcode;
            this.changedFields = changedFields.add("operatorcode");
            return this;
        }

        public Builder duplicateruleconditionid(UUID duplicateruleconditionid) {
            this.duplicateruleconditionid = duplicateruleconditionid;
            this.changedFields = changedFields.add("duplicateruleconditionid");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder owningbusinessunit(UUID owningbusinessunit) {
            this.owningbusinessunit = owningbusinessunit;
            this.changedFields = changedFields.add("owningbusinessunit");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder owninguser(UUID owninguser) {
            this.owninguser = owninguser;
            this.changedFields = changedFields.add("owninguser");
            return this;
        }

        public Builder ignoreblankvalues(Boolean ignoreblankvalues) {
            this.ignoreblankvalues = ignoreblankvalues;
            this.changedFields = changedFields.add("ignoreblankvalues");
            return this;
        }

        public Builder baseattributename(String baseattributename) {
            this.baseattributename = baseattributename;
            this.changedFields = changedFields.add("baseattributename");
            return this;
        }

        public Builder matchingattributename(String matchingattributename) {
            this.matchingattributename = matchingattributename;
            this.changedFields = changedFields.add("matchingattributename");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder operatorparam(Integer operatorparam) {
            this.operatorparam = operatorparam;
            this.changedFields = changedFields.add("operatorparam");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Duplicaterulecondition build() {
            Duplicaterulecondition _x = new Duplicaterulecondition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.duplicaterulecondition";
            _x.operatorcode = operatorcode;
            _x.duplicateruleconditionid = duplicateruleconditionid;
            _x.createdon = createdon;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.owningbusinessunit = owningbusinessunit;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.owninguser = owninguser;
            _x.ignoreblankvalues = ignoreblankvalues;
            _x.baseattributename = baseattributename;
            _x.matchingattributename = matchingattributename;
            _x._ownerid_value = _ownerid_value;
            _x.operatorparam = operatorparam;
            _x._createdby_value = _createdby_value;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.modifiedon = modifiedon;
            _x._modifiedby_value = _modifiedby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && duplicateruleconditionid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(duplicateruleconditionid, UUID.class));
        }
    }

    @Property(name="operatorcode")
    @JsonIgnore
    public Optional<Integer> getOperatorcode() {
        return Optional.ofNullable(operatorcode);
    }

    public Duplicaterulecondition withOperatorcode(Integer operatorcode) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("operatorcode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.operatorcode = operatorcode;
        return _x;
    }

    @Property(name="duplicateruleconditionid")
    @JsonIgnore
    public Optional<UUID> getDuplicateruleconditionid() {
        return Optional.ofNullable(duplicateruleconditionid);
    }

    public Duplicaterulecondition withDuplicateruleconditionid(UUID duplicateruleconditionid) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("duplicateruleconditionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.duplicateruleconditionid = duplicateruleconditionid;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Duplicaterulecondition withCreatedon(OffsetDateTime createdon) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Duplicaterulecondition with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="owningbusinessunit")
    @JsonIgnore
    public Optional<UUID> getOwningbusinessunit() {
        return Optional.ofNullable(owningbusinessunit);
    }

    public Duplicaterulecondition withOwningbusinessunit(UUID owningbusinessunit) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Duplicaterulecondition with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="owninguser")
    @JsonIgnore
    public Optional<UUID> getOwninguser() {
        return Optional.ofNullable(owninguser);
    }

    public Duplicaterulecondition withOwninguser(UUID owninguser) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("owninguser");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.owninguser = owninguser;
        return _x;
    }

    @Property(name="ignoreblankvalues")
    @JsonIgnore
    public Optional<Boolean> getIgnoreblankvalues() {
        return Optional.ofNullable(ignoreblankvalues);
    }

    public Duplicaterulecondition withIgnoreblankvalues(Boolean ignoreblankvalues) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("ignoreblankvalues");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.ignoreblankvalues = ignoreblankvalues;
        return _x;
    }

    @Property(name="baseattributename")
    @JsonIgnore
    public Optional<String> getBaseattributename() {
        return Optional.ofNullable(baseattributename);
    }

    public Duplicaterulecondition withBaseattributename(String baseattributename) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("baseattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.baseattributename = baseattributename;
        return _x;
    }

    @Property(name="matchingattributename")
    @JsonIgnore
    public Optional<String> getMatchingattributename() {
        return Optional.ofNullable(matchingattributename);
    }

    public Duplicaterulecondition withMatchingattributename(String matchingattributename) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("matchingattributename");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.matchingattributename = matchingattributename;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Duplicaterulecondition with_ownerid_value(UUID _ownerid_value) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="operatorparam")
    @JsonIgnore
    public Optional<Integer> getOperatorparam() {
        return Optional.ofNullable(operatorparam);
    }

    public Duplicaterulecondition withOperatorparam(Integer operatorparam) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("operatorparam");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.operatorparam = operatorparam;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Duplicaterulecondition with_createdby_value(UUID _createdby_value) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Duplicaterulecondition with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Duplicaterulecondition withModifiedon(OffsetDateTime modifiedon) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Duplicaterulecondition with_modifiedby_value(UUID _modifiedby_value) {
        Duplicaterulecondition _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterulecondition");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    public Duplicaterulecondition withUnmappedField(String name, Object value) {
        Duplicaterulecondition _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="DuplicateRuleCondition_SyncErrors")
    @JsonIgnore
    public SyncerrorCollectionRequest getDuplicateRuleCondition_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("DuplicateRuleCondition_SyncErrors"), RequestHelper.getValue(unmappedFields, "DuplicateRuleCondition_SyncErrors"));
    }

    @NavigationProperty(name="regardingobjectid")
    @JsonIgnore
    public DuplicateruleRequest getRegardingobjectid() {
        return new DuplicateruleRequest(contextPath.addSegment("regardingobjectid"), RequestHelper.getValue(unmappedFields, "regardingobjectid"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Duplicaterulecondition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Duplicaterulecondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Duplicaterulecondition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Duplicaterulecondition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Duplicaterulecondition _copy() {
        Duplicaterulecondition _x = new Duplicaterulecondition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.operatorcode = operatorcode;
        _x.duplicateruleconditionid = duplicateruleconditionid;
        _x.createdon = createdon;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.owningbusinessunit = owningbusinessunit;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.owninguser = owninguser;
        _x.ignoreblankvalues = ignoreblankvalues;
        _x.baseattributename = baseattributename;
        _x.matchingattributename = matchingattributename;
        _x._ownerid_value = _ownerid_value;
        _x.operatorparam = operatorparam;
        _x._createdby_value = _createdby_value;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.modifiedon = modifiedon;
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Duplicaterulecondition[");
        b.append("operatorcode=");
        b.append(this.operatorcode);
        b.append(", ");
        b.append("duplicateruleconditionid=");
        b.append(this.duplicateruleconditionid);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("owningbusinessunit=");
        b.append(this.owningbusinessunit);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("owninguser=");
        b.append(this.owninguser);
        b.append(", ");
        b.append("ignoreblankvalues=");
        b.append(this.ignoreblankvalues);
        b.append(", ");
        b.append("baseattributename=");
        b.append(this.baseattributename);
        b.append(", ");
        b.append("matchingattributename=");
        b.append(this.matchingattributename);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("operatorparam=");
        b.append(this.operatorparam);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
