package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.ApplicationuserRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessrecordstrackerRequest;
import microsoft.dynamics.crm.entity.request.CascadegrantrevokeaccessversiontrackerRequest;
import microsoft.dynamics.crm.entity.request.ConnectorRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspaceRequest;
import microsoft.dynamics.crm.entity.request.DatalakeworkspacepermissionRequest;
import microsoft.dynamics.crm.entity.request.DuplicateruleRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.EmailserverprofileRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariabledefinitionRequest;
import microsoft.dynamics.crm.entity.request.EnvironmentvariablevalueRequest;
import microsoft.dynamics.crm.entity.request.ExportsolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.FeedbackRequest;
import microsoft.dynamics.crm.entity.request.Ggw_crewRequest;
import microsoft.dynamics.crm.entity.request.Ggw_eventRequest;
import microsoft.dynamics.crm.entity.request.Ggw_teamRequest;
import microsoft.dynamics.crm.entity.request.Ggw_team_applicationRequest;
import microsoft.dynamics.crm.entity.request.GoalRequest;
import microsoft.dynamics.crm.entity.request.GoalrollupqueryRequest;
import microsoft.dynamics.crm.entity.request.KbarticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgearticleRequest;
import microsoft.dynamics.crm.entity.request.KnowledgebaserecordRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetrecordRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibdatasetscontainerRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aibfileattacheddataRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodlabelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingboundingboxRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aiodtrainingimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysiscomponentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisjobRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_analysisresultdetailRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_dataflowRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticleimageRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_knowledgearticletemplateRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_serviceconfigurationRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_slakpiRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleargumentRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthrulesetRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PublisherRequest;
import microsoft.dynamics.crm.entity.request.QueueRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.ServiceplanRequest;
import microsoft.dynamics.crm.entity.request.SharepointdocumentlocationRequest;
import microsoft.dynamics.crm.entity.request.SharepointsiteRequest;
import microsoft.dynamics.crm.entity.request.SocialactivityRequest;
import microsoft.dynamics.crm.entity.request.SocialprofileRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentattributeconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentconfigurationRequest;
import microsoft.dynamics.crm.entity.request.SolutioncomponentrelationshipconfigurationRequest;
import microsoft.dynamics.crm.entity.request.StagesolutionuploadRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TeamRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "createdon", 
    "_duplicateruleid_value", 
    "_ownerid_value", 
    "owningbusinessunit", 
    "_asyncoperationid_value", 
    "owninguser", 
    "_baserecordid_value", 
    "duplicateid", 
    "_duplicaterecordid_value"})
@JsonInclude(Include.NON_NULL)
public class Duplicaterecord extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.duplicaterecord";
    }

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_duplicateruleid_value")
    protected UUID _duplicateruleid_value;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("owningbusinessunit")
    protected UUID owningbusinessunit;

    @JsonProperty("_asyncoperationid_value")
    protected UUID _asyncoperationid_value;

    @JsonProperty("owninguser")
    protected UUID owninguser;

    @JsonProperty("_baserecordid_value")
    protected UUID _baserecordid_value;

    @JsonProperty("duplicateid")
    protected UUID duplicateid;

    @JsonProperty("_duplicaterecordid_value")
    protected UUID _duplicaterecordid_value;

    protected Duplicaterecord() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderDuplicaterecord() {
        return new Builder();
    }

    public static final class Builder {
        private OffsetDateTime createdon;
        private UUID _duplicateruleid_value;
        private UUID _ownerid_value;
        private UUID owningbusinessunit;
        private UUID _asyncoperationid_value;
        private UUID owninguser;
        private UUID _baserecordid_value;
        private UUID duplicateid;
        private UUID _duplicaterecordid_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _duplicateruleid_value(UUID _duplicateruleid_value) {
            this._duplicateruleid_value = _duplicateruleid_value;
            this.changedFields = changedFields.add("_duplicateruleid_value");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder owningbusinessunit(UUID owningbusinessunit) {
            this.owningbusinessunit = owningbusinessunit;
            this.changedFields = changedFields.add("owningbusinessunit");
            return this;
        }

        public Builder _asyncoperationid_value(UUID _asyncoperationid_value) {
            this._asyncoperationid_value = _asyncoperationid_value;
            this.changedFields = changedFields.add("_asyncoperationid_value");
            return this;
        }

        public Builder owninguser(UUID owninguser) {
            this.owninguser = owninguser;
            this.changedFields = changedFields.add("owninguser");
            return this;
        }

        public Builder _baserecordid_value(UUID _baserecordid_value) {
            this._baserecordid_value = _baserecordid_value;
            this.changedFields = changedFields.add("_baserecordid_value");
            return this;
        }

        public Builder duplicateid(UUID duplicateid) {
            this.duplicateid = duplicateid;
            this.changedFields = changedFields.add("duplicateid");
            return this;
        }

        public Builder _duplicaterecordid_value(UUID _duplicaterecordid_value) {
            this._duplicaterecordid_value = _duplicaterecordid_value;
            this.changedFields = changedFields.add("_duplicaterecordid_value");
            return this;
        }

        public Duplicaterecord build() {
            Duplicaterecord _x = new Duplicaterecord();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.duplicaterecord";
            _x.createdon = createdon;
            _x._duplicateruleid_value = _duplicateruleid_value;
            _x._ownerid_value = _ownerid_value;
            _x.owningbusinessunit = owningbusinessunit;
            _x._asyncoperationid_value = _asyncoperationid_value;
            _x.owninguser = owninguser;
            _x._baserecordid_value = _baserecordid_value;
            _x.duplicateid = duplicateid;
            _x._duplicaterecordid_value = _duplicaterecordid_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && duplicateid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(duplicateid, UUID.class));
        }
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Duplicaterecord withCreatedon(OffsetDateTime createdon) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_duplicateruleid_value")
    @JsonIgnore
    public Optional<UUID> get_duplicateruleid_value() {
        return Optional.ofNullable(_duplicateruleid_value);
    }

    public Duplicaterecord with_duplicateruleid_value(UUID _duplicateruleid_value) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("_duplicateruleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x._duplicateruleid_value = _duplicateruleid_value;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Duplicaterecord with_ownerid_value(UUID _ownerid_value) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="owningbusinessunit")
    @JsonIgnore
    public Optional<UUID> getOwningbusinessunit() {
        return Optional.ofNullable(owningbusinessunit);
    }

    public Duplicaterecord withOwningbusinessunit(UUID owningbusinessunit) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("owningbusinessunit");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x.owningbusinessunit = owningbusinessunit;
        return _x;
    }

    @Property(name="_asyncoperationid_value")
    @JsonIgnore
    public Optional<UUID> get_asyncoperationid_value() {
        return Optional.ofNullable(_asyncoperationid_value);
    }

    public Duplicaterecord with_asyncoperationid_value(UUID _asyncoperationid_value) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("_asyncoperationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x._asyncoperationid_value = _asyncoperationid_value;
        return _x;
    }

    @Property(name="owninguser")
    @JsonIgnore
    public Optional<UUID> getOwninguser() {
        return Optional.ofNullable(owninguser);
    }

    public Duplicaterecord withOwninguser(UUID owninguser) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("owninguser");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x.owninguser = owninguser;
        return _x;
    }

    @Property(name="_baserecordid_value")
    @JsonIgnore
    public Optional<UUID> get_baserecordid_value() {
        return Optional.ofNullable(_baserecordid_value);
    }

    public Duplicaterecord with_baserecordid_value(UUID _baserecordid_value) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("_baserecordid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x._baserecordid_value = _baserecordid_value;
        return _x;
    }

    @Property(name="duplicateid")
    @JsonIgnore
    public Optional<UUID> getDuplicateid() {
        return Optional.ofNullable(duplicateid);
    }

    public Duplicaterecord withDuplicateid(UUID duplicateid) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("duplicateid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x.duplicateid = duplicateid;
        return _x;
    }

    @Property(name="_duplicaterecordid_value")
    @JsonIgnore
    public Optional<UUID> get_duplicaterecordid_value() {
        return Optional.ofNullable(_duplicaterecordid_value);
    }

    public Duplicaterecord with_duplicaterecordid_value(UUID _duplicaterecordid_value) {
        Duplicaterecord _x = _copy();
        _x.changedFields = changedFields.add("_duplicaterecordid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.duplicaterecord");
        _x._duplicaterecordid_value = _duplicaterecordid_value;
        return _x;
    }

    public Duplicaterecord withUnmappedField(String name, Object value) {
        Duplicaterecord _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="duplicaterecordid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getDuplicaterecordid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("duplicaterecordid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_knowledgearticle"));
    }

    @NavigationProperty(name="baserecordid_knowledgearticle")
    @JsonIgnore
    public KnowledgearticleRequest getBaserecordid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("baserecordid_knowledgearticle"), RequestHelper.getValue(unmappedFields, "baserecordid_knowledgearticle"));
    }

    @NavigationProperty(name="duplicaterecordid_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getDuplicaterecordid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("duplicaterecordid_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_knowledgebaserecord"));
    }

    @NavigationProperty(name="baserecordid_knowledgebaserecord")
    @JsonIgnore
    public KnowledgebaserecordRequest getBaserecordid_knowledgebaserecord() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("baserecordid_knowledgebaserecord"), RequestHelper.getValue(unmappedFields, "baserecordid_knowledgebaserecord"));
    }

    @NavigationProperty(name="baserecordid_goalrollupquery")
    @JsonIgnore
    public GoalrollupqueryRequest getBaserecordid_goalrollupquery() {
        return new GoalrollupqueryRequest(contextPath.addSegment("baserecordid_goalrollupquery"), RequestHelper.getValue(unmappedFields, "baserecordid_goalrollupquery"));
    }

    @NavigationProperty(name="duplicaterecordid_publisher")
    @JsonIgnore
    public PublisherRequest getDuplicaterecordid_publisher() {
        return new PublisherRequest(contextPath.addSegment("duplicaterecordid_publisher"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_publisher"));
    }

    @NavigationProperty(name="baserecordid_transactioncurrency")
    @JsonIgnore
    public TransactioncurrencyRequest getBaserecordid_transactioncurrency() {
        return new TransactioncurrencyRequest(contextPath.addSegment("baserecordid_transactioncurrency"), RequestHelper.getValue(unmappedFields, "baserecordid_transactioncurrency"));
    }

    @NavigationProperty(name="baserecordid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getBaserecordid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("baserecordid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "baserecordid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="duplicaterecordid_goal")
    @JsonIgnore
    public GoalRequest getDuplicaterecordid_goal() {
        return new GoalRequest(contextPath.addSegment("duplicaterecordid_goal"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_goal"));
    }

    @NavigationProperty(name="duplicaterecordid_transactioncurrency")
    @JsonIgnore
    public TransactioncurrencyRequest getDuplicaterecordid_transactioncurrency() {
        return new TransactioncurrencyRequest(contextPath.addSegment("duplicaterecordid_transactioncurrency"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_transactioncurrency"));
    }

    @NavigationProperty(name="baserecordid_task")
    @JsonIgnore
    public TaskRequest getBaserecordid_task() {
        return new TaskRequest(contextPath.addSegment("baserecordid_task"), RequestHelper.getValue(unmappedFields, "baserecordid_task"));
    }

    @NavigationProperty(name="duplicaterecordid_recurringappointmentmaster")
    @JsonIgnore
    public RecurringappointmentmasterRequest getDuplicaterecordid_recurringappointmentmaster() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("duplicaterecordid_recurringappointmentmaster"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_recurringappointmentmaster"));
    }

    @NavigationProperty(name="asyncoperationid")
    @JsonIgnore
    public AsyncoperationRequest getAsyncoperationid() {
        return new AsyncoperationRequest(contextPath.addSegment("asyncoperationid"), RequestHelper.getValue(unmappedFields, "asyncoperationid"));
    }

    @NavigationProperty(name="duplicaterecordid_task")
    @JsonIgnore
    public TaskRequest getDuplicaterecordid_task() {
        return new TaskRequest(contextPath.addSegment("duplicaterecordid_task"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_task"));
    }

    @NavigationProperty(name="baserecordid_email")
    @JsonIgnore
    public EmailRequest getBaserecordid_email() {
        return new EmailRequest(contextPath.addSegment("baserecordid_email"), RequestHelper.getValue(unmappedFields, "baserecordid_email"));
    }

    @NavigationProperty(name="baserecordid_socialprofile")
    @JsonIgnore
    public SocialprofileRequest getBaserecordid_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("baserecordid_socialprofile"), RequestHelper.getValue(unmappedFields, "baserecordid_socialprofile"));
    }

    @NavigationProperty(name="baserecordid_team")
    @JsonIgnore
    public TeamRequest getBaserecordid_team() {
        return new TeamRequest(contextPath.addSegment("baserecordid_team"), RequestHelper.getValue(unmappedFields, "baserecordid_team"));
    }

    @NavigationProperty(name="baserecordid_systemuser")
    @JsonIgnore
    public SystemuserRequest getBaserecordid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("baserecordid_systemuser"), RequestHelper.getValue(unmappedFields, "baserecordid_systemuser"));
    }

    @NavigationProperty(name="baserecordid_account")
    @JsonIgnore
    public AccountRequest getBaserecordid_account() {
        return new AccountRequest(contextPath.addSegment("baserecordid_account"), RequestHelper.getValue(unmappedFields, "baserecordid_account"));
    }

    @NavigationProperty(name="baserecordid_appointment")
    @JsonIgnore
    public AppointmentRequest getBaserecordid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("baserecordid_appointment"), RequestHelper.getValue(unmappedFields, "baserecordid_appointment"));
    }

    @NavigationProperty(name="baserecordid_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationRequest getBaserecordid_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("baserecordid_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "baserecordid_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="duplicaterecordid_fax")
    @JsonIgnore
    public FaxRequest getDuplicaterecordid_fax() {
        return new FaxRequest(contextPath.addSegment("duplicaterecordid_fax"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_fax"));
    }

    @NavigationProperty(name="baserecordid_publisher")
    @JsonIgnore
    public PublisherRequest getBaserecordid_publisher() {
        return new PublisherRequest(contextPath.addSegment("baserecordid_publisher"), RequestHelper.getValue(unmappedFields, "baserecordid_publisher"));
    }

    @NavigationProperty(name="duplicaterecordid_sharepointsite")
    @JsonIgnore
    public SharepointsiteRequest getDuplicaterecordid_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("duplicaterecordid_sharepointsite"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_sharepointsite"));
    }

    @NavigationProperty(name="duplicaterecordid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getDuplicaterecordid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("duplicaterecordid_kbarticle"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_kbarticle"));
    }

    @NavigationProperty(name="duplicaterecordid_team")
    @JsonIgnore
    public TeamRequest getDuplicaterecordid_team() {
        return new TeamRequest(contextPath.addSegment("duplicaterecordid_team"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_team"));
    }

    @NavigationProperty(name="duplicaterecordid_appointment")
    @JsonIgnore
    public AppointmentRequest getDuplicaterecordid_appointment() {
        return new AppointmentRequest(contextPath.addSegment("duplicaterecordid_appointment"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_appointment"));
    }

    @NavigationProperty(name="duplicaterecordid_phonecall")
    @JsonIgnore
    public PhonecallRequest getDuplicaterecordid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("duplicaterecordid_phonecall"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_phonecall"));
    }

    @NavigationProperty(name="duplicaterecordid_goalrollupquery")
    @JsonIgnore
    public GoalrollupqueryRequest getDuplicaterecordid_goalrollupquery() {
        return new GoalrollupqueryRequest(contextPath.addSegment("duplicaterecordid_goalrollupquery"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_goalrollupquery"));
    }

    @NavigationProperty(name="baserecordid_sharepointsite")
    @JsonIgnore
    public SharepointsiteRequest getBaserecordid_sharepointsite() {
        return new SharepointsiteRequest(contextPath.addSegment("baserecordid_sharepointsite"), RequestHelper.getValue(unmappedFields, "baserecordid_sharepointsite"));
    }

    @NavigationProperty(name="baserecordid_phonecall")
    @JsonIgnore
    public PhonecallRequest getBaserecordid_phonecall() {
        return new PhonecallRequest(contextPath.addSegment("baserecordid_phonecall"), RequestHelper.getValue(unmappedFields, "baserecordid_phonecall"));
    }

    @NavigationProperty(name="duplicaterecordid_contact")
    @JsonIgnore
    public ContactRequest getDuplicaterecordid_contact() {
        return new ContactRequest(contextPath.addSegment("duplicaterecordid_contact"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_contact"));
    }

    @NavigationProperty(name="baserecordid_kbarticle")
    @JsonIgnore
    public KbarticleRequest getBaserecordid_kbarticle() {
        return new KbarticleRequest(contextPath.addSegment("baserecordid_kbarticle"), RequestHelper.getValue(unmappedFields, "baserecordid_kbarticle"));
    }

    @NavigationProperty(name="duplicaterecordid_email")
    @JsonIgnore
    public EmailRequest getDuplicaterecordid_email() {
        return new EmailRequest(contextPath.addSegment("duplicaterecordid_email"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_email"));
    }

    @NavigationProperty(name="baserecordid_letter")
    @JsonIgnore
    public LetterRequest getBaserecordid_letter() {
        return new LetterRequest(contextPath.addSegment("baserecordid_letter"), RequestHelper.getValue(unmappedFields, "baserecordid_letter"));
    }

    @NavigationProperty(name="baserecordid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getBaserecordid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("baserecordid_socialactivity"), RequestHelper.getValue(unmappedFields, "baserecordid_socialactivity"));
    }

    @NavigationProperty(name="duplicaterecordid_systemuser")
    @JsonIgnore
    public SystemuserRequest getDuplicaterecordid_systemuser() {
        return new SystemuserRequest(contextPath.addSegment("duplicaterecordid_systemuser"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_systemuser"));
    }

    @NavigationProperty(name="duplicaterecordid_socialactivity")
    @JsonIgnore
    public SocialactivityRequest getDuplicaterecordid_socialactivity() {
        return new SocialactivityRequest(contextPath.addSegment("duplicaterecordid_socialactivity"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_socialactivity"));
    }

    @NavigationProperty(name="duplicaterecordid_sharepointdocumentlocation")
    @JsonIgnore
    public SharepointdocumentlocationRequest getDuplicaterecordid_sharepointdocumentlocation() {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("duplicaterecordid_sharepointdocumentlocation"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_sharepointdocumentlocation"));
    }

    @NavigationProperty(name="duplicaterecordid_socialprofile")
    @JsonIgnore
    public SocialprofileRequest getDuplicaterecordid_socialprofile() {
        return new SocialprofileRequest(contextPath.addSegment("duplicaterecordid_socialprofile"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_socialprofile"));
    }

    @NavigationProperty(name="baserecordid_goal")
    @JsonIgnore
    public GoalRequest getBaserecordid_goal() {
        return new GoalRequest(contextPath.addSegment("baserecordid_goal"), RequestHelper.getValue(unmappedFields, "baserecordid_goal"));
    }

    @NavigationProperty(name="duplicaterecordid_account")
    @JsonIgnore
    public AccountRequest getDuplicaterecordid_account() {
        return new AccountRequest(contextPath.addSegment("duplicaterecordid_account"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_account"));
    }

    @NavigationProperty(name="baserecordid_fax")
    @JsonIgnore
    public FaxRequest getBaserecordid_fax() {
        return new FaxRequest(contextPath.addSegment("baserecordid_fax"), RequestHelper.getValue(unmappedFields, "baserecordid_fax"));
    }

    @NavigationProperty(name="duplicaterecordid_queue")
    @JsonIgnore
    public QueueRequest getDuplicaterecordid_queue() {
        return new QueueRequest(contextPath.addSegment("duplicaterecordid_queue"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_queue"));
    }

    @NavigationProperty(name="duplicateruleid")
    @JsonIgnore
    public DuplicateruleRequest getDuplicateruleid() {
        return new DuplicateruleRequest(contextPath.addSegment("duplicateruleid"), RequestHelper.getValue(unmappedFields, "duplicateruleid"));
    }

    @NavigationProperty(name="baserecordid_contact")
    @JsonIgnore
    public ContactRequest getBaserecordid_contact() {
        return new ContactRequest(contextPath.addSegment("baserecordid_contact"), RequestHelper.getValue(unmappedFields, "baserecordid_contact"));
    }

    @NavigationProperty(name="duplicaterecordid_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileRequest getDuplicaterecordid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("duplicaterecordid_emailserverprofile"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_emailserverprofile"));
    }

    @NavigationProperty(name="baserecordid_queue")
    @JsonIgnore
    public QueueRequest getBaserecordid_queue() {
        return new QueueRequest(contextPath.addSegment("baserecordid_queue"), RequestHelper.getValue(unmappedFields, "baserecordid_queue"));
    }

    @NavigationProperty(name="baserecordid_emailserverprofile")
    @JsonIgnore
    public EmailserverprofileRequest getBaserecordid_emailserverprofile() {
        return new EmailserverprofileRequest(contextPath.addSegment("baserecordid_emailserverprofile"), RequestHelper.getValue(unmappedFields, "baserecordid_emailserverprofile"));
    }

    @NavigationProperty(name="duplicaterecordid_letter")
    @JsonIgnore
    public LetterRequest getDuplicaterecordid_letter() {
        return new LetterRequest(contextPath.addSegment("duplicaterecordid_letter"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_letter"));
    }

    @NavigationProperty(name="baserecordid_feedback")
    @JsonIgnore
    public FeedbackRequest getBaserecordid_feedback() {
        return new FeedbackRequest(contextPath.addSegment("baserecordid_feedback"), RequestHelper.getValue(unmappedFields, "baserecordid_feedback"));
    }

    @NavigationProperty(name="duplicaterecordid_feedback")
    @JsonIgnore
    public FeedbackRequest getDuplicaterecordid_feedback() {
        return new FeedbackRequest(contextPath.addSegment("duplicaterecordid_feedback"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_feedback"));
    }

    @NavigationProperty(name="duplicaterecordid_solutioncomponentattributeconfiguration")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationRequest getDuplicaterecordid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("duplicaterecordid_solutioncomponentattributeconfiguration"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_solutioncomponentattributeconfiguration"));
    }

    @NavigationProperty(name="baserecordid_solutioncomponentattributeconfiguration")
    @JsonIgnore
    public SolutioncomponentattributeconfigurationRequest getBaserecordid_solutioncomponentattributeconfiguration() {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("baserecordid_solutioncomponentattributeconfiguration"), RequestHelper.getValue(unmappedFields, "baserecordid_solutioncomponentattributeconfiguration"));
    }

    @NavigationProperty(name="duplicaterecordid_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationRequest getDuplicaterecordid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("duplicaterecordid_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="baserecordid_solutioncomponentconfiguration")
    @JsonIgnore
    public SolutioncomponentconfigurationRequest getBaserecordid_solutioncomponentconfiguration() {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("baserecordid_solutioncomponentconfiguration"), RequestHelper.getValue(unmappedFields, "baserecordid_solutioncomponentconfiguration"));
    }

    @NavigationProperty(name="duplicaterecordid_solutioncomponentrelationshipconfiguration")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationRequest getDuplicaterecordid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("duplicaterecordid_solutioncomponentrelationshipconfiguration"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_solutioncomponentrelationshipconfiguration"));
    }

    @NavigationProperty(name="baserecordid_solutioncomponentrelationshipconfiguration")
    @JsonIgnore
    public SolutioncomponentrelationshipconfigurationRequest getBaserecordid_solutioncomponentrelationshipconfiguration() {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("baserecordid_solutioncomponentrelationshipconfiguration"), RequestHelper.getValue(unmappedFields, "baserecordid_solutioncomponentrelationshipconfiguration"));
    }

    @NavigationProperty(name="duplicaterecordid_stagesolutionupload")
    @JsonIgnore
    public StagesolutionuploadRequest getDuplicaterecordid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("duplicaterecordid_stagesolutionupload"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_stagesolutionupload"));
    }

    @NavigationProperty(name="baserecordid_stagesolutionupload")
    @JsonIgnore
    public StagesolutionuploadRequest getBaserecordid_stagesolutionupload() {
        return new StagesolutionuploadRequest(contextPath.addSegment("baserecordid_stagesolutionupload"), RequestHelper.getValue(unmappedFields, "baserecordid_stagesolutionupload"));
    }

    @NavigationProperty(name="duplicaterecordid_exportsolutionupload")
    @JsonIgnore
    public ExportsolutionuploadRequest getDuplicaterecordid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("duplicaterecordid_exportsolutionupload"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_exportsolutionupload"));
    }

    @NavigationProperty(name="baserecordid_exportsolutionupload")
    @JsonIgnore
    public ExportsolutionuploadRequest getBaserecordid_exportsolutionupload() {
        return new ExportsolutionuploadRequest(contextPath.addSegment("baserecordid_exportsolutionupload"), RequestHelper.getValue(unmappedFields, "baserecordid_exportsolutionupload"));
    }

    @NavigationProperty(name="duplicaterecordid_datalakeworkspace")
    @JsonIgnore
    public DatalakeworkspaceRequest getDuplicaterecordid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("duplicaterecordid_datalakeworkspace"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_datalakeworkspace"));
    }

    @NavigationProperty(name="baserecordid_datalakeworkspace")
    @JsonIgnore
    public DatalakeworkspaceRequest getBaserecordid_datalakeworkspace() {
        return new DatalakeworkspaceRequest(contextPath.addSegment("baserecordid_datalakeworkspace"), RequestHelper.getValue(unmappedFields, "baserecordid_datalakeworkspace"));
    }

    @NavigationProperty(name="duplicaterecordid_datalakeworkspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionRequest getDuplicaterecordid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("duplicaterecordid_datalakeworkspacepermission"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_datalakeworkspacepermission"));
    }

    @NavigationProperty(name="baserecordid_datalakeworkspacepermission")
    @JsonIgnore
    public DatalakeworkspacepermissionRequest getBaserecordid_datalakeworkspacepermission() {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("baserecordid_datalakeworkspacepermission"), RequestHelper.getValue(unmappedFields, "baserecordid_datalakeworkspacepermission"));
    }

    @NavigationProperty(name="duplicaterecordid_applicationuser")
    @JsonIgnore
    public ApplicationuserRequest getDuplicaterecordid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("duplicaterecordid_applicationuser"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_applicationuser"));
    }

    @NavigationProperty(name="baserecordid_applicationuser")
    @JsonIgnore
    public ApplicationuserRequest getBaserecordid_applicationuser() {
        return new ApplicationuserRequest(contextPath.addSegment("baserecordid_applicationuser"), RequestHelper.getValue(unmappedFields, "baserecordid_applicationuser"));
    }

    @NavigationProperty(name="duplicaterecordid_serviceplan")
    @JsonIgnore
    public ServiceplanRequest getDuplicaterecordid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("duplicaterecordid_serviceplan"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_serviceplan"));
    }

    @NavigationProperty(name="baserecordid_serviceplan")
    @JsonIgnore
    public ServiceplanRequest getBaserecordid_serviceplan() {
        return new ServiceplanRequest(contextPath.addSegment("baserecordid_serviceplan"), RequestHelper.getValue(unmappedFields, "baserecordid_serviceplan"));
    }

    @NavigationProperty(name="duplicaterecordid_connector")
    @JsonIgnore
    public ConnectorRequest getDuplicaterecordid_connector() {
        return new ConnectorRequest(contextPath.addSegment("duplicaterecordid_connector"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_connector"));
    }

    @NavigationProperty(name="baserecordid_connector")
    @JsonIgnore
    public ConnectorRequest getBaserecordid_connector() {
        return new ConnectorRequest(contextPath.addSegment("baserecordid_connector"), RequestHelper.getValue(unmappedFields, "baserecordid_connector"));
    }

    @NavigationProperty(name="duplicaterecordid_environmentvariabledefinition")
    @JsonIgnore
    public EnvironmentvariabledefinitionRequest getDuplicaterecordid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("duplicaterecordid_environmentvariabledefinition"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_environmentvariabledefinition"));
    }

    @NavigationProperty(name="baserecordid_environmentvariabledefinition")
    @JsonIgnore
    public EnvironmentvariabledefinitionRequest getBaserecordid_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("baserecordid_environmentvariabledefinition"), RequestHelper.getValue(unmappedFields, "baserecordid_environmentvariabledefinition"));
    }

    @NavigationProperty(name="duplicaterecordid_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueRequest getDuplicaterecordid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("duplicaterecordid_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_environmentvariablevalue"));
    }

    @NavigationProperty(name="baserecordid_environmentvariablevalue")
    @JsonIgnore
    public EnvironmentvariablevalueRequest getBaserecordid_environmentvariablevalue() {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("baserecordid_environmentvariablevalue"), RequestHelper.getValue(unmappedFields, "baserecordid_environmentvariablevalue"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_serviceconfiguration")
    @JsonIgnore
    public Msdyn_serviceconfigurationRequest getDuplicaterecordid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("duplicaterecordid_msdyn_serviceconfiguration"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_serviceconfiguration"));
    }

    @NavigationProperty(name="baserecordid_msdyn_serviceconfiguration")
    @JsonIgnore
    public Msdyn_serviceconfigurationRequest getBaserecordid_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("baserecordid_msdyn_serviceconfiguration"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_serviceconfiguration"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_slakpi")
    @JsonIgnore
    public Msdyn_slakpiRequest getDuplicaterecordid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("duplicaterecordid_msdyn_slakpi"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_slakpi"));
    }

    @NavigationProperty(name="baserecordid_msdyn_slakpi")
    @JsonIgnore
    public Msdyn_slakpiRequest getBaserecordid_msdyn_slakpi() {
        return new Msdyn_slakpiRequest(contextPath.addSegment("baserecordid_msdyn_slakpi"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_slakpi"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_knowledgearticleimage")
    @JsonIgnore
    public Msdyn_knowledgearticleimageRequest getDuplicaterecordid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("duplicaterecordid_msdyn_knowledgearticleimage"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_knowledgearticleimage"));
    }

    @NavigationProperty(name="baserecordid_msdyn_knowledgearticleimage")
    @JsonIgnore
    public Msdyn_knowledgearticleimageRequest getBaserecordid_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("baserecordid_msdyn_knowledgearticleimage"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_knowledgearticleimage"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getDuplicaterecordid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("duplicaterecordid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_knowledgearticletemplate"));
    }

    @NavigationProperty(name="baserecordid_msdyn_knowledgearticletemplate")
    @JsonIgnore
    public Msdyn_knowledgearticletemplateRequest getBaserecordid_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("baserecordid_msdyn_knowledgearticletemplate"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_knowledgearticletemplate"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_dataflow")
    @JsonIgnore
    public Msdyn_dataflowRequest getDuplicaterecordid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("duplicaterecordid_msdyn_dataflow"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_dataflow"));
    }

    @NavigationProperty(name="baserecordid_msdyn_dataflow")
    @JsonIgnore
    public Msdyn_dataflowRequest getBaserecordid_msdyn_dataflow() {
        return new Msdyn_dataflowRequest(contextPath.addSegment("baserecordid_msdyn_dataflow"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_dataflow"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aibdataset")
    @JsonIgnore
    public Msdyn_aibdatasetRequest getDuplicaterecordid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("duplicaterecordid_msdyn_aibdataset"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aibdataset"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aibdataset")
    @JsonIgnore
    public Msdyn_aibdatasetRequest getBaserecordid_msdyn_aibdataset() {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("baserecordid_msdyn_aibdataset"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aibdataset"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aibdatasetfile")
    @JsonIgnore
    public Msdyn_aibdatasetfileRequest getDuplicaterecordid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("duplicaterecordid_msdyn_aibdatasetfile"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aibdatasetfile"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aibdatasetfile")
    @JsonIgnore
    public Msdyn_aibdatasetfileRequest getBaserecordid_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("baserecordid_msdyn_aibdatasetfile"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aibdatasetfile"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aibdatasetrecord")
    @JsonIgnore
    public Msdyn_aibdatasetrecordRequest getDuplicaterecordid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("duplicaterecordid_msdyn_aibdatasetrecord"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aibdatasetrecord"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aibdatasetrecord")
    @JsonIgnore
    public Msdyn_aibdatasetrecordRequest getBaserecordid_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("baserecordid_msdyn_aibdatasetrecord"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aibdatasetrecord"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aibdatasetscontainer")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerRequest getDuplicaterecordid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("duplicaterecordid_msdyn_aibdatasetscontainer"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aibdatasetscontainer"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aibdatasetscontainer")
    @JsonIgnore
    public Msdyn_aibdatasetscontainerRequest getBaserecordid_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("baserecordid_msdyn_aibdatasetscontainer"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aibdatasetscontainer"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aibfile")
    @JsonIgnore
    public Msdyn_aibfileRequest getDuplicaterecordid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("duplicaterecordid_msdyn_aibfile"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aibfile"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aibfile")
    @JsonIgnore
    public Msdyn_aibfileRequest getBaserecordid_msdyn_aibfile() {
        return new Msdyn_aibfileRequest(contextPath.addSegment("baserecordid_msdyn_aibfile"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aibfile"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aibfileattacheddata")
    @JsonIgnore
    public Msdyn_aibfileattacheddataRequest getDuplicaterecordid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("duplicaterecordid_msdyn_aibfileattacheddata"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aibfileattacheddata"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aibfileattacheddata")
    @JsonIgnore
    public Msdyn_aibfileattacheddataRequest getBaserecordid_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("baserecordid_msdyn_aibfileattacheddata"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aibfileattacheddata"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageRequest getDuplicaterecordid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("duplicaterecordid_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aiodimage"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aiodimage")
    @JsonIgnore
    public Msdyn_aiodimageRequest getBaserecordid_msdyn_aiodimage() {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("baserecordid_msdyn_aiodimage"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aiodimage"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aiodlabel")
    @JsonIgnore
    public Msdyn_aiodlabelRequest getDuplicaterecordid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("duplicaterecordid_msdyn_aiodlabel"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aiodlabel"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aiodlabel")
    @JsonIgnore
    public Msdyn_aiodlabelRequest getBaserecordid_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("baserecordid_msdyn_aiodlabel"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aiodlabel"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxRequest getDuplicaterecordid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("duplicaterecordid_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aiodtrainingboundingbox"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aiodtrainingboundingbox")
    @JsonIgnore
    public Msdyn_aiodtrainingboundingboxRequest getBaserecordid_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("baserecordid_msdyn_aiodtrainingboundingbox"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aiodtrainingboundingbox"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageRequest getDuplicaterecordid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("duplicaterecordid_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="baserecordid_msdyn_aiodtrainingimage")
    @JsonIgnore
    public Msdyn_aiodtrainingimageRequest getBaserecordid_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("baserecordid_msdyn_aiodtrainingimage"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_aiodtrainingimage"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentRequest getDuplicaterecordid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("duplicaterecordid_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="baserecordid_msdyn_analysiscomponent")
    @JsonIgnore
    public Msdyn_analysiscomponentRequest getBaserecordid_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("baserecordid_msdyn_analysiscomponent"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_analysiscomponent"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_analysisjob")
    @JsonIgnore
    public Msdyn_analysisjobRequest getDuplicaterecordid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("duplicaterecordid_msdyn_analysisjob"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_analysisjob"));
    }

    @NavigationProperty(name="baserecordid_msdyn_analysisjob")
    @JsonIgnore
    public Msdyn_analysisjobRequest getBaserecordid_msdyn_analysisjob() {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("baserecordid_msdyn_analysisjob"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_analysisjob"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultRequest getDuplicaterecordid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("duplicaterecordid_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_analysisresult"));
    }

    @NavigationProperty(name="baserecordid_msdyn_analysisresult")
    @JsonIgnore
    public Msdyn_analysisresultRequest getBaserecordid_msdyn_analysisresult() {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("baserecordid_msdyn_analysisresult"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_analysisresult"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_analysisresultdetail")
    @JsonIgnore
    public Msdyn_analysisresultdetailRequest getDuplicaterecordid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("duplicaterecordid_msdyn_analysisresultdetail"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_analysisresultdetail"));
    }

    @NavigationProperty(name="baserecordid_msdyn_analysisresultdetail")
    @JsonIgnore
    public Msdyn_analysisresultdetailRequest getBaserecordid_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("baserecordid_msdyn_analysisresultdetail"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_analysisresultdetail"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_solutionhealthrule")
    @JsonIgnore
    public Msdyn_solutionhealthruleRequest getDuplicaterecordid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("duplicaterecordid_msdyn_solutionhealthrule"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_solutionhealthrule"));
    }

    @NavigationProperty(name="baserecordid_msdyn_solutionhealthrule")
    @JsonIgnore
    public Msdyn_solutionhealthruleRequest getBaserecordid_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("baserecordid_msdyn_solutionhealthrule"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_solutionhealthrule"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_solutionhealthruleargument")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentRequest getDuplicaterecordid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("duplicaterecordid_msdyn_solutionhealthruleargument"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_solutionhealthruleargument"));
    }

    @NavigationProperty(name="baserecordid_msdyn_solutionhealthruleargument")
    @JsonIgnore
    public Msdyn_solutionhealthruleargumentRequest getBaserecordid_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("baserecordid_msdyn_solutionhealthruleargument"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_solutionhealthruleargument"));
    }

    @NavigationProperty(name="duplicaterecordid_msdyn_solutionhealthruleset")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getDuplicaterecordid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("duplicaterecordid_msdyn_solutionhealthruleset"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_msdyn_solutionhealthruleset"));
    }

    @NavigationProperty(name="baserecordid_msdyn_solutionhealthruleset")
    @JsonIgnore
    public Msdyn_solutionhealthrulesetRequest getBaserecordid_msdyn_solutionhealthruleset() {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("baserecordid_msdyn_solutionhealthruleset"), RequestHelper.getValue(unmappedFields, "baserecordid_msdyn_solutionhealthruleset"));
    }

    @NavigationProperty(name="duplicaterecordid_ggw_event")
    @JsonIgnore
    public Ggw_eventRequest getDuplicaterecordid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("duplicaterecordid_ggw_event"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_ggw_event"));
    }

    @NavigationProperty(name="baserecordid_ggw_event")
    @JsonIgnore
    public Ggw_eventRequest getBaserecordid_ggw_event() {
        return new Ggw_eventRequest(contextPath.addSegment("baserecordid_ggw_event"), RequestHelper.getValue(unmappedFields, "baserecordid_ggw_event"));
    }

    @NavigationProperty(name="duplicaterecordid_ggw_team")
    @JsonIgnore
    public Ggw_teamRequest getDuplicaterecordid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("duplicaterecordid_ggw_team"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_ggw_team"));
    }

    @NavigationProperty(name="baserecordid_ggw_team")
    @JsonIgnore
    public Ggw_teamRequest getBaserecordid_ggw_team() {
        return new Ggw_teamRequest(contextPath.addSegment("baserecordid_ggw_team"), RequestHelper.getValue(unmappedFields, "baserecordid_ggw_team"));
    }

    @NavigationProperty(name="duplicaterecordid_ggw_crew")
    @JsonIgnore
    public Ggw_crewRequest getDuplicaterecordid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("duplicaterecordid_ggw_crew"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_ggw_crew"));
    }

    @NavigationProperty(name="baserecordid_ggw_crew")
    @JsonIgnore
    public Ggw_crewRequest getBaserecordid_ggw_crew() {
        return new Ggw_crewRequest(contextPath.addSegment("baserecordid_ggw_crew"), RequestHelper.getValue(unmappedFields, "baserecordid_ggw_crew"));
    }

    @NavigationProperty(name="duplicaterecordid_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationRequest getDuplicaterecordid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("duplicaterecordid_ggw_team_application"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_ggw_team_application"));
    }

    @NavigationProperty(name="baserecordid_ggw_team_application")
    @JsonIgnore
    public Ggw_team_applicationRequest getBaserecordid_ggw_team_application() {
        return new Ggw_team_applicationRequest(contextPath.addSegment("baserecordid_ggw_team_application"), RequestHelper.getValue(unmappedFields, "baserecordid_ggw_team_application"));
    }

    @NavigationProperty(name="duplicaterecordid_cascadegrantrevokeaccessrecordstracker")
    @JsonIgnore
    public CascadegrantrevokeaccessrecordstrackerRequest getDuplicaterecordid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("duplicaterecordid_cascadegrantrevokeaccessrecordstracker"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_cascadegrantrevokeaccessrecordstracker"));
    }

    @NavigationProperty(name="baserecordid_cascadegrantrevokeaccessrecordstracker")
    @JsonIgnore
    public CascadegrantrevokeaccessrecordstrackerRequest getBaserecordid_cascadegrantrevokeaccessrecordstracker() {
        return new CascadegrantrevokeaccessrecordstrackerRequest(contextPath.addSegment("baserecordid_cascadegrantrevokeaccessrecordstracker"), RequestHelper.getValue(unmappedFields, "baserecordid_cascadegrantrevokeaccessrecordstracker"));
    }

    @NavigationProperty(name="duplicaterecordid_cascadegrantrevokeaccessversiontracker")
    @JsonIgnore
    public CascadegrantrevokeaccessversiontrackerRequest getDuplicaterecordid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("duplicaterecordid_cascadegrantrevokeaccessversiontracker"), RequestHelper.getValue(unmappedFields, "duplicaterecordid_cascadegrantrevokeaccessversiontracker"));
    }

    @NavigationProperty(name="baserecordid_cascadegrantrevokeaccessversiontracker")
    @JsonIgnore
    public CascadegrantrevokeaccessversiontrackerRequest getBaserecordid_cascadegrantrevokeaccessversiontracker() {
        return new CascadegrantrevokeaccessversiontrackerRequest(contextPath.addSegment("baserecordid_cascadegrantrevokeaccessversiontracker"), RequestHelper.getValue(unmappedFields, "baserecordid_cascadegrantrevokeaccessversiontracker"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Duplicaterecord patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Duplicaterecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Duplicaterecord put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Duplicaterecord _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Duplicaterecord _copy() {
        Duplicaterecord _x = new Duplicaterecord();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.createdon = createdon;
        _x._duplicateruleid_value = _duplicateruleid_value;
        _x._ownerid_value = _ownerid_value;
        _x.owningbusinessunit = owningbusinessunit;
        _x._asyncoperationid_value = _asyncoperationid_value;
        _x.owninguser = owninguser;
        _x._baserecordid_value = _baserecordid_value;
        _x.duplicateid = duplicateid;
        _x._duplicaterecordid_value = _duplicaterecordid_value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Duplicaterecord[");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_duplicateruleid_value=");
        b.append(this._duplicateruleid_value);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("owningbusinessunit=");
        b.append(this.owningbusinessunit);
        b.append(", ");
        b.append("_asyncoperationid_value=");
        b.append(this._asyncoperationid_value);
        b.append(", ");
        b.append("owninguser=");
        b.append(this.owninguser);
        b.append(", ");
        b.append("_baserecordid_value=");
        b.append(this._baserecordid_value);
        b.append(", ");
        b.append("duplicateid=");
        b.append(this.duplicateid);
        b.append(", ");
        b.append("_duplicaterecordid_value=");
        b.append(this._duplicaterecordid_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
