package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "solutionid", 
    "appmoduleroleidunique", 
    "overwritetime", 
    "ismanaged", 
    "_appmoduleid_value", 
    "_roleid_value", 
    "introducedversion", 
    "appmoduleroleid", 
    "versionnumber", 
    "componentstate"})
@JsonInclude(Include.NON_NULL)
public class Appmoduleroles extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appmoduleroles";
    }

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("appmoduleroleidunique")
    protected UUID appmoduleroleidunique;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("_appmoduleid_value")
    protected UUID _appmoduleid_value;

    @JsonProperty("_roleid_value")
    protected UUID _roleid_value;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("appmoduleroleid")
    protected UUID appmoduleroleid;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("componentstate")
    protected Integer componentstate;

    protected Appmoduleroles() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppmoduleroles() {
        return new Builder();
    }

    public static final class Builder {
        private UUID solutionid;
        private UUID appmoduleroleidunique;
        private OffsetDateTime overwritetime;
        private Boolean ismanaged;
        private UUID _appmoduleid_value;
        private UUID _roleid_value;
        private String introducedversion;
        private UUID appmoduleroleid;
        private Long versionnumber;
        private Integer componentstate;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder appmoduleroleidunique(UUID appmoduleroleidunique) {
            this.appmoduleroleidunique = appmoduleroleidunique;
            this.changedFields = changedFields.add("appmoduleroleidunique");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder _appmoduleid_value(UUID _appmoduleid_value) {
            this._appmoduleid_value = _appmoduleid_value;
            this.changedFields = changedFields.add("_appmoduleid_value");
            return this;
        }

        public Builder _roleid_value(UUID _roleid_value) {
            this._roleid_value = _roleid_value;
            this.changedFields = changedFields.add("_roleid_value");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder appmoduleroleid(UUID appmoduleroleid) {
            this.appmoduleroleid = appmoduleroleid;
            this.changedFields = changedFields.add("appmoduleroleid");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Appmoduleroles build() {
            Appmoduleroles _x = new Appmoduleroles();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appmoduleroles";
            _x.solutionid = solutionid;
            _x.appmoduleroleidunique = appmoduleroleidunique;
            _x.overwritetime = overwritetime;
            _x.ismanaged = ismanaged;
            _x._appmoduleid_value = _appmoduleid_value;
            _x._roleid_value = _roleid_value;
            _x.introducedversion = introducedversion;
            _x.appmoduleroleid = appmoduleroleid;
            _x.versionnumber = versionnumber;
            _x.componentstate = componentstate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && appmoduleroleid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(appmoduleroleid, UUID.class));
        }
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Appmoduleroles withSolutionid(UUID solutionid) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="appmoduleroleidunique")
    @JsonIgnore
    public Optional<UUID> getAppmoduleroleidunique() {
        return Optional.ofNullable(appmoduleroleidunique);
    }

    public Appmoduleroles withAppmoduleroleidunique(UUID appmoduleroleidunique) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("appmoduleroleidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.appmoduleroleidunique = appmoduleroleidunique;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Appmoduleroles withOverwritetime(OffsetDateTime overwritetime) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Appmoduleroles withIsmanaged(Boolean ismanaged) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="_appmoduleid_value")
    @JsonIgnore
    public Optional<UUID> get_appmoduleid_value() {
        return Optional.ofNullable(_appmoduleid_value);
    }

    public Appmoduleroles with_appmoduleid_value(UUID _appmoduleid_value) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("_appmoduleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x._appmoduleid_value = _appmoduleid_value;
        return _x;
    }

    @Property(name="_roleid_value")
    @JsonIgnore
    public Optional<UUID> get_roleid_value() {
        return Optional.ofNullable(_roleid_value);
    }

    public Appmoduleroles with_roleid_value(UUID _roleid_value) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("_roleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x._roleid_value = _roleid_value;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Appmoduleroles withIntroducedversion(String introducedversion) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="appmoduleroleid")
    @JsonIgnore
    public Optional<UUID> getAppmoduleroleid() {
        return Optional.ofNullable(appmoduleroleid);
    }

    public Appmoduleroles withAppmoduleroleid(UUID appmoduleroleid) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("appmoduleroleid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.appmoduleroleid = appmoduleroleid;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Appmoduleroles withVersionnumber(Long versionnumber) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Appmoduleroles withComponentstate(Integer componentstate) {
        Appmoduleroles _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appmoduleroles");
        _x.componentstate = componentstate;
        return _x;
    }

    public Appmoduleroles withUnmappedField(String name, Object value) {
        Appmoduleroles _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appmoduleroles patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appmoduleroles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appmoduleroles put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appmoduleroles _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appmoduleroles _copy() {
        Appmoduleroles _x = new Appmoduleroles();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.solutionid = solutionid;
        _x.appmoduleroleidunique = appmoduleroleidunique;
        _x.overwritetime = overwritetime;
        _x.ismanaged = ismanaged;
        _x._appmoduleid_value = _appmoduleid_value;
        _x._roleid_value = _roleid_value;
        _x.introducedversion = introducedversion;
        _x.appmoduleroleid = appmoduleroleid;
        _x.versionnumber = versionnumber;
        _x.componentstate = componentstate;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appmoduleroles[");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("appmoduleroleidunique=");
        b.append(this.appmoduleroleidunique);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("_appmoduleid_value=");
        b.append(this._appmoduleid_value);
        b.append(", ");
        b.append("_roleid_value=");
        b.append(this._roleid_value);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("appmoduleroleid=");
        b.append(this.appmoduleroleid);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
