package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.AppconfiginstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NavigationsettingCollectionRequest;
import microsoft.dynamics.crm.entity.request.AppmoduleRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "componentstate", 
    "solutionid", 
    "_organizationid_value", 
    "versionnumber", 
    "ismanaged", 
    "appconfigimportxml", 
    "appconfigidunique", 
    "modifiedon", 
    "createdon", 
    "_createdby_value", 
    "_createdonbehalfby_value", 
    "overwritetime", 
    "importsequencenumber", 
    "introducedversion", 
    "_modifiedby_value", 
    "_appmoduleid_value", 
    "overriddencreatedon", 
    "appconfigid", 
    "statecode", 
    "statuscode", 
    "_modifiedonbehalfby_value"})
@JsonInclude(Include.NON_NULL)
public class Appconfig extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.appconfig";
    }

    @JsonProperty("componentstate")
    protected Integer componentstate;

    @JsonProperty("solutionid")
    protected UUID solutionid;

    @JsonProperty("_organizationid_value")
    protected UUID _organizationid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("ismanaged")
    protected Boolean ismanaged;

    @JsonProperty("appconfigimportxml")
    protected String appconfigimportxml;

    @JsonProperty("appconfigidunique")
    protected UUID appconfigidunique;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("overwritetime")
    protected OffsetDateTime overwritetime;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("introducedversion")
    protected String introducedversion;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("_appmoduleid_value")
    protected UUID _appmoduleid_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("appconfigid")
    protected UUID appconfigid;

    @JsonProperty("statecode")
    protected Integer statecode;

    @JsonProperty("statuscode")
    protected Integer statuscode;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    protected Appconfig() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppconfig() {
        return new Builder();
    }

    public static final class Builder {
        private Integer componentstate;
        private UUID solutionid;
        private UUID _organizationid_value;
        private Long versionnumber;
        private Boolean ismanaged;
        private String appconfigimportxml;
        private UUID appconfigidunique;
        private OffsetDateTime modifiedon;
        private OffsetDateTime createdon;
        private UUID _createdby_value;
        private UUID _createdonbehalfby_value;
        private OffsetDateTime overwritetime;
        private Integer importsequencenumber;
        private String introducedversion;
        private UUID _modifiedby_value;
        private UUID _appmoduleid_value;
        private OffsetDateTime overriddencreatedon;
        private UUID appconfigid;
        private Integer statecode;
        private Integer statuscode;
        private UUID _modifiedonbehalfby_value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentstate(Integer componentstate) {
            this.componentstate = componentstate;
            this.changedFields = changedFields.add("componentstate");
            return this;
        }

        public Builder solutionid(UUID solutionid) {
            this.solutionid = solutionid;
            this.changedFields = changedFields.add("solutionid");
            return this;
        }

        public Builder _organizationid_value(UUID _organizationid_value) {
            this._organizationid_value = _organizationid_value;
            this.changedFields = changedFields.add("_organizationid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder ismanaged(Boolean ismanaged) {
            this.ismanaged = ismanaged;
            this.changedFields = changedFields.add("ismanaged");
            return this;
        }

        public Builder appconfigimportxml(String appconfigimportxml) {
            this.appconfigimportxml = appconfigimportxml;
            this.changedFields = changedFields.add("appconfigimportxml");
            return this;
        }

        public Builder appconfigidunique(UUID appconfigidunique) {
            this.appconfigidunique = appconfigidunique;
            this.changedFields = changedFields.add("appconfigidunique");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder overwritetime(OffsetDateTime overwritetime) {
            this.overwritetime = overwritetime;
            this.changedFields = changedFields.add("overwritetime");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder introducedversion(String introducedversion) {
            this.introducedversion = introducedversion;
            this.changedFields = changedFields.add("introducedversion");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder _appmoduleid_value(UUID _appmoduleid_value) {
            this._appmoduleid_value = _appmoduleid_value;
            this.changedFields = changedFields.add("_appmoduleid_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder appconfigid(UUID appconfigid) {
            this.appconfigid = appconfigid;
            this.changedFields = changedFields.add("appconfigid");
            return this;
        }

        public Builder statecode(Integer statecode) {
            this.statecode = statecode;
            this.changedFields = changedFields.add("statecode");
            return this;
        }

        public Builder statuscode(Integer statuscode) {
            this.statuscode = statuscode;
            this.changedFields = changedFields.add("statuscode");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Appconfig build() {
            Appconfig _x = new Appconfig();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.appconfig";
            _x.componentstate = componentstate;
            _x.solutionid = solutionid;
            _x._organizationid_value = _organizationid_value;
            _x.versionnumber = versionnumber;
            _x.ismanaged = ismanaged;
            _x.appconfigimportxml = appconfigimportxml;
            _x.appconfigidunique = appconfigidunique;
            _x.modifiedon = modifiedon;
            _x.createdon = createdon;
            _x._createdby_value = _createdby_value;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x.overwritetime = overwritetime;
            _x.importsequencenumber = importsequencenumber;
            _x.introducedversion = introducedversion;
            _x._modifiedby_value = _modifiedby_value;
            _x._appmoduleid_value = _appmoduleid_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x.appconfigid = appconfigid;
            _x.statecode = statecode;
            _x.statuscode = statuscode;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && appconfigid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(appconfigid, UUID.class));
        }
    }

    @Property(name="componentstate")
    @JsonIgnore
    public Optional<Integer> getComponentstate() {
        return Optional.ofNullable(componentstate);
    }

    public Appconfig withComponentstate(Integer componentstate) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("componentstate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.componentstate = componentstate;
        return _x;
    }

    @Property(name="solutionid")
    @JsonIgnore
    public Optional<UUID> getSolutionid() {
        return Optional.ofNullable(solutionid);
    }

    public Appconfig withSolutionid(UUID solutionid) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("solutionid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.solutionid = solutionid;
        return _x;
    }

    @Property(name="_organizationid_value")
    @JsonIgnore
    public Optional<UUID> get_organizationid_value() {
        return Optional.ofNullable(_organizationid_value);
    }

    public Appconfig with_organizationid_value(UUID _organizationid_value) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("_organizationid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x._organizationid_value = _organizationid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Appconfig withVersionnumber(Long versionnumber) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="ismanaged")
    @JsonIgnore
    public Optional<Boolean> getIsmanaged() {
        return Optional.ofNullable(ismanaged);
    }

    public Appconfig withIsmanaged(Boolean ismanaged) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("ismanaged");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.ismanaged = ismanaged;
        return _x;
    }

    @Property(name="appconfigimportxml")
    @JsonIgnore
    public Optional<String> getAppconfigimportxml() {
        return Optional.ofNullable(appconfigimportxml);
    }

    public Appconfig withAppconfigimportxml(String appconfigimportxml) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("appconfigimportxml");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.appconfigimportxml = appconfigimportxml;
        return _x;
    }

    @Property(name="appconfigidunique")
    @JsonIgnore
    public Optional<UUID> getAppconfigidunique() {
        return Optional.ofNullable(appconfigidunique);
    }

    public Appconfig withAppconfigidunique(UUID appconfigidunique) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("appconfigidunique");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.appconfigidunique = appconfigidunique;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Appconfig withModifiedon(OffsetDateTime modifiedon) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Appconfig withCreatedon(OffsetDateTime createdon) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Appconfig with_createdby_value(UUID _createdby_value) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Appconfig with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="overwritetime")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverwritetime() {
        return Optional.ofNullable(overwritetime);
    }

    public Appconfig withOverwritetime(OffsetDateTime overwritetime) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("overwritetime");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.overwritetime = overwritetime;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Appconfig withImportsequencenumber(Integer importsequencenumber) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="introducedversion")
    @JsonIgnore
    public Optional<String> getIntroducedversion() {
        return Optional.ofNullable(introducedversion);
    }

    public Appconfig withIntroducedversion(String introducedversion) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("introducedversion");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.introducedversion = introducedversion;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Appconfig with_modifiedby_value(UUID _modifiedby_value) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="_appmoduleid_value")
    @JsonIgnore
    public Optional<UUID> get_appmoduleid_value() {
        return Optional.ofNullable(_appmoduleid_value);
    }

    public Appconfig with_appmoduleid_value(UUID _appmoduleid_value) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("_appmoduleid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x._appmoduleid_value = _appmoduleid_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Appconfig withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="appconfigid")
    @JsonIgnore
    public Optional<UUID> getAppconfigid() {
        return Optional.ofNullable(appconfigid);
    }

    public Appconfig withAppconfigid(UUID appconfigid) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("appconfigid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.appconfigid = appconfigid;
        return _x;
    }

    @Property(name="statecode")
    @JsonIgnore
    public Optional<Integer> getStatecode() {
        return Optional.ofNullable(statecode);
    }

    public Appconfig withStatecode(Integer statecode) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("statecode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.statecode = statecode;
        return _x;
    }

    @Property(name="statuscode")
    @JsonIgnore
    public Optional<Integer> getStatuscode() {
        return Optional.ofNullable(statuscode);
    }

    public Appconfig withStatuscode(Integer statuscode) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("statuscode");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x.statuscode = statuscode;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Appconfig with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Appconfig _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.appconfig");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    public Appconfig withUnmappedField(String name, Object value) {
        Appconfig _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="appmodule_appconfig")
    @JsonIgnore
    public AppmoduleRequest getAppmodule_appconfig() {
        return new AppmoduleRequest(contextPath.addSegment("appmodule_appconfig"), RequestHelper.getValue(unmappedFields, "appmodule_appconfig"));
    }

    @NavigationProperty(name="appconfig_modifiedby")
    @JsonIgnore
    public SystemuserRequest getAppconfig_modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("appconfig_modifiedby"), RequestHelper.getValue(unmappedFields, "appconfig_modifiedby"));
    }

    @NavigationProperty(name="appconfig_modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppconfig_modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfig_modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "appconfig_modifiedonbehalfby"));
    }

    @NavigationProperty(name="appconfig_navigationsetting")
    @JsonIgnore
    public NavigationsettingCollectionRequest getAppconfig_navigationsetting() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("appconfig_navigationsetting"), RequestHelper.getValue(unmappedFields, "appconfig_navigationsetting"));
    }

    @NavigationProperty(name="appconfig_createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getAppconfig_createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("appconfig_createdonbehalfby"), RequestHelper.getValue(unmappedFields, "appconfig_createdonbehalfby"));
    }

    @NavigationProperty(name="appconfig_appconfiginstance")
    @JsonIgnore
    public AppconfiginstanceCollectionRequest getAppconfig_appconfiginstance() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("appconfig_appconfiginstance"), RequestHelper.getValue(unmappedFields, "appconfig_appconfiginstance"));
    }

    @NavigationProperty(name="appconfig_createdby")
    @JsonIgnore
    public SystemuserRequest getAppconfig_createdby() {
        return new SystemuserRequest(contextPath.addSegment("appconfig_createdby"), RequestHelper.getValue(unmappedFields, "appconfig_createdby"));
    }

    @NavigationProperty(name="organization_appconfig")
    @JsonIgnore
    public OrganizationRequest getOrganization_appconfig() {
        return new OrganizationRequest(contextPath.addSegment("organization_appconfig"), RequestHelper.getValue(unmappedFields, "organization_appconfig"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appconfig patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Appconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Appconfig put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Appconfig _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Appconfig _copy() {
        Appconfig _x = new Appconfig();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentstate = componentstate;
        _x.solutionid = solutionid;
        _x._organizationid_value = _organizationid_value;
        _x.versionnumber = versionnumber;
        _x.ismanaged = ismanaged;
        _x.appconfigimportxml = appconfigimportxml;
        _x.appconfigidunique = appconfigidunique;
        _x.modifiedon = modifiedon;
        _x.createdon = createdon;
        _x._createdby_value = _createdby_value;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x.overwritetime = overwritetime;
        _x.importsequencenumber = importsequencenumber;
        _x.introducedversion = introducedversion;
        _x._modifiedby_value = _modifiedby_value;
        _x._appmoduleid_value = _appmoduleid_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x.appconfigid = appconfigid;
        _x.statecode = statecode;
        _x.statuscode = statuscode;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Function(name = "RetrieveUnpublished")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<Appconfig> retrieveUnpublished() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<Appconfig>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUnpublished"), Appconfig.class, _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Appconfig[");
        b.append("componentstate=");
        b.append(this.componentstate);
        b.append(", ");
        b.append("solutionid=");
        b.append(this.solutionid);
        b.append(", ");
        b.append("_organizationid_value=");
        b.append(this._organizationid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("ismanaged=");
        b.append(this.ismanaged);
        b.append(", ");
        b.append("appconfigimportxml=");
        b.append(this.appconfigimportxml);
        b.append(", ");
        b.append("appconfigidunique=");
        b.append(this.appconfigidunique);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("overwritetime=");
        b.append(this.overwritetime);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("introducedversion=");
        b.append(this.introducedversion);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("_appmoduleid_value=");
        b.append(this._appmoduleid_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("appconfigid=");
        b.append(this.appconfigid);
        b.append(", ");
        b.append("statecode=");
        b.append(this.statecode);
        b.append(", ");
        b.append("statuscode=");
        b.append(this.statuscode);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
