package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.collection.request.ActioncarduserstateCollectionRequest;
import microsoft.dynamics.crm.entity.request.AccountRequest;
import microsoft.dynamics.crm.entity.request.AppointmentRequest;
import microsoft.dynamics.crm.entity.request.BusinessunitRequest;
import microsoft.dynamics.crm.entity.request.ContactRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.FaxRequest;
import microsoft.dynamics.crm.entity.request.LetterRequest;
import microsoft.dynamics.crm.entity.request.PhonecallRequest;
import microsoft.dynamics.crm.entity.request.PrincipalRequest;
import microsoft.dynamics.crm.entity.request.RecurringappointmentmasterRequest;
import microsoft.dynamics.crm.entity.request.SystemuserRequest;
import microsoft.dynamics.crm.entity.request.TaskRequest;
import microsoft.dynamics.crm.entity.request.TransactioncurrencyRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "_createdby_value", 
    "createdon", 
    "_owningbusinessunit_value", 
    "overriddencreatedon", 
    "_createdonbehalfby_value", 
    "_recordid_value", 
    "recordidobjecttypecode2", 
    "_regardingobjectid_value", 
    "data", 
    "parentregardingobjectiddata", 
    "source", 
    "_ownerid_value", 
    "versionnumber", 
    "_modifiedby_value", 
    "cardtype", 
    "description", 
    "priority", 
    "state", 
    "_parentregardingobjectid_value", 
    "_modifiedonbehalfby_value", 
    "exchangerate", 
    "startdate", 
    "_owninguser_value", 
    "visibility", 
    "_transactioncurrencyid_value", 
    "expirydate", 
    "_cardtypeid_value", 
    "importsequencenumber", 
    "referencetokens", 
    "_owningteam_value", 
    "actioncardid", 
    "title", 
    "modifiedon"})
@JsonInclude(Include.NON_NULL)
public class Actioncard extends Crmbaseentity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.actioncard";
    }

    @JsonProperty("_createdby_value")
    protected UUID _createdby_value;

    @JsonProperty("createdon")
    protected OffsetDateTime createdon;

    @JsonProperty("_owningbusinessunit_value")
    protected UUID _owningbusinessunit_value;

    @JsonProperty("overriddencreatedon")
    protected OffsetDateTime overriddencreatedon;

    @JsonProperty("_createdonbehalfby_value")
    protected UUID _createdonbehalfby_value;

    @JsonProperty("_recordid_value")
    protected UUID _recordid_value;

    @JsonProperty("recordidobjecttypecode2")
    protected Integer recordidobjecttypecode2;

    @JsonProperty("_regardingobjectid_value")
    protected UUID _regardingobjectid_value;

    @JsonProperty("data")
    protected String data;

    @JsonProperty("parentregardingobjectiddata")
    protected String parentregardingobjectiddata;

    @JsonProperty("source")
    protected Integer source;

    @JsonProperty("_ownerid_value")
    protected UUID _ownerid_value;

    @JsonProperty("versionnumber")
    protected Long versionnumber;

    @JsonProperty("_modifiedby_value")
    protected UUID _modifiedby_value;

    @JsonProperty("cardtype")
    protected Integer cardtype;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("priority")
    protected Integer priority;

    @JsonProperty("state")
    protected Integer state;

    @JsonProperty("_parentregardingobjectid_value")
    protected UUID _parentregardingobjectid_value;

    @JsonProperty("_modifiedonbehalfby_value")
    protected UUID _modifiedonbehalfby_value;

    @JsonProperty("exchangerate")
    protected BigDecimal exchangerate;

    @JsonProperty("startdate")
    protected OffsetDateTime startdate;

    @JsonProperty("_owninguser_value")
    protected UUID _owninguser_value;

    @JsonProperty("visibility")
    protected Boolean visibility;

    @JsonProperty("_transactioncurrencyid_value")
    protected UUID _transactioncurrencyid_value;

    @JsonProperty("expirydate")
    protected OffsetDateTime expirydate;

    @JsonProperty("_cardtypeid_value")
    protected UUID _cardtypeid_value;

    @JsonProperty("importsequencenumber")
    protected Integer importsequencenumber;

    @JsonProperty("referencetokens")
    protected String referencetokens;

    @JsonProperty("_owningteam_value")
    protected UUID _owningteam_value;

    @JsonProperty("actioncardid")
    protected UUID actioncardid;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("modifiedon")
    protected OffsetDateTime modifiedon;

    protected Actioncard() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActioncard() {
        return new Builder();
    }

    public static final class Builder {
        private UUID _createdby_value;
        private OffsetDateTime createdon;
        private UUID _owningbusinessunit_value;
        private OffsetDateTime overriddencreatedon;
        private UUID _createdonbehalfby_value;
        private UUID _recordid_value;
        private Integer recordidobjecttypecode2;
        private UUID _regardingobjectid_value;
        private String data;
        private String parentregardingobjectiddata;
        private Integer source;
        private UUID _ownerid_value;
        private Long versionnumber;
        private UUID _modifiedby_value;
        private Integer cardtype;
        private String description;
        private Integer priority;
        private Integer state;
        private UUID _parentregardingobjectid_value;
        private UUID _modifiedonbehalfby_value;
        private BigDecimal exchangerate;
        private OffsetDateTime startdate;
        private UUID _owninguser_value;
        private Boolean visibility;
        private UUID _transactioncurrencyid_value;
        private OffsetDateTime expirydate;
        private UUID _cardtypeid_value;
        private Integer importsequencenumber;
        private String referencetokens;
        private UUID _owningteam_value;
        private UUID actioncardid;
        private String title;
        private OffsetDateTime modifiedon;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder _createdby_value(UUID _createdby_value) {
            this._createdby_value = _createdby_value;
            this.changedFields = changedFields.add("_createdby_value");
            return this;
        }

        public Builder createdon(OffsetDateTime createdon) {
            this.createdon = createdon;
            this.changedFields = changedFields.add("createdon");
            return this;
        }

        public Builder _owningbusinessunit_value(UUID _owningbusinessunit_value) {
            this._owningbusinessunit_value = _owningbusinessunit_value;
            this.changedFields = changedFields.add("_owningbusinessunit_value");
            return this;
        }

        public Builder overriddencreatedon(OffsetDateTime overriddencreatedon) {
            this.overriddencreatedon = overriddencreatedon;
            this.changedFields = changedFields.add("overriddencreatedon");
            return this;
        }

        public Builder _createdonbehalfby_value(UUID _createdonbehalfby_value) {
            this._createdonbehalfby_value = _createdonbehalfby_value;
            this.changedFields = changedFields.add("_createdonbehalfby_value");
            return this;
        }

        public Builder _recordid_value(UUID _recordid_value) {
            this._recordid_value = _recordid_value;
            this.changedFields = changedFields.add("_recordid_value");
            return this;
        }

        public Builder recordidobjecttypecode2(Integer recordidobjecttypecode2) {
            this.recordidobjecttypecode2 = recordidobjecttypecode2;
            this.changedFields = changedFields.add("recordidobjecttypecode2");
            return this;
        }

        public Builder _regardingobjectid_value(UUID _regardingobjectid_value) {
            this._regardingobjectid_value = _regardingobjectid_value;
            this.changedFields = changedFields.add("_regardingobjectid_value");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.changedFields = changedFields.add("data");
            return this;
        }

        public Builder parentregardingobjectiddata(String parentregardingobjectiddata) {
            this.parentregardingobjectiddata = parentregardingobjectiddata;
            this.changedFields = changedFields.add("parentregardingobjectiddata");
            return this;
        }

        public Builder source(Integer source) {
            this.source = source;
            this.changedFields = changedFields.add("source");
            return this;
        }

        public Builder _ownerid_value(UUID _ownerid_value) {
            this._ownerid_value = _ownerid_value;
            this.changedFields = changedFields.add("_ownerid_value");
            return this;
        }

        public Builder versionnumber(Long versionnumber) {
            this.versionnumber = versionnumber;
            this.changedFields = changedFields.add("versionnumber");
            return this;
        }

        public Builder _modifiedby_value(UUID _modifiedby_value) {
            this._modifiedby_value = _modifiedby_value;
            this.changedFields = changedFields.add("_modifiedby_value");
            return this;
        }

        public Builder cardtype(Integer cardtype) {
            this.cardtype = cardtype;
            this.changedFields = changedFields.add("cardtype");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder priority(Integer priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder state(Integer state) {
            this.state = state;
            this.changedFields = changedFields.add("state");
            return this;
        }

        public Builder _parentregardingobjectid_value(UUID _parentregardingobjectid_value) {
            this._parentregardingobjectid_value = _parentregardingobjectid_value;
            this.changedFields = changedFields.add("_parentregardingobjectid_value");
            return this;
        }

        public Builder _modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
            this._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            this.changedFields = changedFields.add("_modifiedonbehalfby_value");
            return this;
        }

        public Builder exchangerate(BigDecimal exchangerate) {
            this.exchangerate = exchangerate;
            this.changedFields = changedFields.add("exchangerate");
            return this;
        }

        public Builder startdate(OffsetDateTime startdate) {
            this.startdate = startdate;
            this.changedFields = changedFields.add("startdate");
            return this;
        }

        public Builder _owninguser_value(UUID _owninguser_value) {
            this._owninguser_value = _owninguser_value;
            this.changedFields = changedFields.add("_owninguser_value");
            return this;
        }

        public Builder visibility(Boolean visibility) {
            this.visibility = visibility;
            this.changedFields = changedFields.add("visibility");
            return this;
        }

        public Builder _transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
            this._transactioncurrencyid_value = _transactioncurrencyid_value;
            this.changedFields = changedFields.add("_transactioncurrencyid_value");
            return this;
        }

        public Builder expirydate(OffsetDateTime expirydate) {
            this.expirydate = expirydate;
            this.changedFields = changedFields.add("expirydate");
            return this;
        }

        public Builder _cardtypeid_value(UUID _cardtypeid_value) {
            this._cardtypeid_value = _cardtypeid_value;
            this.changedFields = changedFields.add("_cardtypeid_value");
            return this;
        }

        public Builder importsequencenumber(Integer importsequencenumber) {
            this.importsequencenumber = importsequencenumber;
            this.changedFields = changedFields.add("importsequencenumber");
            return this;
        }

        public Builder referencetokens(String referencetokens) {
            this.referencetokens = referencetokens;
            this.changedFields = changedFields.add("referencetokens");
            return this;
        }

        public Builder _owningteam_value(UUID _owningteam_value) {
            this._owningteam_value = _owningteam_value;
            this.changedFields = changedFields.add("_owningteam_value");
            return this;
        }

        public Builder actioncardid(UUID actioncardid) {
            this.actioncardid = actioncardid;
            this.changedFields = changedFields.add("actioncardid");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder modifiedon(OffsetDateTime modifiedon) {
            this.modifiedon = modifiedon;
            this.changedFields = changedFields.add("modifiedon");
            return this;
        }

        public Actioncard build() {
            Actioncard _x = new Actioncard();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.actioncard";
            _x._createdby_value = _createdby_value;
            _x.createdon = createdon;
            _x._owningbusinessunit_value = _owningbusinessunit_value;
            _x.overriddencreatedon = overriddencreatedon;
            _x._createdonbehalfby_value = _createdonbehalfby_value;
            _x._recordid_value = _recordid_value;
            _x.recordidobjecttypecode2 = recordidobjecttypecode2;
            _x._regardingobjectid_value = _regardingobjectid_value;
            _x.data = data;
            _x.parentregardingobjectiddata = parentregardingobjectiddata;
            _x.source = source;
            _x._ownerid_value = _ownerid_value;
            _x.versionnumber = versionnumber;
            _x._modifiedby_value = _modifiedby_value;
            _x.cardtype = cardtype;
            _x.description = description;
            _x.priority = priority;
            _x.state = state;
            _x._parentregardingobjectid_value = _parentregardingobjectid_value;
            _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
            _x.exchangerate = exchangerate;
            _x.startdate = startdate;
            _x._owninguser_value = _owninguser_value;
            _x.visibility = visibility;
            _x._transactioncurrencyid_value = _transactioncurrencyid_value;
            _x.expirydate = expirydate;
            _x._cardtypeid_value = _cardtypeid_value;
            _x.importsequencenumber = importsequencenumber;
            _x.referencetokens = referencetokens;
            _x._owningteam_value = _owningteam_value;
            _x.actioncardid = actioncardid;
            _x.title = title;
            _x.modifiedon = modifiedon;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && actioncardid != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(actioncardid, UUID.class));
        }
    }

    @Property(name="_createdby_value")
    @JsonIgnore
    public Optional<UUID> get_createdby_value() {
        return Optional.ofNullable(_createdby_value);
    }

    public Actioncard with_createdby_value(UUID _createdby_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_createdby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._createdby_value = _createdby_value;
        return _x;
    }

    @Property(name="createdon")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedon() {
        return Optional.ofNullable(createdon);
    }

    public Actioncard withCreatedon(OffsetDateTime createdon) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("createdon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.createdon = createdon;
        return _x;
    }

    @Property(name="_owningbusinessunit_value")
    @JsonIgnore
    public Optional<UUID> get_owningbusinessunit_value() {
        return Optional.ofNullable(_owningbusinessunit_value);
    }

    public Actioncard with_owningbusinessunit_value(UUID _owningbusinessunit_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_owningbusinessunit_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        return _x;
    }

    @Property(name="overriddencreatedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getOverriddencreatedon() {
        return Optional.ofNullable(overriddencreatedon);
    }

    public Actioncard withOverriddencreatedon(OffsetDateTime overriddencreatedon) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("overriddencreatedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.overriddencreatedon = overriddencreatedon;
        return _x;
    }

    @Property(name="_createdonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_createdonbehalfby_value() {
        return Optional.ofNullable(_createdonbehalfby_value);
    }

    public Actioncard with_createdonbehalfby_value(UUID _createdonbehalfby_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_createdonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        return _x;
    }

    @Property(name="_recordid_value")
    @JsonIgnore
    public Optional<UUID> get_recordid_value() {
        return Optional.ofNullable(_recordid_value);
    }

    public Actioncard with_recordid_value(UUID _recordid_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_recordid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._recordid_value = _recordid_value;
        return _x;
    }

    @Property(name="recordidobjecttypecode2")
    @JsonIgnore
    public Optional<Integer> getRecordidobjecttypecode2() {
        return Optional.ofNullable(recordidobjecttypecode2);
    }

    public Actioncard withRecordidobjecttypecode2(Integer recordidobjecttypecode2) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("recordidobjecttypecode2");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.recordidobjecttypecode2 = recordidobjecttypecode2;
        return _x;
    }

    @Property(name="_regardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_regardingobjectid_value() {
        return Optional.ofNullable(_regardingobjectid_value);
    }

    public Actioncard with_regardingobjectid_value(UUID _regardingobjectid_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_regardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._regardingobjectid_value = _regardingobjectid_value;
        return _x;
    }

    @Property(name="data")
    @JsonIgnore
    public Optional<String> getData() {
        return Optional.ofNullable(data);
    }

    public Actioncard withData(String data) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("data");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.data = data;
        return _x;
    }

    @Property(name="parentregardingobjectiddata")
    @JsonIgnore
    public Optional<String> getParentregardingobjectiddata() {
        return Optional.ofNullable(parentregardingobjectiddata);
    }

    public Actioncard withParentregardingobjectiddata(String parentregardingobjectiddata) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("parentregardingobjectiddata");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.parentregardingobjectiddata = parentregardingobjectiddata;
        return _x;
    }

    @Property(name="source")
    @JsonIgnore
    public Optional<Integer> getSource() {
        return Optional.ofNullable(source);
    }

    public Actioncard withSource(Integer source) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("source");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.source = source;
        return _x;
    }

    @Property(name="_ownerid_value")
    @JsonIgnore
    public Optional<UUID> get_ownerid_value() {
        return Optional.ofNullable(_ownerid_value);
    }

    public Actioncard with_ownerid_value(UUID _ownerid_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_ownerid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._ownerid_value = _ownerid_value;
        return _x;
    }

    @Property(name="versionnumber")
    @JsonIgnore
    public Optional<Long> getVersionnumber() {
        return Optional.ofNullable(versionnumber);
    }

    public Actioncard withVersionnumber(Long versionnumber) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("versionnumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.versionnumber = versionnumber;
        return _x;
    }

    @Property(name="_modifiedby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedby_value() {
        return Optional.ofNullable(_modifiedby_value);
    }

    public Actioncard with_modifiedby_value(UUID _modifiedby_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_modifiedby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._modifiedby_value = _modifiedby_value;
        return _x;
    }

    @Property(name="cardtype")
    @JsonIgnore
    public Optional<Integer> getCardtype() {
        return Optional.ofNullable(cardtype);
    }

    public Actioncard withCardtype(Integer cardtype) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("cardtype");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.cardtype = cardtype;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Actioncard withDescription(String description) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.description = description;
        return _x;
    }

    @Property(name="priority")
    @JsonIgnore
    public Optional<Integer> getPriority() {
        return Optional.ofNullable(priority);
    }

    public Actioncard withPriority(Integer priority) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("priority");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.priority = priority;
        return _x;
    }

    @Property(name="state")
    @JsonIgnore
    public Optional<Integer> getState() {
        return Optional.ofNullable(state);
    }

    public Actioncard withState(Integer state) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("state");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.state = state;
        return _x;
    }

    @Property(name="_parentregardingobjectid_value")
    @JsonIgnore
    public Optional<UUID> get_parentregardingobjectid_value() {
        return Optional.ofNullable(_parentregardingobjectid_value);
    }

    public Actioncard with_parentregardingobjectid_value(UUID _parentregardingobjectid_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_parentregardingobjectid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._parentregardingobjectid_value = _parentregardingobjectid_value;
        return _x;
    }

    @Property(name="_modifiedonbehalfby_value")
    @JsonIgnore
    public Optional<UUID> get_modifiedonbehalfby_value() {
        return Optional.ofNullable(_modifiedonbehalfby_value);
    }

    public Actioncard with_modifiedonbehalfby_value(UUID _modifiedonbehalfby_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_modifiedonbehalfby_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        return _x;
    }

    @Property(name="exchangerate")
    @JsonIgnore
    public Optional<BigDecimal> getExchangerate() {
        return Optional.ofNullable(exchangerate);
    }

    public Actioncard withExchangerate(BigDecimal exchangerate) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("exchangerate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.exchangerate = exchangerate;
        return _x;
    }

    @Property(name="startdate")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartdate() {
        return Optional.ofNullable(startdate);
    }

    public Actioncard withStartdate(OffsetDateTime startdate) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("startdate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.startdate = startdate;
        return _x;
    }

    @Property(name="_owninguser_value")
    @JsonIgnore
    public Optional<UUID> get_owninguser_value() {
        return Optional.ofNullable(_owninguser_value);
    }

    public Actioncard with_owninguser_value(UUID _owninguser_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_owninguser_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._owninguser_value = _owninguser_value;
        return _x;
    }

    @Property(name="visibility")
    @JsonIgnore
    public Optional<Boolean> getVisibility() {
        return Optional.ofNullable(visibility);
    }

    public Actioncard withVisibility(Boolean visibility) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("visibility");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.visibility = visibility;
        return _x;
    }

    @Property(name="_transactioncurrencyid_value")
    @JsonIgnore
    public Optional<UUID> get_transactioncurrencyid_value() {
        return Optional.ofNullable(_transactioncurrencyid_value);
    }

    public Actioncard with_transactioncurrencyid_value(UUID _transactioncurrencyid_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_transactioncurrencyid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        return _x;
    }

    @Property(name="expirydate")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirydate() {
        return Optional.ofNullable(expirydate);
    }

    public Actioncard withExpirydate(OffsetDateTime expirydate) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("expirydate");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.expirydate = expirydate;
        return _x;
    }

    @Property(name="_cardtypeid_value")
    @JsonIgnore
    public Optional<UUID> get_cardtypeid_value() {
        return Optional.ofNullable(_cardtypeid_value);
    }

    public Actioncard with_cardtypeid_value(UUID _cardtypeid_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_cardtypeid_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._cardtypeid_value = _cardtypeid_value;
        return _x;
    }

    @Property(name="importsequencenumber")
    @JsonIgnore
    public Optional<Integer> getImportsequencenumber() {
        return Optional.ofNullable(importsequencenumber);
    }

    public Actioncard withImportsequencenumber(Integer importsequencenumber) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("importsequencenumber");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.importsequencenumber = importsequencenumber;
        return _x;
    }

    @Property(name="referencetokens")
    @JsonIgnore
    public Optional<String> getReferencetokens() {
        return Optional.ofNullable(referencetokens);
    }

    public Actioncard withReferencetokens(String referencetokens) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("referencetokens");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.referencetokens = referencetokens;
        return _x;
    }

    @Property(name="_owningteam_value")
    @JsonIgnore
    public Optional<UUID> get_owningteam_value() {
        return Optional.ofNullable(_owningteam_value);
    }

    public Actioncard with_owningteam_value(UUID _owningteam_value) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("_owningteam_value");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x._owningteam_value = _owningteam_value;
        return _x;
    }

    @Property(name="actioncardid")
    @JsonIgnore
    public Optional<UUID> getActioncardid() {
        return Optional.ofNullable(actioncardid);
    }

    public Actioncard withActioncardid(UUID actioncardid) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("actioncardid");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.actioncardid = actioncardid;
        return _x;
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Actioncard withTitle(String title) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.title = title;
        return _x;
    }

    @Property(name="modifiedon")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedon() {
        return Optional.ofNullable(modifiedon);
    }

    public Actioncard withModifiedon(OffsetDateTime modifiedon) {
        Actioncard _x = _copy();
        _x.changedFields = changedFields.add("modifiedon");
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.actioncard");
        _x.modifiedon = modifiedon;
        return _x;
    }

    public Actioncard withUnmappedField(String name, Object value) {
        Actioncard _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @NavigationProperty(name="regardingobjectid_letter_actioncard")
    @JsonIgnore
    public LetterRequest getRegardingobjectid_letter_actioncard() {
        return new LetterRequest(contextPath.addSegment("regardingobjectid_letter_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_letter_actioncard"));
    }

    @NavigationProperty(name="regardingobjectid_phonecall_actioncard")
    @JsonIgnore
    public PhonecallRequest getRegardingobjectid_phonecall_actioncard() {
        return new PhonecallRequest(contextPath.addSegment("regardingobjectid_phonecall_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_phonecall_actioncard"));
    }

    @NavigationProperty(name="regardingobjectid_fax_actioncard")
    @JsonIgnore
    public FaxRequest getRegardingobjectid_fax_actioncard() {
        return new FaxRequest(contextPath.addSegment("regardingobjectid_fax_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_fax_actioncard"));
    }

    @NavigationProperty(name="owningbusinessunit")
    @JsonIgnore
    public BusinessunitRequest getOwningbusinessunit() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit"), RequestHelper.getValue(unmappedFields, "owningbusinessunit"));
    }

    @NavigationProperty(name="transactioncurrencyid")
    @JsonIgnore
    public TransactioncurrencyRequest getTransactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), RequestHelper.getValue(unmappedFields, "transactioncurrencyid"));
    }

    @NavigationProperty(name="modifiedonbehalfby")
    @JsonIgnore
    public SystemuserRequest getModifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), RequestHelper.getValue(unmappedFields, "modifiedonbehalfby"));
    }

    @NavigationProperty(name="ownerid")
    @JsonIgnore
    public PrincipalRequest getOwnerid() {
        return new PrincipalRequest(contextPath.addSegment("ownerid"), RequestHelper.getValue(unmappedFields, "ownerid"));
    }

    @NavigationProperty(name="regardingobjectid_contact_actioncard")
    @JsonIgnore
    public ContactRequest getRegardingobjectid_contact_actioncard() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_contact_actioncard"));
    }

    @NavigationProperty(name="ActionCardUserState_ActionCard")
    @JsonIgnore
    public ActioncarduserstateCollectionRequest getActionCardUserState_ActionCard() {
        return new ActioncarduserstateCollectionRequest(
                        contextPath.addSegment("ActionCardUserState_ActionCard"), RequestHelper.getValue(unmappedFields, "ActionCardUserState_ActionCard"));
    }

    @NavigationProperty(name="createdonbehalfby")
    @JsonIgnore
    public SystemuserRequest getCreatedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), RequestHelper.getValue(unmappedFields, "createdonbehalfby"));
    }

    @NavigationProperty(name="regardingobjectid_email_actioncard")
    @JsonIgnore
    public EmailRequest getRegardingobjectid_email_actioncard() {
        return new EmailRequest(contextPath.addSegment("regardingobjectid_email_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_email_actioncard"));
    }

    @NavigationProperty(name="regardingobjectid_appointment_actioncard")
    @JsonIgnore
    public AppointmentRequest getRegardingobjectid_appointment_actioncard() {
        return new AppointmentRequest(contextPath.addSegment("regardingobjectid_appointment_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_appointment_actioncard"));
    }

    @NavigationProperty(name="createdby")
    @JsonIgnore
    public SystemuserRequest getCreatedby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), RequestHelper.getValue(unmappedFields, "createdby"));
    }

    @NavigationProperty(name="regardingobjectid_recurringappointmentmaster_actioncard")
    @JsonIgnore
    public RecurringappointmentmasterRequest getRegardingobjectid_recurringappointmentmaster_actioncard() {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("regardingobjectid_recurringappointmentmaster_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_recurringappointmentmaster_actioncard"));
    }

    @NavigationProperty(name="regardingobjectid_account_actioncard")
    @JsonIgnore
    public AccountRequest getRegardingobjectid_account_actioncard() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_account_actioncard"));
    }

    @NavigationProperty(name="modifiedby")
    @JsonIgnore
    public SystemuserRequest getModifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), RequestHelper.getValue(unmappedFields, "modifiedby"));
    }

    @NavigationProperty(name="regardingobjectid_task_actioncard")
    @JsonIgnore
    public TaskRequest getRegardingobjectid_task_actioncard() {
        return new TaskRequest(contextPath.addSegment("regardingobjectid_task_actioncard"), RequestHelper.getValue(unmappedFields, "regardingobjectid_task_actioncard"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Actioncard patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Actioncard _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Actioncard put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Actioncard _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Actioncard _copy() {
        Actioncard _x = new Actioncard();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x._createdby_value = _createdby_value;
        _x.createdon = createdon;
        _x._owningbusinessunit_value = _owningbusinessunit_value;
        _x.overriddencreatedon = overriddencreatedon;
        _x._createdonbehalfby_value = _createdonbehalfby_value;
        _x._recordid_value = _recordid_value;
        _x.recordidobjecttypecode2 = recordidobjecttypecode2;
        _x._regardingobjectid_value = _regardingobjectid_value;
        _x.data = data;
        _x.parentregardingobjectiddata = parentregardingobjectiddata;
        _x.source = source;
        _x._ownerid_value = _ownerid_value;
        _x.versionnumber = versionnumber;
        _x._modifiedby_value = _modifiedby_value;
        _x.cardtype = cardtype;
        _x.description = description;
        _x.priority = priority;
        _x.state = state;
        _x._parentregardingobjectid_value = _parentregardingobjectid_value;
        _x._modifiedonbehalfby_value = _modifiedonbehalfby_value;
        _x.exchangerate = exchangerate;
        _x.startdate = startdate;
        _x._owninguser_value = _owninguser_value;
        _x.visibility = visibility;
        _x._transactioncurrencyid_value = _transactioncurrencyid_value;
        _x.expirydate = expirydate;
        _x._cardtypeid_value = _cardtypeid_value;
        _x.importsequencenumber = importsequencenumber;
        _x.referencetokens = referencetokens;
        _x._owningteam_value = _owningteam_value;
        _x.actioncardid = actioncardid;
        _x.title = title;
        _x.modifiedon = modifiedon;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Actioncard[");
        b.append("_createdby_value=");
        b.append(this._createdby_value);
        b.append(", ");
        b.append("createdon=");
        b.append(this.createdon);
        b.append(", ");
        b.append("_owningbusinessunit_value=");
        b.append(this._owningbusinessunit_value);
        b.append(", ");
        b.append("overriddencreatedon=");
        b.append(this.overriddencreatedon);
        b.append(", ");
        b.append("_createdonbehalfby_value=");
        b.append(this._createdonbehalfby_value);
        b.append(", ");
        b.append("_recordid_value=");
        b.append(this._recordid_value);
        b.append(", ");
        b.append("recordidobjecttypecode2=");
        b.append(this.recordidobjecttypecode2);
        b.append(", ");
        b.append("_regardingobjectid_value=");
        b.append(this._regardingobjectid_value);
        b.append(", ");
        b.append("data=");
        b.append(this.data);
        b.append(", ");
        b.append("parentregardingobjectiddata=");
        b.append(this.parentregardingobjectiddata);
        b.append(", ");
        b.append("source=");
        b.append(this.source);
        b.append(", ");
        b.append("_ownerid_value=");
        b.append(this._ownerid_value);
        b.append(", ");
        b.append("versionnumber=");
        b.append(this.versionnumber);
        b.append(", ");
        b.append("_modifiedby_value=");
        b.append(this._modifiedby_value);
        b.append(", ");
        b.append("cardtype=");
        b.append(this.cardtype);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("state=");
        b.append(this.state);
        b.append(", ");
        b.append("_parentregardingobjectid_value=");
        b.append(this._parentregardingobjectid_value);
        b.append(", ");
        b.append("_modifiedonbehalfby_value=");
        b.append(this._modifiedonbehalfby_value);
        b.append(", ");
        b.append("exchangerate=");
        b.append(this.exchangerate);
        b.append(", ");
        b.append("startdate=");
        b.append(this.startdate);
        b.append(", ");
        b.append("_owninguser_value=");
        b.append(this._owninguser_value);
        b.append(", ");
        b.append("visibility=");
        b.append(this.visibility);
        b.append(", ");
        b.append("_transactioncurrencyid_value=");
        b.append(this._transactioncurrencyid_value);
        b.append(", ");
        b.append("expirydate=");
        b.append(this.expirydate);
        b.append(", ");
        b.append("_cardtypeid_value=");
        b.append(this._cardtypeid_value);
        b.append(", ");
        b.append("importsequencenumber=");
        b.append(this.importsequencenumber);
        b.append(", ");
        b.append("referencetokens=");
        b.append(this.referencetokens);
        b.append(", ");
        b.append("_owningteam_value=");
        b.append(this._owningteam_value);
        b.append(", ");
        b.append("actioncardid=");
        b.append(this.actioncardid);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("modifiedon=");
        b.append(this.modifiedon);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
