package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "TypeCode", 
    "Severity", 
    "LocalizedMessageText", 
    "OptionalPropertyBag"})
@JsonInclude(Include.NON_NULL)
public class ValidatorIssue implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("TypeCode")
    protected Integer typeCode;

    @JsonProperty("Severity")
    protected Integer severity;

    @JsonProperty("LocalizedMessageText")
    protected String localizedMessageText;

    @JsonProperty("OptionalPropertyBag")
    protected Collection_String_String optionalPropertyBag;

    protected ValidatorIssue() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ValidatorIssue";
    }

    @Property(name="TypeCode")
    @JsonIgnore
    public Optional<Integer> getTypeCode() {
        return Optional.ofNullable(typeCode);
    }

    public ValidatorIssue withTypeCode(Integer typeCode) {
        ValidatorIssue _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidatorIssue");
        _x.typeCode = typeCode;
        return _x;
    }

    @Property(name="Severity")
    @JsonIgnore
    public Optional<Integer> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public ValidatorIssue withSeverity(Integer severity) {
        ValidatorIssue _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidatorIssue");
        _x.severity = severity;
        return _x;
    }

    @Property(name="LocalizedMessageText")
    @JsonIgnore
    public Optional<String> getLocalizedMessageText() {
        return Optional.ofNullable(localizedMessageText);
    }

    public ValidatorIssue withLocalizedMessageText(String localizedMessageText) {
        ValidatorIssue _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidatorIssue");
        _x.localizedMessageText = localizedMessageText;
        return _x;
    }

    @Property(name="OptionalPropertyBag")
    @JsonIgnore
    public Optional<Collection_String_String> getOptionalPropertyBag() {
        return Optional.ofNullable(optionalPropertyBag);
    }

    public ValidatorIssue withOptionalPropertyBag(Collection_String_String optionalPropertyBag) {
        ValidatorIssue _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ValidatorIssue");
        _x.optionalPropertyBag = optionalPropertyBag;
        return _x;
    }

    public ValidatorIssue withUnmappedField(String name, Object value) {
        ValidatorIssue _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer typeCode;
        private Integer severity;
        private String localizedMessageText;
        private Collection_String_String optionalPropertyBag;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder typeCode(Integer typeCode) {
            this.typeCode = typeCode;
            this.changedFields = changedFields.add("TypeCode");
            return this;
        }

        public Builder severity(Integer severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("Severity");
            return this;
        }

        public Builder localizedMessageText(String localizedMessageText) {
            this.localizedMessageText = localizedMessageText;
            this.changedFields = changedFields.add("LocalizedMessageText");
            return this;
        }

        public Builder optionalPropertyBag(Collection_String_String optionalPropertyBag) {
            this.optionalPropertyBag = optionalPropertyBag;
            this.changedFields = changedFields.add("OptionalPropertyBag");
            return this;
        }

        public ValidatorIssue build() {
            ValidatorIssue _x = new ValidatorIssue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ValidatorIssue";
            _x.typeCode = typeCode;
            _x.severity = severity;
            _x.localizedMessageText = localizedMessageText;
            _x.optionalPropertyBag = optionalPropertyBag;
            return _x;
        }
    }

    private ValidatorIssue _copy() {
        ValidatorIssue _x = new ValidatorIssue();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.typeCode = typeCode;
        _x.severity = severity;
        _x.localizedMessageText = localizedMessageText;
        _x.optionalPropertyBag = optionalPropertyBag;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidatorIssue[");
        b.append("TypeCode=");
        b.append(this.typeCode);
        b.append(", ");
        b.append("Severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("LocalizedMessageText=");
        b.append(this.localizedMessageText);
        b.append(", ");
        b.append("OptionalPropertyBag=");
        b.append(this.optionalPropertyBag);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
