package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Result"})
@JsonInclude(Include.NON_NULL)
public class ValidateResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Result")
    protected List<ValidationResult> result;

    @JsonProperty("Result@nextLink")
    protected String resultNextLink;

    protected ValidateResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ValidateResponse";
    }

    @Property(name="Result")
    @JsonIgnore
    public CollectionPage<ValidationResult> getResult() {
        return new CollectionPage<ValidationResult>(contextPath, ValidationResult.class, this.result, Optional.ofNullable(resultNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Result")
    @JsonIgnore
    public CollectionPage<ValidationResult> getResult(HttpRequestOptions options) {
        return new CollectionPage<ValidationResult>(contextPath, ValidationResult.class, this.result, Optional.ofNullable(resultNextLink), Collections.emptyList(), options);
    }

    public ValidateResponse withUnmappedField(String name, Object value) {
        ValidateResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ValidationResult> result;
        private String resultNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder result(List<ValidationResult> result) {
            this.result = result;
            this.changedFields = changedFields.add("Result");
            return this;
        }

        public Builder result(ValidationResult... result) {
            return result(Arrays.asList(result));
        }

        public Builder resultNextLink(String resultNextLink) {
            this.resultNextLink = resultNextLink;
            this.changedFields = changedFields.add("Result");
            return this;
        }

        public ValidateResponse build() {
            ValidateResponse _x = new ValidateResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ValidateResponse";
            _x.result = result;
            _x.resultNextLink = resultNextLink;
            return _x;
        }
    }

    private ValidateResponse _copy() {
        ValidateResponse _x = new ValidateResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.result = result;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidateResponse[");
        b.append("Result=");
        b.append(this.result);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
