package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ErrorInfoList"})
@JsonInclude(Include.NON_NULL)
public class TraceInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ErrorInfoList")
    protected List<ErrorInfo> errorInfoList;

    @JsonProperty("ErrorInfoList@nextLink")
    protected String errorInfoListNextLink;

    protected TraceInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.TraceInfo";
    }

    @Property(name="ErrorInfoList")
    @JsonIgnore
    public CollectionPage<ErrorInfo> getErrorInfoList() {
        return new CollectionPage<ErrorInfo>(contextPath, ErrorInfo.class, this.errorInfoList, Optional.ofNullable(errorInfoListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ErrorInfoList")
    @JsonIgnore
    public CollectionPage<ErrorInfo> getErrorInfoList(HttpRequestOptions options) {
        return new CollectionPage<ErrorInfo>(contextPath, ErrorInfo.class, this.errorInfoList, Optional.ofNullable(errorInfoListNextLink), Collections.emptyList(), options);
    }

    public TraceInfo withUnmappedField(String name, Object value) {
        TraceInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ErrorInfo> errorInfoList;
        private String errorInfoListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder errorInfoList(List<ErrorInfo> errorInfoList) {
            this.errorInfoList = errorInfoList;
            this.changedFields = changedFields.add("ErrorInfoList");
            return this;
        }

        public Builder errorInfoList(ErrorInfo... errorInfoList) {
            return errorInfoList(Arrays.asList(errorInfoList));
        }

        public Builder errorInfoListNextLink(String errorInfoListNextLink) {
            this.errorInfoListNextLink = errorInfoListNextLink;
            this.changedFields = changedFields.add("ErrorInfoList");
            return this;
        }

        public TraceInfo build() {
            TraceInfo _x = new TraceInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.TraceInfo";
            _x.errorInfoList = errorInfoList;
            _x.errorInfoListNextLink = errorInfoListNextLink;
            return _x;
        }
    }

    private TraceInfo _copy() {
        TraceInfo _x = new TraceInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.errorInfoList = errorInfoList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TraceInfo[");
        b.append("ErrorInfoList=");
        b.append(this.errorInfoList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
