package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "ComponentName", 
    "Attributes", 
    "ComponentTypeName"})
@JsonInclude(Include.NON_NULL)
public class SolutionComponentDetails implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("ComponentName")
    protected String componentName;

    @JsonProperty("Attributes")
    protected Collection_String_String attributes;

    @JsonProperty("ComponentTypeName")
    protected String componentTypeName;

    protected SolutionComponentDetails() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SolutionComponentDetails";
    }

    @Property(name="ComponentName")
    @JsonIgnore
    public Optional<String> getComponentName() {
        return Optional.ofNullable(componentName);
    }

    public SolutionComponentDetails withComponentName(String componentName) {
        SolutionComponentDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionComponentDetails");
        _x.componentName = componentName;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public Optional<Collection_String_String> getAttributes() {
        return Optional.ofNullable(attributes);
    }

    public SolutionComponentDetails withAttributes(Collection_String_String attributes) {
        SolutionComponentDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionComponentDetails");
        _x.attributes = attributes;
        return _x;
    }

    @Property(name="ComponentTypeName")
    @JsonIgnore
    public Optional<String> getComponentTypeName() {
        return Optional.ofNullable(componentTypeName);
    }

    public SolutionComponentDetails withComponentTypeName(String componentTypeName) {
        SolutionComponentDetails _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.SolutionComponentDetails");
        _x.componentTypeName = componentTypeName;
        return _x;
    }

    public SolutionComponentDetails withUnmappedField(String name, Object value) {
        SolutionComponentDetails _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String componentName;
        private Collection_String_String attributes;
        private String componentTypeName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.changedFields = changedFields.add("ComponentName");
            return this;
        }

        public Builder attributes(Collection_String_String attributes) {
            this.attributes = attributes;
            this.changedFields = changedFields.add("Attributes");
            return this;
        }

        public Builder componentTypeName(String componentTypeName) {
            this.componentTypeName = componentTypeName;
            this.changedFields = changedFields.add("ComponentTypeName");
            return this;
        }

        public SolutionComponentDetails build() {
            SolutionComponentDetails _x = new SolutionComponentDetails();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SolutionComponentDetails";
            _x.componentName = componentName;
            _x.attributes = attributes;
            _x.componentTypeName = componentTypeName;
            return _x;
        }
    }

    private SolutionComponentDetails _copy() {
        SolutionComponentDetails _x = new SolutionComponentDetails();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.componentName = componentName;
        _x.attributes = attributes;
        _x.componentTypeName = componentTypeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SolutionComponentDetails[");
        b.append("ComponentName=");
        b.append(this.componentName);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("ComponentTypeName=");
        b.append(this.componentTypeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
