package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EncryptionKey"})
@JsonInclude(Include.NON_NULL)
public class RetrieveDataEncryptionKeyResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EncryptionKey")
    protected String encryptionKey;

    protected RetrieveDataEncryptionKeyResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RetrieveDataEncryptionKeyResponse";
    }

    @Property(name="EncryptionKey")
    @JsonIgnore
    public Optional<String> getEncryptionKey() {
        return Optional.ofNullable(encryptionKey);
    }

    public RetrieveDataEncryptionKeyResponse withEncryptionKey(String encryptionKey) {
        RetrieveDataEncryptionKeyResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.RetrieveDataEncryptionKeyResponse");
        _x.encryptionKey = encryptionKey;
        return _x;
    }

    public RetrieveDataEncryptionKeyResponse withUnmappedField(String name, Object value) {
        RetrieveDataEncryptionKeyResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String encryptionKey;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            this.changedFields = changedFields.add("EncryptionKey");
            return this;
        }

        public RetrieveDataEncryptionKeyResponse build() {
            RetrieveDataEncryptionKeyResponse _x = new RetrieveDataEncryptionKeyResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RetrieveDataEncryptionKeyResponse";
            _x.encryptionKey = encryptionKey;
            return _x;
        }
    }

    private RetrieveDataEncryptionKeyResponse _copy() {
        RetrieveDataEncryptionKeyResponse _x = new RetrieveDataEncryptionKeyResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.encryptionKey = encryptionKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RetrieveDataEncryptionKeyResponse[");
        b.append("EncryptionKey=");
        b.append(this.encryptionKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
