package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "CurrentNumberOfActiveUsers", 
    "MaxNumberOfActiveUsers", 
    "CurrentNumberOfNonInteractiveUsers", 
    "MaxNumberOfNonInteractiveUsers", 
    "CurrentNumberOfCustomEntities", 
    "MaxNumberOfCustomEntities", 
    "CurrentNumberOfPublishedWorkflows", 
    "MaxNumberOfPublishedWorkflows", 
    "CurrentStorage", 
    "MaxStorage"})
@JsonInclude(Include.NON_NULL)
public class OrganizationResources implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("CurrentNumberOfActiveUsers")
    protected Integer currentNumberOfActiveUsers;

    @JsonProperty("MaxNumberOfActiveUsers")
    protected Integer maxNumberOfActiveUsers;

    @JsonProperty("CurrentNumberOfNonInteractiveUsers")
    protected Integer currentNumberOfNonInteractiveUsers;

    @JsonProperty("MaxNumberOfNonInteractiveUsers")
    protected Integer maxNumberOfNonInteractiveUsers;

    @JsonProperty("CurrentNumberOfCustomEntities")
    protected Integer currentNumberOfCustomEntities;

    @JsonProperty("MaxNumberOfCustomEntities")
    protected Integer maxNumberOfCustomEntities;

    @JsonProperty("CurrentNumberOfPublishedWorkflows")
    protected Integer currentNumberOfPublishedWorkflows;

    @JsonProperty("MaxNumberOfPublishedWorkflows")
    protected Integer maxNumberOfPublishedWorkflows;

    @JsonProperty("CurrentStorage")
    protected Integer currentStorage;

    @JsonProperty("MaxStorage")
    protected Integer maxStorage;

    protected OrganizationResources() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrganizationResources";
    }

    @Property(name="CurrentNumberOfActiveUsers")
    @JsonIgnore
    public Optional<Integer> getCurrentNumberOfActiveUsers() {
        return Optional.ofNullable(currentNumberOfActiveUsers);
    }

    public OrganizationResources withCurrentNumberOfActiveUsers(Integer currentNumberOfActiveUsers) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.currentNumberOfActiveUsers = currentNumberOfActiveUsers;
        return _x;
    }

    @Property(name="MaxNumberOfActiveUsers")
    @JsonIgnore
    public Optional<Integer> getMaxNumberOfActiveUsers() {
        return Optional.ofNullable(maxNumberOfActiveUsers);
    }

    public OrganizationResources withMaxNumberOfActiveUsers(Integer maxNumberOfActiveUsers) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.maxNumberOfActiveUsers = maxNumberOfActiveUsers;
        return _x;
    }

    @Property(name="CurrentNumberOfNonInteractiveUsers")
    @JsonIgnore
    public Optional<Integer> getCurrentNumberOfNonInteractiveUsers() {
        return Optional.ofNullable(currentNumberOfNonInteractiveUsers);
    }

    public OrganizationResources withCurrentNumberOfNonInteractiveUsers(Integer currentNumberOfNonInteractiveUsers) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.currentNumberOfNonInteractiveUsers = currentNumberOfNonInteractiveUsers;
        return _x;
    }

    @Property(name="MaxNumberOfNonInteractiveUsers")
    @JsonIgnore
    public Optional<Integer> getMaxNumberOfNonInteractiveUsers() {
        return Optional.ofNullable(maxNumberOfNonInteractiveUsers);
    }

    public OrganizationResources withMaxNumberOfNonInteractiveUsers(Integer maxNumberOfNonInteractiveUsers) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.maxNumberOfNonInteractiveUsers = maxNumberOfNonInteractiveUsers;
        return _x;
    }

    @Property(name="CurrentNumberOfCustomEntities")
    @JsonIgnore
    public Optional<Integer> getCurrentNumberOfCustomEntities() {
        return Optional.ofNullable(currentNumberOfCustomEntities);
    }

    public OrganizationResources withCurrentNumberOfCustomEntities(Integer currentNumberOfCustomEntities) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.currentNumberOfCustomEntities = currentNumberOfCustomEntities;
        return _x;
    }

    @Property(name="MaxNumberOfCustomEntities")
    @JsonIgnore
    public Optional<Integer> getMaxNumberOfCustomEntities() {
        return Optional.ofNullable(maxNumberOfCustomEntities);
    }

    public OrganizationResources withMaxNumberOfCustomEntities(Integer maxNumberOfCustomEntities) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.maxNumberOfCustomEntities = maxNumberOfCustomEntities;
        return _x;
    }

    @Property(name="CurrentNumberOfPublishedWorkflows")
    @JsonIgnore
    public Optional<Integer> getCurrentNumberOfPublishedWorkflows() {
        return Optional.ofNullable(currentNumberOfPublishedWorkflows);
    }

    public OrganizationResources withCurrentNumberOfPublishedWorkflows(Integer currentNumberOfPublishedWorkflows) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.currentNumberOfPublishedWorkflows = currentNumberOfPublishedWorkflows;
        return _x;
    }

    @Property(name="MaxNumberOfPublishedWorkflows")
    @JsonIgnore
    public Optional<Integer> getMaxNumberOfPublishedWorkflows() {
        return Optional.ofNullable(maxNumberOfPublishedWorkflows);
    }

    public OrganizationResources withMaxNumberOfPublishedWorkflows(Integer maxNumberOfPublishedWorkflows) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.maxNumberOfPublishedWorkflows = maxNumberOfPublishedWorkflows;
        return _x;
    }

    @Property(name="CurrentStorage")
    @JsonIgnore
    public Optional<Integer> getCurrentStorage() {
        return Optional.ofNullable(currentStorage);
    }

    public OrganizationResources withCurrentStorage(Integer currentStorage) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.currentStorage = currentStorage;
        return _x;
    }

    @Property(name="MaxStorage")
    @JsonIgnore
    public Optional<Integer> getMaxStorage() {
        return Optional.ofNullable(maxStorage);
    }

    public OrganizationResources withMaxStorage(Integer maxStorage) {
        OrganizationResources _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.OrganizationResources");
        _x.maxStorage = maxStorage;
        return _x;
    }

    public OrganizationResources withUnmappedField(String name, Object value) {
        OrganizationResources _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer currentNumberOfActiveUsers;
        private Integer maxNumberOfActiveUsers;
        private Integer currentNumberOfNonInteractiveUsers;
        private Integer maxNumberOfNonInteractiveUsers;
        private Integer currentNumberOfCustomEntities;
        private Integer maxNumberOfCustomEntities;
        private Integer currentNumberOfPublishedWorkflows;
        private Integer maxNumberOfPublishedWorkflows;
        private Integer currentStorage;
        private Integer maxStorage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder currentNumberOfActiveUsers(Integer currentNumberOfActiveUsers) {
            this.currentNumberOfActiveUsers = currentNumberOfActiveUsers;
            this.changedFields = changedFields.add("CurrentNumberOfActiveUsers");
            return this;
        }

        public Builder maxNumberOfActiveUsers(Integer maxNumberOfActiveUsers) {
            this.maxNumberOfActiveUsers = maxNumberOfActiveUsers;
            this.changedFields = changedFields.add("MaxNumberOfActiveUsers");
            return this;
        }

        public Builder currentNumberOfNonInteractiveUsers(Integer currentNumberOfNonInteractiveUsers) {
            this.currentNumberOfNonInteractiveUsers = currentNumberOfNonInteractiveUsers;
            this.changedFields = changedFields.add("CurrentNumberOfNonInteractiveUsers");
            return this;
        }

        public Builder maxNumberOfNonInteractiveUsers(Integer maxNumberOfNonInteractiveUsers) {
            this.maxNumberOfNonInteractiveUsers = maxNumberOfNonInteractiveUsers;
            this.changedFields = changedFields.add("MaxNumberOfNonInteractiveUsers");
            return this;
        }

        public Builder currentNumberOfCustomEntities(Integer currentNumberOfCustomEntities) {
            this.currentNumberOfCustomEntities = currentNumberOfCustomEntities;
            this.changedFields = changedFields.add("CurrentNumberOfCustomEntities");
            return this;
        }

        public Builder maxNumberOfCustomEntities(Integer maxNumberOfCustomEntities) {
            this.maxNumberOfCustomEntities = maxNumberOfCustomEntities;
            this.changedFields = changedFields.add("MaxNumberOfCustomEntities");
            return this;
        }

        public Builder currentNumberOfPublishedWorkflows(Integer currentNumberOfPublishedWorkflows) {
            this.currentNumberOfPublishedWorkflows = currentNumberOfPublishedWorkflows;
            this.changedFields = changedFields.add("CurrentNumberOfPublishedWorkflows");
            return this;
        }

        public Builder maxNumberOfPublishedWorkflows(Integer maxNumberOfPublishedWorkflows) {
            this.maxNumberOfPublishedWorkflows = maxNumberOfPublishedWorkflows;
            this.changedFields = changedFields.add("MaxNumberOfPublishedWorkflows");
            return this;
        }

        public Builder currentStorage(Integer currentStorage) {
            this.currentStorage = currentStorage;
            this.changedFields = changedFields.add("CurrentStorage");
            return this;
        }

        public Builder maxStorage(Integer maxStorage) {
            this.maxStorage = maxStorage;
            this.changedFields = changedFields.add("MaxStorage");
            return this;
        }

        public OrganizationResources build() {
            OrganizationResources _x = new OrganizationResources();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OrganizationResources";
            _x.currentNumberOfActiveUsers = currentNumberOfActiveUsers;
            _x.maxNumberOfActiveUsers = maxNumberOfActiveUsers;
            _x.currentNumberOfNonInteractiveUsers = currentNumberOfNonInteractiveUsers;
            _x.maxNumberOfNonInteractiveUsers = maxNumberOfNonInteractiveUsers;
            _x.currentNumberOfCustomEntities = currentNumberOfCustomEntities;
            _x.maxNumberOfCustomEntities = maxNumberOfCustomEntities;
            _x.currentNumberOfPublishedWorkflows = currentNumberOfPublishedWorkflows;
            _x.maxNumberOfPublishedWorkflows = maxNumberOfPublishedWorkflows;
            _x.currentStorage = currentStorage;
            _x.maxStorage = maxStorage;
            return _x;
        }
    }

    private OrganizationResources _copy() {
        OrganizationResources _x = new OrganizationResources();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.currentNumberOfActiveUsers = currentNumberOfActiveUsers;
        _x.maxNumberOfActiveUsers = maxNumberOfActiveUsers;
        _x.currentNumberOfNonInteractiveUsers = currentNumberOfNonInteractiveUsers;
        _x.maxNumberOfNonInteractiveUsers = maxNumberOfNonInteractiveUsers;
        _x.currentNumberOfCustomEntities = currentNumberOfCustomEntities;
        _x.maxNumberOfCustomEntities = maxNumberOfCustomEntities;
        _x.currentNumberOfPublishedWorkflows = currentNumberOfPublishedWorkflows;
        _x.maxNumberOfPublishedWorkflows = maxNumberOfPublishedWorkflows;
        _x.currentStorage = currentStorage;
        _x.maxStorage = maxStorage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationResources[");
        b.append("CurrentNumberOfActiveUsers=");
        b.append(this.currentNumberOfActiveUsers);
        b.append(", ");
        b.append("MaxNumberOfActiveUsers=");
        b.append(this.maxNumberOfActiveUsers);
        b.append(", ");
        b.append("CurrentNumberOfNonInteractiveUsers=");
        b.append(this.currentNumberOfNonInteractiveUsers);
        b.append(", ");
        b.append("MaxNumberOfNonInteractiveUsers=");
        b.append(this.maxNumberOfNonInteractiveUsers);
        b.append(", ");
        b.append("CurrentNumberOfCustomEntities=");
        b.append(this.currentNumberOfCustomEntities);
        b.append(", ");
        b.append("MaxNumberOfCustomEntities=");
        b.append(this.maxNumberOfCustomEntities);
        b.append(", ");
        b.append("CurrentNumberOfPublishedWorkflows=");
        b.append(this.currentNumberOfPublishedWorkflows);
        b.append(", ");
        b.append("MaxNumberOfPublishedWorkflows=");
        b.append(this.maxNumberOfPublishedWorkflows);
        b.append(", ");
        b.append("CurrentStorage=");
        b.append(this.currentStorage);
        b.append(", ");
        b.append("MaxStorage=");
        b.append(this.maxStorage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
