package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.MetadataConditionOperator;

@JsonPropertyOrder({
    "@odata.type", 
    "PropertyName", 
    "ConditionOperator", 
    "Value"})
@JsonInclude(Include.NON_NULL)
public class MetadataConditionExpression implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("PropertyName")
    protected String propertyName;

    @JsonProperty("ConditionOperator")
    protected MetadataConditionOperator conditionOperator;

    @JsonProperty("Value")
    protected Object value;

    protected MetadataConditionExpression() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MetadataConditionExpression";
    }

    @Property(name="PropertyName")
    @JsonIgnore
    public Optional<String> getPropertyName() {
        return Optional.ofNullable(propertyName);
    }

    public MetadataConditionExpression withPropertyName(String propertyName) {
        MetadataConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataConditionExpression");
        _x.propertyName = propertyName;
        return _x;
    }

    @Property(name="ConditionOperator")
    @JsonIgnore
    public Optional<MetadataConditionOperator> getConditionOperator() {
        return Optional.ofNullable(conditionOperator);
    }

    public MetadataConditionExpression withConditionOperator(MetadataConditionOperator conditionOperator) {
        MetadataConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataConditionExpression");
        _x.conditionOperator = conditionOperator;
        return _x;
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<Object> getValue() {
        return Optional.ofNullable(value);
    }

    public MetadataConditionExpression withValue(Object value) {
        MetadataConditionExpression _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.MetadataConditionExpression");
        _x.value = value;
        return _x;
    }

    public MetadataConditionExpression withUnmappedField(String name, java.lang.Object value) {
        MetadataConditionExpression _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, java.lang.Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String propertyName;
        private MetadataConditionOperator conditionOperator;
        private Object value;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder propertyName(String propertyName) {
            this.propertyName = propertyName;
            this.changedFields = changedFields.add("PropertyName");
            return this;
        }

        public Builder conditionOperator(MetadataConditionOperator conditionOperator) {
            this.conditionOperator = conditionOperator;
            this.changedFields = changedFields.add("ConditionOperator");
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public MetadataConditionExpression build() {
            MetadataConditionExpression _x = new MetadataConditionExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MetadataConditionExpression";
            _x.propertyName = propertyName;
            _x.conditionOperator = conditionOperator;
            _x.value = value;
            return _x;
        }
    }

    private MetadataConditionExpression _copy() {
        MetadataConditionExpression _x = new MetadataConditionExpression();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.propertyName = propertyName;
        _x.conditionOperator = conditionOperator;
        _x.value = value;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MetadataConditionExpression[");
        b.append("PropertyName=");
        b.append(this.propertyName);
        b.append(", ");
        b.append("ConditionOperator=");
        b.append(this.conditionOperator);
        b.append(", ");
        b.append("Value=");
        b.append(this.value);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
