package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Label", 
    "LanguageCode"})
@JsonInclude(Include.NON_NULL)
public class LocalizedLabelInfo implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Label")
    protected String label;

    @JsonProperty("LanguageCode")
    protected Integer languageCode;

    protected LocalizedLabelInfo() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LocalizedLabelInfo";
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public LocalizedLabelInfo withLabel(String label) {
        LocalizedLabelInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabelInfo");
        _x.label = label;
        return _x;
    }

    @Property(name="LanguageCode")
    @JsonIgnore
    public Optional<Integer> getLanguageCode() {
        return Optional.ofNullable(languageCode);
    }

    public LocalizedLabelInfo withLanguageCode(Integer languageCode) {
        LocalizedLabelInfo _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabelInfo");
        _x.languageCode = languageCode;
        return _x;
    }

    public LocalizedLabelInfo withUnmappedField(String name, Object value) {
        LocalizedLabelInfo _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String label;
        private Integer languageCode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder languageCode(Integer languageCode) {
            this.languageCode = languageCode;
            this.changedFields = changedFields.add("LanguageCode");
            return this;
        }

        public LocalizedLabelInfo build() {
            LocalizedLabelInfo _x = new LocalizedLabelInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LocalizedLabelInfo";
            _x.label = label;
            _x.languageCode = languageCode;
            return _x;
        }
    }

    private LocalizedLabelInfo _copy() {
        LocalizedLabelInfo _x = new LocalizedLabelInfo();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.label = label;
        _x.languageCode = languageCode;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedLabelInfo[");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("LanguageCode=");
        b.append(this.languageCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
