package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder({
    "@odata.type", 
    "Label", 
    "LanguageCode", 
    "IsManaged", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class LocalizedLabel implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Label")
    protected String label;

    @JsonProperty("LanguageCode")
    protected Integer languageCode;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("MetadataId")
    protected UUID metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected LocalizedLabel() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LocalizedLabel";
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(label);
    }

    public LocalizedLabel withLabel(String label) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.label = label;
        return _x;
    }

    @Property(name="LanguageCode")
    @JsonIgnore
    public Optional<Integer> getLanguageCode() {
        return Optional.ofNullable(languageCode);
    }

    public LocalizedLabel withLanguageCode(Integer languageCode) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.languageCode = languageCode;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public LocalizedLabel withIsManaged(Boolean isManaged) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public LocalizedLabel withMetadataId(UUID metadataId) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public LocalizedLabel withHasChanged(Boolean hasChanged) {
        LocalizedLabel _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public LocalizedLabel withUnmappedField(String name, Object value) {
        LocalizedLabel _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String label;
        private Integer languageCode;
        private Boolean isManaged;
        private UUID metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = changedFields.add("Label");
            return this;
        }

        public Builder languageCode(Integer languageCode) {
            this.languageCode = languageCode;
            this.changedFields = changedFields.add("LanguageCode");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public LocalizedLabel build() {
            LocalizedLabel _x = new LocalizedLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LocalizedLabel";
            _x.label = label;
            _x.languageCode = languageCode;
            _x.isManaged = isManaged;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private LocalizedLabel _copy() {
        LocalizedLabel _x = new LocalizedLabel();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.label = label;
        _x.languageCode = languageCode;
        _x.isManaged = isManaged;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedLabel[");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("LanguageCode=");
        b.append(this.languageCode);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
