package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "FileName", 
    "FileSizeInBytes", 
    "MimeType", 
    "SasUrl"})
@JsonInclude(Include.NON_NULL)
public class FileSasUrlResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("FileName")
    protected String fileName;

    @JsonProperty("FileSizeInBytes")
    protected Long fileSizeInBytes;

    @JsonProperty("MimeType")
    protected String mimeType;

    @JsonProperty("SasUrl")
    protected String sasUrl;

    protected FileSasUrlResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FileSasUrlResponse";
    }

    @Property(name="FileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public FileSasUrlResponse withFileName(String fileName) {
        FileSasUrlResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Long> getFileSizeInBytes() {
        return Optional.ofNullable(fileSizeInBytes);
    }

    public FileSasUrlResponse withFileSizeInBytes(Long fileSizeInBytes) {
        FileSasUrlResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Property(name="MimeType")
    @JsonIgnore
    public Optional<String> getMimeType() {
        return Optional.ofNullable(mimeType);
    }

    public FileSasUrlResponse withMimeType(String mimeType) {
        FileSasUrlResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.mimeType = mimeType;
        return _x;
    }

    @Property(name="SasUrl")
    @JsonIgnore
    public Optional<String> getSasUrl() {
        return Optional.ofNullable(sasUrl);
    }

    public FileSasUrlResponse withSasUrl(String sasUrl) {
        FileSasUrlResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.sasUrl = sasUrl;
        return _x;
    }

    public FileSasUrlResponse withUnmappedField(String name, Object value) {
        FileSasUrlResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String fileName;
        private Long fileSizeInBytes;
        private String mimeType;
        private String sasUrl;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("FileName");
            return this;
        }

        public Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = changedFields.add("FileSizeInBytes");
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            this.changedFields = changedFields.add("MimeType");
            return this;
        }

        public Builder sasUrl(String sasUrl) {
            this.sasUrl = sasUrl;
            this.changedFields = changedFields.add("SasUrl");
            return this;
        }

        public FileSasUrlResponse build() {
            FileSasUrlResponse _x = new FileSasUrlResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.FileSasUrlResponse";
            _x.fileName = fileName;
            _x.fileSizeInBytes = fileSizeInBytes;
            _x.mimeType = mimeType;
            _x.sasUrl = sasUrl;
            return _x;
        }
    }

    private FileSasUrlResponse _copy() {
        FileSasUrlResponse _x = new FileSasUrlResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.fileName = fileName;
        _x.fileSizeInBytes = fileSizeInBytes;
        _x.mimeType = mimeType;
        _x.sasUrl = sasUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileSasUrlResponse[");
        b.append("FileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append(", ");
        b.append("MimeType=");
        b.append(this.mimeType);
        b.append(", ");
        b.append("SasUrl=");
        b.append(this.sasUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
