package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.math.BigDecimal;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "originalText", 
    "textScore"})
@JsonInclude(Include.NON_NULL)
public class ExtractTextEntitiesResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("originalText")
    protected String originalText;

    @JsonProperty("textScore")
    protected BigDecimal textScore;

    protected ExtractTextEntitiesResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse";
    }

    @Property(name="originalText")
    @JsonIgnore
    public Optional<String> getOriginalText() {
        return Optional.ofNullable(originalText);
    }

    public ExtractTextEntitiesResponse withOriginalText(String originalText) {
        ExtractTextEntitiesResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse");
        _x.originalText = originalText;
        return _x;
    }

    @Property(name="textScore")
    @JsonIgnore
    public Optional<BigDecimal> getTextScore() {
        return Optional.ofNullable(textScore);
    }

    public ExtractTextEntitiesResponse withTextScore(BigDecimal textScore) {
        ExtractTextEntitiesResponse _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse");
        _x.textScore = textScore;
        return _x;
    }

    public ExtractTextEntitiesResponse withUnmappedField(String name, Object value) {
        ExtractTextEntitiesResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String originalText;
        private BigDecimal textScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder originalText(String originalText) {
            this.originalText = originalText;
            this.changedFields = changedFields.add("originalText");
            return this;
        }

        public Builder textScore(BigDecimal textScore) {
            this.textScore = textScore;
            this.changedFields = changedFields.add("textScore");
            return this;
        }

        public ExtractTextEntitiesResponse build() {
            ExtractTextEntitiesResponse _x = new ExtractTextEntitiesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse";
            _x.originalText = originalText;
            _x.textScore = textScore;
            return _x;
        }
    }

    private ExtractTextEntitiesResponse _copy() {
        ExtractTextEntitiesResponse _x = new ExtractTextEntitiesResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.originalText = originalText;
        _x.textScore = textScore;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractTextEntitiesResponse[");
        b.append("originalText=");
        b.append(this.originalText);
        b.append(", ");
        b.append("textScore=");
        b.append(this.textScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
