package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EntityName", 
    "AttributeName"})
@JsonInclude(Include.NON_NULL)
public class EntityAndAttribute implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EntityName")
    protected String entityName;

    @JsonProperty("AttributeName")
    protected String attributeName;

    protected EntityAndAttribute() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityAndAttribute";
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(entityName);
    }

    public EntityAndAttribute withEntityName(String entityName) {
        EntityAndAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityAndAttribute");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(attributeName);
    }

    public EntityAndAttribute withAttributeName(String attributeName) {
        EntityAndAttribute _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.EntityAndAttribute");
        _x.attributeName = attributeName;
        return _x;
    }

    public EntityAndAttribute withUnmappedField(String name, Object value) {
        EntityAndAttribute _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String entityName;
        private String attributeName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = changedFields.add("EntityName");
            return this;
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = changedFields.add("AttributeName");
            return this;
        }

        public EntityAndAttribute build() {
            EntityAndAttribute _x = new EntityAndAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityAndAttribute";
            _x.entityName = entityName;
            _x.attributeName = attributeName;
            return _x;
        }
    }

    private EntityAndAttribute _copy() {
        EntityAndAttribute _x = new EntityAndAttribute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.entityName = entityName;
        _x.attributeName = attributeName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityAndAttribute[");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
