package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

import microsoft.dynamics.crm.enums.RelationshipType;

@JsonPropertyOrder({
    "@odata.type", 
    "MetadataId", 
    "Name", 
    "EntityRelationshipType", 
    "ReferencingAttribute", 
    "ReferencedAttribute", 
    "RelationshipEntity", 
    "IsValidForAdvancedFind", 
    "HasReadPrivilege", 
    "IsHierarchical", 
    "ManyToManyRelationshipMetadata"})
@JsonInclude(Include.NON_NULL)
public class DependentRelationship implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("MetadataId")
    protected String metadataId;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("EntityRelationshipType")
    protected RelationshipType entityRelationshipType;

    @JsonProperty("ReferencingAttribute")
    protected String referencingAttribute;

    @JsonProperty("ReferencedAttribute")
    protected String referencedAttribute;

    @JsonProperty("RelationshipEntity")
    protected String relationshipEntity;

    @JsonProperty("IsValidForAdvancedFind")
    protected Boolean isValidForAdvancedFind;

    @JsonProperty("HasReadPrivilege")
    protected Boolean hasReadPrivilege;

    @JsonProperty("IsHierarchical")
    protected Boolean isHierarchical;

    @JsonProperty("ManyToManyRelationshipMetadata")
    protected DependentManyToManyRelationshipMetadata manyToManyRelationshipMetadata;

    protected DependentRelationship() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentRelationship";
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<String> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public DependentRelationship withMetadataId(String metadataId) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public DependentRelationship withName(String name) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.name = name;
        return _x;
    }

    @Property(name="EntityRelationshipType")
    @JsonIgnore
    public Optional<RelationshipType> getEntityRelationshipType() {
        return Optional.ofNullable(entityRelationshipType);
    }

    public DependentRelationship withEntityRelationshipType(RelationshipType entityRelationshipType) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.entityRelationshipType = entityRelationshipType;
        return _x;
    }

    @Property(name="ReferencingAttribute")
    @JsonIgnore
    public Optional<String> getReferencingAttribute() {
        return Optional.ofNullable(referencingAttribute);
    }

    public DependentRelationship withReferencingAttribute(String referencingAttribute) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.referencingAttribute = referencingAttribute;
        return _x;
    }

    @Property(name="ReferencedAttribute")
    @JsonIgnore
    public Optional<String> getReferencedAttribute() {
        return Optional.ofNullable(referencedAttribute);
    }

    public DependentRelationship withReferencedAttribute(String referencedAttribute) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.referencedAttribute = referencedAttribute;
        return _x;
    }

    @Property(name="RelationshipEntity")
    @JsonIgnore
    public Optional<String> getRelationshipEntity() {
        return Optional.ofNullable(relationshipEntity);
    }

    public DependentRelationship withRelationshipEntity(String relationshipEntity) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.relationshipEntity = relationshipEntity;
        return _x;
    }

    @Property(name="IsValidForAdvancedFind")
    @JsonIgnore
    public Optional<Boolean> getIsValidForAdvancedFind() {
        return Optional.ofNullable(isValidForAdvancedFind);
    }

    public DependentRelationship withIsValidForAdvancedFind(Boolean isValidForAdvancedFind) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        return _x;
    }

    @Property(name="HasReadPrivilege")
    @JsonIgnore
    public Optional<Boolean> getHasReadPrivilege() {
        return Optional.ofNullable(hasReadPrivilege);
    }

    public DependentRelationship withHasReadPrivilege(Boolean hasReadPrivilege) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.hasReadPrivilege = hasReadPrivilege;
        return _x;
    }

    @Property(name="IsHierarchical")
    @JsonIgnore
    public Optional<Boolean> getIsHierarchical() {
        return Optional.ofNullable(isHierarchical);
    }

    public DependentRelationship withIsHierarchical(Boolean isHierarchical) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.isHierarchical = isHierarchical;
        return _x;
    }

    @Property(name="ManyToManyRelationshipMetadata")
    @JsonIgnore
    public Optional<DependentManyToManyRelationshipMetadata> getManyToManyRelationshipMetadata() {
        return Optional.ofNullable(manyToManyRelationshipMetadata);
    }

    public DependentRelationship withManyToManyRelationshipMetadata(DependentManyToManyRelationshipMetadata manyToManyRelationshipMetadata) {
        DependentRelationship _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.DependentRelationship");
        _x.manyToManyRelationshipMetadata = manyToManyRelationshipMetadata;
        return _x;
    }

    public DependentRelationship withUnmappedField(String name, Object value) {
        DependentRelationship _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String metadataId;
        private String name;
        private RelationshipType entityRelationshipType;
        private String referencingAttribute;
        private String referencedAttribute;
        private String relationshipEntity;
        private Boolean isValidForAdvancedFind;
        private Boolean hasReadPrivilege;
        private Boolean isHierarchical;
        private DependentManyToManyRelationshipMetadata manyToManyRelationshipMetadata;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder entityRelationshipType(RelationshipType entityRelationshipType) {
            this.entityRelationshipType = entityRelationshipType;
            this.changedFields = changedFields.add("EntityRelationshipType");
            return this;
        }

        public Builder referencingAttribute(String referencingAttribute) {
            this.referencingAttribute = referencingAttribute;
            this.changedFields = changedFields.add("ReferencingAttribute");
            return this;
        }

        public Builder referencedAttribute(String referencedAttribute) {
            this.referencedAttribute = referencedAttribute;
            this.changedFields = changedFields.add("ReferencedAttribute");
            return this;
        }

        public Builder relationshipEntity(String relationshipEntity) {
            this.relationshipEntity = relationshipEntity;
            this.changedFields = changedFields.add("RelationshipEntity");
            return this;
        }

        public Builder isValidForAdvancedFind(Boolean isValidForAdvancedFind) {
            this.isValidForAdvancedFind = isValidForAdvancedFind;
            this.changedFields = changedFields.add("IsValidForAdvancedFind");
            return this;
        }

        public Builder hasReadPrivilege(Boolean hasReadPrivilege) {
            this.hasReadPrivilege = hasReadPrivilege;
            this.changedFields = changedFields.add("HasReadPrivilege");
            return this;
        }

        public Builder isHierarchical(Boolean isHierarchical) {
            this.isHierarchical = isHierarchical;
            this.changedFields = changedFields.add("IsHierarchical");
            return this;
        }

        public Builder manyToManyRelationshipMetadata(DependentManyToManyRelationshipMetadata manyToManyRelationshipMetadata) {
            this.manyToManyRelationshipMetadata = manyToManyRelationshipMetadata;
            this.changedFields = changedFields.add("ManyToManyRelationshipMetadata");
            return this;
        }

        public DependentRelationship build() {
            DependentRelationship _x = new DependentRelationship();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentRelationship";
            _x.metadataId = metadataId;
            _x.name = name;
            _x.entityRelationshipType = entityRelationshipType;
            _x.referencingAttribute = referencingAttribute;
            _x.referencedAttribute = referencedAttribute;
            _x.relationshipEntity = relationshipEntity;
            _x.isValidForAdvancedFind = isValidForAdvancedFind;
            _x.hasReadPrivilege = hasReadPrivilege;
            _x.isHierarchical = isHierarchical;
            _x.manyToManyRelationshipMetadata = manyToManyRelationshipMetadata;
            return _x;
        }
    }

    private DependentRelationship _copy() {
        DependentRelationship _x = new DependentRelationship();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.metadataId = metadataId;
        _x.name = name;
        _x.entityRelationshipType = entityRelationshipType;
        _x.referencingAttribute = referencingAttribute;
        _x.referencedAttribute = referencedAttribute;
        _x.relationshipEntity = relationshipEntity;
        _x.isValidForAdvancedFind = isValidForAdvancedFind;
        _x.hasReadPrivilege = hasReadPrivilege;
        _x.isHierarchical = isHierarchical;
        _x.manyToManyRelationshipMetadata = manyToManyRelationshipMetadata;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentRelationship[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("EntityRelationshipType=");
        b.append(this.entityRelationshipType);
        b.append(", ");
        b.append("ReferencingAttribute=");
        b.append(this.referencingAttribute);
        b.append(", ");
        b.append("ReferencedAttribute=");
        b.append(this.referencedAttribute);
        b.append(", ");
        b.append("RelationshipEntity=");
        b.append(this.relationshipEntity);
        b.append(", ");
        b.append("IsValidForAdvancedFind=");
        b.append(this.isValidForAdvancedFind);
        b.append(", ");
        b.append("HasReadPrivilege=");
        b.append(this.hasReadPrivilege);
        b.append(", ");
        b.append("IsHierarchical=");
        b.append(this.isHierarchical);
        b.append(", ");
        b.append("ManyToManyRelationshipMetadata=");
        b.append(this.manyToManyRelationshipMetadata);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
