package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder({
    "@odata.type", 
    "Options", 
    "ParentOptionSetName", 
    "Description", 
    "DisplayName", 
    "IsCustomOptionSet", 
    "IsGlobal", 
    "IsManaged", 
    "IsCustomizable", 
    "Name", 
    "ExternalTypeName", 
    "OptionSetType", 
    "IntroducedVersion", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class ComplexOptionSetMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Options")
    protected List<OptionMetadata> options;

    @JsonProperty("Options@nextLink")
    protected String optionsNextLink;

    @JsonProperty("ParentOptionSetName")
    protected String parentOptionSetName;

    @JsonProperty("Description")
    protected Label description;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("IsCustomOptionSet")
    protected Boolean isCustomOptionSet;

    @JsonProperty("IsGlobal")
    protected Boolean isGlobal;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("Name")
    protected String name;

    @JsonProperty("ExternalTypeName")
    protected String externalTypeName;

    @JsonProperty("OptionSetType")
    protected OptionSetType optionSetType;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("MetadataId")
    protected UUID metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected ComplexOptionSetMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata";
    }

    @Property(name="Options")
    @JsonIgnore
    public CollectionPage<OptionMetadata> getOptions() {
        return new CollectionPage<OptionMetadata>(contextPath, OptionMetadata.class, this.options, Optional.ofNullable(optionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Options")
    @JsonIgnore
    public CollectionPage<OptionMetadata> getOptions(HttpRequestOptions options) {
        return new CollectionPage<OptionMetadata>(contextPath, OptionMetadata.class, this.options, Optional.ofNullable(optionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ParentOptionSetName")
    @JsonIgnore
    public Optional<String> getParentOptionSetName() {
        return Optional.ofNullable(parentOptionSetName);
    }

    public ComplexOptionSetMetadata withParentOptionSetName(String parentOptionSetName) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.parentOptionSetName = parentOptionSetName;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(description);
    }

    public ComplexOptionSetMetadata withDescription(Label description) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ComplexOptionSetMetadata withDisplayName(Label displayName) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="IsCustomOptionSet")
    @JsonIgnore
    public Optional<Boolean> getIsCustomOptionSet() {
        return Optional.ofNullable(isCustomOptionSet);
    }

    public ComplexOptionSetMetadata withIsCustomOptionSet(Boolean isCustomOptionSet) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isCustomOptionSet = isCustomOptionSet;
        return _x;
    }

    @Property(name="IsGlobal")
    @JsonIgnore
    public Optional<Boolean> getIsGlobal() {
        return Optional.ofNullable(isGlobal);
    }

    public ComplexOptionSetMetadata withIsGlobal(Boolean isGlobal) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isGlobal = isGlobal;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public ComplexOptionSetMetadata withIsManaged(Boolean isManaged) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public ComplexOptionSetMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(name);
    }

    public ComplexOptionSetMetadata withName(String name) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.name = name;
        return _x;
    }

    @Property(name="ExternalTypeName")
    @JsonIgnore
    public Optional<String> getExternalTypeName() {
        return Optional.ofNullable(externalTypeName);
    }

    public ComplexOptionSetMetadata withExternalTypeName(String externalTypeName) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.externalTypeName = externalTypeName;
        return _x;
    }

    @Property(name="OptionSetType")
    @JsonIgnore
    public Optional<OptionSetType> getOptionSetType() {
        return Optional.ofNullable(optionSetType);
    }

    public ComplexOptionSetMetadata withOptionSetType(OptionSetType optionSetType) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.optionSetType = optionSetType;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public ComplexOptionSetMetadata withIntroducedVersion(String introducedVersion) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public ComplexOptionSetMetadata withMetadataId(UUID metadataId) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public ComplexOptionSetMetadata withHasChanged(Boolean hasChanged) {
        ComplexOptionSetMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public ComplexOptionSetMetadata withUnmappedField(String name, Object value) {
        ComplexOptionSetMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<OptionMetadata> options;
        private String optionsNextLink;
        private String parentOptionSetName;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private UUID metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder options(List<OptionMetadata> options) {
            this.options = options;
            this.changedFields = changedFields.add("Options");
            return this;
        }

        public Builder options(OptionMetadata... options) {
            return options(Arrays.asList(options));
        }

        public Builder optionsNextLink(String optionsNextLink) {
            this.optionsNextLink = optionsNextLink;
            this.changedFields = changedFields.add("Options");
            return this;
        }

        public Builder parentOptionSetName(String parentOptionSetName) {
            this.parentOptionSetName = parentOptionSetName;
            this.changedFields = changedFields.add("ParentOptionSetName");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public ComplexOptionSetMetadata build() {
            ComplexOptionSetMetadata _x = new ComplexOptionSetMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata";
            _x.options = options;
            _x.optionsNextLink = optionsNextLink;
            _x.parentOptionSetName = parentOptionSetName;
            _x.description = description;
            _x.displayName = displayName;
            _x.isCustomOptionSet = isCustomOptionSet;
            _x.isGlobal = isGlobal;
            _x.isManaged = isManaged;
            _x.isCustomizable = isCustomizable;
            _x.name = name;
            _x.externalTypeName = externalTypeName;
            _x.optionSetType = optionSetType;
            _x.introducedVersion = introducedVersion;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private ComplexOptionSetMetadata _copy() {
        ComplexOptionSetMetadata _x = new ComplexOptionSetMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.options = options;
        _x.parentOptionSetName = parentOptionSetName;
        _x.description = description;
        _x.displayName = displayName;
        _x.isCustomOptionSet = isCustomOptionSet;
        _x.isGlobal = isGlobal;
        _x.isManaged = isManaged;
        _x.isCustomizable = isCustomizable;
        _x.name = name;
        _x.externalTypeName = externalTypeName;
        _x.optionSetType = optionSetType;
        _x.introducedVersion = introducedVersion;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplexOptionSetMetadata[");
        b.append("Options=");
        b.append(this.options);
        b.append(", ");
        b.append("ParentOptionSetName=");
        b.append(this.parentOptionSetName);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append(this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
