package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.enums.EntityKeyIndexStatus;

@JsonPropertyOrder({
    "@odata.type", 
    "DisplayName", 
    "LogicalName", 
    "SchemaName", 
    "EntityLogicalName", 
    "KeyAttributes", 
    "IsCustomizable", 
    "IsManaged", 
    "IntroducedVersion", 
    "EntityKeyIndexStatus", 
    "IsSynchronous", 
    "IsExportKey", 
    "MetadataId", 
    "HasChanged"})
@JsonInclude(Include.NON_NULL)
public class ComplexEntityKeyMetadata implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("DisplayName")
    protected Label displayName;

    @JsonProperty("LogicalName")
    protected String logicalName;

    @JsonProperty("SchemaName")
    protected String schemaName;

    @JsonProperty("EntityLogicalName")
    protected String entityLogicalName;

    @JsonProperty("KeyAttributes")
    protected List<String> keyAttributes;

    @JsonProperty("KeyAttributes@nextLink")
    protected String keyAttributesNextLink;

    @JsonProperty("IsCustomizable")
    protected BooleanManagedProperty isCustomizable;

    @JsonProperty("IsManaged")
    protected Boolean isManaged;

    @JsonProperty("IntroducedVersion")
    protected String introducedVersion;

    @JsonProperty("EntityKeyIndexStatus")
    protected EntityKeyIndexStatus entityKeyIndexStatus;

    @JsonProperty("IsSynchronous")
    protected Boolean isSynchronous;

    @JsonProperty("IsExportKey")
    protected Boolean isExportKey;

    @JsonProperty("MetadataId")
    protected UUID metadataId;

    @JsonProperty("HasChanged")
    protected Boolean hasChanged;

    protected ComplexEntityKeyMetadata() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata";
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ComplexEntityKeyMetadata withDisplayName(Label displayName) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(logicalName);
    }

    public ComplexEntityKeyMetadata withLogicalName(String logicalName) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(schemaName);
    }

    public ComplexEntityKeyMetadata withSchemaName(String schemaName) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(entityLogicalName);
    }

    public ComplexEntityKeyMetadata withEntityLogicalName(String entityLogicalName) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="KeyAttributes")
    @JsonIgnore
    public CollectionPage<String> getKeyAttributes() {
        return new CollectionPage<String>(contextPath, String.class, this.keyAttributes, Optional.ofNullable(keyAttributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="KeyAttributes")
    @JsonIgnore
    public CollectionPage<String> getKeyAttributes(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.keyAttributes, Optional.ofNullable(keyAttributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(isCustomizable);
    }

    public ComplexEntityKeyMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(isManaged);
    }

    public ComplexEntityKeyMetadata withIsManaged(Boolean isManaged) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(introducedVersion);
    }

    public ComplexEntityKeyMetadata withIntroducedVersion(String introducedVersion) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="EntityKeyIndexStatus")
    @JsonIgnore
    public Optional<EntityKeyIndexStatus> getEntityKeyIndexStatus() {
        return Optional.ofNullable(entityKeyIndexStatus);
    }

    public ComplexEntityKeyMetadata withEntityKeyIndexStatus(EntityKeyIndexStatus entityKeyIndexStatus) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.entityKeyIndexStatus = entityKeyIndexStatus;
        return _x;
    }

    @Property(name="IsSynchronous")
    @JsonIgnore
    public Optional<Boolean> getIsSynchronous() {
        return Optional.ofNullable(isSynchronous);
    }

    public ComplexEntityKeyMetadata withIsSynchronous(Boolean isSynchronous) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.isSynchronous = isSynchronous;
        return _x;
    }

    @Property(name="IsExportKey")
    @JsonIgnore
    public Optional<Boolean> getIsExportKey() {
        return Optional.ofNullable(isExportKey);
    }

    public ComplexEntityKeyMetadata withIsExportKey(Boolean isExportKey) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.isExportKey = isExportKey;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(metadataId);
    }

    public ComplexEntityKeyMetadata withMetadataId(UUID metadataId) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(hasChanged);
    }

    public ComplexEntityKeyMetadata withHasChanged(Boolean hasChanged) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public ComplexEntityKeyMetadata withUnmappedField(String name, Object value) {
        ComplexEntityKeyMetadata _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Label displayName;
        private String logicalName;
        private String schemaName;
        private String entityLogicalName;
        private List<String> keyAttributes;
        private String keyAttributesNextLink;
        private BooleanManagedProperty isCustomizable;
        private Boolean isManaged;
        private String introducedVersion;
        private EntityKeyIndexStatus entityKeyIndexStatus;
        private Boolean isSynchronous;
        private Boolean isExportKey;
        private UUID metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("DisplayName");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = changedFields.add("LogicalName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = changedFields.add("SchemaName");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder keyAttributes(List<String> keyAttributes) {
            this.keyAttributes = keyAttributes;
            this.changedFields = changedFields.add("KeyAttributes");
            return this;
        }

        public Builder keyAttributes(String... keyAttributes) {
            return keyAttributes(Arrays.asList(keyAttributes));
        }

        public Builder keyAttributesNextLink(String keyAttributesNextLink) {
            this.keyAttributesNextLink = keyAttributesNextLink;
            this.changedFields = changedFields.add("KeyAttributes");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = changedFields.add("IsManaged");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entityKeyIndexStatus(EntityKeyIndexStatus entityKeyIndexStatus) {
            this.entityKeyIndexStatus = entityKeyIndexStatus;
            this.changedFields = changedFields.add("EntityKeyIndexStatus");
            return this;
        }

        public Builder isSynchronous(Boolean isSynchronous) {
            this.isSynchronous = isSynchronous;
            this.changedFields = changedFields.add("IsSynchronous");
            return this;
        }

        public Builder isExportKey(Boolean isExportKey) {
            this.isExportKey = isExportKey;
            this.changedFields = changedFields.add("IsExportKey");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = changedFields.add("HasChanged");
            return this;
        }

        public ComplexEntityKeyMetadata build() {
            ComplexEntityKeyMetadata _x = new ComplexEntityKeyMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ComplexEntityKeyMetadata";
            _x.displayName = displayName;
            _x.logicalName = logicalName;
            _x.schemaName = schemaName;
            _x.entityLogicalName = entityLogicalName;
            _x.keyAttributes = keyAttributes;
            _x.keyAttributesNextLink = keyAttributesNextLink;
            _x.isCustomizable = isCustomizable;
            _x.isManaged = isManaged;
            _x.introducedVersion = introducedVersion;
            _x.entityKeyIndexStatus = entityKeyIndexStatus;
            _x.isSynchronous = isSynchronous;
            _x.isExportKey = isExportKey;
            _x.metadataId = metadataId;
            _x.hasChanged = hasChanged;
            return _x;
        }
    }

    private ComplexEntityKeyMetadata _copy() {
        ComplexEntityKeyMetadata _x = new ComplexEntityKeyMetadata();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.displayName = displayName;
        _x.logicalName = logicalName;
        _x.schemaName = schemaName;
        _x.entityLogicalName = entityLogicalName;
        _x.keyAttributes = keyAttributes;
        _x.isCustomizable = isCustomizable;
        _x.isManaged = isManaged;
        _x.introducedVersion = introducedVersion;
        _x.entityKeyIndexStatus = entityKeyIndexStatus;
        _x.isSynchronous = isSynchronous;
        _x.isExportKey = isExportKey;
        _x.metadataId = metadataId;
        _x.hasChanged = hasChanged;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplexEntityKeyMetadata[");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("KeyAttributes=");
        b.append(this.keyAttributes);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("EntityKeyIndexStatus=");
        b.append(this.entityKeyIndexStatus);
        b.append(", ");
        b.append("IsSynchronous=");
        b.append(this.isSynchronous);
        b.append(", ");
        b.append("IsExportKey=");
        b.append(this.isExportKey);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
