package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Count", 
    "Keys", 
    "Values"})
@JsonInclude(Include.NON_NULL)
public class Collection_String_String implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Count")
    protected Integer count;

    @JsonProperty("Keys")
    protected List<String> keys;

    @JsonProperty("Keys@nextLink")
    protected String keysNextLink;

    @JsonProperty("Values")
    protected List<String> values;

    @JsonProperty("Values@nextLink")
    protected String valuesNextLink;

    protected Collection_String_String() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.Collection_String_String";
    }

    @Property(name="Count")
    @JsonIgnore
    public Optional<Integer> getCount() {
        return Optional.ofNullable(count);
    }

    public Collection_String_String withCount(Integer count) {
        Collection_String_String _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.Collection_String_String");
        _x.count = count;
        return _x;
    }

    @Property(name="Keys")
    @JsonIgnore
    public CollectionPage<String> getKeys() {
        return new CollectionPage<String>(contextPath, String.class, this.keys, Optional.ofNullable(keysNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Keys")
    @JsonIgnore
    public CollectionPage<String> getKeys(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.keys, Optional.ofNullable(keysNextLink), Collections.emptyList(), options);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<String> getValues() {
        return new CollectionPage<String>(contextPath, String.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Values")
    @JsonIgnore
    public CollectionPage<String> getValues(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, this.values, Optional.ofNullable(valuesNextLink), Collections.emptyList(), options);
    }

    public Collection_String_String withUnmappedField(String name, Object value) {
        Collection_String_String _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer count;
        private List<String> keys;
        private String keysNextLink;
        private List<String> values;
        private String valuesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder count(Integer count) {
            this.count = count;
            this.changedFields = changedFields.add("Count");
            return this;
        }

        public Builder keys(List<String> keys) {
            this.keys = keys;
            this.changedFields = changedFields.add("Keys");
            return this;
        }

        public Builder keys(String... keys) {
            return keys(Arrays.asList(keys));
        }

        public Builder keysNextLink(String keysNextLink) {
            this.keysNextLink = keysNextLink;
            this.changedFields = changedFields.add("Keys");
            return this;
        }

        public Builder values(List<String> values) {
            this.values = values;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Builder values(String... values) {
            return values(Arrays.asList(values));
        }

        public Builder valuesNextLink(String valuesNextLink) {
            this.valuesNextLink = valuesNextLink;
            this.changedFields = changedFields.add("Values");
            return this;
        }

        public Collection_String_String build() {
            Collection_String_String _x = new Collection_String_String();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.Collection_String_String";
            _x.count = count;
            _x.keys = keys;
            _x.keysNextLink = keysNextLink;
            _x.values = values;
            _x.valuesNextLink = valuesNextLink;
            return _x;
        }
    }

    private Collection_String_String _copy() {
        Collection_String_String _x = new Collection_String_String();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.count = count;
        _x.keys = keys;
        _x.values = values;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Collection_String_String[");
        b.append("Count=");
        b.append(this.count);
        b.append(", ");
        b.append("Keys=");
        b.append(this.keys);
        b.append(", ");
        b.append("Values=");
        b.append(this.values);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
