package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "EmailAccess", 
    "FacebookAccess", 
    "PhoneAccess", 
    "TwitterAccess", 
    "WebAccess", 
    "ViewKnowledgeArticles", 
    "ViewArticleRating", 
    "RateKnowledgeArticles", 
    "SubmitFeedback", 
    "ChannelAccessProfilePrivilegeList"})
@JsonInclude(Include.NON_NULL)
public class ChannelAccessProfileWithPrivileges implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("EmailAccess")
    protected Boolean emailAccess;

    @JsonProperty("FacebookAccess")
    protected Boolean facebookAccess;

    @JsonProperty("PhoneAccess")
    protected Boolean phoneAccess;

    @JsonProperty("TwitterAccess")
    protected Boolean twitterAccess;

    @JsonProperty("WebAccess")
    protected Boolean webAccess;

    @JsonProperty("ViewKnowledgeArticles")
    protected Boolean viewKnowledgeArticles;

    @JsonProperty("ViewArticleRating")
    protected Boolean viewArticleRating;

    @JsonProperty("RateKnowledgeArticles")
    protected Boolean rateKnowledgeArticles;

    @JsonProperty("SubmitFeedback")
    protected Boolean submitFeedback;

    @JsonProperty("ChannelAccessProfilePrivilegeList")
    protected List<ChannelAccessProfilePrivilege> channelAccessProfilePrivilegeList;

    @JsonProperty("ChannelAccessProfilePrivilegeList@nextLink")
    protected String channelAccessProfilePrivilegeListNextLink;

    protected ChannelAccessProfileWithPrivileges() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges";
    }

    @Property(name="EmailAccess")
    @JsonIgnore
    public Optional<Boolean> getEmailAccess() {
        return Optional.ofNullable(emailAccess);
    }

    public ChannelAccessProfileWithPrivileges withEmailAccess(Boolean emailAccess) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.emailAccess = emailAccess;
        return _x;
    }

    @Property(name="FacebookAccess")
    @JsonIgnore
    public Optional<Boolean> getFacebookAccess() {
        return Optional.ofNullable(facebookAccess);
    }

    public ChannelAccessProfileWithPrivileges withFacebookAccess(Boolean facebookAccess) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.facebookAccess = facebookAccess;
        return _x;
    }

    @Property(name="PhoneAccess")
    @JsonIgnore
    public Optional<Boolean> getPhoneAccess() {
        return Optional.ofNullable(phoneAccess);
    }

    public ChannelAccessProfileWithPrivileges withPhoneAccess(Boolean phoneAccess) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.phoneAccess = phoneAccess;
        return _x;
    }

    @Property(name="TwitterAccess")
    @JsonIgnore
    public Optional<Boolean> getTwitterAccess() {
        return Optional.ofNullable(twitterAccess);
    }

    public ChannelAccessProfileWithPrivileges withTwitterAccess(Boolean twitterAccess) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.twitterAccess = twitterAccess;
        return _x;
    }

    @Property(name="WebAccess")
    @JsonIgnore
    public Optional<Boolean> getWebAccess() {
        return Optional.ofNullable(webAccess);
    }

    public ChannelAccessProfileWithPrivileges withWebAccess(Boolean webAccess) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.webAccess = webAccess;
        return _x;
    }

    @Property(name="ViewKnowledgeArticles")
    @JsonIgnore
    public Optional<Boolean> getViewKnowledgeArticles() {
        return Optional.ofNullable(viewKnowledgeArticles);
    }

    public ChannelAccessProfileWithPrivileges withViewKnowledgeArticles(Boolean viewKnowledgeArticles) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.viewKnowledgeArticles = viewKnowledgeArticles;
        return _x;
    }

    @Property(name="ViewArticleRating")
    @JsonIgnore
    public Optional<Boolean> getViewArticleRating() {
        return Optional.ofNullable(viewArticleRating);
    }

    public ChannelAccessProfileWithPrivileges withViewArticleRating(Boolean viewArticleRating) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.viewArticleRating = viewArticleRating;
        return _x;
    }

    @Property(name="RateKnowledgeArticles")
    @JsonIgnore
    public Optional<Boolean> getRateKnowledgeArticles() {
        return Optional.ofNullable(rateKnowledgeArticles);
    }

    public ChannelAccessProfileWithPrivileges withRateKnowledgeArticles(Boolean rateKnowledgeArticles) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.rateKnowledgeArticles = rateKnowledgeArticles;
        return _x;
    }

    @Property(name="SubmitFeedback")
    @JsonIgnore
    public Optional<Boolean> getSubmitFeedback() {
        return Optional.ofNullable(submitFeedback);
    }

    public ChannelAccessProfileWithPrivileges withSubmitFeedback(Boolean submitFeedback) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges");
        _x.submitFeedback = submitFeedback;
        return _x;
    }

    @Property(name="ChannelAccessProfilePrivilegeList")
    @JsonIgnore
    public CollectionPage<ChannelAccessProfilePrivilege> getChannelAccessProfilePrivilegeList() {
        return new CollectionPage<ChannelAccessProfilePrivilege>(contextPath, ChannelAccessProfilePrivilege.class, this.channelAccessProfilePrivilegeList, Optional.ofNullable(channelAccessProfilePrivilegeListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ChannelAccessProfilePrivilegeList")
    @JsonIgnore
    public CollectionPage<ChannelAccessProfilePrivilege> getChannelAccessProfilePrivilegeList(HttpRequestOptions options) {
        return new CollectionPage<ChannelAccessProfilePrivilege>(contextPath, ChannelAccessProfilePrivilege.class, this.channelAccessProfilePrivilegeList, Optional.ofNullable(channelAccessProfilePrivilegeListNextLink), Collections.emptyList(), options);
    }

    public ChannelAccessProfileWithPrivileges withUnmappedField(String name, Object value) {
        ChannelAccessProfileWithPrivileges _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean emailAccess;
        private Boolean facebookAccess;
        private Boolean phoneAccess;
        private Boolean twitterAccess;
        private Boolean webAccess;
        private Boolean viewKnowledgeArticles;
        private Boolean viewArticleRating;
        private Boolean rateKnowledgeArticles;
        private Boolean submitFeedback;
        private List<ChannelAccessProfilePrivilege> channelAccessProfilePrivilegeList;
        private String channelAccessProfilePrivilegeListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder emailAccess(Boolean emailAccess) {
            this.emailAccess = emailAccess;
            this.changedFields = changedFields.add("EmailAccess");
            return this;
        }

        public Builder facebookAccess(Boolean facebookAccess) {
            this.facebookAccess = facebookAccess;
            this.changedFields = changedFields.add("FacebookAccess");
            return this;
        }

        public Builder phoneAccess(Boolean phoneAccess) {
            this.phoneAccess = phoneAccess;
            this.changedFields = changedFields.add("PhoneAccess");
            return this;
        }

        public Builder twitterAccess(Boolean twitterAccess) {
            this.twitterAccess = twitterAccess;
            this.changedFields = changedFields.add("TwitterAccess");
            return this;
        }

        public Builder webAccess(Boolean webAccess) {
            this.webAccess = webAccess;
            this.changedFields = changedFields.add("WebAccess");
            return this;
        }

        public Builder viewKnowledgeArticles(Boolean viewKnowledgeArticles) {
            this.viewKnowledgeArticles = viewKnowledgeArticles;
            this.changedFields = changedFields.add("ViewKnowledgeArticles");
            return this;
        }

        public Builder viewArticleRating(Boolean viewArticleRating) {
            this.viewArticleRating = viewArticleRating;
            this.changedFields = changedFields.add("ViewArticleRating");
            return this;
        }

        public Builder rateKnowledgeArticles(Boolean rateKnowledgeArticles) {
            this.rateKnowledgeArticles = rateKnowledgeArticles;
            this.changedFields = changedFields.add("RateKnowledgeArticles");
            return this;
        }

        public Builder submitFeedback(Boolean submitFeedback) {
            this.submitFeedback = submitFeedback;
            this.changedFields = changedFields.add("SubmitFeedback");
            return this;
        }

        public Builder channelAccessProfilePrivilegeList(List<ChannelAccessProfilePrivilege> channelAccessProfilePrivilegeList) {
            this.channelAccessProfilePrivilegeList = channelAccessProfilePrivilegeList;
            this.changedFields = changedFields.add("ChannelAccessProfilePrivilegeList");
            return this;
        }

        public Builder channelAccessProfilePrivilegeList(ChannelAccessProfilePrivilege... channelAccessProfilePrivilegeList) {
            return channelAccessProfilePrivilegeList(Arrays.asList(channelAccessProfilePrivilegeList));
        }

        public Builder channelAccessProfilePrivilegeListNextLink(String channelAccessProfilePrivilegeListNextLink) {
            this.channelAccessProfilePrivilegeListNextLink = channelAccessProfilePrivilegeListNextLink;
            this.changedFields = changedFields.add("ChannelAccessProfilePrivilegeList");
            return this;
        }

        public ChannelAccessProfileWithPrivileges build() {
            ChannelAccessProfileWithPrivileges _x = new ChannelAccessProfileWithPrivileges();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ChannelAccessProfileWithPrivileges";
            _x.emailAccess = emailAccess;
            _x.facebookAccess = facebookAccess;
            _x.phoneAccess = phoneAccess;
            _x.twitterAccess = twitterAccess;
            _x.webAccess = webAccess;
            _x.viewKnowledgeArticles = viewKnowledgeArticles;
            _x.viewArticleRating = viewArticleRating;
            _x.rateKnowledgeArticles = rateKnowledgeArticles;
            _x.submitFeedback = submitFeedback;
            _x.channelAccessProfilePrivilegeList = channelAccessProfilePrivilegeList;
            _x.channelAccessProfilePrivilegeListNextLink = channelAccessProfilePrivilegeListNextLink;
            return _x;
        }
    }

    private ChannelAccessProfileWithPrivileges _copy() {
        ChannelAccessProfileWithPrivileges _x = new ChannelAccessProfileWithPrivileges();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.emailAccess = emailAccess;
        _x.facebookAccess = facebookAccess;
        _x.phoneAccess = phoneAccess;
        _x.twitterAccess = twitterAccess;
        _x.webAccess = webAccess;
        _x.viewKnowledgeArticles = viewKnowledgeArticles;
        _x.viewArticleRating = viewArticleRating;
        _x.rateKnowledgeArticles = rateKnowledgeArticles;
        _x.submitFeedback = submitFeedback;
        _x.channelAccessProfilePrivilegeList = channelAccessProfilePrivilegeList;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ChannelAccessProfileWithPrivileges[");
        b.append("EmailAccess=");
        b.append(this.emailAccess);
        b.append(", ");
        b.append("FacebookAccess=");
        b.append(this.facebookAccess);
        b.append(", ");
        b.append("PhoneAccess=");
        b.append(this.phoneAccess);
        b.append(", ");
        b.append("TwitterAccess=");
        b.append(this.twitterAccess);
        b.append(", ");
        b.append("WebAccess=");
        b.append(this.webAccess);
        b.append(", ");
        b.append("ViewKnowledgeArticles=");
        b.append(this.viewKnowledgeArticles);
        b.append(", ");
        b.append("ViewArticleRating=");
        b.append(this.viewArticleRating);
        b.append(", ");
        b.append("RateKnowledgeArticles=");
        b.append(this.rateKnowledgeArticles);
        b.append(", ");
        b.append("SubmitFeedback=");
        b.append(this.submitFeedback);
        b.append(", ");
        b.append("ChannelAccessProfilePrivilegeList=");
        b.append(this.channelAccessProfilePrivilegeList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
