package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "Value", 
    "CanBeChanged", 
    "ManagedPropertyLogicalName"})
@JsonInclude(Include.NON_NULL)
public class BooleanManagedProperty implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Value")
    protected Boolean value;

    @JsonProperty("CanBeChanged")
    protected Boolean canBeChanged;

    @JsonProperty("ManagedPropertyLogicalName")
    protected String managedPropertyLogicalName;

    protected BooleanManagedProperty() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BooleanManagedProperty";
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<Boolean> getValue() {
        return Optional.ofNullable(value);
    }

    public BooleanManagedProperty withValue(Boolean value) {
        BooleanManagedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BooleanManagedProperty");
        _x.value = value;
        return _x;
    }

    @Property(name="CanBeChanged")
    @JsonIgnore
    public Optional<Boolean> getCanBeChanged() {
        return Optional.ofNullable(canBeChanged);
    }

    public BooleanManagedProperty withCanBeChanged(Boolean canBeChanged) {
        BooleanManagedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BooleanManagedProperty");
        _x.canBeChanged = canBeChanged;
        return _x;
    }

    @Property(name="ManagedPropertyLogicalName")
    @JsonIgnore
    public Optional<String> getManagedPropertyLogicalName() {
        return Optional.ofNullable(managedPropertyLogicalName);
    }

    public BooleanManagedProperty withManagedPropertyLogicalName(String managedPropertyLogicalName) {
        BooleanManagedProperty _x = _copy();
        _x.odataType = Util.nvl(odataType, "Microsoft.Dynamics.CRM.BooleanManagedProperty");
        _x.managedPropertyLogicalName = managedPropertyLogicalName;
        return _x;
    }

    public BooleanManagedProperty withUnmappedField(String name, Object value) {
        BooleanManagedProperty _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Boolean value;
        private Boolean canBeChanged;
        private String managedPropertyLogicalName;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder value(Boolean value) {
            this.value = value;
            this.changedFields = changedFields.add("Value");
            return this;
        }

        public Builder canBeChanged(Boolean canBeChanged) {
            this.canBeChanged = canBeChanged;
            this.changedFields = changedFields.add("CanBeChanged");
            return this;
        }

        public Builder managedPropertyLogicalName(String managedPropertyLogicalName) {
            this.managedPropertyLogicalName = managedPropertyLogicalName;
            this.changedFields = changedFields.add("ManagedPropertyLogicalName");
            return this;
        }

        public BooleanManagedProperty build() {
            BooleanManagedProperty _x = new BooleanManagedProperty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BooleanManagedProperty";
            _x.value = value;
            _x.canBeChanged = canBeChanged;
            _x.managedPropertyLogicalName = managedPropertyLogicalName;
            return _x;
        }
    }

    private BooleanManagedProperty _copy() {
        BooleanManagedProperty _x = new BooleanManagedProperty();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.value = value;
        _x.canBeChanged = canBeChanged;
        _x.managedPropertyLogicalName = managedPropertyLogicalName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BooleanManagedProperty[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("CanBeChanged=");
        b.append(this.canBeChanged);
        b.append(", ");
        b.append("ManagedPropertyLogicalName=");
        b.append(this.managedPropertyLogicalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
