package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "HasAttachments"})
@JsonInclude(Include.NON_NULL)
public class BackgroundSendEmailResponse implements ODataType {

    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("HasAttachments")
    protected List<Boolean> hasAttachments;

    @JsonProperty("HasAttachments@nextLink")
    protected String hasAttachmentsNextLink;

    protected BackgroundSendEmailResponse() {
    }

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BackgroundSendEmailResponse";
    }

    @Property(name="HasAttachments")
    @JsonIgnore
    public CollectionPage<Boolean> getHasAttachments() {
        return new CollectionPage<Boolean>(contextPath, Boolean.class, this.hasAttachments, Optional.ofNullable(hasAttachmentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="HasAttachments")
    @JsonIgnore
    public CollectionPage<Boolean> getHasAttachments(HttpRequestOptions options) {
        return new CollectionPage<Boolean>(contextPath, Boolean.class, this.hasAttachments, Optional.ofNullable(hasAttachmentsNextLink), Collections.emptyList(), options);
    }

    public BackgroundSendEmailResponse withUnmappedField(String name, Object value) {
        BackgroundSendEmailResponse _x = _copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFieldsImpl();
        }
        unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return unmappedFields == null ? UnmappedFieldsImpl.EMPTY : unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return unmappedFields();
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Boolean> hasAttachments;
        private String hasAttachmentsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
            // prevent instantiation
        }

        public Builder hasAttachments(List<Boolean> hasAttachments) {
            this.hasAttachments = hasAttachments;
            this.changedFields = changedFields.add("HasAttachments");
            return this;
        }

        public Builder hasAttachments(Boolean... hasAttachments) {
            return hasAttachments(Arrays.asList(hasAttachments));
        }

        public Builder hasAttachmentsNextLink(String hasAttachmentsNextLink) {
            this.hasAttachmentsNextLink = hasAttachmentsNextLink;
            this.changedFields = changedFields.add("HasAttachments");
            return this;
        }

        public BackgroundSendEmailResponse build() {
            BackgroundSendEmailResponse _x = new BackgroundSendEmailResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BackgroundSendEmailResponse";
            _x.hasAttachments = hasAttachments;
            _x.hasAttachmentsNextLink = hasAttachmentsNextLink;
            return _x;
        }
    }

    private BackgroundSendEmailResponse _copy() {
        BackgroundSendEmailResponse _x = new BackgroundSendEmailResponse();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields.copy();
        _x.odataType = odataType;
        _x.hasAttachments = hasAttachments;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BackgroundSendEmailResponse[");
        b.append("HasAttachments=");
        b.append(this.hasAttachments);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
