/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.entity;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.entity.MetadataBase;
import microsoft.dynamics.crm.enums.EntityKeyIndexStatus;

@JsonPropertyOrder(value={"@odata.type", "DisplayName", "LogicalName", "SchemaName", "EntityLogicalName", "KeyAttributes", "IsCustomizable", "IsManaged", "IntroducedVersion", "EntityKeyIndexStatus", "AsyncJob", "IsSynchronous", "IsExportKey"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityKeyMetadata
extends MetadataBase
implements ODataEntityType {
    @JsonProperty(value="DisplayName")
    protected Label displayName;
    @JsonProperty(value="LogicalName")
    protected String logicalName;
    @JsonProperty(value="SchemaName")
    protected String schemaName;
    @JsonProperty(value="EntityLogicalName")
    protected String entityLogicalName;
    @JsonProperty(value="KeyAttributes")
    protected List<String> keyAttributes;
    @JsonProperty(value="KeyAttributes@nextLink")
    protected String keyAttributesNextLink;
    @JsonProperty(value="IsCustomizable")
    protected BooleanManagedProperty isCustomizable;
    @JsonProperty(value="IsManaged")
    protected Boolean isManaged;
    @JsonProperty(value="IntroducedVersion")
    protected String introducedVersion;
    @JsonProperty(value="EntityKeyIndexStatus")
    protected EntityKeyIndexStatus entityKeyIndexStatus;
    @JsonProperty(value="AsyncJob")
    protected UUID asyncJob;
    @JsonProperty(value="IsSynchronous")
    protected Boolean isSynchronous;
    @JsonProperty(value="IsExportKey")
    protected Boolean isExportKey;

    @Override
    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityKeyMetadata";
    }

    protected EntityKeyMetadata() {
    }

    public static Builder builderEntityKeyMetadata() {
        return new Builder();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return this.changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && this.metadataId != null) {
            this.contextPath = this.contextPath.clearQueries().addKeys(new NameValue[]{new NameValue((Object)this.metadataId, UUID.class)});
        }
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public EntityKeyMetadata withDisplayName(Label displayName) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("DisplayName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(this.logicalName);
    }

    public EntityKeyMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii((String)logicalName);
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("LogicalName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="SchemaName")
    @JsonIgnore
    public Optional<String> getSchemaName() {
        return Optional.ofNullable(this.schemaName);
    }

    public EntityKeyMetadata withSchemaName(String schemaName) {
        Checks.checkIsAscii((String)schemaName);
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("SchemaName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.schemaName = schemaName;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(this.entityLogicalName);
    }

    public EntityKeyMetadata withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii((String)entityLogicalName);
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("EntityLogicalName");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="KeyAttributes")
    @JsonIgnore
    public CollectionPage<String> getKeyAttributes() {
        return new CollectionPage(this.contextPath, String.class, this.keyAttributes, Optional.ofNullable(this.keyAttributesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    public EntityKeyMetadata withKeyAttributes(List<String> keyAttributes) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("KeyAttributes");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.keyAttributes = keyAttributes;
        return _x;
    }

    @Property(name="KeyAttributes")
    @JsonIgnore
    public CollectionPage<String> getKeyAttributes(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.keyAttributes, Optional.ofNullable(this.keyAttributesNextLink), Collections.emptyList(), options);
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(this.isCustomizable);
    }

    public EntityKeyMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IsCustomizable");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(this.isManaged);
    }

    public EntityKeyMetadata withIsManaged(Boolean isManaged) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IsManaged");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(this.introducedVersion);
    }

    public EntityKeyMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii((String)introducedVersion);
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IntroducedVersion");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="EntityKeyIndexStatus")
    @JsonIgnore
    public Optional<EntityKeyIndexStatus> getEntityKeyIndexStatus() {
        return Optional.ofNullable(this.entityKeyIndexStatus);
    }

    public EntityKeyMetadata withEntityKeyIndexStatus(EntityKeyIndexStatus entityKeyIndexStatus) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("EntityKeyIndexStatus");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.entityKeyIndexStatus = entityKeyIndexStatus;
        return _x;
    }

    @Property(name="AsyncJob")
    @JsonIgnore
    public Optional<UUID> getAsyncJob() {
        return Optional.ofNullable(this.asyncJob);
    }

    public EntityKeyMetadata withAsyncJob(UUID asyncJob) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("AsyncJob");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.asyncJob = asyncJob;
        return _x;
    }

    @Property(name="IsSynchronous")
    @JsonIgnore
    public Optional<Boolean> getIsSynchronous() {
        return Optional.ofNullable(this.isSynchronous);
    }

    public EntityKeyMetadata withIsSynchronous(Boolean isSynchronous) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IsSynchronous");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isSynchronous = isSynchronous;
        return _x;
    }

    @Property(name="IsExportKey")
    @JsonIgnore
    public Optional<Boolean> getIsExportKey() {
        return Optional.ofNullable(this.isExportKey);
    }

    public EntityKeyMetadata withIsExportKey(Boolean isExportKey) {
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = this.changedFields.add("IsExportKey");
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityKeyMetadata");
        _x.isExportKey = isExportKey;
        return _x;
    }

    @Override
    public EntityKeyMetadata withUnmappedField(String name, String value) {
        EntityKeyMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    @Override
    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    @Override
    public EntityKeyMetadata patch() {
        RequestHelper.patch((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    @Override
    public EntityKeyMetadata put() {
        RequestHelper.put((ODataEntityType)this, (ContextPath)this.contextPath, (RequestOptions)RequestOptions.EMPTY);
        EntityKeyMetadata _x = this._copy();
        _x.changedFields = null;
        return _x;
    }

    private EntityKeyMetadata _copy() {
        EntityKeyMetadata _x = new EntityKeyMetadata();
        _x.contextPath = this.contextPath;
        _x.changedFields = this.changedFields;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        _x.displayName = this.displayName;
        _x.logicalName = this.logicalName;
        _x.schemaName = this.schemaName;
        _x.entityLogicalName = this.entityLogicalName;
        _x.keyAttributes = this.keyAttributes;
        _x.isCustomizable = this.isCustomizable;
        _x.isManaged = this.isManaged;
        _x.introducedVersion = this.introducedVersion;
        _x.entityKeyIndexStatus = this.entityKeyIndexStatus;
        _x.asyncJob = this.asyncJob;
        _x.isSynchronous = this.isSynchronous;
        _x.isExportKey = this.isExportKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityKeyMetadata[");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("SchemaName=");
        b.append(this.schemaName);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("KeyAttributes=");
        b.append(this.keyAttributes);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("EntityKeyIndexStatus=");
        b.append((Object)this.entityKeyIndexStatus);
        b.append(", ");
        b.append("AsyncJob=");
        b.append(this.asyncJob);
        b.append(", ");
        b.append("IsSynchronous=");
        b.append(this.isSynchronous);
        b.append(", ");
        b.append("IsExportKey=");
        b.append(this.isExportKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private UUID metadataId;
        private Boolean hasChanged;
        private Label displayName;
        private String logicalName;
        private String schemaName;
        private String entityLogicalName;
        private List<String> keyAttributes;
        private String keyAttributesNextLink;
        private BooleanManagedProperty isCustomizable;
        private Boolean isManaged;
        private String introducedVersion;
        private EntityKeyIndexStatus entityKeyIndexStatus;
        private UUID asyncJob;
        private Boolean isSynchronous;
        private Boolean isExportKey;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = this.changedFields.add("LogicalName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.changedFields = this.changedFields.add("SchemaName");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = this.changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder keyAttributes(List<String> keyAttributes) {
            this.keyAttributes = keyAttributes;
            this.changedFields = this.changedFields.add("KeyAttributes");
            return this;
        }

        public Builder keyAttributes(String ... keyAttributes) {
            return this.keyAttributes(Arrays.asList(keyAttributes));
        }

        public Builder keyAttributesNextLink(String keyAttributesNextLink) {
            this.keyAttributesNextLink = keyAttributesNextLink;
            this.changedFields = this.changedFields.add("KeyAttributes");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = this.changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder entityKeyIndexStatus(EntityKeyIndexStatus entityKeyIndexStatus) {
            this.entityKeyIndexStatus = entityKeyIndexStatus;
            this.changedFields = this.changedFields.add("EntityKeyIndexStatus");
            return this;
        }

        public Builder asyncJob(UUID asyncJob) {
            this.asyncJob = asyncJob;
            this.changedFields = this.changedFields.add("AsyncJob");
            return this;
        }

        public Builder isSynchronous(Boolean isSynchronous) {
            this.isSynchronous = isSynchronous;
            this.changedFields = this.changedFields.add("IsSynchronous");
            return this;
        }

        public Builder isExportKey(Boolean isExportKey) {
            this.isExportKey = isExportKey;
            this.changedFields = this.changedFields.add("IsExportKey");
            return this;
        }

        public EntityKeyMetadata build() {
            EntityKeyMetadata _x = new EntityKeyMetadata();
            _x.contextPath = null;
            _x.changedFields = this.changedFields;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityKeyMetadata";
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            _x.displayName = this.displayName;
            _x.logicalName = this.logicalName;
            _x.schemaName = this.schemaName;
            _x.entityLogicalName = this.entityLogicalName;
            _x.keyAttributes = this.keyAttributes;
            _x.keyAttributesNextLink = this.keyAttributesNextLink;
            _x.isCustomizable = this.isCustomizable;
            _x.isManaged = this.isManaged;
            _x.introducedVersion = this.introducedVersion;
            _x.entityKeyIndexStatus = this.entityKeyIndexStatus;
            _x.asyncJob = this.asyncJob;
            _x.isSynchronous = this.isSynchronous;
            _x.isExportKey = this.isExportKey;
            return _x;
        }
    }
}

