/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "Path", "Name", "DisplayName", "WebResourceType", "Guid"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WebResourceInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Path")
    protected String path;
    @JsonProperty(value="Name")
    protected String name;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="WebResourceType")
    protected Integer webResourceType;
    @JsonProperty(value="Guid")
    protected String guid;

    protected WebResourceInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.WebResourceInfo";
    }

    @Property(name="Path")
    @JsonIgnore
    public Optional<String> getPath() {
        return Optional.ofNullable(this.path);
    }

    public WebResourceInfo withPath(String path) {
        Checks.checkIsAscii((String)path);
        WebResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.path = path;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public WebResourceInfo withName(String name) {
        Checks.checkIsAscii((String)name);
        WebResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.name = name;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public WebResourceInfo withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        WebResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="WebResourceType")
    @JsonIgnore
    public Optional<Integer> getWebResourceType() {
        return Optional.ofNullable(this.webResourceType);
    }

    public WebResourceInfo withWebResourceType(Integer webResourceType) {
        WebResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.webResourceType = webResourceType;
        return _x;
    }

    @Property(name="Guid")
    @JsonIgnore
    public Optional<String> getGuid() {
        return Optional.ofNullable(this.guid);
    }

    public WebResourceInfo withGuid(String guid) {
        Checks.checkIsAscii((String)guid);
        WebResourceInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.WebResourceInfo");
        _x.guid = guid;
        return _x;
    }

    public WebResourceInfo withUnmappedField(String name, String value) {
        WebResourceInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private WebResourceInfo _copy() {
        WebResourceInfo _x = new WebResourceInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.path = this.path;
        _x.name = this.name;
        _x.displayName = this.displayName;
        _x.webResourceType = this.webResourceType;
        _x.guid = this.guid;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("WebResourceInfo[");
        b.append("Path=");
        b.append(this.path);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("WebResourceType=");
        b.append(this.webResourceType);
        b.append(", ");
        b.append("Guid=");
        b.append(this.guid);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String path;
        private String name;
        private String displayName;
        private Integer webResourceType;
        private String guid;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder path(String path) {
            this.path = path;
            this.changedFields = this.changedFields.add("Path");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = this.changedFields.add("Name");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder webResourceType(Integer webResourceType) {
            this.webResourceType = webResourceType;
            this.changedFields = this.changedFields.add("WebResourceType");
            return this;
        }

        public Builder guid(String guid) {
            this.guid = guid;
            this.changedFields = this.changedFields.add("Guid");
            return this;
        }

        public WebResourceInfo build() {
            WebResourceInfo _x = new WebResourceInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.WebResourceInfo";
            _x.path = this.path;
            _x.name = this.name;
            _x.displayName = this.displayName;
            _x.webResourceType = this.webResourceType;
            _x.guid = this.guid;
            return _x;
        }
    }
}

