/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.SubscriptionData;

@JsonPropertyOrder(value={"@odata.type", "Data", "SyncToken", "IsFinalPage"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class SyncSubscriptionDataResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Data")
    protected SubscriptionData data;
    @JsonProperty(value="SyncToken")
    protected String syncToken;
    @JsonProperty(value="IsFinalPage")
    protected Boolean isFinalPage;

    protected SyncSubscriptionDataResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse";
    }

    @Property(name="Data")
    @JsonIgnore
    public Optional<SubscriptionData> getData() {
        return Optional.ofNullable(this.data);
    }

    public SyncSubscriptionDataResponse withData(SubscriptionData data) {
        SyncSubscriptionDataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse");
        _x.data = data;
        return _x;
    }

    @Property(name="SyncToken")
    @JsonIgnore
    public Optional<String> getSyncToken() {
        return Optional.ofNullable(this.syncToken);
    }

    public SyncSubscriptionDataResponse withSyncToken(String syncToken) {
        Checks.checkIsAscii((String)syncToken);
        SyncSubscriptionDataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse");
        _x.syncToken = syncToken;
        return _x;
    }

    @Property(name="IsFinalPage")
    @JsonIgnore
    public Optional<Boolean> getIsFinalPage() {
        return Optional.ofNullable(this.isFinalPage);
    }

    public SyncSubscriptionDataResponse withIsFinalPage(Boolean isFinalPage) {
        SyncSubscriptionDataResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse");
        _x.isFinalPage = isFinalPage;
        return _x;
    }

    public SyncSubscriptionDataResponse withUnmappedField(String name, String value) {
        SyncSubscriptionDataResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private SyncSubscriptionDataResponse _copy() {
        SyncSubscriptionDataResponse _x = new SyncSubscriptionDataResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.data = this.data;
        _x.syncToken = this.syncToken;
        _x.isFinalPage = this.isFinalPage;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SyncSubscriptionDataResponse[");
        b.append("Data=");
        b.append(this.data);
        b.append(", ");
        b.append("SyncToken=");
        b.append(this.syncToken);
        b.append(", ");
        b.append("IsFinalPage=");
        b.append(this.isFinalPage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private SubscriptionData data;
        private String syncToken;
        private Boolean isFinalPage;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder data(SubscriptionData data) {
            this.data = data;
            this.changedFields = this.changedFields.add("Data");
            return this;
        }

        public Builder syncToken(String syncToken) {
            this.syncToken = syncToken;
            this.changedFields = this.changedFields.add("SyncToken");
            return this;
        }

        public Builder isFinalPage(Boolean isFinalPage) {
            this.isFinalPage = isFinalPage;
            this.changedFields = this.changedFields.add("IsFinalPage");
            return this;
        }

        public SyncSubscriptionDataResponse build() {
            SyncSubscriptionDataResponse _x = new SyncSubscriptionDataResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.SyncSubscriptionDataResponse";
            _x.data = this.data;
            _x.syncToken = this.syncToken;
            _x.isFinalPage = this.isFinalPage;
            return _x;
        }
    }
}

