/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Solution;
import microsoft.dynamics.crm.enums.OrganizationType;

@JsonPropertyOrder(value={"@odata.type", "InstanceType", "Solutions"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrganizationInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="InstanceType")
    protected OrganizationType instanceType;
    @JsonProperty(value="Solutions")
    protected List<Solution> solutions;
    @JsonProperty(value="Solutions@nextLink")
    protected String solutionsNextLink;

    protected OrganizationInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrganizationInfo";
    }

    @Property(name="InstanceType")
    @JsonIgnore
    public Optional<OrganizationType> getInstanceType() {
        return Optional.ofNullable(this.instanceType);
    }

    public OrganizationInfo withInstanceType(OrganizationType instanceType) {
        OrganizationInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationInfo");
        _x.instanceType = instanceType;
        return _x;
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<Solution> getSolutions() {
        return new CollectionPage(this.contextPath, Solution.class, this.solutions, Optional.ofNullable(this.solutionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Solutions")
    @JsonIgnore
    public CollectionPage<Solution> getSolutions(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, Solution.class, this.solutions, Optional.ofNullable(this.solutionsNextLink), Collections.emptyList(), options);
    }

    public OrganizationInfo withUnmappedField(String name, String value) {
        OrganizationInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private OrganizationInfo _copy() {
        OrganizationInfo _x = new OrganizationInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.instanceType = this.instanceType;
        _x.solutions = this.solutions;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationInfo[");
        b.append("InstanceType=");
        b.append((Object)this.instanceType);
        b.append(", ");
        b.append("Solutions=");
        b.append(this.solutions);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private OrganizationType instanceType;
        private List<Solution> solutions;
        private String solutionsNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder instanceType(OrganizationType instanceType) {
            this.instanceType = instanceType;
            this.changedFields = this.changedFields.add("InstanceType");
            return this;
        }

        public Builder solutions(List<Solution> solutions) {
            this.solutions = solutions;
            this.changedFields = this.changedFields.add("Solutions");
            return this;
        }

        public Builder solutions(Solution ... solutions) {
            return this.solutions(Arrays.asList(solutions));
        }

        public Builder solutionsNextLink(String solutionsNextLink) {
            this.solutionsNextLink = solutionsNextLink;
            this.changedFields = this.changedFields.add("Solutions");
            return this;
        }

        public OrganizationInfo build() {
            OrganizationInfo _x = new OrganizationInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OrganizationInfo";
            _x.instanceType = this.instanceType;
            _x.solutions = this.solutions;
            _x.solutionsNextLink = this.solutionsNextLink;
            return _x;
        }
    }
}

