/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.complex.EndpointCollection;
import microsoft.dynamics.crm.enums.OrganizationState;

@JsonPropertyOrder(value={"@odata.type", "OrganizationId", "FriendlyName", "OrganizationVersion", "EnvironmentId", "Geo", "TenantId", "UrlName", "UniqueName", "Endpoints", "State"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class OrganizationDetail
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="OrganizationId")
    protected UUID organizationId;
    @JsonProperty(value="FriendlyName")
    protected String friendlyName;
    @JsonProperty(value="OrganizationVersion")
    protected String organizationVersion;
    @JsonProperty(value="EnvironmentId")
    protected String environmentId;
    @JsonProperty(value="Geo")
    protected String geo;
    @JsonProperty(value="TenantId")
    protected String tenantId;
    @JsonProperty(value="UrlName")
    protected String urlName;
    @JsonProperty(value="UniqueName")
    protected String uniqueName;
    @JsonProperty(value="Endpoints")
    protected EndpointCollection endpoints;
    @JsonProperty(value="State")
    protected OrganizationState state;

    protected OrganizationDetail() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.OrganizationDetail";
    }

    @Property(name="OrganizationId")
    @JsonIgnore
    public Optional<UUID> getOrganizationId() {
        return Optional.ofNullable(this.organizationId);
    }

    public OrganizationDetail withOrganizationId(UUID organizationId) {
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.organizationId = organizationId;
        return _x;
    }

    @Property(name="FriendlyName")
    @JsonIgnore
    public Optional<String> getFriendlyName() {
        return Optional.ofNullable(this.friendlyName);
    }

    public OrganizationDetail withFriendlyName(String friendlyName) {
        Checks.checkIsAscii((String)friendlyName);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.friendlyName = friendlyName;
        return _x;
    }

    @Property(name="OrganizationVersion")
    @JsonIgnore
    public Optional<String> getOrganizationVersion() {
        return Optional.ofNullable(this.organizationVersion);
    }

    public OrganizationDetail withOrganizationVersion(String organizationVersion) {
        Checks.checkIsAscii((String)organizationVersion);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.organizationVersion = organizationVersion;
        return _x;
    }

    @Property(name="EnvironmentId")
    @JsonIgnore
    public Optional<String> getEnvironmentId() {
        return Optional.ofNullable(this.environmentId);
    }

    public OrganizationDetail withEnvironmentId(String environmentId) {
        Checks.checkIsAscii((String)environmentId);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.environmentId = environmentId;
        return _x;
    }

    @Property(name="Geo")
    @JsonIgnore
    public Optional<String> getGeo() {
        return Optional.ofNullable(this.geo);
    }

    public OrganizationDetail withGeo(String geo) {
        Checks.checkIsAscii((String)geo);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.geo = geo;
        return _x;
    }

    @Property(name="TenantId")
    @JsonIgnore
    public Optional<String> getTenantId() {
        return Optional.ofNullable(this.tenantId);
    }

    public OrganizationDetail withTenantId(String tenantId) {
        Checks.checkIsAscii((String)tenantId);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.tenantId = tenantId;
        return _x;
    }

    @Property(name="UrlName")
    @JsonIgnore
    public Optional<String> getUrlName() {
        return Optional.ofNullable(this.urlName);
    }

    public OrganizationDetail withUrlName(String urlName) {
        Checks.checkIsAscii((String)urlName);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.urlName = urlName;
        return _x;
    }

    @Property(name="UniqueName")
    @JsonIgnore
    public Optional<String> getUniqueName() {
        return Optional.ofNullable(this.uniqueName);
    }

    public OrganizationDetail withUniqueName(String uniqueName) {
        Checks.checkIsAscii((String)uniqueName);
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.uniqueName = uniqueName;
        return _x;
    }

    @Property(name="Endpoints")
    @JsonIgnore
    public Optional<EndpointCollection> getEndpoints() {
        return Optional.ofNullable(this.endpoints);
    }

    public OrganizationDetail withEndpoints(EndpointCollection endpoints) {
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.endpoints = endpoints;
        return _x;
    }

    @Property(name="State")
    @JsonIgnore
    public Optional<OrganizationState> getState() {
        return Optional.ofNullable(this.state);
    }

    public OrganizationDetail withState(OrganizationState state) {
        OrganizationDetail _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.OrganizationDetail");
        _x.state = state;
        return _x;
    }

    public OrganizationDetail withUnmappedField(String name, String value) {
        OrganizationDetail _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private OrganizationDetail _copy() {
        OrganizationDetail _x = new OrganizationDetail();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.organizationId = this.organizationId;
        _x.friendlyName = this.friendlyName;
        _x.organizationVersion = this.organizationVersion;
        _x.environmentId = this.environmentId;
        _x.geo = this.geo;
        _x.tenantId = this.tenantId;
        _x.urlName = this.urlName;
        _x.uniqueName = this.uniqueName;
        _x.endpoints = this.endpoints;
        _x.state = this.state;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("OrganizationDetail[");
        b.append("OrganizationId=");
        b.append(this.organizationId);
        b.append(", ");
        b.append("FriendlyName=");
        b.append(this.friendlyName);
        b.append(", ");
        b.append("OrganizationVersion=");
        b.append(this.organizationVersion);
        b.append(", ");
        b.append("EnvironmentId=");
        b.append(this.environmentId);
        b.append(", ");
        b.append("Geo=");
        b.append(this.geo);
        b.append(", ");
        b.append("TenantId=");
        b.append(this.tenantId);
        b.append(", ");
        b.append("UrlName=");
        b.append(this.urlName);
        b.append(", ");
        b.append("UniqueName=");
        b.append(this.uniqueName);
        b.append(", ");
        b.append("Endpoints=");
        b.append(this.endpoints);
        b.append(", ");
        b.append("State=");
        b.append((Object)this.state);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private UUID organizationId;
        private String friendlyName;
        private String organizationVersion;
        private String environmentId;
        private String geo;
        private String tenantId;
        private String urlName;
        private String uniqueName;
        private EndpointCollection endpoints;
        private OrganizationState state;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder organizationId(UUID organizationId) {
            this.organizationId = organizationId;
            this.changedFields = this.changedFields.add("OrganizationId");
            return this;
        }

        public Builder friendlyName(String friendlyName) {
            this.friendlyName = friendlyName;
            this.changedFields = this.changedFields.add("FriendlyName");
            return this;
        }

        public Builder organizationVersion(String organizationVersion) {
            this.organizationVersion = organizationVersion;
            this.changedFields = this.changedFields.add("OrganizationVersion");
            return this;
        }

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            this.changedFields = this.changedFields.add("EnvironmentId");
            return this;
        }

        public Builder geo(String geo) {
            this.geo = geo;
            this.changedFields = this.changedFields.add("Geo");
            return this;
        }

        public Builder tenantId(String tenantId) {
            this.tenantId = tenantId;
            this.changedFields = this.changedFields.add("TenantId");
            return this;
        }

        public Builder urlName(String urlName) {
            this.urlName = urlName;
            this.changedFields = this.changedFields.add("UrlName");
            return this;
        }

        public Builder uniqueName(String uniqueName) {
            this.uniqueName = uniqueName;
            this.changedFields = this.changedFields.add("UniqueName");
            return this;
        }

        public Builder endpoints(EndpointCollection endpoints) {
            this.endpoints = endpoints;
            this.changedFields = this.changedFields.add("Endpoints");
            return this;
        }

        public Builder state(OrganizationState state) {
            this.state = state;
            this.changedFields = this.changedFields.add("State");
            return this;
        }

        public OrganizationDetail build() {
            OrganizationDetail _x = new OrganizationDetail();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.OrganizationDetail";
            _x.organizationId = this.organizationId;
            _x.friendlyName = this.friendlyName;
            _x.organizationVersion = this.organizationVersion;
            _x.environmentId = this.environmentId;
            _x.geo = this.geo;
            _x.tenantId = this.tenantId;
            _x.urlName = this.urlName;
            _x.uniqueName = this.uniqueName;
            _x.endpoints = this.endpoints;
            _x.state = this.state;
            return _x;
        }
    }
}

