/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder(value={"@odata.type", "Label", "LanguageCode", "IsManaged", "MetadataId", "HasChanged"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LocalizedLabel
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Label")
    protected String label;
    @JsonProperty(value="LanguageCode")
    protected Integer languageCode;
    @JsonProperty(value="IsManaged")
    protected Boolean isManaged;
    @JsonProperty(value="MetadataId")
    protected UUID metadataId;
    @JsonProperty(value="HasChanged")
    protected Boolean hasChanged;

    protected LocalizedLabel() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LocalizedLabel";
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<String> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public LocalizedLabel withLabel(String label) {
        Checks.checkIsAscii((String)label);
        LocalizedLabel _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.label = label;
        return _x;
    }

    @Property(name="LanguageCode")
    @JsonIgnore
    public Optional<Integer> getLanguageCode() {
        return Optional.ofNullable(this.languageCode);
    }

    public LocalizedLabel withLanguageCode(Integer languageCode) {
        LocalizedLabel _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.languageCode = languageCode;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(this.isManaged);
    }

    public LocalizedLabel withIsManaged(Boolean isManaged) {
        LocalizedLabel _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<UUID> getMetadataId() {
        return Optional.ofNullable(this.metadataId);
    }

    public LocalizedLabel withMetadataId(UUID metadataId) {
        LocalizedLabel _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(this.hasChanged);
    }

    public LocalizedLabel withHasChanged(Boolean hasChanged) {
        LocalizedLabel _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LocalizedLabel");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public LocalizedLabel withUnmappedField(String name, String value) {
        LocalizedLabel _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LocalizedLabel _copy() {
        LocalizedLabel _x = new LocalizedLabel();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.label = this.label;
        _x.languageCode = this.languageCode;
        _x.isManaged = this.isManaged;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LocalizedLabel[");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("LanguageCode=");
        b.append(this.languageCode);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String label;
        private Integer languageCode;
        private Boolean isManaged;
        private UUID metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder label(String label) {
            this.label = label;
            this.changedFields = this.changedFields.add("Label");
            return this;
        }

        public Builder languageCode(Integer languageCode) {
            this.languageCode = languageCode;
            this.changedFields = this.changedFields.add("LanguageCode");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder metadataId(UUID metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public LocalizedLabel build() {
            LocalizedLabel _x = new LocalizedLabel();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LocalizedLabel";
            _x.label = this.label;
            _x.languageCode = this.languageCode;
            _x.isManaged = this.isManaged;
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            return _x;
        }
    }
}

