/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.math.BigDecimal;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "originalText", "textScore"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExtractTextEntitiesResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="originalText")
    protected String originalText;
    @JsonProperty(value="textScore")
    protected BigDecimal textScore;

    protected ExtractTextEntitiesResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse";
    }

    @Property(name="originalText")
    @JsonIgnore
    public Optional<String> getOriginalText() {
        return Optional.ofNullable(this.originalText);
    }

    public ExtractTextEntitiesResponse withOriginalText(String originalText) {
        Checks.checkIsAscii((String)originalText);
        ExtractTextEntitiesResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse");
        _x.originalText = originalText;
        return _x;
    }

    @Property(name="textScore")
    @JsonIgnore
    public Optional<BigDecimal> getTextScore() {
        return Optional.ofNullable(this.textScore);
    }

    public ExtractTextEntitiesResponse withTextScore(BigDecimal textScore) {
        ExtractTextEntitiesResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse");
        _x.textScore = textScore;
        return _x;
    }

    public ExtractTextEntitiesResponse withUnmappedField(String name, String value) {
        ExtractTextEntitiesResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ExtractTextEntitiesResponse _copy() {
        ExtractTextEntitiesResponse _x = new ExtractTextEntitiesResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.originalText = this.originalText;
        _x.textScore = this.textScore;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ExtractTextEntitiesResponse[");
        b.append("originalText=");
        b.append(this.originalText);
        b.append(", ");
        b.append("textScore=");
        b.append(this.textScore);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String originalText;
        private BigDecimal textScore;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder originalText(String originalText) {
            this.originalText = originalText;
            this.changedFields = this.changedFields.add("originalText");
            return this;
        }

        public Builder textScore(BigDecimal textScore) {
            this.textScore = textScore;
            this.changedFields = this.changedFields.add("textScore");
            return this;
        }

        public ExtractTextEntitiesResponse build() {
            ExtractTextEntitiesResponse _x = new ExtractTextEntitiesResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ExtractTextEntitiesResponse";
            _x.originalText = this.originalText;
            _x.textScore = this.textScore;
            return _x;
        }
    }
}

