/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.math.BigDecimal;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "language", "score"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DetectLanguageResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="language")
    protected String language;
    @JsonProperty(value="score")
    protected BigDecimal score;

    protected DetectLanguageResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DetectLanguageResponse";
    }

    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(this.language);
    }

    public DetectLanguageResponse withLanguage(String language) {
        Checks.checkIsAscii((String)language);
        DetectLanguageResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DetectLanguageResponse");
        _x.language = language;
        return _x;
    }

    @Property(name="score")
    @JsonIgnore
    public Optional<BigDecimal> getScore() {
        return Optional.ofNullable(this.score);
    }

    public DetectLanguageResponse withScore(BigDecimal score) {
        DetectLanguageResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DetectLanguageResponse");
        _x.score = score;
        return _x;
    }

    public DetectLanguageResponse withUnmappedField(String name, String value) {
        DetectLanguageResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private DetectLanguageResponse _copy() {
        DetectLanguageResponse _x = new DetectLanguageResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.language = this.language;
        _x.score = this.score;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DetectLanguageResponse[");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("score=");
        b.append(this.score);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String language;
        private BigDecimal score;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = this.changedFields.add("language");
            return this;
        }

        public Builder score(BigDecimal score) {
            this.score = score;
            this.changedFields = this.changedFields.add("score");
            return this;
        }

        public DetectLanguageResponse build() {
            DetectLanguageResponse _x = new DetectLanguageResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DetectLanguageResponse";
            _x.language = this.language;
            _x.score = this.score;
            return _x;
        }
    }
}

