/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder(value={"@odata.type", "RelationshipIds", "AttributeId"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CreateCustomerRelationshipsResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="RelationshipIds")
    protected List<UUID> relationshipIds;
    @JsonProperty(value="RelationshipIds@nextLink")
    protected String relationshipIdsNextLink;
    @JsonProperty(value="AttributeId")
    protected UUID attributeId;

    protected CreateCustomerRelationshipsResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.CreateCustomerRelationshipsResponse";
    }

    @Property(name="RelationshipIds")
    @JsonIgnore
    public CollectionPage<UUID> getRelationshipIds() {
        return new CollectionPage(this.contextPath, UUID.class, this.relationshipIds, Optional.ofNullable(this.relationshipIdsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RelationshipIds")
    @JsonIgnore
    public CollectionPage<UUID> getRelationshipIds(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, UUID.class, this.relationshipIds, Optional.ofNullable(this.relationshipIdsNextLink), Collections.emptyList(), options);
    }

    @Property(name="AttributeId")
    @JsonIgnore
    public Optional<UUID> getAttributeId() {
        return Optional.ofNullable(this.attributeId);
    }

    public CreateCustomerRelationshipsResponse withAttributeId(UUID attributeId) {
        CreateCustomerRelationshipsResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.CreateCustomerRelationshipsResponse");
        _x.attributeId = attributeId;
        return _x;
    }

    public CreateCustomerRelationshipsResponse withUnmappedField(String name, String value) {
        CreateCustomerRelationshipsResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private CreateCustomerRelationshipsResponse _copy() {
        CreateCustomerRelationshipsResponse _x = new CreateCustomerRelationshipsResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.relationshipIds = this.relationshipIds;
        _x.attributeId = this.attributeId;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("CreateCustomerRelationshipsResponse[");
        b.append("RelationshipIds=");
        b.append(this.relationshipIds);
        b.append(", ");
        b.append("AttributeId=");
        b.append(this.attributeId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<UUID> relationshipIds;
        private String relationshipIdsNextLink;
        private UUID attributeId;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder relationshipIds(List<UUID> relationshipIds) {
            this.relationshipIds = relationshipIds;
            this.changedFields = this.changedFields.add("RelationshipIds");
            return this;
        }

        public Builder relationshipIds(UUID ... relationshipIds) {
            return this.relationshipIds(Arrays.asList(relationshipIds));
        }

        public Builder relationshipIdsNextLink(String relationshipIdsNextLink) {
            this.relationshipIdsNextLink = relationshipIdsNextLink;
            this.changedFields = this.changedFields.add("RelationshipIds");
            return this;
        }

        public Builder attributeId(UUID attributeId) {
            this.attributeId = attributeId;
            this.changedFields = this.changedFields.add("AttributeId");
            return this;
        }

        public CreateCustomerRelationshipsResponse build() {
            CreateCustomerRelationshipsResponse _x = new CreateCustomerRelationshipsResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.CreateCustomerRelationshipsResponse";
            _x.relationshipIds = this.relationshipIds;
            _x.relationshipIdsNextLink = this.relationshipIdsNextLink;
            _x.attributeId = this.attributeId;
            return _x;
        }
    }
}

