/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.BusinessNotification;
import microsoft.dynamics.crm.complex.ValidationResult;

@JsonPropertyOrder(value={"@odata.type", "Notifications", "ValidationResult"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BookResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Notifications")
    protected List<BusinessNotification> notifications;
    @JsonProperty(value="Notifications@nextLink")
    protected String notificationsNextLink;
    @JsonProperty(value="ValidationResult")
    protected ValidationResult validationResult;

    protected BookResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BookResponse";
    }

    @Property(name="Notifications")
    @JsonIgnore
    public CollectionPage<BusinessNotification> getNotifications() {
        return new CollectionPage(this.contextPath, BusinessNotification.class, this.notifications, Optional.ofNullable(this.notificationsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Notifications")
    @JsonIgnore
    public CollectionPage<BusinessNotification> getNotifications(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, BusinessNotification.class, this.notifications, Optional.ofNullable(this.notificationsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ValidationResult")
    @JsonIgnore
    public Optional<ValidationResult> getValidationResult() {
        return Optional.ofNullable(this.validationResult);
    }

    public BookResponse withValidationResult(ValidationResult validationResult) {
        BookResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BookResponse");
        _x.validationResult = validationResult;
        return _x;
    }

    public BookResponse withUnmappedField(String name, String value) {
        BookResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private BookResponse _copy() {
        BookResponse _x = new BookResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.notifications = this.notifications;
        _x.validationResult = this.validationResult;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BookResponse[");
        b.append("Notifications=");
        b.append(this.notifications);
        b.append(", ");
        b.append("ValidationResult=");
        b.append(this.validationResult);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<BusinessNotification> notifications;
        private String notificationsNextLink;
        private ValidationResult validationResult;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder notifications(List<BusinessNotification> notifications) {
            this.notifications = notifications;
            this.changedFields = this.changedFields.add("Notifications");
            return this;
        }

        public Builder notifications(BusinessNotification ... notifications) {
            return this.notifications(Arrays.asList(notifications));
        }

        public Builder notificationsNextLink(String notificationsNextLink) {
            this.notificationsNextLink = notificationsNextLink;
            this.changedFields = this.changedFields.add("Notifications");
            return this;
        }

        public Builder validationResult(ValidationResult validationResult) {
            this.validationResult = validationResult;
            this.changedFields = this.changedFields.add("ValidationResult");
            return this;
        }

        public BookResponse build() {
            BookResponse _x = new BookResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BookResponse";
            _x.notifications = this.notifications;
            _x.notificationsNextLink = this.notificationsNextLink;
            _x.validationResult = this.validationResult;
            return _x;
        }
    }
}

