/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.complex.AppointmentsToIgnore;
import microsoft.dynamics.crm.complex.ConstraintRelation;
import microsoft.dynamics.crm.complex.ObjectiveRelation;
import microsoft.dynamics.crm.complex.RequiredResource;
import microsoft.dynamics.crm.enums.SearchDirection;

@JsonPropertyOrder(value={"@odata.type", "ServiceId", "AnchorOffset", "UserTimeZoneCode", "RecurrenceDuration", "RecurrenceTimeZoneCode", "AppointmentsToIgnore", "RequiredResources", "SearchWindowStart", "SearchWindowEnd", "SearchRecurrenceStart", "SearchRecurrenceRule", "Duration", "Constraints", "Objectives", "Direction", "NumberOfResults", "Sites"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppointmentRequest
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ServiceId")
    protected UUID serviceId;
    @JsonProperty(value="AnchorOffset")
    protected Integer anchorOffset;
    @JsonProperty(value="UserTimeZoneCode")
    protected Integer userTimeZoneCode;
    @JsonProperty(value="RecurrenceDuration")
    protected Integer recurrenceDuration;
    @JsonProperty(value="RecurrenceTimeZoneCode")
    protected Integer recurrenceTimeZoneCode;
    @JsonProperty(value="AppointmentsToIgnore")
    protected List<AppointmentsToIgnore> appointmentsToIgnore;
    @JsonProperty(value="AppointmentsToIgnore@nextLink")
    protected String appointmentsToIgnoreNextLink;
    @JsonProperty(value="RequiredResources")
    protected List<RequiredResource> requiredResources;
    @JsonProperty(value="RequiredResources@nextLink")
    protected String requiredResourcesNextLink;
    @JsonProperty(value="SearchWindowStart")
    protected OffsetDateTime searchWindowStart;
    @JsonProperty(value="SearchWindowEnd")
    protected OffsetDateTime searchWindowEnd;
    @JsonProperty(value="SearchRecurrenceStart")
    protected OffsetDateTime searchRecurrenceStart;
    @JsonProperty(value="SearchRecurrenceRule")
    protected String searchRecurrenceRule;
    @JsonProperty(value="Duration")
    protected Integer duration;
    @JsonProperty(value="Constraints")
    protected List<ConstraintRelation> constraints;
    @JsonProperty(value="Constraints@nextLink")
    protected String constraintsNextLink;
    @JsonProperty(value="Objectives")
    protected List<ObjectiveRelation> objectives;
    @JsonProperty(value="Objectives@nextLink")
    protected String objectivesNextLink;
    @JsonProperty(value="Direction")
    protected SearchDirection direction;
    @JsonProperty(value="NumberOfResults")
    protected Integer numberOfResults;
    @JsonProperty(value="Sites")
    protected List<UUID> sites;
    @JsonProperty(value="Sites@nextLink")
    protected String sitesNextLink;

    protected AppointmentRequest() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppointmentRequest";
    }

    @Property(name="ServiceId")
    @JsonIgnore
    public Optional<UUID> getServiceId() {
        return Optional.ofNullable(this.serviceId);
    }

    public AppointmentRequest withServiceId(UUID serviceId) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.serviceId = serviceId;
        return _x;
    }

    @Property(name="AnchorOffset")
    @JsonIgnore
    public Optional<Integer> getAnchorOffset() {
        return Optional.ofNullable(this.anchorOffset);
    }

    public AppointmentRequest withAnchorOffset(Integer anchorOffset) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.anchorOffset = anchorOffset;
        return _x;
    }

    @Property(name="UserTimeZoneCode")
    @JsonIgnore
    public Optional<Integer> getUserTimeZoneCode() {
        return Optional.ofNullable(this.userTimeZoneCode);
    }

    public AppointmentRequest withUserTimeZoneCode(Integer userTimeZoneCode) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.userTimeZoneCode = userTimeZoneCode;
        return _x;
    }

    @Property(name="RecurrenceDuration")
    @JsonIgnore
    public Optional<Integer> getRecurrenceDuration() {
        return Optional.ofNullable(this.recurrenceDuration);
    }

    public AppointmentRequest withRecurrenceDuration(Integer recurrenceDuration) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.recurrenceDuration = recurrenceDuration;
        return _x;
    }

    @Property(name="RecurrenceTimeZoneCode")
    @JsonIgnore
    public Optional<Integer> getRecurrenceTimeZoneCode() {
        return Optional.ofNullable(this.recurrenceTimeZoneCode);
    }

    public AppointmentRequest withRecurrenceTimeZoneCode(Integer recurrenceTimeZoneCode) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.recurrenceTimeZoneCode = recurrenceTimeZoneCode;
        return _x;
    }

    @Property(name="AppointmentsToIgnore")
    @JsonIgnore
    public CollectionPage<AppointmentsToIgnore> getAppointmentsToIgnore() {
        return new CollectionPage(this.contextPath, AppointmentsToIgnore.class, this.appointmentsToIgnore, Optional.ofNullable(this.appointmentsToIgnoreNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AppointmentsToIgnore")
    @JsonIgnore
    public CollectionPage<AppointmentsToIgnore> getAppointmentsToIgnore(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, AppointmentsToIgnore.class, this.appointmentsToIgnore, Optional.ofNullable(this.appointmentsToIgnoreNextLink), Collections.emptyList(), options);
    }

    @Property(name="RequiredResources")
    @JsonIgnore
    public CollectionPage<RequiredResource> getRequiredResources() {
        return new CollectionPage(this.contextPath, RequiredResource.class, this.requiredResources, Optional.ofNullable(this.requiredResourcesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RequiredResources")
    @JsonIgnore
    public CollectionPage<RequiredResource> getRequiredResources(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, RequiredResource.class, this.requiredResources, Optional.ofNullable(this.requiredResourcesNextLink), Collections.emptyList(), options);
    }

    @Property(name="SearchWindowStart")
    @JsonIgnore
    public Optional<OffsetDateTime> getSearchWindowStart() {
        return Optional.ofNullable(this.searchWindowStart);
    }

    public AppointmentRequest withSearchWindowStart(OffsetDateTime searchWindowStart) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.searchWindowStart = searchWindowStart;
        return _x;
    }

    @Property(name="SearchWindowEnd")
    @JsonIgnore
    public Optional<OffsetDateTime> getSearchWindowEnd() {
        return Optional.ofNullable(this.searchWindowEnd);
    }

    public AppointmentRequest withSearchWindowEnd(OffsetDateTime searchWindowEnd) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.searchWindowEnd = searchWindowEnd;
        return _x;
    }

    @Property(name="SearchRecurrenceStart")
    @JsonIgnore
    public Optional<OffsetDateTime> getSearchRecurrenceStart() {
        return Optional.ofNullable(this.searchRecurrenceStart);
    }

    public AppointmentRequest withSearchRecurrenceStart(OffsetDateTime searchRecurrenceStart) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.searchRecurrenceStart = searchRecurrenceStart;
        return _x;
    }

    @Property(name="SearchRecurrenceRule")
    @JsonIgnore
    public Optional<String> getSearchRecurrenceRule() {
        return Optional.ofNullable(this.searchRecurrenceRule);
    }

    public AppointmentRequest withSearchRecurrenceRule(String searchRecurrenceRule) {
        Checks.checkIsAscii((String)searchRecurrenceRule);
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.searchRecurrenceRule = searchRecurrenceRule;
        return _x;
    }

    @Property(name="Duration")
    @JsonIgnore
    public Optional<Integer> getDuration() {
        return Optional.ofNullable(this.duration);
    }

    public AppointmentRequest withDuration(Integer duration) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.duration = duration;
        return _x;
    }

    @Property(name="Constraints")
    @JsonIgnore
    public CollectionPage<ConstraintRelation> getConstraints() {
        return new CollectionPage(this.contextPath, ConstraintRelation.class, this.constraints, Optional.ofNullable(this.constraintsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Constraints")
    @JsonIgnore
    public CollectionPage<ConstraintRelation> getConstraints(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ConstraintRelation.class, this.constraints, Optional.ofNullable(this.constraintsNextLink), Collections.emptyList(), options);
    }

    @Property(name="Objectives")
    @JsonIgnore
    public CollectionPage<ObjectiveRelation> getObjectives() {
        return new CollectionPage(this.contextPath, ObjectiveRelation.class, this.objectives, Optional.ofNullable(this.objectivesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Objectives")
    @JsonIgnore
    public CollectionPage<ObjectiveRelation> getObjectives(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ObjectiveRelation.class, this.objectives, Optional.ofNullable(this.objectivesNextLink), Collections.emptyList(), options);
    }

    @Property(name="Direction")
    @JsonIgnore
    public Optional<SearchDirection> getDirection() {
        return Optional.ofNullable(this.direction);
    }

    public AppointmentRequest withDirection(SearchDirection direction) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.direction = direction;
        return _x;
    }

    @Property(name="NumberOfResults")
    @JsonIgnore
    public Optional<Integer> getNumberOfResults() {
        return Optional.ofNullable(this.numberOfResults);
    }

    public AppointmentRequest withNumberOfResults(Integer numberOfResults) {
        AppointmentRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppointmentRequest");
        _x.numberOfResults = numberOfResults;
        return _x;
    }

    @Property(name="Sites")
    @JsonIgnore
    public CollectionPage<UUID> getSites() {
        return new CollectionPage(this.contextPath, UUID.class, this.sites, Optional.ofNullable(this.sitesNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Sites")
    @JsonIgnore
    public CollectionPage<UUID> getSites(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, UUID.class, this.sites, Optional.ofNullable(this.sitesNextLink), Collections.emptyList(), options);
    }

    public AppointmentRequest withUnmappedField(String name, String value) {
        AppointmentRequest _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppointmentRequest _copy() {
        AppointmentRequest _x = new AppointmentRequest();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.serviceId = this.serviceId;
        _x.anchorOffset = this.anchorOffset;
        _x.userTimeZoneCode = this.userTimeZoneCode;
        _x.recurrenceDuration = this.recurrenceDuration;
        _x.recurrenceTimeZoneCode = this.recurrenceTimeZoneCode;
        _x.appointmentsToIgnore = this.appointmentsToIgnore;
        _x.requiredResources = this.requiredResources;
        _x.searchWindowStart = this.searchWindowStart;
        _x.searchWindowEnd = this.searchWindowEnd;
        _x.searchRecurrenceStart = this.searchRecurrenceStart;
        _x.searchRecurrenceRule = this.searchRecurrenceRule;
        _x.duration = this.duration;
        _x.constraints = this.constraints;
        _x.objectives = this.objectives;
        _x.direction = this.direction;
        _x.numberOfResults = this.numberOfResults;
        _x.sites = this.sites;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppointmentRequest[");
        b.append("ServiceId=");
        b.append(this.serviceId);
        b.append(", ");
        b.append("AnchorOffset=");
        b.append(this.anchorOffset);
        b.append(", ");
        b.append("UserTimeZoneCode=");
        b.append(this.userTimeZoneCode);
        b.append(", ");
        b.append("RecurrenceDuration=");
        b.append(this.recurrenceDuration);
        b.append(", ");
        b.append("RecurrenceTimeZoneCode=");
        b.append(this.recurrenceTimeZoneCode);
        b.append(", ");
        b.append("AppointmentsToIgnore=");
        b.append(this.appointmentsToIgnore);
        b.append(", ");
        b.append("RequiredResources=");
        b.append(this.requiredResources);
        b.append(", ");
        b.append("SearchWindowStart=");
        b.append(this.searchWindowStart);
        b.append(", ");
        b.append("SearchWindowEnd=");
        b.append(this.searchWindowEnd);
        b.append(", ");
        b.append("SearchRecurrenceStart=");
        b.append(this.searchRecurrenceStart);
        b.append(", ");
        b.append("SearchRecurrenceRule=");
        b.append(this.searchRecurrenceRule);
        b.append(", ");
        b.append("Duration=");
        b.append(this.duration);
        b.append(", ");
        b.append("Constraints=");
        b.append(this.constraints);
        b.append(", ");
        b.append("Objectives=");
        b.append(this.objectives);
        b.append(", ");
        b.append("Direction=");
        b.append((Object)this.direction);
        b.append(", ");
        b.append("NumberOfResults=");
        b.append(this.numberOfResults);
        b.append(", ");
        b.append("Sites=");
        b.append(this.sites);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private UUID serviceId;
        private Integer anchorOffset;
        private Integer userTimeZoneCode;
        private Integer recurrenceDuration;
        private Integer recurrenceTimeZoneCode;
        private List<AppointmentsToIgnore> appointmentsToIgnore;
        private String appointmentsToIgnoreNextLink;
        private List<RequiredResource> requiredResources;
        private String requiredResourcesNextLink;
        private OffsetDateTime searchWindowStart;
        private OffsetDateTime searchWindowEnd;
        private OffsetDateTime searchRecurrenceStart;
        private String searchRecurrenceRule;
        private Integer duration;
        private List<ConstraintRelation> constraints;
        private String constraintsNextLink;
        private List<ObjectiveRelation> objectives;
        private String objectivesNextLink;
        private SearchDirection direction;
        private Integer numberOfResults;
        private List<UUID> sites;
        private String sitesNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder serviceId(UUID serviceId) {
            this.serviceId = serviceId;
            this.changedFields = this.changedFields.add("ServiceId");
            return this;
        }

        public Builder anchorOffset(Integer anchorOffset) {
            this.anchorOffset = anchorOffset;
            this.changedFields = this.changedFields.add("AnchorOffset");
            return this;
        }

        public Builder userTimeZoneCode(Integer userTimeZoneCode) {
            this.userTimeZoneCode = userTimeZoneCode;
            this.changedFields = this.changedFields.add("UserTimeZoneCode");
            return this;
        }

        public Builder recurrenceDuration(Integer recurrenceDuration) {
            this.recurrenceDuration = recurrenceDuration;
            this.changedFields = this.changedFields.add("RecurrenceDuration");
            return this;
        }

        public Builder recurrenceTimeZoneCode(Integer recurrenceTimeZoneCode) {
            this.recurrenceTimeZoneCode = recurrenceTimeZoneCode;
            this.changedFields = this.changedFields.add("RecurrenceTimeZoneCode");
            return this;
        }

        public Builder appointmentsToIgnore(List<AppointmentsToIgnore> appointmentsToIgnore) {
            this.appointmentsToIgnore = appointmentsToIgnore;
            this.changedFields = this.changedFields.add("AppointmentsToIgnore");
            return this;
        }

        public Builder appointmentsToIgnore(AppointmentsToIgnore ... appointmentsToIgnore) {
            return this.appointmentsToIgnore(Arrays.asList(appointmentsToIgnore));
        }

        public Builder appointmentsToIgnoreNextLink(String appointmentsToIgnoreNextLink) {
            this.appointmentsToIgnoreNextLink = appointmentsToIgnoreNextLink;
            this.changedFields = this.changedFields.add("AppointmentsToIgnore");
            return this;
        }

        public Builder requiredResources(List<RequiredResource> requiredResources) {
            this.requiredResources = requiredResources;
            this.changedFields = this.changedFields.add("RequiredResources");
            return this;
        }

        public Builder requiredResources(RequiredResource ... requiredResources) {
            return this.requiredResources(Arrays.asList(requiredResources));
        }

        public Builder requiredResourcesNextLink(String requiredResourcesNextLink) {
            this.requiredResourcesNextLink = requiredResourcesNextLink;
            this.changedFields = this.changedFields.add("RequiredResources");
            return this;
        }

        public Builder searchWindowStart(OffsetDateTime searchWindowStart) {
            this.searchWindowStart = searchWindowStart;
            this.changedFields = this.changedFields.add("SearchWindowStart");
            return this;
        }

        public Builder searchWindowEnd(OffsetDateTime searchWindowEnd) {
            this.searchWindowEnd = searchWindowEnd;
            this.changedFields = this.changedFields.add("SearchWindowEnd");
            return this;
        }

        public Builder searchRecurrenceStart(OffsetDateTime searchRecurrenceStart) {
            this.searchRecurrenceStart = searchRecurrenceStart;
            this.changedFields = this.changedFields.add("SearchRecurrenceStart");
            return this;
        }

        public Builder searchRecurrenceRule(String searchRecurrenceRule) {
            this.searchRecurrenceRule = searchRecurrenceRule;
            this.changedFields = this.changedFields.add("SearchRecurrenceRule");
            return this;
        }

        public Builder duration(Integer duration) {
            this.duration = duration;
            this.changedFields = this.changedFields.add("Duration");
            return this;
        }

        public Builder constraints(List<ConstraintRelation> constraints) {
            this.constraints = constraints;
            this.changedFields = this.changedFields.add("Constraints");
            return this;
        }

        public Builder constraints(ConstraintRelation ... constraints) {
            return this.constraints(Arrays.asList(constraints));
        }

        public Builder constraintsNextLink(String constraintsNextLink) {
            this.constraintsNextLink = constraintsNextLink;
            this.changedFields = this.changedFields.add("Constraints");
            return this;
        }

        public Builder objectives(List<ObjectiveRelation> objectives) {
            this.objectives = objectives;
            this.changedFields = this.changedFields.add("Objectives");
            return this;
        }

        public Builder objectives(ObjectiveRelation ... objectives) {
            return this.objectives(Arrays.asList(objectives));
        }

        public Builder objectivesNextLink(String objectivesNextLink) {
            this.objectivesNextLink = objectivesNextLink;
            this.changedFields = this.changedFields.add("Objectives");
            return this;
        }

        public Builder direction(SearchDirection direction) {
            this.direction = direction;
            this.changedFields = this.changedFields.add("Direction");
            return this;
        }

        public Builder numberOfResults(Integer numberOfResults) {
            this.numberOfResults = numberOfResults;
            this.changedFields = this.changedFields.add("NumberOfResults");
            return this;
        }

        public Builder sites(List<UUID> sites) {
            this.sites = sites;
            this.changedFields = this.changedFields.add("Sites");
            return this;
        }

        public Builder sites(UUID ... sites) {
            return this.sites(Arrays.asList(sites));
        }

        public Builder sitesNextLink(String sitesNextLink) {
            this.sitesNextLink = sitesNextLink;
            this.changedFields = this.changedFields.add("Sites");
            return this;
        }

        public AppointmentRequest build() {
            AppointmentRequest _x = new AppointmentRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppointmentRequest";
            _x.serviceId = this.serviceId;
            _x.anchorOffset = this.anchorOffset;
            _x.userTimeZoneCode = this.userTimeZoneCode;
            _x.recurrenceDuration = this.recurrenceDuration;
            _x.recurrenceTimeZoneCode = this.recurrenceTimeZoneCode;
            _x.appointmentsToIgnore = this.appointmentsToIgnore;
            _x.appointmentsToIgnoreNextLink = this.appointmentsToIgnoreNextLink;
            _x.requiredResources = this.requiredResources;
            _x.requiredResourcesNextLink = this.requiredResourcesNextLink;
            _x.searchWindowStart = this.searchWindowStart;
            _x.searchWindowEnd = this.searchWindowEnd;
            _x.searchRecurrenceStart = this.searchRecurrenceStart;
            _x.searchRecurrenceRule = this.searchRecurrenceRule;
            _x.duration = this.duration;
            _x.constraints = this.constraints;
            _x.constraintsNextLink = this.constraintsNextLink;
            _x.objectives = this.objectives;
            _x.objectivesNextLink = this.objectivesNextLink;
            _x.direction = this.direction;
            _x.numberOfResults = this.numberOfResults;
            _x.sites = this.sites;
            _x.sitesNextLink = this.sitesNextLink;
            return _x;
        }
    }
}

