package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.RetrievePrincipalAccessInfoResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAccessResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAttributePrivilegesResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalSyncAttributeMappingsResponse;
import microsoft.dynamics.crm.complex.RetrieveTeamPrivilegesResponse;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Systemuser;
import microsoft.dynamics.crm.entity.Team;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionreferenceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailserverprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariabledefinitionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariablevalueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExchangesyncidmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExportsolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FlowsessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_crewCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_eventCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_teamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_team_applicationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalrollupqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportdataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportmapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.InteractionforemailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetrecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetscontainerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileattacheddataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aifptrainingdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aimodelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodlabelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingboundingboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aitemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultdetailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_dataflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticleimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_richtextfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_serviceconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_slakpiCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleargumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcessstageparameterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.StagesolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserformCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowbinaryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class TeamRequest extends EntityRequest<Team> {

    public TeamRequest(ContextPath contextPath, Optional<Object> value) {
        super(Team.class, contextPath, value, false);
    }

    public SystemuserRequest teammembership_association(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("teammembership_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest teammembership_association() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("teammembership_association"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest team_principalobjectattributeaccess_principalid(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("team_principalobjectattributeaccess_principalid").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest team_principalobjectattributeaccess_principalid() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("team_principalobjectattributeaccess_principalid"), Optional.empty());
    }

    public ExchangesyncidmappingRequest team_exchangesyncidmapping(UUID exchangesyncidmappingid) {
        return new ExchangesyncidmappingRequest(contextPath.addSegment("team_exchangesyncidmapping").addKeys(new NameValue(exchangesyncidmappingid, UUID.class)), Optional.empty());
    }

    public ExchangesyncidmappingCollectionRequest team_exchangesyncidmapping() {
        return new ExchangesyncidmappingCollectionRequest(
                        contextPath.addSegment("team_exchangesyncidmapping"), Optional.empty());
    }

    public InteractionforemailRequest team_new_interactionforemail(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("team_new_interactionforemail").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest team_new_interactionforemail() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("team_new_interactionforemail"), Optional.empty());
    }

    public KnowledgearticleRequest team_knowledgearticle(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("team_knowledgearticle").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest team_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("team_knowledgearticle"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle"), Optional.empty());
    }

    public SharepointsiteRequest team_sharepointsite(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("team_sharepointsite").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest team_sharepointsite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("team_sharepointsite"), Optional.empty());
    }

    public SharepointdocumentlocationRequest team_sharepointdocumentlocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("team_sharepointdocumentlocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest team_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("team_sharepointdocumentlocation"), Optional.empty());
    }

    public GoalRequest team_goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("team_goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest team_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("team_goal"), Optional.empty());
    }

    public GoalrollupqueryRequest team_goalrollupquery(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("team_goalrollupquery").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest team_goalrollupquery() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("team_goalrollupquery"), Optional.empty());
    }

    public MailboxRequest team_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("team_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest team_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("team_mailbox"), Optional.empty());
    }

    public TeamtemplateRequest associatedteamtemplateid() {
        return new TeamtemplateRequest(contextPath.addSegment("associatedteamtemplateid"), Optional.empty());
    }

    public DuplicateruleRequest team_DuplicateRules(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("team_DuplicateRules").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest team_DuplicateRules() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("team_DuplicateRules"), Optional.empty());
    }

    public ImportRequest team_Imports(UUID importid) {
        return new ImportRequest(contextPath.addSegment("team_Imports").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest team_Imports() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("team_Imports"), Optional.empty());
    }

    public PostfollowRequest owningTeam_postfollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("OwningTeam_postfollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest owningTeam_postfollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("OwningTeam_postfollows"), Optional.empty());
    }

    public RecurringappointmentmasterRequest team_recurringappointmentmaster(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("team_recurringappointmentmaster").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest team_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("team_recurringappointmentmaster"), Optional.empty());
    }

    public WorkflowlogRequest team_workflowlog(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("team_workflowlog").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest team_workflowlog() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("team_workflowlog"), Optional.empty());
    }

    public ConnectionRequest team_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("team_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest team_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("team_connections2"), Optional.empty());
    }

    public ProcesssessionRequest team_processsession(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("team_processsession").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest team_processsession() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("team_processsession"), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public UserformRequest team_userform(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("team_userform").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest team_userform() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("team_userform"), Optional.empty());
    }

    public AsyncoperationRequest team_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Team_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest team_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Team_AsyncOperations"), Optional.empty());
    }

    public SyncerrorRequest team_SyncError(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("team_SyncError").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest team_SyncError() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("team_SyncError"), Optional.empty());
    }

    public QueueRequest queueid() {
        return new QueueRequest(contextPath.addSegment("queueid"), Optional.empty());
    }

    public DuplicaterecordRequest team_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Team_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest team_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Team_DuplicateBaseRecord"), Optional.empty());
    }

    public TaskRequest team_task(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("team_task").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest team_task() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("team_task"), Optional.empty());
    }

    public UserqueryRequest team_userquery(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("team_userquery").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest team_userquery() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("team_userquery"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SocialactivityRequest team_socialactivity(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("team_socialactivity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest team_socialactivity() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("team_socialactivity"), Optional.empty());
    }

    public UserqueryvisualizationRequest team_userqueryvisualizations(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("team_userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest team_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("team_userqueryvisualizations"), Optional.empty());
    }

    public SyncerrorRequest team_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Team_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest team_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Team_SyncErrors"), Optional.empty());
    }

    public ImportmapRequest team_ImportMaps(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("team_ImportMaps").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest team_ImportMaps() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("team_ImportMaps"), Optional.empty());
    }

    public FaxRequest team_fax(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("team_fax").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest team_fax() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("team_fax"), Optional.empty());
    }

    public QueueitemRequest team_queueitembase_workerid(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("team_queueitembase_workerid").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest team_queueitembase_workerid() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("team_queueitembase_workerid"), Optional.empty());
    }

    public PostregardingRequest team_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("team_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest team_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("team_PostRegardings"), Optional.empty());
    }

    public BusinessunitRequest businessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), Optional.empty());
    }

    public ImportfileRequest importFile_Team(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("ImportFile_Team").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest importFile_Team() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("ImportFile_Team"), Optional.empty());
    }

    public ConnectionRequest team_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("team_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest team_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("team_connections1"), Optional.empty());
    }

    public TemplateRequest team_email_templates(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("team_email_templates").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest team_email_templates() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("team_email_templates"), Optional.empty());
    }

    public WorkflowRequest team_workflow(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("team_workflow").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest team_workflow() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("team_workflow"), Optional.empty());
    }

    public DuplicaterecordRequest team_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Team_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest team_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Team_DuplicateMatchingRecord"), Optional.empty());
    }

    public OrganizationRequest organizationid_organization() {
        return new OrganizationRequest(contextPath.addSegment("organizationid_organization"), Optional.empty());
    }

    public EmailRequest team_email(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("team_email").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest team_email() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("team_email"), Optional.empty());
    }

    public LetterRequest team_letter(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("team_letter").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest team_letter() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("team_letter"), Optional.empty());
    }

    public ImportfileRequest team_ImportFiles(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("team_ImportFiles").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest team_ImportFiles() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("team_ImportFiles"), Optional.empty());
    }

    public ImportdataRequest team_ImportData(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("team_ImportData").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest team_ImportData() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("team_ImportData"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public AsyncoperationRequest team_asyncoperation(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("team_asyncoperation").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest team_asyncoperation() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("team_asyncoperation"), Optional.empty());
    }

    public ContactRequest team_contacts(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("team_contacts").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest team_contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("team_contacts"), Optional.empty());
    }

    public MailboxtrackingfolderRequest team_mailboxtrackingfolder(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("team_mailboxtrackingfolder").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest team_mailboxtrackingfolder() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("team_mailboxtrackingfolder"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public EmailserverprofileRequest team_emailserverprofile(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("team_emailserverprofile").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest team_emailserverprofile() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("team_emailserverprofile"), Optional.empty());
    }

    public ProcesssessionRequest team_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Team_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest team_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Team_ProcessSessions"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest team_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("team_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest team_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("team_principalobjectattributeaccess"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public AnnotationRequest team_annotations(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("team_annotations").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest team_annotations() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("team_annotations"), Optional.empty());
    }

    public ImportlogRequest team_ImportLogs(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("team_ImportLogs").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest team_ImportLogs() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("team_ImportLogs"), Optional.empty());
    }

    public SlaRequest team_slaBase(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("team_slaBase").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest team_slaBase() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("team_slaBase"), Optional.empty());
    }

    public FieldsecurityprofileRequest teamprofiles_association(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("teamprofiles_association").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest teamprofiles_association() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("teamprofiles_association"), Optional.empty());
    }

    public PhonecallRequest team_phonecall(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("team_phonecall").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest team_phonecall() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("team_phonecall"), Optional.empty());
    }

    public RoleRequest teamroles_association(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("teamroles_association").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest teamroles_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("teamroles_association"), Optional.empty());
    }

    public AccountRequest team_accounts(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("team_accounts").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest team_accounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("team_accounts"), Optional.empty());
    }

    public ActivitypointerRequest team_activity(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("team_activity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest team_activity() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("team_activity"), Optional.empty());
    }

    public AppointmentRequest team_appointment(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("team_appointment").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest team_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("team_appointment"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest administratorid() {
        return new SystemuserRequest(contextPath.addSegment("administratorid"), Optional.empty());
    }

    public BulkdeletefailureRequest team_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Team_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest team_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Team_BulkDeleteFailures"), Optional.empty());
    }

    public GoalRequest team_goal_goalowner(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("team_goal_goalowner").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest team_goal_goalowner() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("team_goal_goalowner"), Optional.empty());
    }

    public StagesolutionuploadRequest team_stagesolutionupload(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("team_stagesolutionupload").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest team_stagesolutionupload() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("team_stagesolutionupload"), Optional.empty());
    }

    public ExportsolutionuploadRequest team_exportsolutionupload(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("team_exportsolutionupload").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest team_exportsolutionupload() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("team_exportsolutionupload"), Optional.empty());
    }

    public ConnectorRequest team_connector(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("team_connector").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest team_connector() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("team_connector"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest team_environmentvariabledefinition(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("team_environmentvariabledefinition").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest team_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("team_environmentvariabledefinition"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest team_environmentvariablevalue(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("team_environmentvariablevalue").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest team_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("team_environmentvariablevalue"), Optional.empty());
    }

    public ProcessstageparameterRequest team_processstageparameter(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("team_processstageparameter").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest team_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("team_processstageparameter"), Optional.empty());
    }

    public FlowsessionRequest team_flowsession(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("team_flowsession").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest team_flowsession() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("team_flowsession"), Optional.empty());
    }

    public WorkflowbinaryRequest team_workflowbinary(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("team_workflowbinary").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest team_workflowbinary() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("team_workflowbinary"), Optional.empty());
    }

    public ConnectionreferenceRequest team_connectionreference(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("team_connectionreference").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest team_connectionreference() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("team_connectionreference"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest team_msdyn_serviceconfiguration(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("team_msdyn_serviceconfiguration").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest team_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("team_msdyn_serviceconfiguration"), Optional.empty());
    }

    public Msdyn_slakpiRequest team_msdyn_slakpi(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("team_msdyn_slakpi").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest team_msdyn_slakpi() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("team_msdyn_slakpi"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest team_msdyn_knowledgearticleimage(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("team_msdyn_knowledgearticleimage").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest team_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("team_msdyn_knowledgearticleimage"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest team_msdyn_knowledgearticletemplate(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("team_msdyn_knowledgearticletemplate").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest team_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("team_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    public Msdyn_dataflowRequest team_msdyn_dataflow(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("team_msdyn_dataflow").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest team_msdyn_dataflow() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("team_msdyn_dataflow"), Optional.empty());
    }

    public Msdyn_richtextfileRequest team_msdyn_richtextfile(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("team_msdyn_richtextfile").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest team_msdyn_richtextfile() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("team_msdyn_richtextfile"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest team_msdyn_aiconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("team_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest team_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aimodelRequest team_msdyn_aimodel(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("team_msdyn_aimodel").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest team_msdyn_aimodel() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("team_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aitemplateRequest team_msdyn_aitemplate(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("team_msdyn_aitemplate").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest team_msdyn_aitemplate() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("team_msdyn_aitemplate"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest team_msdyn_aibdataset(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("team_msdyn_aibdataset").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest team_msdyn_aibdataset() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdataset"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest team_msdyn_aibdatasetfile(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("team_msdyn_aibdatasetfile").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest team_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdatasetfile"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest team_msdyn_aibdatasetrecord(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("team_msdyn_aibdatasetrecord").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest team_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdatasetrecord"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest team_msdyn_aibdatasetscontainer(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("team_msdyn_aibdatasetscontainer").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest team_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibdatasetscontainer"), Optional.empty());
    }

    public Msdyn_aibfileRequest team_msdyn_aibfile(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("team_msdyn_aibfile").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest team_msdyn_aibfile() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibfile"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest team_msdyn_aibfileattacheddata(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("team_msdyn_aibfileattacheddata").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest team_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("team_msdyn_aibfileattacheddata"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest team_msdyn_aifptrainingdocument(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("team_msdyn_aifptrainingdocument").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest team_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("team_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest team_msdyn_aiodimage(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("team_msdyn_aiodimage").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest team_msdyn_aiodimage() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest team_msdyn_aiodlabel(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("team_msdyn_aiodlabel").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest team_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodlabel"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest team_msdyn_aiodtrainingboundingbox(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("team_msdyn_aiodtrainingboundingbox").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest team_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest team_msdyn_aiodtrainingimage(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("team_msdyn_aiodtrainingimage").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest team_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("team_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest team_msdyn_analysiscomponent(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("team_msdyn_analysiscomponent").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest team_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysiscomponent"), Optional.empty());
    }

    public Msdyn_analysisjobRequest team_msdyn_analysisjob(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("team_msdyn_analysisjob").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest team_msdyn_analysisjob() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysisjob"), Optional.empty());
    }

    public Msdyn_analysisresultRequest team_msdyn_analysisresult(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("team_msdyn_analysisresult").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest team_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest team_msdyn_analysisresultdetail(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("team_msdyn_analysisresultdetail").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest team_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("team_msdyn_analysisresultdetail"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest team_msdyn_solutionhealthrule(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("team_msdyn_solutionhealthrule").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest team_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("team_msdyn_solutionhealthrule"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest team_msdyn_solutionhealthruleargument(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("team_msdyn_solutionhealthruleargument").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest team_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("team_msdyn_solutionhealthruleargument"), Optional.empty());
    }

    public Ggw_eventRequest team_ggw_event(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("team_ggw_event").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest team_ggw_event() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("team_ggw_event"), Optional.empty());
    }

    public Ggw_teamRequest team_ggw_team(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("team_ggw_team").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest team_ggw_team() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("team_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest team_ggw_crew(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("team_ggw_crew").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest team_ggw_crew() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("team_ggw_crew"), Optional.empty());
    }

    public Ggw_team_applicationRequest team_ggw_team_application(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("team_ggw_team_application").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest team_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("team_ggw_team_application"), Optional.empty());
    }

    @Action(name = "AddMembersTeam")
    @JsonIgnore
    public ActionRequestNoReturn addMembersTeam(List<Systemuser> members) {
        Preconditions.checkNotNull(members, "members cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Members", "Collection(Microsoft.Dynamics.CRM.systemuser)", members)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddMembersTeam"), _parameters);
    }

    @Action(name = "ConvertOwnerTeamToAccessTeam")
    @JsonIgnore
    public ActionRequestNoReturn convertOwnerTeamToAccessTeam() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ConvertOwnerTeamToAccessTeam"), _parameters);
    }

    @Action(name = "RemoveMembersTeam")
    @JsonIgnore
    public ActionRequestNoReturn removeMembersTeam(List<Systemuser> members) {
        Preconditions.checkNotNull(members, "members cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Members", "Collection(Microsoft.Dynamics.CRM.systemuser)", members)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveMembersTeam"), _parameters);
    }

    @Function(name = "RetrievePrincipalAccess")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessResponse> retrievePrincipalAccess(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAccess"), RetrievePrincipalAccessResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAccessInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessInfoResponse> retrievePrincipalAccessInfo(UUID objectId, String entityName) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAccessInfo"), RetrievePrincipalAccessInfoResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAttributePrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAttributePrivilegesResponse> retrievePrincipalAttributePrivileges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAttributePrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAttributePrivileges"), RetrievePrincipalAttributePrivilegesResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalSyncAttributeMappings")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalSyncAttributeMappingsResponse> retrievePrincipalSyncAttributeMappings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalSyncAttributeMappingsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalSyncAttributeMappings"), RetrievePrincipalSyncAttributeMappingsResponse.class, _parameters);
    }

    @Function(name = "RetrieveTeamPrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveTeamPrivilegesResponse> retrieveTeamPrivileges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveTeamPrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveTeamPrivileges"), RetrieveTeamPrivilegesResponse.class, _parameters);
    }

}
