package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.String;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.complex.AddUserToRecordTeamResponse;
import microsoft.dynamics.crm.complex.RemoveUserFromRecordTeamResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAccessInfoResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAccessResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalAttributePrivilegesResponse;
import microsoft.dynamics.crm.complex.RetrievePrincipalSyncAttributeMappingsResponse;
import microsoft.dynamics.crm.complex.RetrieveUserLicenseInfoResponse;
import microsoft.dynamics.crm.complex.RetrieveUserPrivilegeByPrivilegeIdResponse;
import microsoft.dynamics.crm.complex.RetrieveUserPrivilegeByPrivilegeNameResponse;
import microsoft.dynamics.crm.complex.RetrieveUserPrivilegesResponse;
import microsoft.dynamics.crm.complex.RetrieveUsersPrivilegesThroughTeamsResponse;
import microsoft.dynamics.crm.entity.Businessunit;
import microsoft.dynamics.crm.entity.Crmbaseentity;
import microsoft.dynamics.crm.entity.Queue;
import microsoft.dynamics.crm.entity.Savedquery;
import microsoft.dynamics.crm.entity.Systemuser;
import microsoft.dynamics.crm.entity.Teamtemplate;
import microsoft.dynamics.crm.entity.collection.request.AccountCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AciviewmapperCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypointerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnualfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfiginstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppconfigmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ApplicationuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmoduleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppmodulecomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AppointmentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AuditCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeleteoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BusinessunitnewsarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CalendarruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CallbackregistrationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ColumnmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionreferenceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionroleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ContactCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontroldefaultconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomcontrolresourceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.CustomeraddressCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspaceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DatalakeworkspacepermissionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DisplaystringCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DocumenttemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicateruleconditionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EmailserverprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariabledefinitionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.EnvironmentvariablevalueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExchangesyncidmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExpiredprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ExportsolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FaxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FeedbackCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FieldsecurityprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FixedmonthlyfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.FlowsessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_crewCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_eventCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_teamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Ggw_team_applicationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.GoalrollupqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportdataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportentitymappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportlogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ImportmapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.InteractionforemailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticlecommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KbarticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgearticleviewsCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.KnowledgebaserecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LetterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.LookupmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailboxtrackingfolderCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MailmergetemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MetricCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MobileofflineprofileitemassociationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.MonthlyfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetrecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibdatasetscontainerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aibfileattacheddataCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aifptrainingdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aimodelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodlabelCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingboundingboxCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aiodtrainingimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_aitemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysiscomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisjobCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_analysisresultdetailCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_dataflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_helppageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticleimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_knowledgearticletemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_richtextfileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_serviceconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_slakpiCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthruleargumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.Msdyn_solutionhealthrulesetCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NavigationsettingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.NewprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OfficegraphdocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OrganizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.OwnermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PersonaldocumenttemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PhonecallCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PicklistmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PluginassemblyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintracelogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintypeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PlugintypestatisticCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PositionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostcommentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostfollowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostlikeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PostregardingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcessstageparameterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesstriggerCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PublisherCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PublisheraddressCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QuarterlyfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecommendeddocumentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurrenceruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RecurringappointmentmasterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ReportCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ReportcategoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RoleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.RollupfieldCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SavedqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessagefilterCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepimageCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SdkmessageprocessingstepsecureconfigCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SemiannualfiscalcalendarCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ServiceendpointCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ServiceplanCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointdocumentlocationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SharepointsiteCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SimilarityruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SitemapCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlaitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialactivityCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SocialprofileCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentattributeconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SolutioncomponentrelationshipconfigurationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.StagesolutionuploadCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SubjectCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SystemuserCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TaskCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TeamtemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TemplateCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TerritoryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ThemeCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TimezonedefinitionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TimezonelocalizednameCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TimezoneruleCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TracelogCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransactioncurrencyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransformationmappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TransformationparametermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.TranslationprocessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserformCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UsermappingCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UserqueryvisualizationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.UsersettingsCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WebresourceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WebwizardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowbinaryCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.WorkflowlogCollectionRequest;

@JsonIgnoreType
public class SystemuserRequest extends EntityRequest<Systemuser> {

    public SystemuserRequest(ContextPath contextPath, Optional<Object> value) {
        super(Systemuser.class, contextPath, value, false);
    }

    public RoleRequest systemuserroles_association(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("systemuserroles_association").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest systemuserroles_association() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("systemuserroles_association"), Optional.empty());
    }

    public TeamRequest teammembership_association(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("teammembership_association").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest teammembership_association() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("teammembership_association"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest systemuser_principalobjectattributeaccess_principalid(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("systemuser_principalobjectattributeaccess_principalid").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest systemuser_principalobjectattributeaccess_principalid() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("systemuser_principalobjectattributeaccess_principalid"), Optional.empty());
    }

    public ExchangesyncidmappingRequest user_exchangesyncidmapping(UUID exchangesyncidmappingid) {
        return new ExchangesyncidmappingRequest(contextPath.addSegment("user_exchangesyncidmapping").addKeys(new NameValue(exchangesyncidmappingid, UUID.class)), Optional.empty());
    }

    public ExchangesyncidmappingCollectionRequest user_exchangesyncidmapping() {
        return new ExchangesyncidmappingCollectionRequest(
                        contextPath.addSegment("user_exchangesyncidmapping"), Optional.empty());
    }

    public ThemeRequest lk_theme_createdby(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("lk_theme_createdby").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public ThemeCollectionRequest lk_theme_createdby() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("lk_theme_createdby"), Optional.empty());
    }

    public ThemeRequest lk_theme_createdonbehalfby(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("lk_theme_createdonbehalfby").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public ThemeCollectionRequest lk_theme_createdonbehalfby() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("lk_theme_createdonbehalfby"), Optional.empty());
    }

    public ThemeRequest lk_theme_modifiedby(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("lk_theme_modifiedby").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public ThemeCollectionRequest lk_theme_modifiedby() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("lk_theme_modifiedby"), Optional.empty());
    }

    public ThemeRequest lk_theme_modifiedonbehalfby(UUID themeid) {
        return new ThemeRequest(contextPath.addSegment("lk_theme_modifiedonbehalfby").addKeys(new NameValue(themeid, UUID.class)), Optional.empty());
    }

    public ThemeCollectionRequest lk_theme_modifiedonbehalfby() {
        return new ThemeCollectionRequest(
                        contextPath.addSegment("lk_theme_modifiedonbehalfby"), Optional.empty());
    }

    public UsermappingRequest lk_usermapping_createdby(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("lk_usermapping_createdby").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public UsermappingCollectionRequest lk_usermapping_createdby() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("lk_usermapping_createdby"), Optional.empty());
    }

    public UsermappingRequest lk_usermapping_createdonbehalfby(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("lk_usermapping_createdonbehalfby").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public UsermappingCollectionRequest lk_usermapping_createdonbehalfby() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("lk_usermapping_createdonbehalfby"), Optional.empty());
    }

    public UsermappingRequest lk_usermapping_modifiedby(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("lk_usermapping_modifiedby").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public UsermappingCollectionRequest lk_usermapping_modifiedby() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("lk_usermapping_modifiedby"), Optional.empty());
    }

    public UsermappingRequest lk_usermapping_modifiedonbehalfby(UUID usermappingid) {
        return new UsermappingRequest(contextPath.addSegment("lk_usermapping_modifiedonbehalfby").addKeys(new NameValue(usermappingid, UUID.class)), Optional.empty());
    }

    public UsermappingCollectionRequest lk_usermapping_modifiedonbehalfby() {
        return new UsermappingCollectionRequest(
                        contextPath.addSegment("lk_usermapping_modifiedonbehalfby"), Optional.empty());
    }

    public InteractionforemailRequest lk_new_interactionforemail_createdby(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("lk_new_interactionforemail_createdby").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest lk_new_interactionforemail_createdby() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("lk_new_interactionforemail_createdby"), Optional.empty());
    }

    public InteractionforemailRequest lk_new_interactionforemail_createdonbehalfby(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("lk_new_interactionforemail_createdonbehalfby").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest lk_new_interactionforemail_createdonbehalfby() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("lk_new_interactionforemail_createdonbehalfby"), Optional.empty());
    }

    public InteractionforemailRequest lk_new_interactionforemail_modifiedby(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("lk_new_interactionforemail_modifiedby").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest lk_new_interactionforemail_modifiedby() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("lk_new_interactionforemail_modifiedby"), Optional.empty());
    }

    public InteractionforemailRequest lk_new_interactionforemail_modifiedonbehalfby(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("lk_new_interactionforemail_modifiedonbehalfby").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest lk_new_interactionforemail_modifiedonbehalfby() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("lk_new_interactionforemail_modifiedonbehalfby"), Optional.empty());
    }

    public InteractionforemailRequest user_new_interactionforemail(UUID interactionforemailid) {
        return new InteractionforemailRequest(contextPath.addSegment("user_new_interactionforemail").addKeys(new NameValue(interactionforemailid, UUID.class)), Optional.empty());
    }

    public InteractionforemailCollectionRequest user_new_interactionforemail() {
        return new InteractionforemailCollectionRequest(
                        contextPath.addSegment("user_new_interactionforemail"), Optional.empty());
    }

    public KnowledgearticleRequest lk_knowledgearticle_createdby(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("lk_knowledgearticle_createdby").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest lk_knowledgearticle_createdby() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticle_createdby"), Optional.empty());
    }

    public KnowledgearticleRequest lk_knowledgearticle_createdonbehalfby(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("lk_knowledgearticle_createdonbehalfby").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest lk_knowledgearticle_createdonbehalfby() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticle_createdonbehalfby"), Optional.empty());
    }

    public KnowledgearticleRequest lk_knowledgearticle_modifiedby(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("lk_knowledgearticle_modifiedby").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest lk_knowledgearticle_modifiedby() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticle_modifiedby"), Optional.empty());
    }

    public KnowledgearticleRequest lk_knowledgearticle_modifiedonbehalfby(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("lk_knowledgearticle_modifiedonbehalfby").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest lk_knowledgearticle_modifiedonbehalfby() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticle_modifiedonbehalfby"), Optional.empty());
    }

    public KnowledgearticleRequest user_knowledgearticle(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("user_knowledgearticle").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest user_knowledgearticle() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("user_knowledgearticle"), Optional.empty());
    }

    public SharepointsiteRequest user_sharepointsite(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("user_sharepointsite").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest user_sharepointsite() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("user_sharepointsite"), Optional.empty());
    }

    public SharepointdocumentlocationRequest user_sharepointdocumentlocation(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("user_sharepointdocumentlocation").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest user_sharepointdocumentlocation() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("user_sharepointdocumentlocation"), Optional.empty());
    }

    public GoalRequest lk_goal_createdby(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("lk_goal_createdby").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest lk_goal_createdby() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("lk_goal_createdby"), Optional.empty());
    }

    public GoalRequest lk_goal_createdonbehalfby(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("lk_goal_createdonbehalfby").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest lk_goal_createdonbehalfby() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("lk_goal_createdonbehalfby"), Optional.empty());
    }

    public GoalRequest lk_goal_modifiedby(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("lk_goal_modifiedby").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest lk_goal_modifiedby() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("lk_goal_modifiedby"), Optional.empty());
    }

    public GoalRequest lk_goal_modifiedonbehalfby(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("lk_goal_modifiedonbehalfby").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest lk_goal_modifiedonbehalfby() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("lk_goal_modifiedonbehalfby"), Optional.empty());
    }

    public GoalRequest user_goal(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("user_goal").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest user_goal() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("user_goal"), Optional.empty());
    }

    public GoalRequest user_goal_goalowner(UUID goalid) {
        return new GoalRequest(contextPath.addSegment("user_goal_goalowner").addKeys(new NameValue(goalid, UUID.class)), Optional.empty());
    }

    public GoalCollectionRequest user_goal_goalowner() {
        return new GoalCollectionRequest(
                        contextPath.addSegment("user_goal_goalowner"), Optional.empty());
    }

    public MetricRequest lk_metric_createdby(UUID metricid) {
        return new MetricRequest(contextPath.addSegment("lk_metric_createdby").addKeys(new NameValue(metricid, UUID.class)), Optional.empty());
    }

    public MetricCollectionRequest lk_metric_createdby() {
        return new MetricCollectionRequest(
                        contextPath.addSegment("lk_metric_createdby"), Optional.empty());
    }

    public MetricRequest lk_metric_createdonbehalfby(UUID metricid) {
        return new MetricRequest(contextPath.addSegment("lk_metric_createdonbehalfby").addKeys(new NameValue(metricid, UUID.class)), Optional.empty());
    }

    public MetricCollectionRequest lk_metric_createdonbehalfby() {
        return new MetricCollectionRequest(
                        contextPath.addSegment("lk_metric_createdonbehalfby"), Optional.empty());
    }

    public MetricRequest lk_metric_modifiedby(UUID metricid) {
        return new MetricRequest(contextPath.addSegment("lk_metric_modifiedby").addKeys(new NameValue(metricid, UUID.class)), Optional.empty());
    }

    public MetricCollectionRequest lk_metric_modifiedby() {
        return new MetricCollectionRequest(
                        contextPath.addSegment("lk_metric_modifiedby"), Optional.empty());
    }

    public MetricRequest lk_metric_modifiedonbehalfby(UUID metricid) {
        return new MetricRequest(contextPath.addSegment("lk_metric_modifiedonbehalfby").addKeys(new NameValue(metricid, UUID.class)), Optional.empty());
    }

    public MetricCollectionRequest lk_metric_modifiedonbehalfby() {
        return new MetricCollectionRequest(
                        contextPath.addSegment("lk_metric_modifiedonbehalfby"), Optional.empty());
    }

    public RollupfieldRequest lk_rollupfield_createdby(UUID rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("lk_rollupfield_createdby").addKeys(new NameValue(rollupfieldid, UUID.class)), Optional.empty());
    }

    public RollupfieldCollectionRequest lk_rollupfield_createdby() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("lk_rollupfield_createdby"), Optional.empty());
    }

    public RollupfieldRequest lk_rollupfield_createdonbehalfby(UUID rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("lk_rollupfield_createdonbehalfby").addKeys(new NameValue(rollupfieldid, UUID.class)), Optional.empty());
    }

    public RollupfieldCollectionRequest lk_rollupfield_createdonbehalfby() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("lk_rollupfield_createdonbehalfby"), Optional.empty());
    }

    public RollupfieldRequest lk_rollupfield_modifiedby(UUID rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("lk_rollupfield_modifiedby").addKeys(new NameValue(rollupfieldid, UUID.class)), Optional.empty());
    }

    public RollupfieldCollectionRequest lk_rollupfield_modifiedby() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("lk_rollupfield_modifiedby"), Optional.empty());
    }

    public RollupfieldRequest lk_rollupfield_modifiedonbehalfby(UUID rollupfieldid) {
        return new RollupfieldRequest(contextPath.addSegment("lk_rollupfield_modifiedonbehalfby").addKeys(new NameValue(rollupfieldid, UUID.class)), Optional.empty());
    }

    public RollupfieldCollectionRequest lk_rollupfield_modifiedonbehalfby() {
        return new RollupfieldCollectionRequest(
                        contextPath.addSegment("lk_rollupfield_modifiedonbehalfby"), Optional.empty());
    }

    public GoalrollupqueryRequest lk_goalrollupquery_createdby(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("lk_goalrollupquery_createdby").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest lk_goalrollupquery_createdby() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("lk_goalrollupquery_createdby"), Optional.empty());
    }

    public GoalrollupqueryRequest lk_goalrollupquery_createdonbehalfby(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("lk_goalrollupquery_createdonbehalfby").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest lk_goalrollupquery_createdonbehalfby() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("lk_goalrollupquery_createdonbehalfby"), Optional.empty());
    }

    public GoalrollupqueryRequest lk_goalrollupquery_modifiedby(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("lk_goalrollupquery_modifiedby").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest lk_goalrollupquery_modifiedby() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("lk_goalrollupquery_modifiedby"), Optional.empty());
    }

    public GoalrollupqueryRequest lk_goalrollupquery_modifiedonbehalfby(UUID goalrollupqueryid) {
        return new GoalrollupqueryRequest(contextPath.addSegment("lk_goalrollupquery_modifiedonbehalfby").addKeys(new NameValue(goalrollupqueryid, UUID.class)), Optional.empty());
    }

    public GoalrollupqueryCollectionRequest lk_goalrollupquery_modifiedonbehalfby() {
        return new GoalrollupqueryCollectionRequest(
                        contextPath.addSegment("lk_goalrollupquery_modifiedonbehalfby"), Optional.empty());
    }

    public EmailserverprofileRequest lk_emailserverprofile_createdonbehalfby(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("lk_emailserverprofile_createdonbehalfby").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest lk_emailserverprofile_createdonbehalfby() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("lk_emailserverprofile_createdonbehalfby"), Optional.empty());
    }

    public EmailserverprofileRequest lk_emailserverprofile_modifiedonbehalfby(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("lk_emailserverprofile_modifiedonbehalfby").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest lk_emailserverprofile_modifiedonbehalfby() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("lk_emailserverprofile_modifiedonbehalfby"), Optional.empty());
    }

    public MailboxRequest lk_mailbox_createdby(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("lk_mailbox_createdby").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest lk_mailbox_createdby() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("lk_mailbox_createdby"), Optional.empty());
    }

    public MailboxRequest lk_mailbox_createdonbehalfby(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("lk_mailbox_createdonbehalfby").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest lk_mailbox_createdonbehalfby() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("lk_mailbox_createdonbehalfby"), Optional.empty());
    }

    public MailboxRequest lk_mailbox_modifiedby(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("lk_mailbox_modifiedby").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest lk_mailbox_modifiedby() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("lk_mailbox_modifiedby"), Optional.empty());
    }

    public MailboxRequest lk_mailbox_modifiedonbehalfby(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("lk_mailbox_modifiedonbehalfby").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest lk_mailbox_modifiedonbehalfby() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("lk_mailbox_modifiedonbehalfby"), Optional.empty());
    }

    public MailboxRequest user_mailbox(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("user_mailbox").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest user_mailbox() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("user_mailbox"), Optional.empty());
    }

    public MailboxRequest mailbox_regarding_systemuser(UUID mailboxid) {
        return new MailboxRequest(contextPath.addSegment("mailbox_regarding_systemuser").addKeys(new NameValue(mailboxid, UUID.class)), Optional.empty());
    }

    public MailboxCollectionRequest mailbox_regarding_systemuser() {
        return new MailboxCollectionRequest(
                        contextPath.addSegment("mailbox_regarding_systemuser"), Optional.empty());
    }

    public MailboxRequest defaultmailbox() {
        return new MailboxRequest(contextPath.addSegment("defaultmailbox"), Optional.empty());
    }

    public PostRequest lk_post_createdby(UUID postid) {
        return new PostRequest(contextPath.addSegment("lk_post_createdby").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public PostCollectionRequest lk_post_createdby() {
        return new PostCollectionRequest(
                        contextPath.addSegment("lk_post_createdby"), Optional.empty());
    }

    public PostRequest lk_post_createdonbehalfby(UUID postid) {
        return new PostRequest(contextPath.addSegment("lk_post_createdonbehalfby").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public PostCollectionRequest lk_post_createdonbehalfby() {
        return new PostCollectionRequest(
                        contextPath.addSegment("lk_post_createdonbehalfby"), Optional.empty());
    }

    public PostRequest lk_post_modifiedby(UUID postid) {
        return new PostRequest(contextPath.addSegment("lk_post_modifiedby").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public PostCollectionRequest lk_post_modifiedby() {
        return new PostCollectionRequest(
                        contextPath.addSegment("lk_post_modifiedby"), Optional.empty());
    }

    public PostRequest lk_post_modifiedonbehalfby(UUID postid) {
        return new PostRequest(contextPath.addSegment("lk_post_modifiedonbehalfby").addKeys(new NameValue(postid, UUID.class)), Optional.empty());
    }

    public PostCollectionRequest lk_post_modifiedonbehalfby() {
        return new PostCollectionRequest(
                        contextPath.addSegment("lk_post_modifiedonbehalfby"), Optional.empty());
    }

    public PositionRequest lk_position_createdby(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("lk_position_createdby").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public PositionCollectionRequest lk_position_createdby() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("lk_position_createdby"), Optional.empty());
    }

    public PositionRequest lk_position_createdonbehalfby(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("lk_position_createdonbehalfby").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public PositionCollectionRequest lk_position_createdonbehalfby() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("lk_position_createdonbehalfby"), Optional.empty());
    }

    public PositionRequest lk_position_modifiedby(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("lk_position_modifiedby").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public PositionCollectionRequest lk_position_modifiedby() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("lk_position_modifiedby"), Optional.empty());
    }

    public PositionRequest lk_position_modifiedonbehalfby(UUID positionid) {
        return new PositionRequest(contextPath.addSegment("lk_position_modifiedonbehalfby").addKeys(new NameValue(positionid, UUID.class)), Optional.empty());
    }

    public PositionCollectionRequest lk_position_modifiedonbehalfby() {
        return new PositionCollectionRequest(
                        contextPath.addSegment("lk_position_modifiedonbehalfby"), Optional.empty());
    }

    public PositionRequest positionid() {
        return new PositionRequest(contextPath.addSegment("positionid"), Optional.empty());
    }

    public SolutionRequest lk_solution_createdby(UUID solutionid) {
        return new SolutionRequest(contextPath.addSegment("lk_solution_createdby").addKeys(new NameValue(solutionid, UUID.class)), Optional.empty());
    }

    public SolutionCollectionRequest lk_solution_createdby() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("lk_solution_createdby"), Optional.empty());
    }

    public SolutionRequest lk_solution_modifiedby(UUID solutionid) {
        return new SolutionRequest(contextPath.addSegment("lk_solution_modifiedby").addKeys(new NameValue(solutionid, UUID.class)), Optional.empty());
    }

    public SolutionCollectionRequest lk_solution_modifiedby() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("lk_solution_modifiedby"), Optional.empty());
    }

    public PublisherRequest lk_publisher_createdby(UUID publisherid) {
        return new PublisherRequest(contextPath.addSegment("lk_publisher_createdby").addKeys(new NameValue(publisherid, UUID.class)), Optional.empty());
    }

    public PublisherCollectionRequest lk_publisher_createdby() {
        return new PublisherCollectionRequest(
                        contextPath.addSegment("lk_publisher_createdby"), Optional.empty());
    }

    public PublisherRequest lk_publisher_modifiedby(UUID publisherid) {
        return new PublisherRequest(contextPath.addSegment("lk_publisher_modifiedby").addKeys(new NameValue(publisherid, UUID.class)), Optional.empty());
    }

    public PublisherCollectionRequest lk_publisher_modifiedby() {
        return new PublisherCollectionRequest(
                        contextPath.addSegment("lk_publisher_modifiedby"), Optional.empty());
    }

    public OfficegraphdocumentRequest lk_officegraphdocument_createdonbehalfby(UUID officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("lk_officegraphdocument_createdonbehalfby").addKeys(new NameValue(officegraphdocumentid, UUID.class)), Optional.empty());
    }

    public OfficegraphdocumentCollectionRequest lk_officegraphdocument_createdonbehalfby() {
        return new OfficegraphdocumentCollectionRequest(
                        contextPath.addSegment("lk_officegraphdocument_createdonbehalfby"), Optional.empty());
    }

    public OfficegraphdocumentRequest lk_officegraphdocument_modifiedonbehalfby(UUID officegraphdocumentid) {
        return new OfficegraphdocumentRequest(contextPath.addSegment("lk_officegraphdocument_modifiedonbehalfby").addKeys(new NameValue(officegraphdocumentid, UUID.class)), Optional.empty());
    }

    public OfficegraphdocumentCollectionRequest lk_officegraphdocument_modifiedonbehalfby() {
        return new OfficegraphdocumentCollectionRequest(
                        contextPath.addSegment("lk_officegraphdocument_modifiedonbehalfby"), Optional.empty());
    }

    public SimilarityruleRequest lk_similarityrule_createdonbehalfby(UUID similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("lk_similarityrule_createdonbehalfby").addKeys(new NameValue(similarityruleid, UUID.class)), Optional.empty());
    }

    public SimilarityruleCollectionRequest lk_similarityrule_createdonbehalfby() {
        return new SimilarityruleCollectionRequest(
                        contextPath.addSegment("lk_similarityrule_createdonbehalfby"), Optional.empty());
    }

    public SimilarityruleRequest lk_similarityrule_modifiedonbehalfby(UUID similarityruleid) {
        return new SimilarityruleRequest(contextPath.addSegment("lk_similarityrule_modifiedonbehalfby").addKeys(new NameValue(similarityruleid, UUID.class)), Optional.empty());
    }

    public SimilarityruleCollectionRequest lk_similarityrule_modifiedonbehalfby() {
        return new SimilarityruleCollectionRequest(
                        contextPath.addSegment("lk_similarityrule_modifiedonbehalfby"), Optional.empty());
    }

    public RecommendeddocumentRequest lk_recommendeddocument_createdby(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("lk_recommendeddocument_createdby").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest lk_recommendeddocument_createdby() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("lk_recommendeddocument_createdby"), Optional.empty());
    }

    public RecommendeddocumentRequest lk_recommendeddocument_createdonbehalfby(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("lk_recommendeddocument_createdonbehalfby").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest lk_recommendeddocument_createdonbehalfby() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("lk_recommendeddocument_createdonbehalfby"), Optional.empty());
    }

    public RecommendeddocumentRequest lk_recommendeddocument_modifiedby(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("lk_recommendeddocument_modifiedby").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest lk_recommendeddocument_modifiedby() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("lk_recommendeddocument_modifiedby"), Optional.empty());
    }

    public RecommendeddocumentRequest lk_recommendeddocument_modifiedonbehalfby(UUID recommendeddocumentid) {
        return new RecommendeddocumentRequest(contextPath.addSegment("lk_recommendeddocument_modifiedonbehalfby").addKeys(new NameValue(recommendeddocumentid, UUID.class)), Optional.empty());
    }

    public RecommendeddocumentCollectionRequest lk_recommendeddocument_modifiedonbehalfby() {
        return new RecommendeddocumentCollectionRequest(
                        contextPath.addSegment("lk_recommendeddocument_modifiedonbehalfby"), Optional.empty());
    }

    public KnowledgebaserecordRequest lk_KnowledgeBaseRecord_createdby(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("lk_KnowledgeBaseRecord_createdby").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest lk_KnowledgeBaseRecord_createdby() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("lk_KnowledgeBaseRecord_createdby"), Optional.empty());
    }

    public KnowledgebaserecordRequest lk_KnowledgeBaseRecord_createdonbehalfby(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("lk_KnowledgeBaseRecord_createdonbehalfby").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest lk_KnowledgeBaseRecord_createdonbehalfby() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("lk_KnowledgeBaseRecord_createdonbehalfby"), Optional.empty());
    }

    public KnowledgebaserecordRequest lk_KnowledgeBaseRecord_modifiedby(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("lk_KnowledgeBaseRecord_modifiedby").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest lk_KnowledgeBaseRecord_modifiedby() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("lk_KnowledgeBaseRecord_modifiedby"), Optional.empty());
    }

    public KnowledgebaserecordRequest lk_KnowledgeBaseRecord_modifiedonbehalfby(UUID knowledgebaserecordid) {
        return new KnowledgebaserecordRequest(contextPath.addSegment("lk_KnowledgeBaseRecord_modifiedonbehalfby").addKeys(new NameValue(knowledgebaserecordid, UUID.class)), Optional.empty());
    }

    public KnowledgebaserecordCollectionRequest lk_KnowledgeBaseRecord_modifiedonbehalfby() {
        return new KnowledgebaserecordCollectionRequest(
                        contextPath.addSegment("lk_KnowledgeBaseRecord_modifiedonbehalfby"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest lk_monthlyfiscalcalendar_modifiedby(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("lk_monthlyfiscalcalendar_modifiedby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public MonthlyfiscalcalendarCollectionRequest lk_monthlyfiscalcalendar_modifiedby() {
        return new MonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_monthlyfiscalcalendar_modifiedby"), Optional.empty());
    }

    public SlakpiinstanceRequest lk_slakpiinstancebase_createdonbehalfby(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("lk_slakpiinstancebase_createdonbehalfby").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest lk_slakpiinstancebase_createdonbehalfby() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("lk_slakpiinstancebase_createdonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest lk_mobileofflineprofileitemassocaition_modifiedonbehalfby(UUID mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("lk_mobileofflineprofileitemassocaition_modifiedonbehalfby").addKeys(new NameValue(mobileofflineprofileitemassociationid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest lk_mobileofflineprofileitemassocaition_modifiedonbehalfby() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitemassocaition_modifiedonbehalfby"), Optional.empty());
    }

    public UserqueryvisualizationRequest lk_userqueryvisualizationbase_modifiedonbehalfby(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("lk_userqueryvisualizationbase_modifiedonbehalfby").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest lk_userqueryvisualizationbase_modifiedonbehalfby() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_userqueryvisualizationbase_modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest systemUser_SyncError(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SystemUser_SyncError").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest systemUser_SyncError() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SystemUser_SyncError"), Optional.empty());
    }

    public ImportdataRequest systemUser_ImportData(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("SystemUser_ImportData").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest systemUser_ImportData() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("SystemUser_ImportData"), Optional.empty());
    }

    public RecurrenceruleRequest lk_recurrencerulebase_createdonbehalfby(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("lk_recurrencerulebase_createdonbehalfby").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest lk_recurrencerulebase_createdonbehalfby() {
        return new RecurrenceruleCollectionRequest(
                        contextPath.addSegment("lk_recurrencerulebase_createdonbehalfby"), Optional.empty());
    }

    public FieldsecurityprofileRequest lk_fieldsecurityprofile_createdonbehalfby(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("lk_fieldsecurityprofile_createdonbehalfby").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest lk_fieldsecurityprofile_createdonbehalfby() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("lk_fieldsecurityprofile_createdonbehalfby"), Optional.empty());
    }

    public ImportRequest lk_importbase_createdby(UUID importid) {
        return new ImportRequest(contextPath.addSegment("lk_importbase_createdby").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest lk_importbase_createdby() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("lk_importbase_createdby"), Optional.empty());
    }

    public SlaitemRequest lk_slaitembase_modifiedonbehalfby(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("lk_slaitembase_modifiedonbehalfby").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public SlaitemCollectionRequest lk_slaitembase_modifiedonbehalfby() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("lk_slaitembase_modifiedonbehalfby"), Optional.empty());
    }

    public SdkmessageRequest createdby_sdkmessage(UUID sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("createdby_sdkmessage").addKeys(new NameValue(sdkmessageid, UUID.class)), Optional.empty());
    }

    public SdkmessageCollectionRequest createdby_sdkmessage() {
        return new SdkmessageCollectionRequest(
                        contextPath.addSegment("createdby_sdkmessage"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_canceledby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_canceledby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_canceledby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_canceledby"), Optional.empty());
    }

    public DuplicateruleRequest lk_duplicaterule_createdonbehalfby(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("lk_duplicaterule_createdonbehalfby").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest lk_duplicaterule_createdonbehalfby() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("lk_duplicaterule_createdonbehalfby"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest lk_monthlyfiscalcalendar_modifiedonbehalfby(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("lk_monthlyfiscalcalendar_modifiedonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public MonthlyfiscalcalendarCollectionRequest lk_monthlyfiscalcalendar_modifiedonbehalfby() {
        return new MonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_monthlyfiscalcalendar_modifiedonbehalfby"), Optional.empty());
    }

    public LookupmappingRequest lk_lookupmapping_modifiedby(UUID lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("lk_lookupmapping_modifiedby").addKeys(new NameValue(lookupmappingid, UUID.class)), Optional.empty());
    }

    public LookupmappingCollectionRequest lk_lookupmapping_modifiedby() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("lk_lookupmapping_modifiedby"), Optional.empty());
    }

    public KbarticletemplateRequest lk_kbarticletemplatebase_createdby(UUID kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("lk_kbarticletemplatebase_createdby").addKeys(new NameValue(kbarticletemplateid, UUID.class)), Optional.empty());
    }

    public KbarticletemplateCollectionRequest lk_kbarticletemplatebase_createdby() {
        return new KbarticletemplateCollectionRequest(
                        contextPath.addSegment("lk_kbarticletemplatebase_createdby"), Optional.empty());
    }

    public SavedqueryRequest lk_savedquerybase_modifiedby(UUID savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("lk_savedquerybase_modifiedby").addKeys(new NameValue(savedqueryid, UUID.class)), Optional.empty());
    }

    public SavedqueryCollectionRequest lk_savedquerybase_modifiedby() {
        return new SavedqueryCollectionRequest(
                        contextPath.addSegment("lk_savedquerybase_modifiedby"), Optional.empty());
    }

    public TeamtemplateRequest lk_teamtemplate_createdby(UUID teamtemplateid) {
        return new TeamtemplateRequest(contextPath.addSegment("lk_teamtemplate_createdby").addKeys(new NameValue(teamtemplateid, UUID.class)), Optional.empty());
    }

    public TeamtemplateCollectionRequest lk_teamtemplate_createdby() {
        return new TeamtemplateCollectionRequest(
                        contextPath.addSegment("lk_teamtemplate_createdby"), Optional.empty());
    }

    public AccountRequest lk_accountbase_createdby(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("lk_accountbase_createdby").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest lk_accountbase_createdby() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("lk_accountbase_createdby"), Optional.empty());
    }

    public PluginassemblyRequest createdby_pluginassembly(UUID pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("createdby_pluginassembly").addKeys(new NameValue(pluginassemblyid, UUID.class)), Optional.empty());
    }

    public PluginassemblyCollectionRequest createdby_pluginassembly() {
        return new PluginassemblyCollectionRequest(
                        contextPath.addSegment("createdby_pluginassembly"), Optional.empty());
    }

    public KbarticleRequest lk_kbarticle_createdonbehalfby(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("lk_kbarticle_createdonbehalfby").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest lk_kbarticle_createdonbehalfby() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("lk_kbarticle_createdonbehalfby"), Optional.empty());
    }

    public UserformRequest user_userform(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("user_userform").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest user_userform() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("user_userform"), Optional.empty());
    }

    public OrganizationRequest lk_organization_modifiedonbehalfby(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("lk_organization_modifiedonbehalfby").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest lk_organization_modifiedonbehalfby() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("lk_organization_modifiedonbehalfby"), Optional.empty());
    }

    public SolutionRequest lk_solutionbase_modifiedonbehalfby(UUID solutionid) {
        return new SolutionRequest(contextPath.addSegment("lk_solutionbase_modifiedonbehalfby").addKeys(new NameValue(solutionid, UUID.class)), Optional.empty());
    }

    public SolutionCollectionRequest lk_solutionbase_modifiedonbehalfby() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("lk_solutionbase_modifiedonbehalfby"), Optional.empty());
    }

    public TimezoneruleRequest lk_timezonerule_createdby(UUID timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("lk_timezonerule_createdby").addKeys(new NameValue(timezoneruleid, UUID.class)), Optional.empty());
    }

    public TimezoneruleCollectionRequest lk_timezonerule_createdby() {
        return new TimezoneruleCollectionRequest(
                        contextPath.addSegment("lk_timezonerule_createdby"), Optional.empty());
    }

    public ConnectionRequest modifiedby_connection(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("modifiedby_connection").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest modifiedby_connection() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("modifiedby_connection"), Optional.empty());
    }

    public ConnectionRequest systemuser_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("systemuser_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest systemuser_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("systemuser_connections1"), Optional.empty());
    }

    public ReportRequest lk_report_modifiedonbehalfby(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("lk_report_modifiedonbehalfby").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public ReportCollectionRequest lk_report_modifiedonbehalfby() {
        return new ReportCollectionRequest(
                        contextPath.addSegment("lk_report_modifiedonbehalfby"), Optional.empty());
    }

    public TracelogRequest lk_tracelog_createdby(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("lk_tracelog_createdby").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest lk_tracelog_createdby() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("lk_tracelog_createdby"), Optional.empty());
    }

    public CalendarRequest lk_calendar_createdonbehalfby(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("lk_calendar_createdonbehalfby").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public CalendarCollectionRequest lk_calendar_createdonbehalfby() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("lk_calendar_createdonbehalfby"), Optional.empty());
    }

    public ActivitypointerRequest lk_activitypointer_createdby(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("lk_activitypointer_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest lk_activitypointer_createdby() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("lk_activitypointer_createdby"), Optional.empty());
    }

    public QueueitemRequest lk_queueitembase_createdby(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("lk_queueitembase_createdby").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest lk_queueitembase_createdby() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("lk_queueitembase_createdby"), Optional.empty());
    }

    public NavigationsettingRequest systemuser_navigationsetting_modifiedby(UUID navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("systemuser_navigationsetting_modifiedby").addKeys(new NameValue(navigationsettingid, UUID.class)), Optional.empty());
    }

    public NavigationsettingCollectionRequest systemuser_navigationsetting_modifiedby() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("systemuser_navigationsetting_modifiedby"), Optional.empty());
    }

    public SitemapRequest systemuser_SiteMap_modifiedonbehalfby(UUID sitemapid) {
        return new SitemapRequest(contextPath.addSegment("systemuser_SiteMap_modifiedonbehalfby").addKeys(new NameValue(sitemapid, UUID.class)), Optional.empty());
    }

    public SitemapCollectionRequest systemuser_SiteMap_modifiedonbehalfby() {
        return new SitemapCollectionRequest(
                        contextPath.addSegment("systemuser_SiteMap_modifiedonbehalfby"), Optional.empty());
    }

    public AnnotationRequest lk_annotationbase_modifiedonbehalfby(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("lk_annotationbase_modifiedonbehalfby").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest lk_annotationbase_modifiedonbehalfby() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("lk_annotationbase_modifiedonbehalfby"), Optional.empty());
    }

    public SlakpiinstanceRequest lk_slakpiinstancebase_createdby(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("lk_slakpiinstancebase_createdby").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest lk_slakpiinstancebase_createdby() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("lk_slakpiinstancebase_createdby"), Optional.empty());
    }

    public AppmoduleRequest systemuser_appmodule_modifiedonbehalfby(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("systemuser_appmodule_modifiedonbehalfby").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest systemuser_appmodule_modifiedonbehalfby() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("systemuser_appmodule_modifiedonbehalfby"), Optional.empty());
    }

    public RoleRequest lk_role_createdonbehalfby(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("lk_role_createdonbehalfby").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest lk_role_createdonbehalfby() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("lk_role_createdonbehalfby"), Optional.empty());
    }

    public SocialactivityRequest lk_socialactivitybase_modifiedonbehalfby(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("lk_socialactivitybase_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest lk_socialactivitybase_modifiedonbehalfby() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("lk_socialactivitybase_modifiedonbehalfby"), Optional.empty());
    }

    public RecurringappointmentmasterRequest user_recurringappointmentmaster(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("user_recurringappointmentmaster").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest user_recurringappointmentmaster() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("user_recurringappointmentmaster"), Optional.empty());
    }

    public CustomeraddressRequest lk_customeraddress_modifiedonbehalfby(UUID customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("lk_customeraddress_modifiedonbehalfby").addKeys(new NameValue(customeraddressid, UUID.class)), Optional.empty());
    }

    public CustomeraddressCollectionRequest lk_customeraddress_modifiedonbehalfby() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("lk_customeraddress_modifiedonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest lk_businessunitbase_modifiedby(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("lk_businessunitbase_modifiedby").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest lk_businessunitbase_modifiedby() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("lk_businessunitbase_modifiedby"), Optional.empty());
    }

    public PlugintypeRequest modifiedby_plugintype(UUID plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("modifiedby_plugintype").addKeys(new NameValue(plugintypeid, UUID.class)), Optional.empty());
    }

    public PlugintypeCollectionRequest modifiedby_plugintype() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("modifiedby_plugintype"), Optional.empty());
    }

    public TimezonelocalizednameRequest lk_timezonelocalizedname_createdonbehalfby(UUID timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("lk_timezonelocalizedname_createdonbehalfby").addKeys(new NameValue(timezonelocalizednameid, UUID.class)), Optional.empty());
    }

    public TimezonelocalizednameCollectionRequest lk_timezonelocalizedname_createdonbehalfby() {
        return new TimezonelocalizednameCollectionRequest(
                        contextPath.addSegment("lk_timezonelocalizedname_createdonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest lk_sdkmessageprocessingstepimage_createdonbehalfby(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("lk_sdkmessageprocessingstepimage_createdonbehalfby").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest lk_sdkmessageprocessingstepimage_createdonbehalfby() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("lk_sdkmessageprocessingstepimage_createdonbehalfby"), Optional.empty());
    }

    public ConnectionRequest createdby_connection(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("createdby_connection").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest createdby_connection() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("createdby_connection"), Optional.empty());
    }

    public SavedqueryvisualizationRequest lk_savedqueryvisualizationbase_createdonbehalfby(UUID savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("lk_savedqueryvisualizationbase_createdonbehalfby").addKeys(new NameValue(savedqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest lk_savedqueryvisualizationbase_createdonbehalfby() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_savedqueryvisualizationbase_createdonbehalfby"), Optional.empty());
    }

    public ProcesssessionRequest systemUser_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("SystemUser_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest systemUser_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("SystemUser_ProcessSessions"), Optional.empty());
    }

    public ImportdataRequest lk_importdatabase_modifiedby(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("lk_importdatabase_modifiedby").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest lk_importdatabase_modifiedby() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("lk_importdatabase_modifiedby"), Optional.empty());
    }

    public WorkflowRequest workflow_createdonbehalfby(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflow_createdonbehalfby").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest workflow_createdonbehalfby() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("workflow_createdonbehalfby"), Optional.empty());
    }

    public SlaRequest lk_slabase_createdby(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("lk_slabase_createdby").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest lk_slabase_createdby() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("lk_slabase_createdby"), Optional.empty());
    }

    public ProcesstriggerRequest lk_processtriggerbase_createdonbehalfby(UUID processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("lk_processtriggerbase_createdonbehalfby").addKeys(new NameValue(processtriggerid, UUID.class)), Optional.empty());
    }

    public ProcesstriggerCollectionRequest lk_processtriggerbase_createdonbehalfby() {
        return new ProcesstriggerCollectionRequest(
                        contextPath.addSegment("lk_processtriggerbase_createdonbehalfby"), Optional.empty());
    }

    public ConnectionRequest systemuser_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("systemuser_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest systemuser_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("systemuser_connections2"), Optional.empty());
    }

    public ConnectionroleRequest modifiedby_connection_role(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("modifiedby_connection_role").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest modifiedby_connection_role() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("modifiedby_connection_role"), Optional.empty());
    }

    public AppmodulecomponentRequest appmodulecomponent_modifiedby(UUID appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("appmodulecomponent_modifiedby").addKeys(new NameValue(appmodulecomponentid, UUID.class)), Optional.empty());
    }

    public AppmodulecomponentCollectionRequest appmodulecomponent_modifiedby() {
        return new AppmodulecomponentCollectionRequest(
                        contextPath.addSegment("appmodulecomponent_modifiedby"), Optional.empty());
    }

    public ServiceendpointRequest lk_serviceendpointbase_createdonbehalfby(UUID serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("lk_serviceendpointbase_createdonbehalfby").addKeys(new NameValue(serviceendpointid, UUID.class)), Optional.empty());
    }

    public ServiceendpointCollectionRequest lk_serviceendpointbase_createdonbehalfby() {
        return new ServiceendpointCollectionRequest(
                        contextPath.addSegment("lk_serviceendpointbase_createdonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest modifiedby_sdkmessageprocessingstepimage(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("modifiedby_sdkmessageprocessingstepimage").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest modifiedby_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("modifiedby_sdkmessageprocessingstepimage"), Optional.empty());
    }

    public ImportentitymappingRequest lk_importentitymapping_modifiedby(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("lk_importentitymapping_modifiedby").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public ImportentitymappingCollectionRequest lk_importentitymapping_modifiedby() {
        return new ImportentitymappingCollectionRequest(
                        contextPath.addSegment("lk_importentitymapping_modifiedby"), Optional.empty());
    }

    public SlaRequest lk_slabase_createdonbehalfby(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("lk_slabase_createdonbehalfby").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest lk_slabase_createdonbehalfby() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("lk_slabase_createdonbehalfby"), Optional.empty());
    }

    public ProcesstriggerRequest lk_processtriggerbase_modifiedby(UUID processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("lk_processtriggerbase_modifiedby").addKeys(new NameValue(processtriggerid, UUID.class)), Optional.empty());
    }

    public ProcesstriggerCollectionRequest lk_processtriggerbase_modifiedby() {
        return new ProcesstriggerCollectionRequest(
                        contextPath.addSegment("lk_processtriggerbase_modifiedby"), Optional.empty());
    }

    public AccountRequest lk_accountbase_modifiedby(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("lk_accountbase_modifiedby").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest lk_accountbase_modifiedby() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("lk_accountbase_modifiedby"), Optional.empty());
    }

    public PostfollowRequest lk_PostFollow_createdby(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("lk_PostFollow_createdby").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest lk_PostFollow_createdby() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("lk_PostFollow_createdby"), Optional.empty());
    }

    public PostfollowRequest systemuser_PostFollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("systemuser_PostFollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest systemuser_PostFollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("systemuser_PostFollows"), Optional.empty());
    }

    public PostregardingRequest systemuser_PostRegardings(UUID postregardingid) {
        return new PostregardingRequest(contextPath.addSegment("systemuser_PostRegardings").addKeys(new NameValue(postregardingid, UUID.class)), Optional.empty());
    }

    public PostregardingCollectionRequest systemuser_PostRegardings() {
        return new PostregardingCollectionRequest(
                        contextPath.addSegment("systemuser_PostRegardings"), Optional.empty());
    }

    public PostcommentRequest lk_postcomment_createdby(UUID postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("lk_postcomment_createdby").addKeys(new NameValue(postcommentid, UUID.class)), Optional.empty());
    }

    public PostcommentCollectionRequest lk_postcomment_createdby() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("lk_postcomment_createdby"), Optional.empty());
    }

    public PostfollowRequest user_owner_postfollows(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("user_owner_postfollows").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest user_owner_postfollows() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("user_owner_postfollows"), Optional.empty());
    }

    public PostfollowRequest lk_postfollow_createdonbehalfby(UUID postfollowid) {
        return new PostfollowRequest(contextPath.addSegment("lk_postfollow_createdonbehalfby").addKeys(new NameValue(postfollowid, UUID.class)), Optional.empty());
    }

    public PostfollowCollectionRequest lk_postfollow_createdonbehalfby() {
        return new PostfollowCollectionRequest(
                        contextPath.addSegment("lk_postfollow_createdonbehalfby"), Optional.empty());
    }

    public PostcommentRequest lk_postcomment_createdonbehalfby(UUID postcommentid) {
        return new PostcommentRequest(contextPath.addSegment("lk_postcomment_createdonbehalfby").addKeys(new NameValue(postcommentid, UUID.class)), Optional.empty());
    }

    public PostcommentCollectionRequest lk_postcomment_createdonbehalfby() {
        return new PostcommentCollectionRequest(
                        contextPath.addSegment("lk_postcomment_createdonbehalfby"), Optional.empty());
    }

    public PostlikeRequest lk_postlike_createdonbehalfby(UUID postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("lk_postlike_createdonbehalfby").addKeys(new NameValue(postlikeid, UUID.class)), Optional.empty());
    }

    public PostlikeCollectionRequest lk_postlike_createdonbehalfby() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("lk_postlike_createdonbehalfby"), Optional.empty());
    }

    public PostlikeRequest lk_postlike_createdby(UUID postlikeid) {
        return new PostlikeRequest(contextPath.addSegment("lk_postlike_createdby").addKeys(new NameValue(postlikeid, UUID.class)), Optional.empty());
    }

    public PostlikeCollectionRequest lk_postlike_createdby() {
        return new PostlikeCollectionRequest(
                        contextPath.addSegment("lk_postlike_createdby"), Optional.empty());
    }

    public CalendarRequest lk_calendar_modifiedby(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("lk_calendar_modifiedby").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public CalendarCollectionRequest lk_calendar_modifiedby() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("lk_calendar_modifiedby"), Optional.empty());
    }

    public SharepointdocumentlocationRequest lk_sharepointdocumentlocationbase_createdonbehalfby(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("lk_sharepointdocumentlocationbase_createdonbehalfby").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest lk_sharepointdocumentlocationbase_createdonbehalfby() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("lk_sharepointdocumentlocationbase_createdonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest systemUser_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("SystemUser_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest systemUser_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("SystemUser_SyncErrors"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest lk_quarterlyfiscalcalendar_createdonbehalfby(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("lk_quarterlyfiscalcalendar_createdonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public QuarterlyfiscalcalendarCollectionRequest lk_quarterlyfiscalcalendar_createdonbehalfby() {
        return new QuarterlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_quarterlyfiscalcalendar_createdonbehalfby"), Optional.empty());
    }

    public TransformationparametermappingRequest lk_transformationparametermapping_modifiedonbehalfby(UUID transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("lk_transformationparametermapping_modifiedonbehalfby").addKeys(new NameValue(transformationparametermappingid, UUID.class)), Optional.empty());
    }

    public TransformationparametermappingCollectionRequest lk_transformationparametermapping_modifiedonbehalfby() {
        return new TransformationparametermappingCollectionRequest(
                        contextPath.addSegment("lk_transformationparametermapping_modifiedonbehalfby"), Optional.empty());
    }

    public TimezonedefinitionRequest lk_timezonedefinition_modifiedby(UUID timezonedefinitionid) {
        return new TimezonedefinitionRequest(contextPath.addSegment("lk_timezonedefinition_modifiedby").addKeys(new NameValue(timezonedefinitionid, UUID.class)), Optional.empty());
    }

    public TimezonedefinitionCollectionRequest lk_timezonedefinition_modifiedby() {
        return new TimezonedefinitionCollectionRequest(
                        contextPath.addSegment("lk_timezonedefinition_modifiedby"), Optional.empty());
    }

    public PicklistmappingRequest lk_picklistmapping_modifiedby(UUID picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("lk_picklistmapping_modifiedby").addKeys(new NameValue(picklistmappingid, UUID.class)), Optional.empty());
    }

    public PicklistmappingCollectionRequest lk_picklistmapping_modifiedby() {
        return new PicklistmappingCollectionRequest(
                        contextPath.addSegment("lk_picklistmapping_modifiedby"), Optional.empty());
    }

    public TemplateRequest lk_templatebase_createdby(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("lk_templatebase_createdby").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest lk_templatebase_createdby() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("lk_templatebase_createdby"), Optional.empty());
    }

    public PlugintracelogRequest lk_plugintracelogbase_createdonbehalfby(UUID plugintracelogid) {
        return new PlugintracelogRequest(contextPath.addSegment("lk_plugintracelogbase_createdonbehalfby").addKeys(new NameValue(plugintracelogid, UUID.class)), Optional.empty());
    }

    public PlugintracelogCollectionRequest lk_plugintracelogbase_createdonbehalfby() {
        return new PlugintracelogCollectionRequest(
                        contextPath.addSegment("lk_plugintracelogbase_createdonbehalfby"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_createdonbehalfby(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_createdonbehalfby").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_createdonbehalfby() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_createdonbehalfby"), Optional.empty());
    }

    public UserqueryvisualizationRequest lk_userqueryvisualizationbase_createdonbehalfby(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("lk_userqueryvisualizationbase_createdonbehalfby").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest lk_userqueryvisualizationbase_createdonbehalfby() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_userqueryvisualizationbase_createdonbehalfby"), Optional.empty());
    }

    public BulkdeleteoperationRequest lk_bulkdeleteoperationbase_modifiedby(UUID bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("lk_bulkdeleteoperationbase_modifiedby").addKeys(new NameValue(bulkdeleteoperationid, UUID.class)), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest lk_bulkdeleteoperationbase_modifiedby() {
        return new BulkdeleteoperationCollectionRequest(
                        contextPath.addSegment("lk_bulkdeleteoperationbase_modifiedby"), Optional.empty());
    }

    public SharepointsiteRequest lk_sharepointsitebase_modifiedby(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("lk_sharepointsitebase_modifiedby").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest lk_sharepointsitebase_modifiedby() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("lk_sharepointsitebase_modifiedby"), Optional.empty());
    }

    public ReportRequest lk_report_createdonbehalfby(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("lk_report_createdonbehalfby").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public ReportCollectionRequest lk_report_createdonbehalfby() {
        return new ReportCollectionRequest(
                        contextPath.addSegment("lk_report_createdonbehalfby"), Optional.empty());
    }

    public PlugintracelogRequest createdby_plugintracelog(UUID plugintracelogid) {
        return new PlugintracelogRequest(contextPath.addSegment("createdby_plugintracelog").addKeys(new NameValue(plugintracelogid, UUID.class)), Optional.empty());
    }

    public PlugintracelogCollectionRequest createdby_plugintracelog() {
        return new PlugintracelogCollectionRequest(
                        contextPath.addSegment("createdby_plugintracelog"), Optional.empty());
    }

    public PlugintypestatisticRequest createdby_plugintypestatistic(UUID plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("createdby_plugintypestatistic").addKeys(new NameValue(plugintypestatisticid, UUID.class)), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest createdby_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("createdby_plugintypestatistic"), Optional.empty());
    }

    public DisplaystringRequest lk_DisplayStringbase_modifiedonbehalfby(UUID displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("lk_DisplayStringbase_modifiedonbehalfby").addKeys(new NameValue(displaystringid, UUID.class)), Optional.empty());
    }

    public DisplaystringCollectionRequest lk_DisplayStringbase_modifiedonbehalfby() {
        return new DisplaystringCollectionRequest(
                        contextPath.addSegment("lk_DisplayStringbase_modifiedonbehalfby"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest lk_monthlyfiscalcalendar_salespersonid(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("lk_monthlyfiscalcalendar_salespersonid").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public MonthlyfiscalcalendarCollectionRequest lk_monthlyfiscalcalendar_salespersonid() {
        return new MonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_monthlyfiscalcalendar_salespersonid"), Optional.empty());
    }

    public SitemapRequest systemuser_SiteMap_modifiedby(UUID sitemapid) {
        return new SitemapRequest(contextPath.addSegment("systemuser_SiteMap_modifiedby").addKeys(new NameValue(sitemapid, UUID.class)), Optional.empty());
    }

    public SitemapCollectionRequest systemuser_SiteMap_modifiedby() {
        return new SitemapCollectionRequest(
                        contextPath.addSegment("systemuser_SiteMap_modifiedby"), Optional.empty());
    }

    public TracelogRequest lk_tracelog_modifiedby(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("lk_tracelog_modifiedby").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest lk_tracelog_modifiedby() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("lk_tracelog_modifiedby"), Optional.empty());
    }

    public DuplicateruleRequest lk_duplicaterule_modifiedonbehalfby(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("lk_duplicaterule_modifiedonbehalfby").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest lk_duplicaterule_modifiedonbehalfby() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("lk_duplicaterule_modifiedonbehalfby"), Optional.empty());
    }

    public SavedqueryRequest lk_savedquery_createdonbehalfby(UUID savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("lk_savedquery_createdonbehalfby").addKeys(new NameValue(savedqueryid, UUID.class)), Optional.empty());
    }

    public SavedqueryCollectionRequest lk_savedquery_createdonbehalfby() {
        return new SavedqueryCollectionRequest(
                        contextPath.addSegment("lk_savedquery_createdonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest lk_mobileofflineprofileitemassocaition_modifiedby(UUID mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("lk_mobileofflineprofileitemassocaition_modifiedby").addKeys(new NameValue(mobileofflineprofileitemassociationid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest lk_mobileofflineprofileitemassocaition_modifiedby() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitemassocaition_modifiedby"), Optional.empty());
    }

    public QueueitemRequest lk_queueitembase_modifiedby(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("lk_queueitembase_modifiedby").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest lk_queueitembase_modifiedby() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("lk_queueitembase_modifiedby"), Optional.empty());
    }

    public RoleRequest lk_rolebase_modifiedby(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("lk_rolebase_modifiedby").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest lk_rolebase_modifiedby() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("lk_rolebase_modifiedby"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest lk_sdkmessageprocessingstep_createdonbehalfby(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("lk_sdkmessageprocessingstep_createdonbehalfby").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest lk_sdkmessageprocessingstep_createdonbehalfby() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("lk_sdkmessageprocessingstep_createdonbehalfby"), Optional.empty());
    }

    public NewprocessRequest lk_newprocess_createdby(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("lk_newprocess_createdby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest lk_newprocess_createdby() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("lk_newprocess_createdby"), Optional.empty());
    }

    public ImportjobRequest lk_importjobbase_createdonbehalfby(UUID importjobid) {
        return new ImportjobRequest(contextPath.addSegment("lk_importjobbase_createdonbehalfby").addKeys(new NameValue(importjobid, UUID.class)), Optional.empty());
    }

    public ImportjobCollectionRequest lk_importjobbase_createdonbehalfby() {
        return new ImportjobCollectionRequest(
                        contextPath.addSegment("lk_importjobbase_createdonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest createdby_sdkmessageprocessingstepimage(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("createdby_sdkmessageprocessingstepimage").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest createdby_sdkmessageprocessingstepimage() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("createdby_sdkmessageprocessingstepimage"), Optional.empty());
    }

    public SitemapRequest systemuser_SiteMap_createdonbehalfby(UUID sitemapid) {
        return new SitemapRequest(contextPath.addSegment("systemuser_SiteMap_createdonbehalfby").addKeys(new NameValue(sitemapid, UUID.class)), Optional.empty());
    }

    public SitemapCollectionRequest systemuser_SiteMap_createdonbehalfby() {
        return new SitemapCollectionRequest(
                        contextPath.addSegment("systemuser_SiteMap_createdonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest lk_businessunit_createdonbehalfby(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("lk_businessunit_createdonbehalfby").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest lk_businessunit_createdonbehalfby() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("lk_businessunit_createdonbehalfby"), Optional.empty());
    }

    public CustomcontrolRequest lk_customcontrol_modifiedonbehalfby(UUID customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("lk_customcontrol_modifiedonbehalfby").addKeys(new NameValue(customcontrolid, UUID.class)), Optional.empty());
    }

    public CustomcontrolCollectionRequest lk_customcontrol_modifiedonbehalfby() {
        return new CustomcontrolCollectionRequest(
                        contextPath.addSegment("lk_customcontrol_modifiedonbehalfby"), Optional.empty());
    }

    public ServiceendpointRequest createdby_serviceendpoint(UUID serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("createdby_serviceendpoint").addKeys(new NameValue(serviceendpointid, UUID.class)), Optional.empty());
    }

    public ServiceendpointCollectionRequest createdby_serviceendpoint() {
        return new ServiceendpointCollectionRequest(
                        contextPath.addSegment("createdby_serviceendpoint"), Optional.empty());
    }

    public SocialactivityRequest lk_socialactivitybase_createdonbehalfby(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("lk_socialactivitybase_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest lk_socialactivitybase_createdonbehalfby() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("lk_socialactivitybase_createdonbehalfby"), Optional.empty());
    }

    public LetterRequest lk_letter_modifiedonbehalfby(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("lk_letter_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest lk_letter_modifiedonbehalfby() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("lk_letter_modifiedonbehalfby"), Optional.empty());
    }

    public TimezoneruleRequest lk_timezonerule_createdonbehalfby(UUID timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("lk_timezonerule_createdonbehalfby").addKeys(new NameValue(timezoneruleid, UUID.class)), Optional.empty());
    }

    public TimezoneruleCollectionRequest lk_timezonerule_createdonbehalfby() {
        return new TimezoneruleCollectionRequest(
                        contextPath.addSegment("lk_timezonerule_createdonbehalfby"), Optional.empty());
    }

    public PersonaldocumenttemplateRequest lk_personaldocumenttemplatebase_modifiedonbehalfby(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("lk_personaldocumenttemplatebase_modifiedonbehalfby").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public PersonaldocumenttemplateCollectionRequest lk_personaldocumenttemplatebase_modifiedonbehalfby() {
        return new PersonaldocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_personaldocumenttemplatebase_modifiedonbehalfby"), Optional.empty());
    }

    public TeamtemplateRequest lk_teamtemplate_createdonbehalfby(UUID teamtemplateid) {
        return new TeamtemplateRequest(contextPath.addSegment("lk_teamtemplate_createdonbehalfby").addKeys(new NameValue(teamtemplateid, UUID.class)), Optional.empty());
    }

    public TeamtemplateCollectionRequest lk_teamtemplate_createdonbehalfby() {
        return new TeamtemplateCollectionRequest(
                        contextPath.addSegment("lk_teamtemplate_createdonbehalfby"), Optional.empty());
    }

    public ImportlogRequest systemUser_ImportLogs(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("SystemUser_ImportLogs").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest systemUser_ImportLogs() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("SystemUser_ImportLogs"), Optional.empty());
    }

    public TeamtemplateRequest lk_teamtemplate_modifiedby(UUID teamtemplateid) {
        return new TeamtemplateRequest(contextPath.addSegment("lk_teamtemplate_modifiedby").addKeys(new NameValue(teamtemplateid, UUID.class)), Optional.empty());
    }

    public TeamtemplateCollectionRequest lk_teamtemplate_modifiedby() {
        return new TeamtemplateCollectionRequest(
                        contextPath.addSegment("lk_teamtemplate_modifiedby"), Optional.empty());
    }

    public ColumnmappingRequest lk_columnmapping_modifiedby(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("lk_columnmapping_modifiedby").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public ColumnmappingCollectionRequest lk_columnmapping_modifiedby() {
        return new ColumnmappingCollectionRequest(
                        contextPath.addSegment("lk_columnmapping_modifiedby"), Optional.empty());
    }

    public TimezonedefinitionRequest lk_timezonedefinition_createdonbehalfby(UUID timezonedefinitionid) {
        return new TimezonedefinitionRequest(contextPath.addSegment("lk_timezonedefinition_createdonbehalfby").addKeys(new NameValue(timezonedefinitionid, UUID.class)), Optional.empty());
    }

    public TimezonedefinitionCollectionRequest lk_timezonedefinition_createdonbehalfby() {
        return new TimezonedefinitionCollectionRequest(
                        contextPath.addSegment("lk_timezonedefinition_createdonbehalfby"), Optional.empty());
    }

    public ReportcategoryRequest lk_reportcategory_modifiedonbehalfby(UUID reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("lk_reportcategory_modifiedonbehalfby").addKeys(new NameValue(reportcategoryid, UUID.class)), Optional.empty());
    }

    public ReportcategoryCollectionRequest lk_reportcategory_modifiedonbehalfby() {
        return new ReportcategoryCollectionRequest(
                        contextPath.addSegment("lk_reportcategory_modifiedonbehalfby"), Optional.empty());
    }

    public ExpiredprocessRequest lk_expiredprocess_createdby(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("lk_expiredprocess_createdby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest lk_expiredprocess_createdby() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("lk_expiredprocess_createdby"), Optional.empty());
    }

    public WebresourceRequest webresource_modifiedby(UUID webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("webresource_modifiedby").addKeys(new NameValue(webresourceid, UUID.class)), Optional.empty());
    }

    public WebresourceCollectionRequest webresource_modifiedby() {
        return new WebresourceCollectionRequest(
                        contextPath.addSegment("webresource_modifiedby"), Optional.empty());
    }

    public ReportcategoryRequest lk_reportcategorybase_createdby(UUID reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("lk_reportcategorybase_createdby").addKeys(new NameValue(reportcategoryid, UUID.class)), Optional.empty());
    }

    public ReportcategoryCollectionRequest lk_reportcategorybase_createdby() {
        return new ReportcategoryCollectionRequest(
                        contextPath.addSegment("lk_reportcategorybase_createdby"), Optional.empty());
    }

    public UserqueryRequest lk_userquery_modifiedby(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("lk_userquery_modifiedby").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest lk_userquery_modifiedby() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("lk_userquery_modifiedby"), Optional.empty());
    }

    public CustomcontrolRequest lk_customcontrol_createdby(UUID customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("lk_customcontrol_createdby").addKeys(new NameValue(customcontrolid, UUID.class)), Optional.empty());
    }

    public CustomcontrolCollectionRequest lk_customcontrol_createdby() {
        return new CustomcontrolCollectionRequest(
                        contextPath.addSegment("lk_customcontrol_createdby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest lk_systemuser_modifiedonbehalfby(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("lk_systemuser_modifiedonbehalfby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest lk_systemuser_modifiedonbehalfby() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("lk_systemuser_modifiedonbehalfby"), Optional.empty());
    }

    public ImportlogRequest lk_importlogbase_createdby(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("lk_importlogbase_createdby").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest lk_importlogbase_createdby() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("lk_importlogbase_createdby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

    public SystemuserRequest lk_systemuserbase_createdby(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("lk_systemuserbase_createdby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest lk_systemuserbase_createdby() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("lk_systemuserbase_createdby"), Optional.empty());
    }

    public SharepointdocumentlocationRequest lk_sharepointdocumentlocationbase_modifiedby(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("lk_sharepointdocumentlocationbase_modifiedby").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest lk_sharepointdocumentlocationbase_modifiedby() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("lk_sharepointdocumentlocationbase_modifiedby"), Optional.empty());
    }

    public QueueitemRequest lk_queueitembase_workerid(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("lk_queueitembase_workerid").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest lk_queueitembase_workerid() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("lk_queueitembase_workerid"), Optional.empty());
    }

    public SolutioncomponentRequest lk_solutioncomponentbase_createdonbehalfby(UUID solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("lk_solutioncomponentbase_createdonbehalfby").addKeys(new NameValue(solutioncomponentid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentCollectionRequest lk_solutioncomponentbase_createdonbehalfby() {
        return new SolutioncomponentCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentbase_createdonbehalfby"), Optional.empty());
    }

    public FieldsecurityprofileRequest systemuserprofiles_association(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("systemuserprofiles_association").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest systemuserprofiles_association() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("systemuserprofiles_association"), Optional.empty());
    }

    public TranslationprocessRequest lk_translationprocess_modifiedby(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("lk_translationprocess_modifiedby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest lk_translationprocess_modifiedby() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("lk_translationprocess_modifiedby"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest lk_semiannualfiscalcalendar_modifiedonbehalfby(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("lk_semiannualfiscalcalendar_modifiedonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public SemiannualfiscalcalendarCollectionRequest lk_semiannualfiscalcalendar_modifiedonbehalfby() {
        return new SemiannualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_semiannualfiscalcalendar_modifiedonbehalfby"), Optional.empty());
    }

    public PublisherRequest lk_publisherbase_modifiedonbehalfby(UUID publisherid) {
        return new PublisherRequest(contextPath.addSegment("lk_publisherbase_modifiedonbehalfby").addKeys(new NameValue(publisherid, UUID.class)), Optional.empty());
    }

    public PublisherCollectionRequest lk_publisherbase_modifiedonbehalfby() {
        return new PublisherCollectionRequest(
                        contextPath.addSegment("lk_publisherbase_modifiedonbehalfby"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid"), Optional.empty());
    }

    public AciviewmapperRequest lk_ACIViewMapper_createdby(UUID aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("lk_ACIViewMapper_createdby").addKeys(new NameValue(aciviewmapperid, UUID.class)), Optional.empty());
    }

    public AciviewmapperCollectionRequest lk_ACIViewMapper_createdby() {
        return new AciviewmapperCollectionRequest(
                        contextPath.addSegment("lk_ACIViewMapper_createdby"), Optional.empty());
    }

    public ImportlogRequest lk_importlog_createdonbehalfby(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("lk_importlog_createdonbehalfby").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest lk_importlog_createdonbehalfby() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("lk_importlog_createdonbehalfby"), Optional.empty());
    }

    public ImportdataRequest lk_importdata_createdonbehalfby(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("lk_importdata_createdonbehalfby").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest lk_importdata_createdonbehalfby() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("lk_importdata_createdonbehalfby"), Optional.empty());
    }

    public LetterRequest lk_letter_createdonbehalfby(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("lk_letter_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest lk_letter_createdonbehalfby() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("lk_letter_createdonbehalfby"), Optional.empty());
    }

    public ServiceendpointRequest modifiedby_serviceendpoint(UUID serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("modifiedby_serviceendpoint").addKeys(new NameValue(serviceendpointid, UUID.class)), Optional.empty());
    }

    public ServiceendpointCollectionRequest modifiedby_serviceendpoint() {
        return new ServiceendpointCollectionRequest(
                        contextPath.addSegment("modifiedby_serviceendpoint"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest lk_annualfiscalcalendar_modifiedby(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("lk_annualfiscalcalendar_modifiedby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public AnnualfiscalcalendarCollectionRequest lk_annualfiscalcalendar_modifiedby() {
        return new AnnualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_annualfiscalcalendar_modifiedby"), Optional.empty());
    }

    public ImportmapRequest lk_importmap_createdonbehalfby(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("lk_importmap_createdonbehalfby").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest lk_importmap_createdonbehalfby() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("lk_importmap_createdonbehalfby"), Optional.empty());
    }

    public KnowledgearticleviewsRequest lk_knowledgearticleviews_createdonbehalfby(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("lk_knowledgearticleviews_createdonbehalfby").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleviewsCollectionRequest lk_knowledgearticleviews_createdonbehalfby() {
        return new KnowledgearticleviewsCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticleviews_createdonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileitemRequest lk_mobileofflineprofileitem_createdonbehalfby(UUID mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("lk_mobileofflineprofileitem_createdonbehalfby").addKeys(new NameValue(mobileofflineprofileitemid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest lk_mobileofflineprofileitem_createdonbehalfby() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitem_createdonbehalfby"), Optional.empty());
    }

    public AnnotationRequest lk_annotationbase_createdby(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("lk_annotationbase_createdby").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest lk_annotationbase_createdby() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("lk_annotationbase_createdby"), Optional.empty());
    }

    public PlugintypeRequest lk_plugintype_createdonbehalfby(UUID plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("lk_plugintype_createdonbehalfby").addKeys(new NameValue(plugintypeid, UUID.class)), Optional.empty());
    }

    public PlugintypeCollectionRequest lk_plugintype_createdonbehalfby() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("lk_plugintype_createdonbehalfby"), Optional.empty());
    }

    public ConnectionroleRequest createdby_connection_role(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("createdby_connection_role").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest createdby_connection_role() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("createdby_connection_role"), Optional.empty());
    }

    public CustomeraddressRequest lk_customeraddressbase_createdby(UUID customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("lk_customeraddressbase_createdby").addKeys(new NameValue(customeraddressid, UUID.class)), Optional.empty());
    }

    public CustomeraddressCollectionRequest lk_customeraddressbase_createdby() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("lk_customeraddressbase_createdby"), Optional.empty());
    }

    public TimezonedefinitionRequest lk_timezonedefinition_createdby(UUID timezonedefinitionid) {
        return new TimezonedefinitionRequest(contextPath.addSegment("lk_timezonedefinition_createdby").addKeys(new NameValue(timezonedefinitionid, UUID.class)), Optional.empty());
    }

    public TimezonedefinitionCollectionRequest lk_timezonedefinition_createdby() {
        return new TimezonedefinitionCollectionRequest(
                        contextPath.addSegment("lk_timezonedefinition_createdby"), Optional.empty());
    }

    public DocumenttemplateRequest lk_documenttemplatebase_createdonbehalfby(UUID documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("lk_documenttemplatebase_createdonbehalfby").addKeys(new NameValue(documenttemplateid, UUID.class)), Optional.empty());
    }

    public DocumenttemplateCollectionRequest lk_documenttemplatebase_createdonbehalfby() {
        return new DocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_documenttemplatebase_createdonbehalfby"), Optional.empty());
    }

    public RecurringappointmentmasterRequest lk_recurringappointmentmaster_createdonbehalfby(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("lk_recurringappointmentmaster_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest lk_recurringappointmentmaster_createdonbehalfby() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("lk_recurringappointmentmaster_createdonbehalfby"), Optional.empty());
    }

    public PersonaldocumenttemplateRequest lk_personaldocumenttemplatebase_createdby(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("lk_personaldocumenttemplatebase_createdby").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public PersonaldocumenttemplateCollectionRequest lk_personaldocumenttemplatebase_createdby() {
        return new PersonaldocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_personaldocumenttemplatebase_createdby"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest lk_semiannualfiscalcalendar_createdonbehalfby(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("lk_semiannualfiscalcalendar_createdonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public SemiannualfiscalcalendarCollectionRequest lk_semiannualfiscalcalendar_createdonbehalfby() {
        return new SemiannualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_semiannualfiscalcalendar_createdonbehalfby"), Optional.empty());
    }

    public DuplicaterecordRequest systemUser_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SystemUser_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest systemUser_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SystemUser_DuplicateBaseRecord"), Optional.empty());
    }

    public MailboxtrackingfolderRequest lk_mailboxtrackingfolder_modifiedonbehalfby(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("lk_mailboxtrackingfolder_modifiedonbehalfby").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest lk_mailboxtrackingfolder_modifiedonbehalfby() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("lk_mailboxtrackingfolder_modifiedonbehalfby"), Optional.empty());
    }

    public RecurringappointmentmasterRequest lk_recurringappointmentmaster_createdby(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("lk_recurringappointmentmaster_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest lk_recurringappointmentmaster_createdby() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("lk_recurringappointmentmaster_createdby"), Optional.empty());
    }

    public SharepointsiteRequest lk_sharepointsitebase_createdby(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("lk_sharepointsitebase_createdby").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest lk_sharepointsitebase_createdby() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("lk_sharepointsitebase_createdby"), Optional.empty());
    }

    public PhonecallRequest lk_phonecall_modifiedonbehalfby(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("lk_phonecall_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest lk_phonecall_modifiedonbehalfby() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("lk_phonecall_modifiedonbehalfby"), Optional.empty());
    }

    public KbarticlecommentRequest lk_kbarticlecommentbase_createdby(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("lk_kbarticlecommentbase_createdby").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public KbarticlecommentCollectionRequest lk_kbarticlecommentbase_createdby() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("lk_kbarticlecommentbase_createdby"), Optional.empty());
    }

    public RecurrenceruleRequest lk_recurrencerulebase_modifiedonbehalfby(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("lk_recurrencerulebase_modifiedonbehalfby").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest lk_recurrencerulebase_modifiedonbehalfby() {
        return new RecurrenceruleCollectionRequest(
                        contextPath.addSegment("lk_recurrencerulebase_modifiedonbehalfby"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest lk_quarterlyfiscalcalendar_modifiedby(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("lk_quarterlyfiscalcalendar_modifiedby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public QuarterlyfiscalcalendarCollectionRequest lk_quarterlyfiscalcalendar_modifiedby() {
        return new QuarterlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_quarterlyfiscalcalendar_modifiedby"), Optional.empty());
    }

    public SolutioncomponentRequest lk_solutioncomponentbase_modifiedonbehalfby(UUID solutioncomponentid) {
        return new SolutioncomponentRequest(contextPath.addSegment("lk_solutioncomponentbase_modifiedonbehalfby").addKeys(new NameValue(solutioncomponentid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentCollectionRequest lk_solutioncomponentbase_modifiedonbehalfby() {
        return new SolutioncomponentCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentbase_modifiedonbehalfby"), Optional.empty());
    }

    public RoleRequest lk_role_modifiedonbehalfby(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("lk_role_modifiedonbehalfby").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest lk_role_modifiedonbehalfby() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("lk_role_modifiedonbehalfby"), Optional.empty());
    }

    public DuplicateruleRequest lk_duplicaterulebase_modifiedby(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("lk_duplicaterulebase_modifiedby").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest lk_duplicaterulebase_modifiedby() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("lk_duplicaterulebase_modifiedby"), Optional.empty());
    }

    public SubjectRequest lk_subjectbase_createdby(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("lk_subjectbase_createdby").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public SubjectCollectionRequest lk_subjectbase_createdby() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("lk_subjectbase_createdby"), Optional.empty());
    }

    public ContactRequest lk_contact_createdonbehalfby(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("lk_contact_createdonbehalfby").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest lk_contact_createdonbehalfby() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("lk_contact_createdonbehalfby"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest lk_semiannualfiscalcalendar_createdby(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("lk_semiannualfiscalcalendar_createdby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public SemiannualfiscalcalendarCollectionRequest lk_semiannualfiscalcalendar_createdby() {
        return new SemiannualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_semiannualfiscalcalendar_createdby"), Optional.empty());
    }

    public SocialprofileRequest lk_SocialProfile_modifiedonbehalfby(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("lk_SocialProfile_modifiedonbehalfby").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public SocialprofileCollectionRequest lk_SocialProfile_modifiedonbehalfby() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("lk_SocialProfile_modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest lk_systemuserbase_modifiedby(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("lk_systemuserbase_modifiedby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest lk_systemuserbase_modifiedby() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("lk_systemuserbase_modifiedby"), Optional.empty());
    }

    public KnowledgearticleviewsRequest lk_knowledgearticleviews_modifiedonbehalfby(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("lk_knowledgearticleviews_modifiedonbehalfby").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleviewsCollectionRequest lk_knowledgearticleviews_modifiedonbehalfby() {
        return new KnowledgearticleviewsCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticleviews_modifiedonbehalfby"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsessionbase_modifiedonbehalfby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsessionbase_modifiedonbehalfby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsessionbase_modifiedonbehalfby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsessionbase_modifiedonbehalfby"), Optional.empty());
    }

    public LookupmappingRequest lk_lookupmapping_createdby(UUID lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("lk_lookupmapping_createdby").addKeys(new NameValue(lookupmappingid, UUID.class)), Optional.empty());
    }

    public LookupmappingCollectionRequest lk_lookupmapping_createdby() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("lk_lookupmapping_createdby"), Optional.empty());
    }

    public ImportentitymappingRequest lk_importentitymapping_createdby(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("lk_importentitymapping_createdby").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public ImportentitymappingCollectionRequest lk_importentitymapping_createdby() {
        return new ImportentitymappingCollectionRequest(
                        contextPath.addSegment("lk_importentitymapping_createdby"), Optional.empty());
    }

    public KbarticlecommentRequest lk_kbarticlecomment_createdonbehalfby(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("lk_kbarticlecomment_createdonbehalfby").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public KbarticlecommentCollectionRequest lk_kbarticlecomment_createdonbehalfby() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("lk_kbarticlecomment_createdonbehalfby"), Optional.empty());
    }

    public TeamRequest lk_team_modifiedonbehalfby(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("lk_team_modifiedonbehalfby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest lk_team_modifiedonbehalfby() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("lk_team_modifiedonbehalfby"), Optional.empty());
    }

    public TeamtemplateRequest lk_teamtemplate_modifiedonbehalfby(UUID teamtemplateid) {
        return new TeamtemplateRequest(contextPath.addSegment("lk_teamtemplate_modifiedonbehalfby").addKeys(new NameValue(teamtemplateid, UUID.class)), Optional.empty());
    }

    public TeamtemplateCollectionRequest lk_teamtemplate_modifiedonbehalfby() {
        return new TeamtemplateCollectionRequest(
                        contextPath.addSegment("lk_teamtemplate_modifiedonbehalfby"), Optional.empty());
    }

    public FaxRequest lk_fax_createdby(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("lk_fax_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest lk_fax_createdby() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("lk_fax_createdby"), Optional.empty());
    }

    public DisplaystringRequest lk_DisplayStringbase_createdby(UUID displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("lk_DisplayStringbase_createdby").addKeys(new NameValue(displaystringid, UUID.class)), Optional.empty());
    }

    public DisplaystringCollectionRequest lk_DisplayStringbase_createdby() {
        return new DisplaystringCollectionRequest(
                        contextPath.addSegment("lk_DisplayStringbase_createdby"), Optional.empty());
    }

    public PublisheraddressRequest lk_publisheraddressbase_createdby(UUID publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("lk_publisheraddressbase_createdby").addKeys(new NameValue(publisheraddressid, UUID.class)), Optional.empty());
    }

    public PublisheraddressCollectionRequest lk_publisheraddressbase_createdby() {
        return new PublisheraddressCollectionRequest(
                        contextPath.addSegment("lk_publisheraddressbase_createdby"), Optional.empty());
    }

    public TemplateRequest lk_templatebase_modifiedby(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("lk_templatebase_modifiedby").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest lk_templatebase_modifiedby() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("lk_templatebase_modifiedby"), Optional.empty());
    }

    public ActivitypointerRequest user_activity(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("user_activity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest user_activity() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("user_activity"), Optional.empty());
    }

    public MobileofflineprofileRequest lk_MobileOfflineProfile_modifiedonbehalfby(UUID mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("lk_MobileOfflineProfile_modifiedonbehalfby").addKeys(new NameValue(mobileofflineprofileid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileCollectionRequest lk_MobileOfflineProfile_modifiedonbehalfby() {
        return new MobileofflineprofileCollectionRequest(
                        contextPath.addSegment("lk_MobileOfflineProfile_modifiedonbehalfby"), Optional.empty());
    }

    public FaxRequest lk_fax_createdonbehalfby(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("lk_fax_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest lk_fax_createdonbehalfby() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("lk_fax_createdonbehalfby"), Optional.empty());
    }

    public LookupmappingRequest lk_lookupmapping_modifiedonbehalfby(UUID lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("lk_lookupmapping_modifiedonbehalfby").addKeys(new NameValue(lookupmappingid, UUID.class)), Optional.empty());
    }

    public LookupmappingCollectionRequest lk_lookupmapping_modifiedonbehalfby() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("lk_lookupmapping_modifiedonbehalfby"), Optional.empty());
    }

    public BulkdeletefailureRequest systemUser_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("SystemUser_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest systemUser_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("SystemUser_BulkDeleteFailures"), Optional.empty());
    }

    public OrganizationRequest organizationid_organization() {
        return new OrganizationRequest(contextPath.addSegment("organizationid_organization"), Optional.empty());
    }

    public CustomeraddressRequest lk_customeraddress_createdonbehalfby(UUID customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("lk_customeraddress_createdonbehalfby").addKeys(new NameValue(customeraddressid, UUID.class)), Optional.empty());
    }

    public CustomeraddressCollectionRequest lk_customeraddress_createdonbehalfby() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("lk_customeraddress_createdonbehalfby"), Optional.empty());
    }

    public CalendarruleRequest lk_calendarrule_modifiedby(UUID calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("lk_calendarrule_modifiedby").addKeys(new NameValue(calendarruleid, UUID.class)), Optional.empty());
    }

    public CalendarruleCollectionRequest lk_calendarrule_modifiedby() {
        return new CalendarruleCollectionRequest(
                        contextPath.addSegment("lk_calendarrule_modifiedby"), Optional.empty());
    }

    public AccountRequest system_user_accounts(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("system_user_accounts").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest system_user_accounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("system_user_accounts"), Optional.empty());
    }

    public SavedqueryvisualizationRequest lk_savedqueryvisualizationbase_createdby(UUID savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("lk_savedqueryvisualizationbase_createdby").addKeys(new NameValue(savedqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest lk_savedqueryvisualizationbase_createdby() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_savedqueryvisualizationbase_createdby"), Optional.empty());
    }

    public ColumnmappingRequest lk_columnmapping_createdby(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("lk_columnmapping_createdby").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public ColumnmappingCollectionRequest lk_columnmapping_createdby() {
        return new ColumnmappingCollectionRequest(
                        contextPath.addSegment("lk_columnmapping_createdby"), Optional.empty());
    }

    public ConnectionRequest lk_connectionbase_createdonbehalfby(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("lk_connectionbase_createdonbehalfby").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest lk_connectionbase_createdonbehalfby() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("lk_connectionbase_createdonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest impersonatinguserid_sdkmessageprocessingstep(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("impersonatinguserid_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest impersonatinguserid_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("impersonatinguserid_sdkmessageprocessingstep"), Optional.empty());
    }

    public UserqueryRequest lk_userquery_createdonbehalfby(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("lk_userquery_createdonbehalfby").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest lk_userquery_createdonbehalfby() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("lk_userquery_createdonbehalfby"), Optional.empty());
    }

    public AccountRequest lk_accountbase_createdonbehalfby(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("lk_accountbase_createdonbehalfby").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest lk_accountbase_createdonbehalfby() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("lk_accountbase_createdonbehalfby"), Optional.empty());
    }

    public PublisheraddressRequest lk_publisheraddressbase_modifiedonbehalfby(UUID publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("lk_publisheraddressbase_modifiedonbehalfby").addKeys(new NameValue(publisheraddressid, UUID.class)), Optional.empty());
    }

    public PublisheraddressCollectionRequest lk_publisheraddressbase_modifiedonbehalfby() {
        return new PublisheraddressCollectionRequest(
                        contextPath.addSegment("lk_publisheraddressbase_modifiedonbehalfby"), Optional.empty());
    }

    public UserqueryvisualizationRequest lk_userqueryvisualization_modifiedby(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("lk_userqueryvisualization_modifiedby").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest lk_userqueryvisualization_modifiedby() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_userqueryvisualization_modifiedby"), Optional.empty());
    }

    public AppconfigRequest systemuser_appconfig_modifiedby(UUID appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("systemuser_appconfig_modifiedby").addKeys(new NameValue(appconfigid, UUID.class)), Optional.empty());
    }

    public AppconfigCollectionRequest systemuser_appconfig_modifiedby() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("systemuser_appconfig_modifiedby"), Optional.empty());
    }

    public ConnectionroleRequest lk_connectionrolebase_modifiedonbehalfby(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("lk_connectionrolebase_modifiedonbehalfby").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest lk_connectionrolebase_modifiedonbehalfby() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("lk_connectionrolebase_modifiedonbehalfby"), Optional.empty());
    }

    public CalendarRequest lk_calendar_createdby(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("lk_calendar_createdby").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public CalendarCollectionRequest lk_calendar_createdby() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("lk_calendar_createdby"), Optional.empty());
    }

    public AnnotationRequest annotation_owning_user(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("annotation_owning_user").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest annotation_owning_user() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("annotation_owning_user"), Optional.empty());
    }

    public AppconfigmasterRequest systemuser_appconfigmaster_createdonbehalfby(UUID appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("systemuser_appconfigmaster_createdonbehalfby").addKeys(new NameValue(appconfigmasterid, UUID.class)), Optional.empty());
    }

    public AppconfigmasterCollectionRequest systemuser_appconfigmaster_createdonbehalfby() {
        return new AppconfigmasterCollectionRequest(
                        contextPath.addSegment("systemuser_appconfigmaster_createdonbehalfby"), Optional.empty());
    }

    public NewprocessRequest lk_newprocess_modifiedby(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("lk_newprocess_modifiedby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest lk_newprocess_modifiedby() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("lk_newprocess_modifiedby"), Optional.empty());
    }

    public CalendarRequest calendarid() {
        return new CalendarRequest(contextPath.addSegment("calendarid"), Optional.empty());
    }

    public TracelogRequest lk_tracelog_createdonbehalfby(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("lk_tracelog_createdonbehalfby").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest lk_tracelog_createdonbehalfby() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("lk_tracelog_createdonbehalfby"), Optional.empty());
    }

    public MailboxtrackingfolderRequest lk_mailboxtrackingfolder_createdonbehalfby(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("lk_mailboxtrackingfolder_createdonbehalfby").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest lk_mailboxtrackingfolder_createdonbehalfby() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("lk_mailboxtrackingfolder_createdonbehalfby"), Optional.empty());
    }

    public CategoryRequest lk_category_modifiedonbehalfby(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("lk_category_modifiedonbehalfby").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest lk_category_modifiedonbehalfby() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("lk_category_modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest lk_asyncoperation_createdby(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("lk_asyncoperation_createdby").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest lk_asyncoperation_createdby() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("lk_asyncoperation_createdby"), Optional.empty());
    }

    public AppmoduleRequest systemuser_appmodule_createdby(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("systemuser_appmodule_createdby").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest systemuser_appmodule_createdby() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("systemuser_appmodule_createdby"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_createdby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_createdby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_createdby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_createdby"), Optional.empty());
    }

    public AuditRequest lk_audit_callinguserid(UUID auditid) {
        return new AuditRequest(contextPath.addSegment("lk_audit_callinguserid").addKeys(new NameValue(auditid, UUID.class)), Optional.empty());
    }

    public AuditCollectionRequest lk_audit_callinguserid() {
        return new AuditCollectionRequest(
                        contextPath.addSegment("lk_audit_callinguserid"), Optional.empty());
    }

    public ImportRequest systemUser_Imports(UUID importid) {
        return new ImportRequest(contextPath.addSegment("SystemUser_Imports").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest systemUser_Imports() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("SystemUser_Imports"), Optional.empty());
    }

    public TransactioncurrencyRequest lk_transactioncurrency_createdonbehalfby(UUID transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("lk_transactioncurrency_createdonbehalfby").addKeys(new NameValue(transactioncurrencyid, UUID.class)), Optional.empty());
    }

    public TransactioncurrencyCollectionRequest lk_transactioncurrency_createdonbehalfby() {
        return new TransactioncurrencyCollectionRequest(
                        contextPath.addSegment("lk_transactioncurrency_createdonbehalfby"), Optional.empty());
    }

    public ActivitypartyRequest system_user_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("system_user_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest system_user_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("system_user_activity_parties"), Optional.empty());
    }

    public EmailserverprofileRequest lk_emailserverprofile_createdby(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("lk_emailserverprofile_createdby").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest lk_emailserverprofile_createdby() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("lk_emailserverprofile_createdby"), Optional.empty());
    }

    public SlaitemRequest lk_slaitembase_createdonbehalfby(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("lk_slaitembase_createdonbehalfby").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public SlaitemCollectionRequest lk_slaitembase_createdonbehalfby() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("lk_slaitembase_createdonbehalfby"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest lk_businessunitnewsarticlebase_createdby(UUID businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("lk_businessunitnewsarticlebase_createdby").addKeys(new NameValue(businessunitnewsarticleid, UUID.class)), Optional.empty());
    }

    public BusinessunitnewsarticleCollectionRequest lk_businessunitnewsarticlebase_createdby() {
        return new BusinessunitnewsarticleCollectionRequest(
                        contextPath.addSegment("lk_businessunitnewsarticlebase_createdby"), Optional.empty());
    }

    public PluginassemblyRequest lk_pluginassembly_modifiedonbehalfby(UUID pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("lk_pluginassembly_modifiedonbehalfby").addKeys(new NameValue(pluginassemblyid, UUID.class)), Optional.empty());
    }

    public PluginassemblyCollectionRequest lk_pluginassembly_modifiedonbehalfby() {
        return new PluginassemblyCollectionRequest(
                        contextPath.addSegment("lk_pluginassembly_modifiedonbehalfby"), Optional.empty());
    }

    public ContactRequest lk_contact_modifiedonbehalfby(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("lk_contact_modifiedonbehalfby").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest lk_contact_modifiedonbehalfby() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("lk_contact_modifiedonbehalfby"), Optional.empty());
    }

    public SubjectRequest lk_subjectbase_modifiedby(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("lk_subjectbase_modifiedby").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public SubjectCollectionRequest lk_subjectbase_modifiedby() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("lk_subjectbase_modifiedby"), Optional.empty());
    }

    public PhonecallRequest lk_phonecall_createdby(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("lk_phonecall_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest lk_phonecall_createdby() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("lk_phonecall_createdby"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest lk_quarterlyfiscalcalendar_createdby(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("lk_quarterlyfiscalcalendar_createdby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public QuarterlyfiscalcalendarCollectionRequest lk_quarterlyfiscalcalendar_createdby() {
        return new QuarterlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_quarterlyfiscalcalendar_createdby"), Optional.empty());
    }

    public ActioncardRequest lk_actioncardbase_modifiedonbehalfby(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("lk_actioncardbase_modifiedonbehalfby").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest lk_actioncardbase_modifiedonbehalfby() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("lk_actioncardbase_modifiedonbehalfby"), Optional.empty());
    }

    public TracelogRequest lk_tracelog_modifiedonbehalfby(UUID tracelogid) {
        return new TracelogRequest(contextPath.addSegment("lk_tracelog_modifiedonbehalfby").addKeys(new NameValue(tracelogid, UUID.class)), Optional.empty());
    }

    public TracelogCollectionRequest lk_tracelog_modifiedonbehalfby() {
        return new TracelogCollectionRequest(
                        contextPath.addSegment("lk_tracelog_modifiedonbehalfby"), Optional.empty());
    }

    public AppmodulecomponentRequest lk_appmodulecomponent_modifiedonbehalfby(UUID appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("lk_appmodulecomponent_modifiedonbehalfby").addKeys(new NameValue(appmodulecomponentid, UUID.class)), Optional.empty());
    }

    public AppmodulecomponentCollectionRequest lk_appmodulecomponent_modifiedonbehalfby() {
        return new AppmodulecomponentCollectionRequest(
                        contextPath.addSegment("lk_appmodulecomponent_modifiedonbehalfby"), Optional.empty());
    }

    public SubjectRequest lk_subject_modifiedonbehalfby(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("lk_subject_modifiedonbehalfby").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public SubjectCollectionRequest lk_subject_modifiedonbehalfby() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("lk_subject_modifiedonbehalfby"), Optional.empty());
    }

    public CustomcontrolresourceRequest lk_customcontrolresource_createdby(UUID customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("lk_customcontrolresource_createdby").addKeys(new NameValue(customcontrolresourceid, UUID.class)), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest lk_customcontrolresource_createdby() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("lk_customcontrolresource_createdby"), Optional.empty());
    }

    public PicklistmappingRequest lk_picklistmapping_createdonbehalfby(UUID picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("lk_picklistmapping_createdonbehalfby").addKeys(new NameValue(picklistmappingid, UUID.class)), Optional.empty());
    }

    public PicklistmappingCollectionRequest lk_picklistmapping_createdonbehalfby() {
        return new PicklistmappingCollectionRequest(
                        contextPath.addSegment("lk_picklistmapping_createdonbehalfby"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest lk_fixedmonthlyfiscalcalendar_createdonbehalfby(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_createdonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarCollectionRequest lk_fixedmonthlyfiscalcalendar_createdonbehalfby() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_createdonbehalfby"), Optional.empty());
    }

    public SdkmessagefilterRequest modifiedby_sdkmessagefilter(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("modifiedby_sdkmessagefilter").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest modifiedby_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("modifiedby_sdkmessagefilter"), Optional.empty());
    }

    public SharepointsiteRequest lk_sharepointsitebase_createdonbehalfby(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("lk_sharepointsitebase_createdonbehalfby").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest lk_sharepointsitebase_createdonbehalfby() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("lk_sharepointsitebase_createdonbehalfby"), Optional.empty());
    }

    public ReportcategoryRequest lk_reportcategory_createdonbehalfby(UUID reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("lk_reportcategory_createdonbehalfby").addKeys(new NameValue(reportcategoryid, UUID.class)), Optional.empty());
    }

    public ReportcategoryCollectionRequest lk_reportcategory_createdonbehalfby() {
        return new ReportcategoryCollectionRequest(
                        contextPath.addSegment("lk_reportcategory_createdonbehalfby"), Optional.empty());
    }

    public TemplateRequest lk_templatebase_createdonbehalfby(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("lk_templatebase_createdonbehalfby").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest lk_templatebase_createdonbehalfby() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("lk_templatebase_createdonbehalfby"), Optional.empty());
    }

    public EmailRequest user_email(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("user_email").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest user_email() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("user_email"), Optional.empty());
    }

    public FaxRequest user_fax(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("user_fax").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest user_fax() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("user_fax"), Optional.empty());
    }

    public FeedbackRequest lk_feedback_modifiedby(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_feedback_modifiedby").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest lk_feedback_modifiedby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_feedback_modifiedby"), Optional.empty());
    }

    public ContactRequest lk_contactbase_createdby(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("lk_contactbase_createdby").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest lk_contactbase_createdby() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("lk_contactbase_createdby"), Optional.empty());
    }

    public TimezonelocalizednameRequest lk_timezonelocalizedname_modifiedonbehalfby(UUID timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("lk_timezonelocalizedname_modifiedonbehalfby").addKeys(new NameValue(timezonelocalizednameid, UUID.class)), Optional.empty());
    }

    public TimezonelocalizednameCollectionRequest lk_timezonelocalizedname_modifiedonbehalfby() {
        return new TimezonelocalizednameCollectionRequest(
                        contextPath.addSegment("lk_timezonelocalizedname_modifiedonbehalfby"), Optional.empty());
    }

    public EmailRequest lk_email_modifiedby(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("lk_email_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest lk_email_modifiedby() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("lk_email_modifiedby"), Optional.empty());
    }

    public PhonecallRequest lk_phonecall_createdonbehalfby(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("lk_phonecall_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest lk_phonecall_createdonbehalfby() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("lk_phonecall_createdonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest lk_businessunitbase_createdby(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("lk_businessunitbase_createdby").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest lk_businessunitbase_createdby() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("lk_businessunitbase_createdby"), Optional.empty());
    }

    public CategoryRequest lk_category_createdonbehalfby(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("lk_category_createdonbehalfby").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest lk_category_createdonbehalfby() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("lk_category_createdonbehalfby"), Optional.empty());
    }

    public SlakpiinstanceRequest lk_slakpiinstancebase_modifiedby(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("lk_slakpiinstancebase_modifiedby").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest lk_slakpiinstancebase_modifiedby() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("lk_slakpiinstancebase_modifiedby"), Optional.empty());
    }

    public QueueRequest queue_primary_user(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("queue_primary_user").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest queue_primary_user() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("queue_primary_user"), Optional.empty());
    }

    public ImportjobRequest lk_importjobbase_modifiedonbehalfby(UUID importjobid) {
        return new ImportjobRequest(contextPath.addSegment("lk_importjobbase_modifiedonbehalfby").addKeys(new NameValue(importjobid, UUID.class)), Optional.empty());
    }

    public ImportjobCollectionRequest lk_importjobbase_modifiedonbehalfby() {
        return new ImportjobCollectionRequest(
                        contextPath.addSegment("lk_importjobbase_modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest systemUser_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("SystemUser_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest systemUser_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("SystemUser_AsyncOperations"), Optional.empty());
    }

    public OrganizationRequest lk_organization_createdonbehalfby(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("lk_organization_createdonbehalfby").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest lk_organization_createdonbehalfby() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("lk_organization_createdonbehalfby"), Optional.empty());
    }

    public DisplaystringRequest lk_DisplayStringbase_createdonbehalfby(UUID displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("lk_DisplayStringbase_createdonbehalfby").addKeys(new NameValue(displaystringid, UUID.class)), Optional.empty());
    }

    public DisplaystringCollectionRequest lk_DisplayStringbase_createdonbehalfby() {
        return new DisplaystringCollectionRequest(
                        contextPath.addSegment("lk_DisplayStringbase_createdonbehalfby"), Optional.empty());
    }

    public CalendarruleRequest lk_calendarrule_modifiedonbehalfby(UUID calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("lk_calendarrule_modifiedonbehalfby").addKeys(new NameValue(calendarruleid, UUID.class)), Optional.empty());
    }

    public CalendarruleCollectionRequest lk_calendarrule_modifiedonbehalfby() {
        return new CalendarruleCollectionRequest(
                        contextPath.addSegment("lk_calendarrule_modifiedonbehalfby"), Optional.empty());
    }

    public ImportjobRequest lk_importjobbase_createdby(UUID importjobid) {
        return new ImportjobRequest(contextPath.addSegment("lk_importjobbase_createdby").addKeys(new NameValue(importjobid, UUID.class)), Optional.empty());
    }

    public ImportjobCollectionRequest lk_importjobbase_createdby() {
        return new ImportjobCollectionRequest(
                        contextPath.addSegment("lk_importjobbase_createdby"), Optional.empty());
    }

    public ImportfileRequest systemUser_ImportFiles(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("SystemUser_ImportFiles").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest systemUser_ImportFiles() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("SystemUser_ImportFiles"), Optional.empty());
    }

    public ColumnmappingRequest lk_columnmapping_createdonbehalfby(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("lk_columnmapping_createdonbehalfby").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public ColumnmappingCollectionRequest lk_columnmapping_createdonbehalfby() {
        return new ColumnmappingCollectionRequest(
                        contextPath.addSegment("lk_columnmapping_createdonbehalfby"), Optional.empty());
    }

    public ImportfileRequest lk_importfilebase_modifiedonbehalfby(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("lk_importfilebase_modifiedonbehalfby").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest lk_importfilebase_modifiedonbehalfby() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("lk_importfilebase_modifiedonbehalfby"), Optional.empty());
    }

    public MailboxtrackingfolderRequest lk_mailboxtrackingfolder_createdby(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("lk_mailboxtrackingfolder_createdby").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest lk_mailboxtrackingfolder_createdby() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("lk_mailboxtrackingfolder_createdby"), Optional.empty());
    }

    public SocialprofileRequest socialProfile_owning_user(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("socialProfile_owning_user").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public SocialprofileCollectionRequest socialProfile_owning_user() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("socialProfile_owning_user"), Optional.empty());
    }

    public AppmodulecomponentRequest lk_appmodulecomponent_createdonbehalfby(UUID appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("lk_appmodulecomponent_createdonbehalfby").addKeys(new NameValue(appmodulecomponentid, UUID.class)), Optional.empty());
    }

    public AppmodulecomponentCollectionRequest lk_appmodulecomponent_createdonbehalfby() {
        return new AppmodulecomponentCollectionRequest(
                        contextPath.addSegment("lk_appmodulecomponent_createdonbehalfby"), Optional.empty());
    }

    public AciviewmapperRequest lk_ACIViewMapper_createdonbehalfby(UUID aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("lk_ACIViewMapper_createdonbehalfby").addKeys(new NameValue(aciviewmapperid, UUID.class)), Optional.empty());
    }

    public AciviewmapperCollectionRequest lk_ACIViewMapper_createdonbehalfby() {
        return new AciviewmapperCollectionRequest(
                        contextPath.addSegment("lk_ACIViewMapper_createdonbehalfby"), Optional.empty());
    }

    public BusinessunitRequest lk_businessunit_modifiedonbehalfby(UUID businessunitid) {
        return new BusinessunitRequest(contextPath.addSegment("lk_businessunit_modifiedonbehalfby").addKeys(new NameValue(businessunitid, UUID.class)), Optional.empty());
    }

    public BusinessunitCollectionRequest lk_businessunit_modifiedonbehalfby() {
        return new BusinessunitCollectionRequest(
                        contextPath.addSegment("lk_businessunit_modifiedonbehalfby"), Optional.empty());
    }

    public AppointmentRequest lk_appointment_modifiedonbehalfby(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("lk_appointment_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest lk_appointment_modifiedonbehalfby() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("lk_appointment_modifiedonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepimageRequest lk_sdkmessageprocessingstepimage_modifiedonbehalfby(UUID sdkmessageprocessingstepimageid) {
        return new SdkmessageprocessingstepimageRequest(contextPath.addSegment("lk_sdkmessageprocessingstepimage_modifiedonbehalfby").addKeys(new NameValue(sdkmessageprocessingstepimageid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepimageCollectionRequest lk_sdkmessageprocessingstepimage_modifiedonbehalfby() {
        return new SdkmessageprocessingstepimageCollectionRequest(
                        contextPath.addSegment("lk_sdkmessageprocessingstepimage_modifiedonbehalfby"), Optional.empty());
    }

    public KbarticletemplateRequest lk_kbarticletemplate_createdonbehalfby(UUID kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("lk_kbarticletemplate_createdonbehalfby").addKeys(new NameValue(kbarticletemplateid, UUID.class)), Optional.empty());
    }

    public KbarticletemplateCollectionRequest lk_kbarticletemplate_createdonbehalfby() {
        return new KbarticletemplateCollectionRequest(
                        contextPath.addSegment("lk_kbarticletemplate_createdonbehalfby"), Optional.empty());
    }

    public DocumenttemplateRequest lk_documenttemplatebase_modifiedonbehalfby(UUID documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("lk_documenttemplatebase_modifiedonbehalfby").addKeys(new NameValue(documenttemplateid, UUID.class)), Optional.empty());
    }

    public DocumenttemplateCollectionRequest lk_documenttemplatebase_modifiedonbehalfby() {
        return new DocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_documenttemplatebase_modifiedonbehalfby"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_executedby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_executedby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_executedby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_executedby"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest lk_sdkmessageprocessingstep_modifiedonbehalfby(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("lk_sdkmessageprocessingstep_modifiedonbehalfby").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest lk_sdkmessageprocessingstep_modifiedonbehalfby() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("lk_sdkmessageprocessingstep_modifiedonbehalfby"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest lk_monthlyfiscalcalendar_createdby(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("lk_monthlyfiscalcalendar_createdby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public MonthlyfiscalcalendarCollectionRequest lk_monthlyfiscalcalendar_createdby() {
        return new MonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_monthlyfiscalcalendar_createdby"), Optional.empty());
    }

    public SyncerrorRequest lk_syncerrorbase_modifiedby(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("lk_syncerrorbase_modifiedby").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest lk_syncerrorbase_modifiedby() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("lk_syncerrorbase_modifiedby"), Optional.empty());
    }

    public AppconfigRequest systemuser_appconfig_modifiedonbehalfby(UUID appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("systemuser_appconfig_modifiedonbehalfby").addKeys(new NameValue(appconfigid, UUID.class)), Optional.empty());
    }

    public AppconfigCollectionRequest systemuser_appconfig_modifiedonbehalfby() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("systemuser_appconfig_modifiedonbehalfby"), Optional.empty());
    }

    public ReportRequest lk_reportbase_createdby(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("lk_reportbase_createdby").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public ReportCollectionRequest lk_reportbase_createdby() {
        return new ReportCollectionRequest(
                        contextPath.addSegment("lk_reportbase_createdby"), Optional.empty());
    }

    public DocumenttemplateRequest lk_documenttemplatebase_createdby(UUID documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("lk_documenttemplatebase_createdby").addKeys(new NameValue(documenttemplateid, UUID.class)), Optional.empty());
    }

    public DocumenttemplateCollectionRequest lk_documenttemplatebase_createdby() {
        return new DocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_documenttemplatebase_createdby"), Optional.empty());
    }

    public SubjectRequest lk_subject_createdonbehalfby(UUID subjectid) {
        return new SubjectRequest(contextPath.addSegment("lk_subject_createdonbehalfby").addKeys(new NameValue(subjectid, UUID.class)), Optional.empty());
    }

    public SubjectCollectionRequest lk_subject_createdonbehalfby() {
        return new SubjectCollectionRequest(
                        contextPath.addSegment("lk_subject_createdonbehalfby"), Optional.empty());
    }

    public RecurringappointmentmasterRequest lk_recurringappointmentmaster_modifiedonbehalfby(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("lk_recurringappointmentmaster_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest lk_recurringappointmentmaster_modifiedonbehalfby() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("lk_recurringappointmentmaster_modifiedonbehalfby"), Optional.empty());
    }

    public ReportRequest lk_reportbase_modifiedby(UUID reportid) {
        return new ReportRequest(contextPath.addSegment("lk_reportbase_modifiedby").addKeys(new NameValue(reportid, UUID.class)), Optional.empty());
    }

    public ReportCollectionRequest lk_reportbase_modifiedby() {
        return new ReportCollectionRequest(
                        contextPath.addSegment("lk_reportbase_modifiedby"), Optional.empty());
    }

    public UserformRequest lk_userformbase_modifiedonbehalfby(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("lk_userformbase_modifiedonbehalfby").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest lk_userformbase_modifiedonbehalfby() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("lk_userformbase_modifiedonbehalfby"), Optional.empty());
    }

    public BulkdeleteoperationRequest lk_bulkdeleteoperationbase_createdby(UUID bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("lk_bulkdeleteoperationbase_createdby").addKeys(new NameValue(bulkdeleteoperationid, UUID.class)), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest lk_bulkdeleteoperationbase_createdby() {
        return new BulkdeleteoperationCollectionRequest(
                        contextPath.addSegment("lk_bulkdeleteoperationbase_createdby"), Optional.empty());
    }

    public TransformationmappingRequest lk_transformationmapping_modifiedonbehalfby(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("lk_transformationmapping_modifiedonbehalfby").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public TransformationmappingCollectionRequest lk_transformationmapping_modifiedonbehalfby() {
        return new TransformationmappingCollectionRequest(
                        contextPath.addSegment("lk_transformationmapping_modifiedonbehalfby"), Optional.empty());
    }

    public FeedbackRequest lk_feedback_modifiedonbehalfby(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_feedback_modifiedonbehalfby").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest lk_feedback_modifiedonbehalfby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_feedback_modifiedonbehalfby"), Optional.empty());
    }

    public SlaRequest lk_slabase_modifiedby(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("lk_slabase_modifiedby").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest lk_slabase_modifiedby() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("lk_slabase_modifiedby"), Optional.empty());
    }

    public PersonaldocumenttemplateRequest lk_personaldocumenttemplatebase_createdonbehalfby(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("lk_personaldocumenttemplatebase_createdonbehalfby").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public PersonaldocumenttemplateCollectionRequest lk_personaldocumenttemplatebase_createdonbehalfby() {
        return new PersonaldocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_personaldocumenttemplatebase_createdonbehalfby"), Optional.empty());
    }

    public ActivitypointerRequest lk_activitypointer_modifiedonbehalfby(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("lk_activitypointer_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest lk_activitypointer_modifiedonbehalfby() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("lk_activitypointer_modifiedonbehalfby"), Optional.empty());
    }

    public SocialactivityRequest lk_socialactivity_createdby(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("lk_socialactivity_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest lk_socialactivity_createdby() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("lk_socialactivity_createdby"), Optional.empty());
    }

    public NavigationsettingRequest systemuser_navigationsetting_createdonbehalfby(UUID navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("systemuser_navigationsetting_createdonbehalfby").addKeys(new NameValue(navigationsettingid, UUID.class)), Optional.empty());
    }

    public NavigationsettingCollectionRequest systemuser_navigationsetting_createdonbehalfby() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("systemuser_navigationsetting_createdonbehalfby"), Optional.empty());
    }

    public FaxRequest lk_fax_modifiedby(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("lk_fax_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest lk_fax_modifiedby() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("lk_fax_modifiedby"), Optional.empty());
    }

    public UserformRequest lk_userformbase_createdonbehalfby(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("lk_userformbase_createdonbehalfby").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest lk_userformbase_createdonbehalfby() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("lk_userformbase_createdonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest modifiedby_sdkmessageprocessingstep(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("modifiedby_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest modifiedby_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("modifiedby_sdkmessageprocessingstep"), Optional.empty());
    }

    public PlugintypeRequest createdby_plugintype(UUID plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("createdby_plugintype").addKeys(new NameValue(plugintypeid, UUID.class)), Optional.empty());
    }

    public PlugintypeCollectionRequest createdby_plugintype() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("createdby_plugintype"), Optional.empty());
    }

    public SdkmessageRequest lk_sdkmessage_createdonbehalfby(UUID sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("lk_sdkmessage_createdonbehalfby").addKeys(new NameValue(sdkmessageid, UUID.class)), Optional.empty());
    }

    public SdkmessageCollectionRequest lk_sdkmessage_createdonbehalfby() {
        return new SdkmessageCollectionRequest(
                        contextPath.addSegment("lk_sdkmessage_createdonbehalfby"), Optional.empty());
    }

    public CustomcontroldefaultconfigRequest lk_customcontroldefaultconfig_createdonbehalfby(UUID customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("lk_customcontroldefaultconfig_createdonbehalfby").addKeys(new NameValue(customcontroldefaultconfigid, UUID.class)), Optional.empty());
    }

    public CustomcontroldefaultconfigCollectionRequest lk_customcontroldefaultconfig_createdonbehalfby() {
        return new CustomcontroldefaultconfigCollectionRequest(
                        contextPath.addSegment("lk_customcontroldefaultconfig_createdonbehalfby"), Optional.empty());
    }

    public PluginassemblyRequest lk_pluginassembly_createdonbehalfby(UUID pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("lk_pluginassembly_createdonbehalfby").addKeys(new NameValue(pluginassemblyid, UUID.class)), Optional.empty());
    }

    public PluginassemblyCollectionRequest lk_pluginassembly_createdonbehalfby() {
        return new PluginassemblyCollectionRequest(
                        contextPath.addSegment("lk_pluginassembly_createdonbehalfby"), Optional.empty());
    }

    public SdkmessagefilterRequest createdby_sdkmessagefilter(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("createdby_sdkmessagefilter").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest createdby_sdkmessagefilter() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("createdby_sdkmessagefilter"), Optional.empty());
    }

    public KnowledgearticleviewsRequest lk_knowledgearticleviews_modifiedby(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("lk_knowledgearticleviews_modifiedby").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleviewsCollectionRequest lk_knowledgearticleviews_modifiedby() {
        return new KnowledgearticleviewsCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticleviews_modifiedby"), Optional.empty());
    }

    public ConnectionroleRequest lk_connectionrolebase_createdonbehalfby(UUID connectionroleid) {
        return new ConnectionroleRequest(contextPath.addSegment("lk_connectionrolebase_createdonbehalfby").addKeys(new NameValue(connectionroleid, UUID.class)), Optional.empty());
    }

    public ConnectionroleCollectionRequest lk_connectionrolebase_createdonbehalfby() {
        return new ConnectionroleCollectionRequest(
                        contextPath.addSegment("lk_connectionrolebase_createdonbehalfby"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_modifiedonbehalfby(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_modifiedonbehalfby").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_modifiedonbehalfby() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_modifiedonbehalfby"), Optional.empty());
    }

    public FeedbackRequest lk_feedback_closedby(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_feedback_closedby").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest lk_feedback_closedby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_feedback_closedby"), Optional.empty());
    }

    public AppconfigmasterRequest systemuser_appconfigmaster_createdby(UUID appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("systemuser_appconfigmaster_createdby").addKeys(new NameValue(appconfigmasterid, UUID.class)), Optional.empty());
    }

    public AppconfigmasterCollectionRequest systemuser_appconfigmaster_createdby() {
        return new AppconfigmasterCollectionRequest(
                        contextPath.addSegment("systemuser_appconfigmaster_createdby"), Optional.empty());
    }

    public UsersettingsRequest lk_usersettingsbase_modifiedby(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("lk_usersettingsbase_modifiedby").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest lk_usersettingsbase_modifiedby() {
        return new UsersettingsCollectionRequest(
                        contextPath.addSegment("lk_usersettingsbase_modifiedby"), Optional.empty());
    }

    public SharepointdocumentlocationRequest lk_sharepointdocumentlocationbase_createdby(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("lk_sharepointdocumentlocationbase_createdby").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest lk_sharepointdocumentlocationbase_createdby() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("lk_sharepointdocumentlocationbase_createdby"), Optional.empty());
    }

    public FaxRequest lk_fax_modifiedonbehalfby(UUID activityid) {
        return new FaxRequest(contextPath.addSegment("lk_fax_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public FaxCollectionRequest lk_fax_modifiedonbehalfby() {
        return new FaxCollectionRequest(
                        contextPath.addSegment("lk_fax_modifiedonbehalfby"), Optional.empty());
    }

    public FeedbackRequest lk_feedback_createdonbehalfby(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_feedback_createdonbehalfby").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest lk_feedback_createdonbehalfby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_feedback_createdonbehalfby"), Optional.empty());
    }

    public AppconfiginstanceRequest systemuser_appconfiginstance_createdonbehalfby(UUID appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("systemuser_appconfiginstance_createdonbehalfby").addKeys(new NameValue(appconfiginstanceid, UUID.class)), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest systemuser_appconfiginstance_createdonbehalfby() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("systemuser_appconfiginstance_createdonbehalfby"), Optional.empty());
    }

    public SitemapRequest systemuser_SiteMap_createdby(UUID sitemapid) {
        return new SitemapRequest(contextPath.addSegment("systemuser_SiteMap_createdby").addKeys(new NameValue(sitemapid, UUID.class)), Optional.empty());
    }

    public SitemapCollectionRequest systemuser_SiteMap_createdby() {
        return new SitemapCollectionRequest(
                        contextPath.addSegment("systemuser_SiteMap_createdby"), Optional.empty());
    }

    public AsyncoperationRequest lk_asyncoperation_modifiedby(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("lk_asyncoperation_modifiedby").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest lk_asyncoperation_modifiedby() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("lk_asyncoperation_modifiedby"), Optional.empty());
    }

    public SavedqueryRequest lk_savedquery_modifiedonbehalfby(UUID savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("lk_savedquery_modifiedonbehalfby").addKeys(new NameValue(savedqueryid, UUID.class)), Optional.empty());
    }

    public SavedqueryCollectionRequest lk_savedquery_modifiedonbehalfby() {
        return new SavedqueryCollectionRequest(
                        contextPath.addSegment("lk_savedquery_modifiedonbehalfby"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_modifiedby(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_modifiedby").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_modifiedby() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_modifiedby"), Optional.empty());
    }

    public ProcesstriggerRequest lk_processtriggerbase_modifiedonbehalfby(UUID processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("lk_processtriggerbase_modifiedonbehalfby").addKeys(new NameValue(processtriggerid, UUID.class)), Optional.empty());
    }

    public ProcesstriggerCollectionRequest lk_processtriggerbase_modifiedonbehalfby() {
        return new ProcesstriggerCollectionRequest(
                        contextPath.addSegment("lk_processtriggerbase_modifiedonbehalfby"), Optional.empty());
    }

    public WebwizardRequest lk_webwizard_createdonbehalfby(UUID webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("lk_webwizard_createdonbehalfby").addKeys(new NameValue(webwizardid, UUID.class)), Optional.empty());
    }

    public WebwizardCollectionRequest lk_webwizard_createdonbehalfby() {
        return new WebwizardCollectionRequest(
                        contextPath.addSegment("lk_webwizard_createdonbehalfby"), Optional.empty());
    }

    public WebwizardRequest lk_webwizard_modifiedonbehalfby(UUID webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("lk_webwizard_modifiedonbehalfby").addKeys(new NameValue(webwizardid, UUID.class)), Optional.empty());
    }

    public WebwizardCollectionRequest lk_webwizard_modifiedonbehalfby() {
        return new WebwizardCollectionRequest(
                        contextPath.addSegment("lk_webwizard_modifiedonbehalfby"), Optional.empty());
    }

    public AppconfigRequest systemuser_appconfig_createdonbehalfby(UUID appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("systemuser_appconfig_createdonbehalfby").addKeys(new NameValue(appconfigid, UUID.class)), Optional.empty());
    }

    public AppconfigCollectionRequest systemuser_appconfig_createdonbehalfby() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("systemuser_appconfig_createdonbehalfby"), Optional.empty());
    }

    public AppointmentRequest lk_appointment_modifiedby(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("lk_appointment_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest lk_appointment_modifiedby() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("lk_appointment_modifiedby"), Optional.empty());
    }

    public OrganizationRequest lk_organizationbase_createdby(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("lk_organizationbase_createdby").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest lk_organizationbase_createdby() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("lk_organizationbase_createdby"), Optional.empty());
    }

    public TimezonelocalizednameRequest lk_timezonelocalizedname_modifiedby(UUID timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("lk_timezonelocalizedname_modifiedby").addKeys(new NameValue(timezonelocalizednameid, UUID.class)), Optional.empty());
    }

    public TimezonelocalizednameCollectionRequest lk_timezonelocalizedname_modifiedby() {
        return new TimezonelocalizednameCollectionRequest(
                        contextPath.addSegment("lk_timezonelocalizedname_modifiedby"), Optional.empty());
    }

    public ActivitypointerRequest lk_activitypointer_createdonbehalfby(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("lk_activitypointer_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest lk_activitypointer_createdonbehalfby() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("lk_activitypointer_createdonbehalfby"), Optional.empty());
    }

    public DuplicateruleconditionRequest lk_duplicaterulecondition_createdonbehalfby(UUID duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("lk_duplicaterulecondition_createdonbehalfby").addKeys(new NameValue(duplicateruleconditionid, UUID.class)), Optional.empty());
    }

    public DuplicateruleconditionCollectionRequest lk_duplicaterulecondition_createdonbehalfby() {
        return new DuplicateruleconditionCollectionRequest(
                        contextPath.addSegment("lk_duplicaterulecondition_createdonbehalfby"), Optional.empty());
    }

    public MailmergetemplateRequest lk_mailmergetemplate_createdonbehalfby(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("lk_mailmergetemplate_createdonbehalfby").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest lk_mailmergetemplate_createdonbehalfby() {
        return new MailmergetemplateCollectionRequest(
                        contextPath.addSegment("lk_mailmergetemplate_createdonbehalfby"), Optional.empty());
    }

    public ImportdataRequest lk_importdata_modifiedonbehalfby(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("lk_importdata_modifiedonbehalfby").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest lk_importdata_modifiedonbehalfby() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("lk_importdata_modifiedonbehalfby"), Optional.empty());
    }

    public TransformationmappingRequest lk_transformationmapping_createdonbehalfby(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("lk_transformationmapping_createdonbehalfby").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public TransformationmappingCollectionRequest lk_transformationmapping_createdonbehalfby() {
        return new TransformationmappingCollectionRequest(
                        contextPath.addSegment("lk_transformationmapping_createdonbehalfby"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest lk_semiannualfiscalcalendar_salespersonid(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("lk_semiannualfiscalcalendar_salespersonid").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public SemiannualfiscalcalendarCollectionRequest lk_semiannualfiscalcalendar_salespersonid() {
        return new SemiannualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_semiannualfiscalcalendar_salespersonid"), Optional.empty());
    }

    public TransformationparametermappingRequest lk_transformationparametermapping_createdonbehalfby(UUID transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("lk_transformationparametermapping_createdonbehalfby").addKeys(new NameValue(transformationparametermappingid, UUID.class)), Optional.empty());
    }

    public TransformationparametermappingCollectionRequest lk_transformationparametermapping_createdonbehalfby() {
        return new TransformationparametermappingCollectionRequest(
                        contextPath.addSegment("lk_transformationparametermapping_createdonbehalfby"), Optional.empty());
    }

    public ConnectionRequest lk_connectionbase_modifiedonbehalfby(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("lk_connectionbase_modifiedonbehalfby").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest lk_connectionbase_modifiedonbehalfby() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("lk_connectionbase_modifiedonbehalfby"), Optional.empty());
    }

    public PlugintypestatisticRequest lk_plugintypestatisticbase_createdonbehalfby(UUID plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("lk_plugintypestatisticbase_createdonbehalfby").addKeys(new NameValue(plugintypestatisticid, UUID.class)), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest lk_plugintypestatisticbase_createdonbehalfby() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("lk_plugintypestatisticbase_createdonbehalfby"), Optional.empty());
    }

    public TransformationmappingRequest lk_transformationmapping_createdby(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("lk_transformationmapping_createdby").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public TransformationmappingCollectionRequest lk_transformationmapping_createdby() {
        return new TransformationmappingCollectionRequest(
                        contextPath.addSegment("lk_transformationmapping_createdby"), Optional.empty());
    }

    public MobileofflineprofileRequest lk_MobileOfflineProfile_createdby(UUID mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("lk_MobileOfflineProfile_createdby").addKeys(new NameValue(mobileofflineprofileid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileCollectionRequest lk_MobileOfflineProfile_createdby() {
        return new MobileofflineprofileCollectionRequest(
                        contextPath.addSegment("lk_MobileOfflineProfile_createdby"), Optional.empty());
    }

    public SyncerrorRequest lk_syncerrorbase_createdby(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("lk_syncerrorbase_createdby").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest lk_syncerrorbase_createdby() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("lk_syncerrorbase_createdby"), Optional.empty());
    }

    public DocumenttemplateRequest lk_documenttemplatebase_modifiedby(UUID documenttemplateid) {
        return new DocumenttemplateRequest(contextPath.addSegment("lk_documenttemplatebase_modifiedby").addKeys(new NameValue(documenttemplateid, UUID.class)), Optional.empty());
    }

    public DocumenttemplateCollectionRequest lk_documenttemplatebase_modifiedby() {
        return new DocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_documenttemplatebase_modifiedby"), Optional.empty());
    }

    public TaskRequest lk_task_modifiedby(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("lk_task_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest lk_task_modifiedby() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("lk_task_modifiedby"), Optional.empty());
    }

    public KbarticleRequest lk_kbarticlebase_createdby(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("lk_kbarticlebase_createdby").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest lk_kbarticlebase_createdby() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("lk_kbarticlebase_createdby"), Optional.empty());
    }

    public TaskRequest lk_task_createdby(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("lk_task_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest lk_task_createdby() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("lk_task_createdby"), Optional.empty());
    }

    public TranslationprocessRequest lk_translationprocess_modifiedonbehalfby(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("lk_translationprocess_modifiedonbehalfby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest lk_translationprocess_modifiedonbehalfby() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("lk_translationprocess_modifiedonbehalfby"), Optional.empty());
    }

    public TimezonedefinitionRequest lk_timezonedefinition_modifiedonbehalfby(UUID timezonedefinitionid) {
        return new TimezonedefinitionRequest(contextPath.addSegment("lk_timezonedefinition_modifiedonbehalfby").addKeys(new NameValue(timezonedefinitionid, UUID.class)), Optional.empty());
    }

    public TimezonedefinitionCollectionRequest lk_timezonedefinition_modifiedonbehalfby() {
        return new TimezonedefinitionCollectionRequest(
                        contextPath.addSegment("lk_timezonedefinition_modifiedonbehalfby"), Optional.empty());
    }

    public DuplicateruleconditionRequest lk_duplicaterulecondition_modifiedonbehalfby(UUID duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("lk_duplicaterulecondition_modifiedonbehalfby").addKeys(new NameValue(duplicateruleconditionid, UUID.class)), Optional.empty());
    }

    public DuplicateruleconditionCollectionRequest lk_duplicaterulecondition_modifiedonbehalfby() {
        return new DuplicateruleconditionCollectionRequest(
                        contextPath.addSegment("lk_duplicaterulecondition_modifiedonbehalfby"), Optional.empty());
    }

    public AsyncoperationRequest lk_asyncoperation_createdonbehalfby(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("lk_asyncoperation_createdonbehalfby").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest lk_asyncoperation_createdonbehalfby() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("lk_asyncoperation_createdonbehalfby"), Optional.empty());
    }

    public ActivitypointerRequest lk_activitypointer_modifiedby(UUID activityid) {
        return new ActivitypointerRequest(contextPath.addSegment("lk_activitypointer_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public ActivitypointerCollectionRequest lk_activitypointer_modifiedby() {
        return new ActivitypointerCollectionRequest(
                        contextPath.addSegment("lk_activitypointer_modifiedby"), Optional.empty());
    }

    public QueueRequest lk_queuebase_createdby(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("lk_queuebase_createdby").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest lk_queuebase_createdby() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("lk_queuebase_createdby"), Optional.empty());
    }

    public TransformationmappingRequest lk_transformationmapping_modifiedby(UUID transformationmappingid) {
        return new TransformationmappingRequest(contextPath.addSegment("lk_transformationmapping_modifiedby").addKeys(new NameValue(transformationmappingid, UUID.class)), Optional.empty());
    }

    public TransformationmappingCollectionRequest lk_transformationmapping_modifiedby() {
        return new TransformationmappingCollectionRequest(
                        contextPath.addSegment("lk_transformationmapping_modifiedby"), Optional.empty());
    }

    public AppconfigRequest systemuser_appconfig_createdby(UUID appconfigid) {
        return new AppconfigRequest(contextPath.addSegment("systemuser_appconfig_createdby").addKeys(new NameValue(appconfigid, UUID.class)), Optional.empty());
    }

    public AppconfigCollectionRequest systemuser_appconfig_createdby() {
        return new AppconfigCollectionRequest(
                        contextPath.addSegment("systemuser_appconfig_createdby"), Optional.empty());
    }

    public UsersettingsRequest user_settings(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("user_settings").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest user_settings() {
        return new UsersettingsCollectionRequest(
                        contextPath.addSegment("user_settings"), Optional.empty());
    }

    public AppconfiginstanceRequest systemuser_appconfiginstance_modifiedby(UUID appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("systemuser_appconfiginstance_modifiedby").addKeys(new NameValue(appconfiginstanceid, UUID.class)), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest systemuser_appconfiginstance_modifiedby() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("systemuser_appconfiginstance_modifiedby"), Optional.empty());
    }

    public TranslationprocessRequest lk_translationprocess_createdby(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("lk_translationprocess_createdby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest lk_translationprocess_createdby() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("lk_translationprocess_createdby"), Optional.empty());
    }

    public NavigationsettingRequest systemuser_navigationsetting_modifiedonbehalfby(UUID navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("systemuser_navigationsetting_modifiedonbehalfby").addKeys(new NameValue(navigationsettingid, UUID.class)), Optional.empty());
    }

    public NavigationsettingCollectionRequest systemuser_navigationsetting_modifiedonbehalfby() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("systemuser_navigationsetting_modifiedonbehalfby"), Optional.empty());
    }

    public QueueitemRequest lk_queueitem_modifiedonbehalfby(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("lk_queueitem_modifiedonbehalfby").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest lk_queueitem_modifiedonbehalfby() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("lk_queueitem_modifiedonbehalfby"), Optional.empty());
    }

    public AnnotationRequest lk_annotationbase_createdonbehalfby(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("lk_annotationbase_createdonbehalfby").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest lk_annotationbase_createdonbehalfby() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("lk_annotationbase_createdonbehalfby"), Optional.empty());
    }

    public ActioncardRequest lk_actioncardbase_createdonbehalfby(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("lk_actioncardbase_createdonbehalfby").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest lk_actioncardbase_createdonbehalfby() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("lk_actioncardbase_createdonbehalfby"), Optional.empty());
    }

    public TimezonelocalizednameRequest lk_timezonelocalizedname_createdby(UUID timezonelocalizednameid) {
        return new TimezonelocalizednameRequest(contextPath.addSegment("lk_timezonelocalizedname_createdby").addKeys(new NameValue(timezonelocalizednameid, UUID.class)), Optional.empty());
    }

    public TimezonelocalizednameCollectionRequest lk_timezonelocalizedname_createdby() {
        return new TimezonelocalizednameCollectionRequest(
                        contextPath.addSegment("lk_timezonelocalizedname_createdby"), Optional.empty());
    }

    public AppconfiginstanceRequest systemuser_appconfiginstance_modifiedonbehalfby(UUID appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("systemuser_appconfiginstance_modifiedonbehalfby").addKeys(new NameValue(appconfiginstanceid, UUID.class)), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest systemuser_appconfiginstance_modifiedonbehalfby() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("systemuser_appconfiginstance_modifiedonbehalfby"), Optional.empty());
    }

    public ImportRequest lk_import_createdonbehalfby(UUID importid) {
        return new ImportRequest(contextPath.addSegment("lk_import_createdonbehalfby").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest lk_import_createdonbehalfby() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("lk_import_createdonbehalfby"), Optional.empty());
    }

    public MailmergetemplateRequest lk_mailmergetemplate_modifiedonbehalfby(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("lk_mailmergetemplate_modifiedonbehalfby").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest lk_mailmergetemplate_modifiedonbehalfby() {
        return new MailmergetemplateCollectionRequest(
                        contextPath.addSegment("lk_mailmergetemplate_modifiedonbehalfby"), Optional.empty());
    }

    public CustomcontroldefaultconfigRequest lk_customcontroldefaultconfig_modifiedby(UUID customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("lk_customcontroldefaultconfig_modifiedby").addKeys(new NameValue(customcontroldefaultconfigid, UUID.class)), Optional.empty());
    }

    public CustomcontroldefaultconfigCollectionRequest lk_customcontroldefaultconfig_modifiedby() {
        return new CustomcontroldefaultconfigCollectionRequest(
                        contextPath.addSegment("lk_customcontroldefaultconfig_modifiedby"), Optional.empty());
    }

    public CustomcontrolRequest lk_customcontrol_createdonbehalfby(UUID customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("lk_customcontrol_createdonbehalfby").addKeys(new NameValue(customcontrolid, UUID.class)), Optional.empty());
    }

    public CustomcontrolCollectionRequest lk_customcontrol_createdonbehalfby() {
        return new CustomcontrolCollectionRequest(
                        contextPath.addSegment("lk_customcontrol_createdonbehalfby"), Optional.empty());
    }

    public UsersettingsRequest lk_usersettings_modifiedonbehalfby(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("lk_usersettings_modifiedonbehalfby").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest lk_usersettings_modifiedonbehalfby() {
        return new UsersettingsCollectionRequest(
                        contextPath.addSegment("lk_usersettings_modifiedonbehalfby"), Optional.empty());
    }

    public OwnermappingRequest lk_ownermapping_modifiedonbehalfby(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("lk_ownermapping_modifiedonbehalfby").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest lk_ownermapping_modifiedonbehalfby() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("lk_ownermapping_modifiedonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileRequest lk_MobileOfflineProfile_modifiedby(UUID mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("lk_MobileOfflineProfile_modifiedby").addKeys(new NameValue(mobileofflineprofileid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileCollectionRequest lk_MobileOfflineProfile_modifiedby() {
        return new MobileofflineprofileCollectionRequest(
                        contextPath.addSegment("lk_MobileOfflineProfile_modifiedby"), Optional.empty());
    }

    public LookupmappingRequest lk_lookupmapping_createdonbehalfby(UUID lookupmappingid) {
        return new LookupmappingRequest(contextPath.addSegment("lk_lookupmapping_createdonbehalfby").addKeys(new NameValue(lookupmappingid, UUID.class)), Optional.empty());
    }

    public LookupmappingCollectionRequest lk_lookupmapping_createdonbehalfby() {
        return new LookupmappingCollectionRequest(
                        contextPath.addSegment("lk_lookupmapping_createdonbehalfby"), Optional.empty());
    }

    public PlugintypeRequest lk_plugintype_modifiedonbehalfby(UUID plugintypeid) {
        return new PlugintypeRequest(contextPath.addSegment("lk_plugintype_modifiedonbehalfby").addKeys(new NameValue(plugintypeid, UUID.class)), Optional.empty());
    }

    public PlugintypeCollectionRequest lk_plugintype_modifiedonbehalfby() {
        return new PlugintypeCollectionRequest(
                        contextPath.addSegment("lk_plugintype_modifiedonbehalfby"), Optional.empty());
    }

    public AppmodulecomponentRequest appmodulecomponent_createdby(UUID appmodulecomponentid) {
        return new AppmodulecomponentRequest(contextPath.addSegment("appmodulecomponent_createdby").addKeys(new NameValue(appmodulecomponentid, UUID.class)), Optional.empty());
    }

    public AppmodulecomponentCollectionRequest appmodulecomponent_createdby() {
        return new AppmodulecomponentCollectionRequest(
                        contextPath.addSegment("appmodulecomponent_createdby"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_modifiedby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_modifiedby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_modifiedby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_modifiedby"), Optional.empty());
    }

    public TransformationparametermappingRequest lk_transformationparametermapping_modifiedby(UUID transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("lk_transformationparametermapping_modifiedby").addKeys(new NameValue(transformationparametermappingid, UUID.class)), Optional.empty());
    }

    public TransformationparametermappingCollectionRequest lk_transformationparametermapping_modifiedby() {
        return new TransformationparametermappingCollectionRequest(
                        contextPath.addSegment("lk_transformationparametermapping_modifiedby"), Optional.empty());
    }

    public SavedqueryvisualizationRequest lk_savedqueryvisualizationbase_modifiedonbehalfby(UUID savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("lk_savedqueryvisualizationbase_modifiedonbehalfby").addKeys(new NameValue(savedqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest lk_savedqueryvisualizationbase_modifiedonbehalfby() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_savedqueryvisualizationbase_modifiedonbehalfby"), Optional.empty());
    }

    public KbarticlecommentRequest lk_kbarticlecomment_modifiedonbehalfby(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("lk_kbarticlecomment_modifiedonbehalfby").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public KbarticlecommentCollectionRequest lk_kbarticlecomment_modifiedonbehalfby() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("lk_kbarticlecomment_modifiedonbehalfby"), Optional.empty());
    }

    public RoleRequest lk_rolebase_createdby(UUID roleid) {
        return new RoleRequest(contextPath.addSegment("lk_rolebase_createdby").addKeys(new NameValue(roleid, UUID.class)), Optional.empty());
    }

    public RoleCollectionRequest lk_rolebase_createdby() {
        return new RoleCollectionRequest(
                        contextPath.addSegment("lk_rolebase_createdby"), Optional.empty());
    }

    public BulkdeleteoperationRequest lk_bulkdeleteoperation_createdonbehalfby(UUID bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("lk_bulkdeleteoperation_createdonbehalfby").addKeys(new NameValue(bulkdeleteoperationid, UUID.class)), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest lk_bulkdeleteoperation_createdonbehalfby() {
        return new BulkdeleteoperationCollectionRequest(
                        contextPath.addSegment("lk_bulkdeleteoperation_createdonbehalfby"), Optional.empty());
    }

    public KnowledgearticleviewsRequest lk_knowledgearticleviews_createdby(UUID knowledgearticleviewsid) {
        return new KnowledgearticleviewsRequest(contextPath.addSegment("lk_knowledgearticleviews_createdby").addKeys(new NameValue(knowledgearticleviewsid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleviewsCollectionRequest lk_knowledgearticleviews_createdby() {
        return new KnowledgearticleviewsCollectionRequest(
                        contextPath.addSegment("lk_knowledgearticleviews_createdby"), Optional.empty());
    }

    public CustomeraddressRequest lk_customeraddressbase_modifiedby(UUID customeraddressid) {
        return new CustomeraddressRequest(contextPath.addSegment("lk_customeraddressbase_modifiedby").addKeys(new NameValue(customeraddressid, UUID.class)), Optional.empty());
    }

    public CustomeraddressCollectionRequest lk_customeraddressbase_modifiedby() {
        return new CustomeraddressCollectionRequest(
                        contextPath.addSegment("lk_customeraddressbase_modifiedby"), Optional.empty());
    }

    public TranslationprocessRequest lk_translationprocess_createdonbehalfby(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("lk_translationprocess_createdonbehalfby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest lk_translationprocess_createdonbehalfby() {
        return new TranslationprocessCollectionRequest(
                        contextPath.addSegment("lk_translationprocess_createdonbehalfby"), Optional.empty());
    }

    public EmailRequest lk_email_createdonbehalfby(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("lk_email_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest lk_email_createdonbehalfby() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("lk_email_createdonbehalfby"), Optional.empty());
    }

    public CategoryRequest lk_category_modifiedby(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("lk_category_modifiedby").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest lk_category_modifiedby() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("lk_category_modifiedby"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest lk_quarterlyfiscalcalendar_modifiedonbehalfby(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("lk_quarterlyfiscalcalendar_modifiedonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public QuarterlyfiscalcalendarCollectionRequest lk_quarterlyfiscalcalendar_modifiedonbehalfby() {
        return new QuarterlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_quarterlyfiscalcalendar_modifiedonbehalfby"), Optional.empty());
    }

    public ImportfileRequest lk_importfilebase_createdonbehalfby(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("lk_importfilebase_createdonbehalfby").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest lk_importfilebase_createdonbehalfby() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("lk_importfilebase_createdonbehalfby"), Optional.empty());
    }

    public SdkmessagefilterRequest lk_sdkmessagefilter_createdonbehalfby(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("lk_sdkmessagefilter_createdonbehalfby").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest lk_sdkmessagefilter_createdonbehalfby() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("lk_sdkmessagefilter_createdonbehalfby"), Optional.empty());
    }

    public AnnotationRequest lk_annotationbase_modifiedby(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("lk_annotationbase_modifiedby").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest lk_annotationbase_modifiedby() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("lk_annotationbase_modifiedby"), Optional.empty());
    }

    public QueueRequest lk_queue_modifiedonbehalfby(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("lk_queue_modifiedonbehalfby").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest lk_queue_modifiedonbehalfby() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("lk_queue_modifiedonbehalfby"), Optional.empty());
    }

    public SharepointdocumentlocationRequest lk_sharepointdocumentlocationbase_modifiedonbehalfby(UUID sharepointdocumentlocationid) {
        return new SharepointdocumentlocationRequest(contextPath.addSegment("lk_sharepointdocumentlocationbase_modifiedonbehalfby").addKeys(new NameValue(sharepointdocumentlocationid, UUID.class)), Optional.empty());
    }

    public SharepointdocumentlocationCollectionRequest lk_sharepointdocumentlocationbase_modifiedonbehalfby() {
        return new SharepointdocumentlocationCollectionRequest(
                        contextPath.addSegment("lk_sharepointdocumentlocationbase_modifiedonbehalfby"), Optional.empty());
    }

    public SocialactivityRequest lk_socialactivity_modifiedby(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("lk_socialactivity_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest lk_socialactivity_modifiedby() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("lk_socialactivity_modifiedby"), Optional.empty());
    }

    public CalendarRequest lk_calendar_modifiedonbehalfby(UUID calendarid) {
        return new CalendarRequest(contextPath.addSegment("lk_calendar_modifiedonbehalfby").addKeys(new NameValue(calendarid, UUID.class)), Optional.empty());
    }

    public CalendarCollectionRequest lk_calendar_modifiedonbehalfby() {
        return new CalendarCollectionRequest(
                        contextPath.addSegment("lk_calendar_modifiedonbehalfby"), Optional.empty());
    }

    public ContactRequest system_user_contacts(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("system_user_contacts").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest system_user_contacts() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("system_user_contacts"), Optional.empty());
    }

    public WebresourceRequest lk_webresourcebase_createdonbehalfby(UUID webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("lk_webresourcebase_createdonbehalfby").addKeys(new NameValue(webresourceid, UUID.class)), Optional.empty());
    }

    public WebresourceCollectionRequest lk_webresourcebase_createdonbehalfby() {
        return new WebresourceCollectionRequest(
                        contextPath.addSegment("lk_webresourcebase_createdonbehalfby"), Optional.empty());
    }

    public FeedbackRequest lk_feedback_createdby(UUID feedbackid) {
        return new FeedbackRequest(contextPath.addSegment("lk_feedback_createdby").addKeys(new NameValue(feedbackid, UUID.class)), Optional.empty());
    }

    public FeedbackCollectionRequest lk_feedback_createdby() {
        return new FeedbackCollectionRequest(
                        contextPath.addSegment("lk_feedback_createdby"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest lk_fixedmonthlyfiscalcalendar_createdby(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_createdby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarCollectionRequest lk_fixedmonthlyfiscalcalendar_createdby() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_createdby"), Optional.empty());
    }

    public FieldsecurityprofileRequest lk_fieldsecurityprofile_modifiedonbehalfby(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("lk_fieldsecurityprofile_modifiedonbehalfby").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest lk_fieldsecurityprofile_modifiedonbehalfby() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("lk_fieldsecurityprofile_modifiedonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigRequest createdby_sdkmessageprocessingstepsecureconfig(UUID sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("createdby_sdkmessageprocessingstepsecureconfig").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigCollectionRequest createdby_sdkmessageprocessingstepsecureconfig() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(
                        contextPath.addSegment("createdby_sdkmessageprocessingstepsecureconfig"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsessionbase_createdonbehalfby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsessionbase_createdonbehalfby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsessionbase_createdonbehalfby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsessionbase_createdonbehalfby"), Optional.empty());
    }

    public WebwizardRequest lk_webwizard_modifiedby(UUID webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("lk_webwizard_modifiedby").addKeys(new NameValue(webwizardid, UUID.class)), Optional.empty());
    }

    public WebwizardCollectionRequest lk_webwizard_modifiedby() {
        return new WebwizardCollectionRequest(
                        contextPath.addSegment("lk_webwizard_modifiedby"), Optional.empty());
    }

    public TeamRequest lk_teambase_modifiedby(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("lk_teambase_modifiedby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest lk_teambase_modifiedby() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("lk_teambase_modifiedby"), Optional.empty());
    }

    public AciviewmapperRequest lk_ACIViewMapper_modifiedonbehalfby(UUID aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("lk_ACIViewMapper_modifiedonbehalfby").addKeys(new NameValue(aciviewmapperid, UUID.class)), Optional.empty());
    }

    public AciviewmapperCollectionRequest lk_ACIViewMapper_modifiedonbehalfby() {
        return new AciviewmapperCollectionRequest(
                        contextPath.addSegment("lk_ACIViewMapper_modifiedonbehalfby"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest lk_annualfiscalcalendar_createdby(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("lk_annualfiscalcalendar_createdby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public AnnualfiscalcalendarCollectionRequest lk_annualfiscalcalendar_createdby() {
        return new AnnualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_annualfiscalcalendar_createdby"), Optional.empty());
    }

    public CustomcontroldefaultconfigRequest lk_customcontroldefaultconfig_createdby(UUID customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("lk_customcontroldefaultconfig_createdby").addKeys(new NameValue(customcontroldefaultconfigid, UUID.class)), Optional.empty());
    }

    public CustomcontroldefaultconfigCollectionRequest lk_customcontroldefaultconfig_createdby() {
        return new CustomcontroldefaultconfigCollectionRequest(
                        contextPath.addSegment("lk_customcontroldefaultconfig_createdby"), Optional.empty());
    }

    public MobileofflineprofileitemRequest lk_mobileofflineprofileitem_modifiedonbehalfby(UUID mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("lk_mobileofflineprofileitem_modifiedonbehalfby").addKeys(new NameValue(mobileofflineprofileitemid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest lk_mobileofflineprofileitem_modifiedonbehalfby() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitem_modifiedonbehalfby"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest lk_annualfiscalcalendar_createdonbehalfby(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("lk_annualfiscalcalendar_createdonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public AnnualfiscalcalendarCollectionRequest lk_annualfiscalcalendar_createdonbehalfby() {
        return new AnnualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_annualfiscalcalendar_createdonbehalfby"), Optional.empty());
    }

    public QueueRequest queuemembership_association(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("queuemembership_association").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest queuemembership_association() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("queuemembership_association"), Optional.empty());
    }

    public SolutionRequest lk_solutionbase_createdonbehalfby(UUID solutionid) {
        return new SolutionRequest(contextPath.addSegment("lk_solutionbase_createdonbehalfby").addKeys(new NameValue(solutionid, UUID.class)), Optional.empty());
    }

    public SolutionCollectionRequest lk_solutionbase_createdonbehalfby() {
        return new SolutionCollectionRequest(
                        contextPath.addSegment("lk_solutionbase_createdonbehalfby"), Optional.empty());
    }

    public SharepointsiteRequest lk_sharepointsitebase_modifiedonbehalfby(UUID sharepointsiteid) {
        return new SharepointsiteRequest(contextPath.addSegment("lk_sharepointsitebase_modifiedonbehalfby").addKeys(new NameValue(sharepointsiteid, UUID.class)), Optional.empty());
    }

    public SharepointsiteCollectionRequest lk_sharepointsitebase_modifiedonbehalfby() {
        return new SharepointsiteCollectionRequest(
                        contextPath.addSegment("lk_sharepointsitebase_modifiedonbehalfby"), Optional.empty());
    }

    public SyncerrorRequest lk_syncerrorbase_createdonbehalfby(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("lk_syncerrorbase_createdonbehalfby").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest lk_syncerrorbase_createdonbehalfby() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("lk_syncerrorbase_createdonbehalfby"), Optional.empty());
    }

    public CustomcontrolresourceRequest lk_customcontrolresource_modifiedby(UUID customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("lk_customcontrolresource_modifiedby").addKeys(new NameValue(customcontrolresourceid, UUID.class)), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest lk_customcontrolresource_modifiedby() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("lk_customcontrolresource_modifiedby"), Optional.empty());
    }

    public PluginassemblyRequest modifiedby_pluginassembly(UUID pluginassemblyid) {
        return new PluginassemblyRequest(contextPath.addSegment("modifiedby_pluginassembly").addKeys(new NameValue(pluginassemblyid, UUID.class)), Optional.empty());
    }

    public PluginassemblyCollectionRequest modifiedby_pluginassembly() {
        return new PluginassemblyCollectionRequest(
                        contextPath.addSegment("modifiedby_pluginassembly"), Optional.empty());
    }

    public RecurrenceruleRequest lk_recurrencerule_modifiedby(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("lk_recurrencerule_modifiedby").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest lk_recurrencerule_modifiedby() {
        return new RecurrenceruleCollectionRequest(
                        contextPath.addSegment("lk_recurrencerule_modifiedby"), Optional.empty());
    }

    public KnowledgearticleRequest knowledgearticle_primaryauthorid(UUID knowledgearticleid) {
        return new KnowledgearticleRequest(contextPath.addSegment("knowledgearticle_primaryauthorid").addKeys(new NameValue(knowledgearticleid, UUID.class)), Optional.empty());
    }

    public KnowledgearticleCollectionRequest knowledgearticle_primaryauthorid() {
        return new KnowledgearticleCollectionRequest(
                        contextPath.addSegment("knowledgearticle_primaryauthorid"), Optional.empty());
    }

    public PublisheraddressRequest lk_publisheraddressbase_createdonbehalfby(UUID publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("lk_publisheraddressbase_createdonbehalfby").addKeys(new NameValue(publisheraddressid, UUID.class)), Optional.empty());
    }

    public PublisheraddressCollectionRequest lk_publisheraddressbase_createdonbehalfby() {
        return new PublisheraddressCollectionRequest(
                        contextPath.addSegment("lk_publisheraddressbase_createdonbehalfby"), Optional.empty());
    }

    public TransactioncurrencyRequest lk_transactioncurrencybase_modifiedby(UUID transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("lk_transactioncurrencybase_modifiedby").addKeys(new NameValue(transactioncurrencyid, UUID.class)), Optional.empty());
    }

    public TransactioncurrencyCollectionRequest lk_transactioncurrencybase_modifiedby() {
        return new TransactioncurrencyCollectionRequest(
                        contextPath.addSegment("lk_transactioncurrencybase_modifiedby"), Optional.empty());
    }

    public ContactRequest contact_owning_user(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("contact_owning_user").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest contact_owning_user() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("contact_owning_user"), Optional.empty());
    }

    public AppointmentRequest lk_appointment_createdonbehalfby(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("lk_appointment_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest lk_appointment_createdonbehalfby() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("lk_appointment_createdonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest lk_MobileOfflineProfileItemAssociation_createdby(UUID mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("lk_MobileOfflineProfileItemAssociation_createdby").addKeys(new NameValue(mobileofflineprofileitemassociationid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest lk_MobileOfflineProfileItemAssociation_createdby() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("lk_MobileOfflineProfileItemAssociation_createdby"), Optional.empty());
    }

    public ActioncardRequest lk_actioncardbase_createdby(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("lk_actioncardbase_createdby").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest lk_actioncardbase_createdby() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("lk_actioncardbase_createdby"), Optional.empty());
    }

    public QuarterlyfiscalcalendarRequest lk_quarterlyfiscalcalendar_salespersonid(UUID userfiscalcalendarid) {
        return new QuarterlyfiscalcalendarRequest(contextPath.addSegment("lk_quarterlyfiscalcalendar_salespersonid").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public QuarterlyfiscalcalendarCollectionRequest lk_quarterlyfiscalcalendar_salespersonid() {
        return new QuarterlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_quarterlyfiscalcalendar_salespersonid"), Optional.empty());
    }

    public ImportlogRequest lk_importlogbase_modifiedby(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("lk_importlogbase_modifiedby").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest lk_importlogbase_modifiedby() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("lk_importlogbase_modifiedby"), Optional.empty());
    }

    public RecurrenceruleRequest lk_recurrencerule_createdby(UUID ruleid) {
        return new RecurrenceruleRequest(contextPath.addSegment("lk_recurrencerule_createdby").addKeys(new NameValue(ruleid, UUID.class)), Optional.empty());
    }

    public RecurrenceruleCollectionRequest lk_recurrencerule_createdby() {
        return new RecurrenceruleCollectionRequest(
                        contextPath.addSegment("lk_recurrencerule_createdby"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest lk_businessunitnewsarticlebase_modifiedby(UUID businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("lk_businessunitnewsarticlebase_modifiedby").addKeys(new NameValue(businessunitnewsarticleid, UUID.class)), Optional.empty());
    }

    public BusinessunitnewsarticleCollectionRequest lk_businessunitnewsarticlebase_modifiedby() {
        return new BusinessunitnewsarticleCollectionRequest(
                        contextPath.addSegment("lk_businessunitnewsarticlebase_modifiedby"), Optional.empty());
    }

    public CustomcontrolresourceRequest lk_customcontrolresource_createdonbehalfby(UUID customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("lk_customcontrolresource_createdonbehalfby").addKeys(new NameValue(customcontrolresourceid, UUID.class)), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest lk_customcontrolresource_createdonbehalfby() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("lk_customcontrolresource_createdonbehalfby"), Optional.empty());
    }

    public ImportmapRequest lk_importmap_modifiedonbehalfby(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("lk_importmap_modifiedonbehalfby").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest lk_importmap_modifiedonbehalfby() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("lk_importmap_modifiedonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigRequest modifiedby_sdkmessageprocessingstepsecureconfig(UUID sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("modifiedby_sdkmessageprocessingstepsecureconfig").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigCollectionRequest modifiedby_sdkmessageprocessingstepsecureconfig() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(
                        contextPath.addSegment("modifiedby_sdkmessageprocessingstepsecureconfig"), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public CategoryRequest lk_category_createdby(UUID categoryid) {
        return new CategoryRequest(contextPath.addSegment("lk_category_createdby").addKeys(new NameValue(categoryid, UUID.class)), Optional.empty());
    }

    public CategoryCollectionRequest lk_category_createdby() {
        return new CategoryCollectionRequest(
                        contextPath.addSegment("lk_category_createdby"), Optional.empty());
    }

    public AppmoduleRequest systemuser_appmodule_modifiedby(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("systemuser_appmodule_modifiedby").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest systemuser_appmodule_modifiedby() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("systemuser_appmodule_modifiedby"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_startedby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_startedby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_startedby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_startedby"), Optional.empty());
    }

    public NavigationsettingRequest systemuser_navigationsetting_createdby(UUID navigationsettingid) {
        return new NavigationsettingRequest(contextPath.addSegment("systemuser_navigationsetting_createdby").addKeys(new NameValue(navigationsettingid, UUID.class)), Optional.empty());
    }

    public NavigationsettingCollectionRequest systemuser_navigationsetting_createdby() {
        return new NavigationsettingCollectionRequest(
                        contextPath.addSegment("systemuser_navigationsetting_createdby"), Optional.empty());
    }

    public NewprocessRequest lk_newprocess_createdonbehalfby(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("lk_newprocess_createdonbehalfby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest lk_newprocess_createdonbehalfby() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("lk_newprocess_createdonbehalfby"), Optional.empty());
    }

    public ReportcategoryRequest lk_reportcategorybase_modifiedby(UUID reportcategoryid) {
        return new ReportcategoryRequest(contextPath.addSegment("lk_reportcategorybase_modifiedby").addKeys(new NameValue(reportcategoryid, UUID.class)), Optional.empty());
    }

    public ReportcategoryCollectionRequest lk_reportcategorybase_modifiedby() {
        return new ReportcategoryCollectionRequest(
                        contextPath.addSegment("lk_reportcategorybase_modifiedby"), Optional.empty());
    }

    public TaskRequest lk_task_createdonbehalfby(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("lk_task_createdonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest lk_task_createdonbehalfby() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("lk_task_createdonbehalfby"), Optional.empty());
    }

    public LetterRequest user_letter(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("user_letter").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest user_letter() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("user_letter"), Optional.empty());
    }

    public TeamRequest lk_teambase_createdby(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("lk_teambase_createdby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest lk_teambase_createdby() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("lk_teambase_createdby"), Optional.empty());
    }

    public SlaRequest lk_slabase_modifiedonbehalfby(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("lk_slabase_modifiedonbehalfby").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest lk_slabase_modifiedonbehalfby() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("lk_slabase_modifiedonbehalfby"), Optional.empty());
    }

    public UsersettingsRequest lk_usersettings_createdonbehalfby(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("lk_usersettings_createdonbehalfby").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest lk_usersettings_createdonbehalfby() {
        return new UsersettingsCollectionRequest(
                        contextPath.addSegment("lk_usersettings_createdonbehalfby"), Optional.empty());
    }

    public CalendarruleRequest lk_calendarrule_createdby(UUID calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("lk_calendarrule_createdby").addKeys(new NameValue(calendarruleid, UUID.class)), Optional.empty());
    }

    public CalendarruleCollectionRequest lk_calendarrule_createdby() {
        return new CalendarruleCollectionRequest(
                        contextPath.addSegment("lk_calendarrule_createdby"), Optional.empty());
    }

    public ImportentitymappingRequest lk_importentitymapping_createdonbehalfby(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("lk_importentitymapping_createdonbehalfby").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public ImportentitymappingCollectionRequest lk_importentitymapping_createdonbehalfby() {
        return new ImportentitymappingCollectionRequest(
                        contextPath.addSegment("lk_importentitymapping_createdonbehalfby"), Optional.empty());
    }

    public CustomcontrolresourceRequest lk_customcontrolresource_modifiedonbehalfby(UUID customcontrolresourceid) {
        return new CustomcontrolresourceRequest(contextPath.addSegment("lk_customcontrolresource_modifiedonbehalfby").addKeys(new NameValue(customcontrolresourceid, UUID.class)), Optional.empty());
    }

    public CustomcontrolresourceCollectionRequest lk_customcontrolresource_modifiedonbehalfby() {
        return new CustomcontrolresourceCollectionRequest(
                        contextPath.addSegment("lk_customcontrolresource_modifiedonbehalfby"), Optional.empty());
    }

    public MobileofflineprofileitemRequest lk_mobileofflineprofileitem_modifiedby(UUID mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("lk_mobileofflineprofileitem_modifiedby").addKeys(new NameValue(mobileofflineprofileitemid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest lk_mobileofflineprofileitem_modifiedby() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitem_modifiedby"), Optional.empty());
    }

    public SystemuserRequest parentsystemuserid() {
        return new SystemuserRequest(contextPath.addSegment("parentsystemuserid"), Optional.empty());
    }

    public SystemuserRequest user_parent_user(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("user_parent_user").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest user_parent_user() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("user_parent_user"), Optional.empty());
    }

    public PersonaldocumenttemplateRequest lk_personaldocumenttemplatebase_modifiedby(UUID personaldocumenttemplateid) {
        return new PersonaldocumenttemplateRequest(contextPath.addSegment("lk_personaldocumenttemplatebase_modifiedby").addKeys(new NameValue(personaldocumenttemplateid, UUID.class)), Optional.empty());
    }

    public PersonaldocumenttemplateCollectionRequest lk_personaldocumenttemplatebase_modifiedby() {
        return new PersonaldocumenttemplateCollectionRequest(
                        contextPath.addSegment("lk_personaldocumenttemplatebase_modifiedby"), Optional.empty());
    }

    public ImportfileRequest importFile_SystemUser(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("ImportFile_SystemUser").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest importFile_SystemUser() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("ImportFile_SystemUser"), Optional.empty());
    }

    public SavedqueryRequest lk_savedquerybase_createdby(UUID savedqueryid) {
        return new SavedqueryRequest(contextPath.addSegment("lk_savedquerybase_createdby").addKeys(new NameValue(savedqueryid, UUID.class)), Optional.empty());
    }

    public SavedqueryCollectionRequest lk_savedquerybase_createdby() {
        return new SavedqueryCollectionRequest(
                        contextPath.addSegment("lk_savedquerybase_createdby"), Optional.empty());
    }

    public DuplicaterecordRequest systemUser_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("SystemUser_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest systemUser_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("SystemUser_DuplicateMatchingRecord"), Optional.empty());
    }

    public EmailRequest lk_email_modifiedonbehalfby(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("lk_email_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest lk_email_modifiedonbehalfby() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("lk_email_modifiedonbehalfby"), Optional.empty());
    }

    public SocialactivityRequest user_socialactivity(UUID activityid) {
        return new SocialactivityRequest(contextPath.addSegment("user_socialactivity").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public SocialactivityCollectionRequest user_socialactivity() {
        return new SocialactivityCollectionRequest(
                        contextPath.addSegment("user_socialactivity"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest lk_fixedmonthlyfiscalcalendar_modifiedby(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_modifiedby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarCollectionRequest lk_fixedmonthlyfiscalcalendar_modifiedby() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_modifiedby"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest lk_businessunitnewsarticle_modifiedonbehalfby(UUID businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("lk_businessunitnewsarticle_modifiedonbehalfby").addKeys(new NameValue(businessunitnewsarticleid, UUID.class)), Optional.empty());
    }

    public BusinessunitnewsarticleCollectionRequest lk_businessunitnewsarticle_modifiedonbehalfby() {
        return new BusinessunitnewsarticleCollectionRequest(
                        contextPath.addSegment("lk_businessunitnewsarticle_modifiedonbehalfby"), Optional.empty());
    }

    public PhonecallRequest lk_phonecall_modifiedby(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("lk_phonecall_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest lk_phonecall_modifiedby() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("lk_phonecall_modifiedby"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest lk_annualfiscalcalendar_modifiedonbehalfby(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("lk_annualfiscalcalendar_modifiedonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public AnnualfiscalcalendarCollectionRequest lk_annualfiscalcalendar_modifiedonbehalfby() {
        return new AnnualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_annualfiscalcalendar_modifiedonbehalfby"), Optional.empty());
    }

    public KbarticletemplateRequest lk_kbarticletemplate_modifiedonbehalfby(UUID kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("lk_kbarticletemplate_modifiedonbehalfby").addKeys(new NameValue(kbarticletemplateid, UUID.class)), Optional.empty());
    }

    public KbarticletemplateCollectionRequest lk_kbarticletemplate_modifiedonbehalfby() {
        return new KbarticletemplateCollectionRequest(
                        contextPath.addSegment("lk_kbarticletemplate_modifiedonbehalfby"), Optional.empty());
    }

    public OrganizationRequest lk_organizationbase_modifiedby(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("lk_organizationbase_modifiedby").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest lk_organizationbase_modifiedby() {
        return new OrganizationCollectionRequest(
                        contextPath.addSegment("lk_organizationbase_modifiedby"), Optional.empty());
    }

    public OwnermappingRequest lk_ownermapping_createdonbehalfby(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("lk_ownermapping_createdonbehalfby").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest lk_ownermapping_createdonbehalfby() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("lk_ownermapping_createdonbehalfby"), Optional.empty());
    }

    public SdkmessageprocessingstepRequest createdby_sdkmessageprocessingstep(UUID sdkmessageprocessingstepid) {
        return new SdkmessageprocessingstepRequest(contextPath.addSegment("createdby_sdkmessageprocessingstep").addKeys(new NameValue(sdkmessageprocessingstepid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepCollectionRequest createdby_sdkmessageprocessingstep() {
        return new SdkmessageprocessingstepCollectionRequest(
                        contextPath.addSegment("createdby_sdkmessageprocessingstep"), Optional.empty());
    }

    public SyncerrorRequest lk_syncerrorbase_modifiedonbehalfby(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("lk_syncerrorbase_modifiedonbehalfby").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest lk_syncerrorbase_modifiedonbehalfby() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("lk_syncerrorbase_modifiedonbehalfby"), Optional.empty());
    }

    public AppointmentRequest lk_appointment_createdby(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("lk_appointment_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest lk_appointment_createdby() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("lk_appointment_createdby"), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigRequest lk_sdkmessageprocessingstepsecureconfig_modifiedonbehalfby(UUID sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("lk_sdkmessageprocessingstepsecureconfig_modifiedonbehalfby").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigCollectionRequest lk_sdkmessageprocessingstepsecureconfig_modifiedonbehalfby() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(
                        contextPath.addSegment("lk_sdkmessageprocessingstepsecureconfig_modifiedonbehalfby"), Optional.empty());
    }

    public ImportjobRequest lk_importjobbase_modifiedby(UUID importjobid) {
        return new ImportjobRequest(contextPath.addSegment("lk_importjobbase_modifiedby").addKeys(new NameValue(importjobid, UUID.class)), Optional.empty());
    }

    public ImportjobCollectionRequest lk_importjobbase_modifiedby() {
        return new ImportjobCollectionRequest(
                        contextPath.addSegment("lk_importjobbase_modifiedby"), Optional.empty());
    }

    public MobileofflineprofileRequest mobileofflineprofileid() {
        return new MobileofflineprofileRequest(contextPath.addSegment("mobileofflineprofileid"), Optional.empty());
    }

    public MailmergetemplateRequest lk_mailmergetemplatebase_modifiedby(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("lk_mailmergetemplatebase_modifiedby").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest lk_mailmergetemplatebase_modifiedby() {
        return new MailmergetemplateCollectionRequest(
                        contextPath.addSegment("lk_mailmergetemplatebase_modifiedby"), Optional.empty());
    }

    public ImportRequest lk_import_modifiedonbehalfby(UUID importid) {
        return new ImportRequest(contextPath.addSegment("lk_import_modifiedonbehalfby").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest lk_import_modifiedonbehalfby() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("lk_import_modifiedonbehalfby"), Optional.empty());
    }

    public MonthlyfiscalcalendarRequest lk_monthlyfiscalcalendar_createdonbehalfby(UUID userfiscalcalendarid) {
        return new MonthlyfiscalcalendarRequest(contextPath.addSegment("lk_monthlyfiscalcalendar_createdonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public MonthlyfiscalcalendarCollectionRequest lk_monthlyfiscalcalendar_createdonbehalfby() {
        return new MonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_monthlyfiscalcalendar_createdonbehalfby"), Optional.empty());
    }

    public QueueRequest queueid() {
        return new QueueRequest(contextPath.addSegment("queueid"), Optional.empty());
    }

    public UserqueryRequest lk_userquery_modifiedonbehalfby(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("lk_userquery_modifiedonbehalfby").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest lk_userquery_modifiedonbehalfby() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("lk_userquery_modifiedonbehalfby"), Optional.empty());
    }

    public TimezoneruleRequest lk_timezonerule_modifiedonbehalfby(UUID timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("lk_timezonerule_modifiedonbehalfby").addKeys(new NameValue(timezoneruleid, UUID.class)), Optional.empty());
    }

    public TimezoneruleCollectionRequest lk_timezonerule_modifiedonbehalfby() {
        return new TimezoneruleCollectionRequest(
                        contextPath.addSegment("lk_timezonerule_modifiedonbehalfby"), Optional.empty());
    }

    public UserqueryvisualizationRequest user_userqueryvisualizations(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("user_userqueryvisualizations").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest user_userqueryvisualizations() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("user_userqueryvisualizations"), Optional.empty());
    }

    public UserformRequest lk_userform_createdby(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("lk_userform_createdby").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest lk_userform_createdby() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("lk_userform_createdby"), Optional.empty());
    }

    public TaskRequest user_task(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("user_task").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest user_task() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("user_task"), Optional.empty());
    }

    public MobileofflineprofileRequest lk_MobileOfflineProfile_createdonbehalfby(UUID mobileofflineprofileid) {
        return new MobileofflineprofileRequest(contextPath.addSegment("lk_MobileOfflineProfile_createdonbehalfby").addKeys(new NameValue(mobileofflineprofileid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileCollectionRequest lk_MobileOfflineProfile_createdonbehalfby() {
        return new MobileofflineprofileCollectionRequest(
                        contextPath.addSegment("lk_MobileOfflineProfile_createdonbehalfby"), Optional.empty());
    }

    public WebwizardRequest lk_webwizard_createdby(UUID webwizardid) {
        return new WebwizardRequest(contextPath.addSegment("lk_webwizard_createdby").addKeys(new NameValue(webwizardid, UUID.class)), Optional.empty());
    }

    public WebwizardCollectionRequest lk_webwizard_createdby() {
        return new WebwizardCollectionRequest(
                        contextPath.addSegment("lk_webwizard_createdby"), Optional.empty());
    }

    public MailmergetemplateRequest lk_mailmergetemplatebase_createdby(UUID mailmergetemplateid) {
        return new MailmergetemplateRequest(contextPath.addSegment("lk_mailmergetemplatebase_createdby").addKeys(new NameValue(mailmergetemplateid, UUID.class)), Optional.empty());
    }

    public MailmergetemplateCollectionRequest lk_mailmergetemplatebase_createdby() {
        return new MailmergetemplateCollectionRequest(
                        contextPath.addSegment("lk_mailmergetemplatebase_createdby"), Optional.empty());
    }

    public CalendarruleRequest lk_calendarrule_createdonbehalfby(UUID calendarruleid) {
        return new CalendarruleRequest(contextPath.addSegment("lk_calendarrule_createdonbehalfby").addKeys(new NameValue(calendarruleid, UUID.class)), Optional.empty());
    }

    public CalendarruleCollectionRequest lk_calendarrule_createdonbehalfby() {
        return new CalendarruleCollectionRequest(
                        contextPath.addSegment("lk_calendarrule_createdonbehalfby"), Optional.empty());
    }

    public EmailRequest lk_email_createdby(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("lk_email_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest lk_email_createdby() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("lk_email_createdby"), Optional.empty());
    }

    public QueueRequest lk_queue_createdonbehalfby(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("lk_queue_createdonbehalfby").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest lk_queue_createdonbehalfby() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("lk_queue_createdonbehalfby"), Optional.empty());
    }

    public UserqueryRequest lk_userquery_createdby(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("lk_userquery_createdby").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest lk_userquery_createdby() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("lk_userquery_createdby"), Optional.empty());
    }

    public AppconfigmasterRequest systemuser_appconfigmaster_modifiedonbehalfby(UUID appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("systemuser_appconfigmaster_modifiedonbehalfby").addKeys(new NameValue(appconfigmasterid, UUID.class)), Optional.empty());
    }

    public AppconfigmasterCollectionRequest systemuser_appconfigmaster_modifiedonbehalfby() {
        return new AppconfigmasterCollectionRequest(
                        contextPath.addSegment("systemuser_appconfigmaster_modifiedonbehalfby"), Optional.empty());
    }

    public QueueRequest lk_queuebase_modifiedby(UUID queueid) {
        return new QueueRequest(contextPath.addSegment("lk_queuebase_modifiedby").addKeys(new NameValue(queueid, UUID.class)), Optional.empty());
    }

    public QueueCollectionRequest lk_queuebase_modifiedby() {
        return new QueueCollectionRequest(
                        contextPath.addSegment("lk_queuebase_modifiedby"), Optional.empty());
    }

    public AuditRequest lk_audit_userid(UUID auditid) {
        return new AuditRequest(contextPath.addSegment("lk_audit_userid").addKeys(new NameValue(auditid, UUID.class)), Optional.empty());
    }

    public AuditCollectionRequest lk_audit_userid() {
        return new AuditCollectionRequest(
                        contextPath.addSegment("lk_audit_userid"), Optional.empty());
    }

    public SdkmessageRequest modifiedby_sdkmessage(UUID sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("modifiedby_sdkmessage").addKeys(new NameValue(sdkmessageid, UUID.class)), Optional.empty());
    }

    public SdkmessageCollectionRequest modifiedby_sdkmessage() {
        return new SdkmessageCollectionRequest(
                        contextPath.addSegment("modifiedby_sdkmessage"), Optional.empty());
    }

    public TransformationparametermappingRequest lk_transformationparametermapping_createdby(UUID transformationparametermappingid) {
        return new TransformationparametermappingRequest(contextPath.addSegment("lk_transformationparametermapping_createdby").addKeys(new NameValue(transformationparametermappingid, UUID.class)), Optional.empty());
    }

    public TransformationparametermappingCollectionRequest lk_transformationparametermapping_createdby() {
        return new TransformationparametermappingCollectionRequest(
                        contextPath.addSegment("lk_transformationparametermapping_createdby"), Optional.empty());
    }

    public FieldsecurityprofileRequest lk_fieldsecurityprofile_modifiedby(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("lk_fieldsecurityprofile_modifiedby").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest lk_fieldsecurityprofile_modifiedby() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("lk_fieldsecurityprofile_modifiedby"), Optional.empty());
    }

    public CustomcontroldefaultconfigRequest lk_customcontroldefaultconfig_modifiedonbehalfby(UUID customcontroldefaultconfigid) {
        return new CustomcontroldefaultconfigRequest(contextPath.addSegment("lk_customcontroldefaultconfig_modifiedonbehalfby").addKeys(new NameValue(customcontroldefaultconfigid, UUID.class)), Optional.empty());
    }

    public CustomcontroldefaultconfigCollectionRequest lk_customcontroldefaultconfig_modifiedonbehalfby() {
        return new CustomcontroldefaultconfigCollectionRequest(
                        contextPath.addSegment("lk_customcontroldefaultconfig_modifiedonbehalfby"), Optional.empty());
    }

    public PicklistmappingRequest lk_picklistmapping_createdby(UUID picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("lk_picklistmapping_createdby").addKeys(new NameValue(picklistmappingid, UUID.class)), Optional.empty());
    }

    public PicklistmappingCollectionRequest lk_picklistmapping_createdby() {
        return new PicklistmappingCollectionRequest(
                        contextPath.addSegment("lk_picklistmapping_createdby"), Optional.empty());
    }

    public AsyncoperationRequest lk_asyncoperation_modifiedonbehalfby(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("lk_asyncoperation_modifiedonbehalfby").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest lk_asyncoperation_modifiedonbehalfby() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("lk_asyncoperation_modifiedonbehalfby"), Optional.empty());
    }

    public PublisherRequest lk_publisherbase_createdonbehalfby(UUID publisherid) {
        return new PublisherRequest(contextPath.addSegment("lk_publisherbase_createdonbehalfby").addKeys(new NameValue(publisherid, UUID.class)), Optional.empty());
    }

    public PublisherCollectionRequest lk_publisherbase_createdonbehalfby() {
        return new PublisherCollectionRequest(
                        contextPath.addSegment("lk_publisherbase_createdonbehalfby"), Optional.empty());
    }

    public EmailRequest systemUser_Email_EmailSender(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("SystemUser_Email_EmailSender").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest systemUser_Email_EmailSender() {
        return new EmailCollectionRequest(
                        contextPath.addSegment("SystemUser_Email_EmailSender"), Optional.empty());
    }

    public RecurringappointmentmasterRequest lk_recurringappointmentmaster_modifiedby(UUID activityid) {
        return new RecurringappointmentmasterRequest(contextPath.addSegment("lk_recurringappointmentmaster_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public RecurringappointmentmasterCollectionRequest lk_recurringappointmentmaster_modifiedby() {
        return new RecurringappointmentmasterCollectionRequest(
                        contextPath.addSegment("lk_recurringappointmentmaster_modifiedby"), Optional.empty());
    }

    public ImportmapRequest systemUser_ImportMaps(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("SystemUser_ImportMaps").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest systemUser_ImportMaps() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("SystemUser_ImportMaps"), Optional.empty());
    }

    public WorkflowRequest workflow_modifiedonbehalfby(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflow_modifiedonbehalfby").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest workflow_modifiedonbehalfby() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("workflow_modifiedonbehalfby"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest systemuser_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("systemuser_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest systemuser_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("systemuser_principalobjectattributeaccess"), Optional.empty());
    }

    public SlaitemRequest lk_slaitembase_modifiedby(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("lk_slaitembase_modifiedby").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public SlaitemCollectionRequest lk_slaitembase_modifiedby() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("lk_slaitembase_modifiedby"), Optional.empty());
    }

    public MobileofflineprofileitemassociationRequest lk_mobileofflineprofileitemassociation_createdonbehalfby(UUID mobileofflineprofileitemassociationid) {
        return new MobileofflineprofileitemassociationRequest(contextPath.addSegment("lk_mobileofflineprofileitemassociation_createdonbehalfby").addKeys(new NameValue(mobileofflineprofileitemassociationid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemassociationCollectionRequest lk_mobileofflineprofileitemassociation_createdonbehalfby() {
        return new MobileofflineprofileitemassociationCollectionRequest(
                        contextPath.addSegment("lk_mobileofflineprofileitemassociation_createdonbehalfby"), Optional.empty());
    }

    public AnnualfiscalcalendarRequest lk_annualfiscalcalendar_salespersonid(UUID userfiscalcalendarid) {
        return new AnnualfiscalcalendarRequest(contextPath.addSegment("lk_annualfiscalcalendar_salespersonid").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public AnnualfiscalcalendarCollectionRequest lk_annualfiscalcalendar_salespersonid() {
        return new AnnualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_annualfiscalcalendar_salespersonid"), Optional.empty());
    }

    public EmailserverprofileRequest lk_emailserverprofile_modifiedby(UUID emailserverprofileid) {
        return new EmailserverprofileRequest(contextPath.addSegment("lk_emailserverprofile_modifiedby").addKeys(new NameValue(emailserverprofileid, UUID.class)), Optional.empty());
    }

    public EmailserverprofileCollectionRequest lk_emailserverprofile_modifiedby() {
        return new EmailserverprofileCollectionRequest(
                        contextPath.addSegment("lk_emailserverprofile_modifiedby"), Optional.empty());
    }

    public SlakpiinstanceRequest lk_slakpiinstancebase_modifiedonbehalfby(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("lk_slakpiinstancebase_modifiedonbehalfby").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest lk_slakpiinstancebase_modifiedonbehalfby() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("lk_slakpiinstancebase_modifiedonbehalfby"), Optional.empty());
    }

    public DuplicateruleconditionRequest lk_duplicateruleconditionbase_modifiedby(UUID duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("lk_duplicateruleconditionbase_modifiedby").addKeys(new NameValue(duplicateruleconditionid, UUID.class)), Optional.empty());
    }

    public DuplicateruleconditionCollectionRequest lk_duplicateruleconditionbase_modifiedby() {
        return new DuplicateruleconditionCollectionRequest(
                        contextPath.addSegment("lk_duplicateruleconditionbase_modifiedby"), Optional.empty());
    }

    public TemplateRequest system_user_email_templates(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("system_user_email_templates").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest system_user_email_templates() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("system_user_email_templates"), Optional.empty());
    }

    public LetterRequest lk_letter_modifiedby(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("lk_letter_modifiedby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest lk_letter_modifiedby() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("lk_letter_modifiedby"), Optional.empty());
    }

    public WorkflowRequest workflow_createdby(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflow_createdby").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest workflow_createdby() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("workflow_createdby"), Optional.empty());
    }

    public PublisheraddressRequest lk_publisheraddressbase_modifiedby(UUID publisheraddressid) {
        return new PublisheraddressRequest(contextPath.addSegment("lk_publisheraddressbase_modifiedby").addKeys(new NameValue(publisheraddressid, UUID.class)), Optional.empty());
    }

    public PublisheraddressCollectionRequest lk_publisheraddressbase_modifiedby() {
        return new PublisheraddressCollectionRequest(
                        contextPath.addSegment("lk_publisheraddressbase_modifiedby"), Optional.empty());
    }

    public PicklistmappingRequest lk_picklistmapping_modifiedonbehalfby(UUID picklistmappingid) {
        return new PicklistmappingRequest(contextPath.addSegment("lk_picklistmapping_modifiedonbehalfby").addKeys(new NameValue(picklistmappingid, UUID.class)), Optional.empty());
    }

    public PicklistmappingCollectionRequest lk_picklistmapping_modifiedonbehalfby() {
        return new PicklistmappingCollectionRequest(
                        contextPath.addSegment("lk_picklistmapping_modifiedonbehalfby"), Optional.empty());
    }

    public OwnermappingRequest lk_ownermapping_modifiedby(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("lk_ownermapping_modifiedby").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest lk_ownermapping_modifiedby() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("lk_ownermapping_modifiedby"), Optional.empty());
    }

    public TaskRequest lk_task_modifiedonbehalfby(UUID activityid) {
        return new TaskRequest(contextPath.addSegment("lk_task_modifiedonbehalfby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public TaskCollectionRequest lk_task_modifiedonbehalfby() {
        return new TaskCollectionRequest(
                        contextPath.addSegment("lk_task_modifiedonbehalfby"), Optional.empty());
    }

    public UserformRequest lk_userform_modifiedby(UUID userformid) {
        return new UserformRequest(contextPath.addSegment("lk_userform_modifiedby").addKeys(new NameValue(userformid, UUID.class)), Optional.empty());
    }

    public UserformCollectionRequest lk_userform_modifiedby() {
        return new UserformCollectionRequest(
                        contextPath.addSegment("lk_userform_modifiedby"), Optional.empty());
    }

    public DisplaystringRequest lk_DisplayStringbase_modifiedby(UUID displaystringid) {
        return new DisplaystringRequest(contextPath.addSegment("lk_DisplayStringbase_modifiedby").addKeys(new NameValue(displaystringid, UUID.class)), Optional.empty());
    }

    public DisplaystringCollectionRequest lk_DisplayStringbase_modifiedby() {
        return new DisplaystringCollectionRequest(
                        contextPath.addSegment("lk_DisplayStringbase_modifiedby"), Optional.empty());
    }

    public ImportdataRequest lk_importdatabase_createdby(UUID importdataid) {
        return new ImportdataRequest(contextPath.addSegment("lk_importdatabase_createdby").addKeys(new NameValue(importdataid, UUID.class)), Optional.empty());
    }

    public ImportdataCollectionRequest lk_importdatabase_createdby() {
        return new ImportdataCollectionRequest(
                        contextPath.addSegment("lk_importdatabase_createdby"), Optional.empty());
    }

    public SlaRequest user_slabase(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("user_slabase").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest user_slabase() {
        return new SlaCollectionRequest(
                        contextPath.addSegment("user_slabase"), Optional.empty());
    }

    public ImportfileRequest lk_importfilebase_modifiedby(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("lk_importfilebase_modifiedby").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest lk_importfilebase_modifiedby() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("lk_importfilebase_modifiedby"), Optional.empty());
    }

    public TeamRequest lk_team_createdonbehalfby(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("lk_team_createdonbehalfby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest lk_team_createdonbehalfby() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("lk_team_createdonbehalfby"), Optional.empty());
    }

    public TemplateRequest lk_templatebase_modifiedonbehalfby(UUID templateid) {
        return new TemplateRequest(contextPath.addSegment("lk_templatebase_modifiedonbehalfby").addKeys(new NameValue(templateid, UUID.class)), Optional.empty());
    }

    public TemplateCollectionRequest lk_templatebase_modifiedonbehalfby() {
        return new TemplateCollectionRequest(
                        contextPath.addSegment("lk_templatebase_modifiedonbehalfby"), Optional.empty());
    }

    public SlaitemRequest lk_slaitembase_createdby(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("lk_slaitembase_createdby").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public SlaitemCollectionRequest lk_slaitembase_createdby() {
        return new SlaitemCollectionRequest(
                        contextPath.addSegment("lk_slaitembase_createdby"), Optional.empty());
    }

    public BusinessunitRequest businessunitid() {
        return new BusinessunitRequest(contextPath.addSegment("businessunitid"), Optional.empty());
    }

    public ImportmapRequest lk_importmapbase_modifiedby(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("lk_importmapbase_modifiedby").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest lk_importmapbase_modifiedby() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("lk_importmapbase_modifiedby"), Optional.empty());
    }

    public NewprocessRequest lk_newprocess_modifiedonbehalfby(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("lk_newprocess_modifiedonbehalfby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest lk_newprocess_modifiedonbehalfby() {
        return new NewprocessCollectionRequest(
                        contextPath.addSegment("lk_newprocess_modifiedonbehalfby"), Optional.empty());
    }

    public UsersettingsRequest lk_usersettingsbase_createdby(UUID systemuserid) {
        return new UsersettingsRequest(contextPath.addSegment("lk_usersettingsbase_createdby").addKeys(new NameValue(systemuserid, UUID.class)), Optional.empty());
    }

    public UsersettingsCollectionRequest lk_usersettingsbase_createdby() {
        return new UsersettingsCollectionRequest(
                        contextPath.addSegment("lk_usersettingsbase_createdby"), Optional.empty());
    }

    public WebresourceRequest lk_webresourcebase_modifiedonbehalfby(UUID webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("lk_webresourcebase_modifiedonbehalfby").addKeys(new NameValue(webresourceid, UUID.class)), Optional.empty());
    }

    public WebresourceCollectionRequest lk_webresourcebase_modifiedonbehalfby() {
        return new WebresourceCollectionRequest(
                        contextPath.addSegment("lk_webresourcebase_modifiedonbehalfby"), Optional.empty());
    }

    public WebresourceRequest webresource_createdby(UUID webresourceid) {
        return new WebresourceRequest(contextPath.addSegment("webresource_createdby").addKeys(new NameValue(webresourceid, UUID.class)), Optional.empty());
    }

    public WebresourceCollectionRequest webresource_createdby() {
        return new WebresourceCollectionRequest(
                        contextPath.addSegment("webresource_createdby"), Optional.empty());
    }

    public ProcesstriggerRequest lk_processtriggerbase_createdby(UUID processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("lk_processtriggerbase_createdby").addKeys(new NameValue(processtriggerid, UUID.class)), Optional.empty());
    }

    public ProcesstriggerCollectionRequest lk_processtriggerbase_createdby() {
        return new ProcesstriggerCollectionRequest(
                        contextPath.addSegment("lk_processtriggerbase_createdby"), Optional.empty());
    }

    public ExpiredprocessRequest lk_expiredprocess_modifiedonbehalfby(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("lk_expiredprocess_modifiedonbehalfby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest lk_expiredprocess_modifiedonbehalfby() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("lk_expiredprocess_modifiedonbehalfby"), Optional.empty());
    }

    public OwnermappingRequest lk_ownermapping_createdby(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("lk_ownermapping_createdby").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest lk_ownermapping_createdby() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("lk_ownermapping_createdby"), Optional.empty());
    }

    public AccountRequest user_accounts(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("user_accounts").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest user_accounts() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("user_accounts"), Optional.empty());
    }

    public KbarticleRequest lk_kbarticlebase_modifiedby(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("lk_kbarticlebase_modifiedby").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest lk_kbarticlebase_modifiedby() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("lk_kbarticlebase_modifiedby"), Optional.empty());
    }

    public WorkflowlogRequest lk_workflowlog_createdby(UUID workflowlogid) {
        return new WorkflowlogRequest(contextPath.addSegment("lk_workflowlog_createdby").addKeys(new NameValue(workflowlogid, UUID.class)), Optional.empty());
    }

    public WorkflowlogCollectionRequest lk_workflowlog_createdby() {
        return new WorkflowlogCollectionRequest(
                        contextPath.addSegment("lk_workflowlog_createdby"), Optional.empty());
    }

    public BulkdeleteoperationRequest lk_bulkdeleteoperation_modifiedonbehalfby(UUID bulkdeleteoperationid) {
        return new BulkdeleteoperationRequest(contextPath.addSegment("lk_bulkdeleteoperation_modifiedonbehalfby").addKeys(new NameValue(bulkdeleteoperationid, UUID.class)), Optional.empty());
    }

    public BulkdeleteoperationCollectionRequest lk_bulkdeleteoperation_modifiedonbehalfby() {
        return new BulkdeleteoperationCollectionRequest(
                        contextPath.addSegment("lk_bulkdeleteoperation_modifiedonbehalfby"), Optional.empty());
    }

    public UserqueryvisualizationRequest lk_userqueryvisualization_createdby(UUID userqueryvisualizationid) {
        return new UserqueryvisualizationRequest(contextPath.addSegment("lk_userqueryvisualization_createdby").addKeys(new NameValue(userqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public UserqueryvisualizationCollectionRequest lk_userqueryvisualization_createdby() {
        return new UserqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_userqueryvisualization_createdby"), Optional.empty());
    }

    public ImportfileRequest lk_importfilebase_createdby(UUID importfileid) {
        return new ImportfileRequest(contextPath.addSegment("lk_importfilebase_createdby").addKeys(new NameValue(importfileid, UUID.class)), Optional.empty());
    }

    public ImportfileCollectionRequest lk_importfilebase_createdby() {
        return new ImportfileCollectionRequest(
                        contextPath.addSegment("lk_importfilebase_createdby"), Optional.empty());
    }

    public ContactRequest lk_contactbase_modifiedby(UUID contactid) {
        return new ContactRequest(contextPath.addSegment("lk_contactbase_modifiedby").addKeys(new NameValue(contactid, UUID.class)), Optional.empty());
    }

    public ContactCollectionRequest lk_contactbase_modifiedby() {
        return new ContactCollectionRequest(
                        contextPath.addSegment("lk_contactbase_modifiedby"), Optional.empty());
    }

    public MobileofflineprofileitemRequest lk_MobileOfflineProfileItem_createdby(UUID mobileofflineprofileitemid) {
        return new MobileofflineprofileitemRequest(contextPath.addSegment("lk_MobileOfflineProfileItem_createdby").addKeys(new NameValue(mobileofflineprofileitemid, UUID.class)), Optional.empty());
    }

    public MobileofflineprofileitemCollectionRequest lk_MobileOfflineProfileItem_createdby() {
        return new MobileofflineprofileitemCollectionRequest(
                        contextPath.addSegment("lk_MobileOfflineProfileItem_createdby"), Optional.empty());
    }

    public WorkflowRequest workflow_modifiedby(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflow_modifiedby").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest workflow_modifiedby() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("workflow_modifiedby"), Optional.empty());
    }

    public SdkmessagefilterRequest lk_sdkmessagefilter_modifiedonbehalfby(UUID sdkmessagefilterid) {
        return new SdkmessagefilterRequest(contextPath.addSegment("lk_sdkmessagefilter_modifiedonbehalfby").addKeys(new NameValue(sdkmessagefilterid, UUID.class)), Optional.empty());
    }

    public SdkmessagefilterCollectionRequest lk_sdkmessagefilter_modifiedonbehalfby() {
        return new SdkmessagefilterCollectionRequest(
                        contextPath.addSegment("lk_sdkmessagefilter_modifiedonbehalfby"), Optional.empty());
    }

    public DuplicateruleRequest systemUser_DuplicateRules(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("SystemUser_DuplicateRules").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest systemUser_DuplicateRules() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("SystemUser_DuplicateRules"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest lk_fixedmonthlyfiscalcalendar_salespersonid(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_salespersonid").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarCollectionRequest lk_fixedmonthlyfiscalcalendar_salespersonid() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_salespersonid"), Optional.empty());
    }

    public ActioncardRequest lk_actioncardbase_modifiedby(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("lk_actioncardbase_modifiedby").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest lk_actioncardbase_modifiedby() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("lk_actioncardbase_modifiedby"), Optional.empty());
    }

    public AciviewmapperRequest lk_ACIViewMapper_modifiedby(UUID aciviewmapperid) {
        return new AciviewmapperRequest(contextPath.addSegment("lk_ACIViewMapper_modifiedby").addKeys(new NameValue(aciviewmapperid, UUID.class)), Optional.empty());
    }

    public AciviewmapperCollectionRequest lk_ACIViewMapper_modifiedby() {
        return new AciviewmapperCollectionRequest(
                        contextPath.addSegment("lk_ACIViewMapper_modifiedby"), Optional.empty());
    }

    public KbarticletemplateRequest lk_kbarticletemplatebase_modifiedby(UUID kbarticletemplateid) {
        return new KbarticletemplateRequest(contextPath.addSegment("lk_kbarticletemplatebase_modifiedby").addKeys(new NameValue(kbarticletemplateid, UUID.class)), Optional.empty());
    }

    public KbarticletemplateCollectionRequest lk_kbarticletemplatebase_modifiedby() {
        return new KbarticletemplateCollectionRequest(
                        contextPath.addSegment("lk_kbarticletemplatebase_modifiedby"), Optional.empty());
    }

    public AppconfigmasterRequest systemuser_appconfigmaster_modifiedby(UUID appconfigmasterid) {
        return new AppconfigmasterRequest(contextPath.addSegment("systemuser_appconfigmaster_modifiedby").addKeys(new NameValue(appconfigmasterid, UUID.class)), Optional.empty());
    }

    public AppconfigmasterCollectionRequest systemuser_appconfigmaster_modifiedby() {
        return new AppconfigmasterCollectionRequest(
                        contextPath.addSegment("systemuser_appconfigmaster_modifiedby"), Optional.empty());
    }

    public SavedqueryvisualizationRequest lk_savedqueryvisualizationbase_modifiedby(UUID savedqueryvisualizationid) {
        return new SavedqueryvisualizationRequest(contextPath.addSegment("lk_savedqueryvisualizationbase_modifiedby").addKeys(new NameValue(savedqueryvisualizationid, UUID.class)), Optional.empty());
    }

    public SavedqueryvisualizationCollectionRequest lk_savedqueryvisualizationbase_modifiedby() {
        return new SavedqueryvisualizationCollectionRequest(
                        contextPath.addSegment("lk_savedqueryvisualizationbase_modifiedby"), Optional.empty());
    }

    public SemiannualfiscalcalendarRequest lk_semiannualfiscalcalendar_modifiedby(UUID userfiscalcalendarid) {
        return new SemiannualfiscalcalendarRequest(contextPath.addSegment("lk_semiannualfiscalcalendar_modifiedby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public SemiannualfiscalcalendarCollectionRequest lk_semiannualfiscalcalendar_modifiedby() {
        return new SemiannualfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_semiannualfiscalcalendar_modifiedby"), Optional.empty());
    }

    public PlugintypestatisticRequest modifiedby_plugintypestatistic(UUID plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("modifiedby_plugintypestatistic").addKeys(new NameValue(plugintypestatisticid, UUID.class)), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest modifiedby_plugintypestatistic() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("modifiedby_plugintypestatistic"), Optional.empty());
    }

    public LetterRequest lk_letter_createdby(UUID activityid) {
        return new LetterRequest(contextPath.addSegment("lk_letter_createdby").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public LetterCollectionRequest lk_letter_createdby() {
        return new LetterCollectionRequest(
                        contextPath.addSegment("lk_letter_createdby"), Optional.empty());
    }

    public AppmoduleRequest systemuser_appmodule_createdonbehalfby(UUID appmoduleid) {
        return new AppmoduleRequest(contextPath.addSegment("systemuser_appmodule_createdonbehalfby").addKeys(new NameValue(appmoduleid, UUID.class)), Optional.empty());
    }

    public AppmoduleCollectionRequest systemuser_appmodule_createdonbehalfby() {
        return new AppmoduleCollectionRequest(
                        contextPath.addSegment("systemuser_appmodule_createdonbehalfby"), Optional.empty());
    }

    public BusinessunitnewsarticleRequest lk_businessunitnewsarticle_createdonbehalfby(UUID businessunitnewsarticleid) {
        return new BusinessunitnewsarticleRequest(contextPath.addSegment("lk_businessunitnewsarticle_createdonbehalfby").addKeys(new NameValue(businessunitnewsarticleid, UUID.class)), Optional.empty());
    }

    public BusinessunitnewsarticleCollectionRequest lk_businessunitnewsarticle_createdonbehalfby() {
        return new BusinessunitnewsarticleCollectionRequest(
                        contextPath.addSegment("lk_businessunitnewsarticle_createdonbehalfby"), Optional.empty());
    }

    public TimezoneruleRequest lk_timezonerule_modifiedby(UUID timezoneruleid) {
        return new TimezoneruleRequest(contextPath.addSegment("lk_timezonerule_modifiedby").addKeys(new NameValue(timezoneruleid, UUID.class)), Optional.empty());
    }

    public TimezoneruleCollectionRequest lk_timezonerule_modifiedby() {
        return new TimezoneruleCollectionRequest(
                        contextPath.addSegment("lk_timezonerule_modifiedby"), Optional.empty());
    }

    public ServiceendpointRequest lk_serviceendpointbase_modifiedonbehalfby(UUID serviceendpointid) {
        return new ServiceendpointRequest(contextPath.addSegment("lk_serviceendpointbase_modifiedonbehalfby").addKeys(new NameValue(serviceendpointid, UUID.class)), Optional.empty());
    }

    public ServiceendpointCollectionRequest lk_serviceendpointbase_modifiedonbehalfby() {
        return new ServiceendpointCollectionRequest(
                        contextPath.addSegment("lk_serviceendpointbase_modifiedonbehalfby"), Optional.empty());
    }

    public KbarticleRequest lk_kbarticle_modifiedonbehalfby(UUID kbarticleid) {
        return new KbarticleRequest(contextPath.addSegment("lk_kbarticle_modifiedonbehalfby").addKeys(new NameValue(kbarticleid, UUID.class)), Optional.empty());
    }

    public KbarticleCollectionRequest lk_kbarticle_modifiedonbehalfby() {
        return new KbarticleCollectionRequest(
                        contextPath.addSegment("lk_kbarticle_modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest lk_systemuser_createdonbehalfby(UUID ownerid) {
        return new SystemuserRequest(contextPath.addSegment("lk_systemuser_createdonbehalfby").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public SystemuserCollectionRequest lk_systemuser_createdonbehalfby() {
        return new SystemuserCollectionRequest(
                        contextPath.addSegment("lk_systemuser_createdonbehalfby"), Optional.empty());
    }

    public SocialprofileRequest lk_SocialProfile_createdonbehalfby(UUID socialprofileid) {
        return new SocialprofileRequest(contextPath.addSegment("lk_SocialProfile_createdonbehalfby").addKeys(new NameValue(socialprofileid, UUID.class)), Optional.empty());
    }

    public SocialprofileCollectionRequest lk_SocialProfile_createdonbehalfby() {
        return new SocialprofileCollectionRequest(
                        contextPath.addSegment("lk_SocialProfile_createdonbehalfby"), Optional.empty());
    }

    public OwnermappingRequest ownerMapping_SystemUser(UUID ownermappingid) {
        return new OwnermappingRequest(contextPath.addSegment("OwnerMapping_SystemUser").addKeys(new NameValue(ownermappingid, UUID.class)), Optional.empty());
    }

    public OwnermappingCollectionRequest ownerMapping_SystemUser() {
        return new OwnermappingCollectionRequest(
                        contextPath.addSegment("OwnerMapping_SystemUser"), Optional.empty());
    }

    public WorkflowRequest system_user_workflow(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("system_user_workflow").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest system_user_workflow() {
        return new WorkflowCollectionRequest(
                        contextPath.addSegment("system_user_workflow"), Optional.empty());
    }

    public ImportRequest lk_importbase_modifiedby(UUID importid) {
        return new ImportRequest(contextPath.addSegment("lk_importbase_modifiedby").addKeys(new NameValue(importid, UUID.class)), Optional.empty());
    }

    public ImportCollectionRequest lk_importbase_modifiedby() {
        return new ImportCollectionRequest(
                        contextPath.addSegment("lk_importbase_modifiedby"), Optional.empty());
    }

    public TeamRequest lk_teambase_administratorid(UUID ownerid) {
        return new TeamRequest(contextPath.addSegment("lk_teambase_administratorid").addKeys(new NameValue(ownerid, UUID.class)), Optional.empty());
    }

    public TeamCollectionRequest lk_teambase_administratorid() {
        return new TeamCollectionRequest(
                        contextPath.addSegment("lk_teambase_administratorid"), Optional.empty());
    }

    public FieldsecurityprofileRequest lk_fieldsecurityprofile_createdby(UUID fieldsecurityprofileid) {
        return new FieldsecurityprofileRequest(contextPath.addSegment("lk_fieldsecurityprofile_createdby").addKeys(new NameValue(fieldsecurityprofileid, UUID.class)), Optional.empty());
    }

    public FieldsecurityprofileCollectionRequest lk_fieldsecurityprofile_createdby() {
        return new FieldsecurityprofileCollectionRequest(
                        contextPath.addSegment("lk_fieldsecurityprofile_createdby"), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarRequest lk_fixedmonthlyfiscalcalendar_modifiedonbehalfby(UUID userfiscalcalendarid) {
        return new FixedmonthlyfiscalcalendarRequest(contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_modifiedonbehalfby").addKeys(new NameValue(userfiscalcalendarid, UUID.class)), Optional.empty());
    }

    public FixedmonthlyfiscalcalendarCollectionRequest lk_fixedmonthlyfiscalcalendar_modifiedonbehalfby() {
        return new FixedmonthlyfiscalcalendarCollectionRequest(
                        contextPath.addSegment("lk_fixedmonthlyfiscalcalendar_modifiedonbehalfby"), Optional.empty());
    }

    public MailboxtrackingfolderRequest lk_mailboxtrackingfolder_modifiedby(UUID mailboxtrackingfolderid) {
        return new MailboxtrackingfolderRequest(contextPath.addSegment("lk_mailboxtrackingfolder_modifiedby").addKeys(new NameValue(mailboxtrackingfolderid, UUID.class)), Optional.empty());
    }

    public MailboxtrackingfolderCollectionRequest lk_mailboxtrackingfolder_modifiedby() {
        return new MailboxtrackingfolderCollectionRequest(
                        contextPath.addSegment("lk_mailboxtrackingfolder_modifiedby"), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigRequest lk_sdkmessageprocessingstepsecureconfig_createdonbehalfby(UUID sdkmessageprocessingstepsecureconfigid) {
        return new SdkmessageprocessingstepsecureconfigRequest(contextPath.addSegment("lk_sdkmessageprocessingstepsecureconfig_createdonbehalfby").addKeys(new NameValue(sdkmessageprocessingstepsecureconfigid, UUID.class)), Optional.empty());
    }

    public SdkmessageprocessingstepsecureconfigCollectionRequest lk_sdkmessageprocessingstepsecureconfig_createdonbehalfby() {
        return new SdkmessageprocessingstepsecureconfigCollectionRequest(
                        contextPath.addSegment("lk_sdkmessageprocessingstepsecureconfig_createdonbehalfby"), Optional.empty());
    }

    public ColumnmappingRequest lk_columnmapping_modifiedonbehalfby(UUID columnmappingid) {
        return new ColumnmappingRequest(contextPath.addSegment("lk_columnmapping_modifiedonbehalfby").addKeys(new NameValue(columnmappingid, UUID.class)), Optional.empty());
    }

    public ColumnmappingCollectionRequest lk_columnmapping_modifiedonbehalfby() {
        return new ColumnmappingCollectionRequest(
                        contextPath.addSegment("lk_columnmapping_modifiedonbehalfby"), Optional.empty());
    }

    public ImportmapRequest lk_importmapbase_createdby(UUID importmapid) {
        return new ImportmapRequest(contextPath.addSegment("lk_importmapbase_createdby").addKeys(new NameValue(importmapid, UUID.class)), Optional.empty());
    }

    public ImportmapCollectionRequest lk_importmapbase_createdby() {
        return new ImportmapCollectionRequest(
                        contextPath.addSegment("lk_importmapbase_createdby"), Optional.empty());
    }

    public TransactioncurrencyRequest lk_transactioncurrency_modifiedonbehalfby(UUID transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("lk_transactioncurrency_modifiedonbehalfby").addKeys(new NameValue(transactioncurrencyid, UUID.class)), Optional.empty());
    }

    public TransactioncurrencyCollectionRequest lk_transactioncurrency_modifiedonbehalfby() {
        return new TransactioncurrencyCollectionRequest(
                        contextPath.addSegment("lk_transactioncurrency_modifiedonbehalfby"), Optional.empty());
    }

    public ExpiredprocessRequest lk_expiredprocess_modifiedby(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("lk_expiredprocess_modifiedby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest lk_expiredprocess_modifiedby() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("lk_expiredprocess_modifiedby"), Optional.empty());
    }

    public UserqueryRequest user_userquery(UUID userqueryid) {
        return new UserqueryRequest(contextPath.addSegment("user_userquery").addKeys(new NameValue(userqueryid, UUID.class)), Optional.empty());
    }

    public UserqueryCollectionRequest user_userquery() {
        return new UserqueryCollectionRequest(
                        contextPath.addSegment("user_userquery"), Optional.empty());
    }

    public AsyncoperationRequest system_user_asyncoperation(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("system_user_asyncoperation").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest system_user_asyncoperation() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("system_user_asyncoperation"), Optional.empty());
    }

    public PlugintypestatisticRequest lk_plugintypestatisticbase_modifiedonbehalfby(UUID plugintypestatisticid) {
        return new PlugintypestatisticRequest(contextPath.addSegment("lk_plugintypestatisticbase_modifiedonbehalfby").addKeys(new NameValue(plugintypestatisticid, UUID.class)), Optional.empty());
    }

    public PlugintypestatisticCollectionRequest lk_plugintypestatisticbase_modifiedonbehalfby() {
        return new PlugintypestatisticCollectionRequest(
                        contextPath.addSegment("lk_plugintypestatisticbase_modifiedonbehalfby"), Optional.empty());
    }

    public DuplicateruleconditionRequest lk_duplicateruleconditionbase_createdby(UUID duplicateruleconditionid) {
        return new DuplicateruleconditionRequest(contextPath.addSegment("lk_duplicateruleconditionbase_createdby").addKeys(new NameValue(duplicateruleconditionid, UUID.class)), Optional.empty());
    }

    public DuplicateruleconditionCollectionRequest lk_duplicateruleconditionbase_createdby() {
        return new DuplicateruleconditionCollectionRequest(
                        contextPath.addSegment("lk_duplicateruleconditionbase_createdby"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_completedby(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_completedby").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_completedby() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("lk_processsession_completedby"), Optional.empty());
    }

    public ImportentitymappingRequest lk_importentitymapping_modifiedonbehalfby(UUID importentitymappingid) {
        return new ImportentitymappingRequest(contextPath.addSegment("lk_importentitymapping_modifiedonbehalfby").addKeys(new NameValue(importentitymappingid, UUID.class)), Optional.empty());
    }

    public ImportentitymappingCollectionRequest lk_importentitymapping_modifiedonbehalfby() {
        return new ImportentitymappingCollectionRequest(
                        contextPath.addSegment("lk_importentitymapping_modifiedonbehalfby"), Optional.empty());
    }

    public AccountRequest lk_accountbase_modifiedonbehalfby(UUID accountid) {
        return new AccountRequest(contextPath.addSegment("lk_accountbase_modifiedonbehalfby").addKeys(new NameValue(accountid, UUID.class)), Optional.empty());
    }

    public AccountCollectionRequest lk_accountbase_modifiedonbehalfby() {
        return new AccountCollectionRequest(
                        contextPath.addSegment("lk_accountbase_modifiedonbehalfby"), Optional.empty());
    }

    public AppconfiginstanceRequest systemuser_appconfiginstance_createdby(UUID appconfiginstanceid) {
        return new AppconfiginstanceRequest(contextPath.addSegment("systemuser_appconfiginstance_createdby").addKeys(new NameValue(appconfiginstanceid, UUID.class)), Optional.empty());
    }

    public AppconfiginstanceCollectionRequest systemuser_appconfiginstance_createdby() {
        return new AppconfiginstanceCollectionRequest(
                        contextPath.addSegment("systemuser_appconfiginstance_createdby"), Optional.empty());
    }

    public CustomcontrolRequest lk_customcontrol_modifiedby(UUID customcontrolid) {
        return new CustomcontrolRequest(contextPath.addSegment("lk_customcontrol_modifiedby").addKeys(new NameValue(customcontrolid, UUID.class)), Optional.empty());
    }

    public CustomcontrolCollectionRequest lk_customcontrol_modifiedby() {
        return new CustomcontrolCollectionRequest(
                        contextPath.addSegment("lk_customcontrol_modifiedby"), Optional.empty());
    }

    public DuplicateruleRequest lk_duplicaterulebase_createdby(UUID duplicateruleid) {
        return new DuplicateruleRequest(contextPath.addSegment("lk_duplicaterulebase_createdby").addKeys(new NameValue(duplicateruleid, UUID.class)), Optional.empty());
    }

    public DuplicateruleCollectionRequest lk_duplicaterulebase_createdby() {
        return new DuplicateruleCollectionRequest(
                        contextPath.addSegment("lk_duplicaterulebase_createdby"), Optional.empty());
    }

    public QueueitemRequest lk_queueitem_createdonbehalfby(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("lk_queueitem_createdonbehalfby").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest lk_queueitem_createdonbehalfby() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("lk_queueitem_createdonbehalfby"), Optional.empty());
    }

    public TransactioncurrencyRequest lk_transactioncurrencybase_createdby(UUID transactioncurrencyid) {
        return new TransactioncurrencyRequest(contextPath.addSegment("lk_transactioncurrencybase_createdby").addKeys(new NameValue(transactioncurrencyid, UUID.class)), Optional.empty());
    }

    public TransactioncurrencyCollectionRequest lk_transactioncurrencybase_createdby() {
        return new TransactioncurrencyCollectionRequest(
                        contextPath.addSegment("lk_transactioncurrencybase_createdby"), Optional.empty());
    }

    public ImportlogRequest lk_importlog_modifiedonbehalfby(UUID importlogid) {
        return new ImportlogRequest(contextPath.addSegment("lk_importlog_modifiedonbehalfby").addKeys(new NameValue(importlogid, UUID.class)), Optional.empty());
    }

    public ImportlogCollectionRequest lk_importlog_modifiedonbehalfby() {
        return new ImportlogCollectionRequest(
                        contextPath.addSegment("lk_importlog_modifiedonbehalfby"), Optional.empty());
    }

    public SdkmessageRequest lk_sdkmessage_modifiedonbehalfby(UUID sdkmessageid) {
        return new SdkmessageRequest(contextPath.addSegment("lk_sdkmessage_modifiedonbehalfby").addKeys(new NameValue(sdkmessageid, UUID.class)), Optional.empty());
    }

    public SdkmessageCollectionRequest lk_sdkmessage_modifiedonbehalfby() {
        return new SdkmessageCollectionRequest(
                        contextPath.addSegment("lk_sdkmessage_modifiedonbehalfby"), Optional.empty());
    }

    public KbarticlecommentRequest lk_kbarticlecommentbase_modifiedby(UUID kbarticlecommentid) {
        return new KbarticlecommentRequest(contextPath.addSegment("lk_kbarticlecommentbase_modifiedby").addKeys(new NameValue(kbarticlecommentid, UUID.class)), Optional.empty());
    }

    public KbarticlecommentCollectionRequest lk_kbarticlecommentbase_modifiedby() {
        return new KbarticlecommentCollectionRequest(
                        contextPath.addSegment("lk_kbarticlecommentbase_modifiedby"), Optional.empty());
    }

    public PhonecallRequest user_phonecall(UUID activityid) {
        return new PhonecallRequest(contextPath.addSegment("user_phonecall").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public PhonecallCollectionRequest user_phonecall() {
        return new PhonecallCollectionRequest(
                        contextPath.addSegment("user_phonecall"), Optional.empty());
    }

    public AppointmentRequest user_appointment(UUID activityid) {
        return new AppointmentRequest(contextPath.addSegment("user_appointment").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public AppointmentCollectionRequest user_appointment() {
        return new AppointmentCollectionRequest(
                        contextPath.addSegment("user_appointment"), Optional.empty());
    }

    public ExpiredprocessRequest lk_expiredprocess_createdonbehalfby(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("lk_expiredprocess_createdonbehalfby").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest lk_expiredprocess_createdonbehalfby() {
        return new ExpiredprocessCollectionRequest(
                        contextPath.addSegment("lk_expiredprocess_createdonbehalfby"), Optional.empty());
    }

    public CallbackregistrationRequest systemuser_callbackregistration_modifiedonbehalfby(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("systemuser_callbackregistration_modifiedonbehalfby").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public CallbackregistrationCollectionRequest systemuser_callbackregistration_modifiedonbehalfby() {
        return new CallbackregistrationCollectionRequest(
                        contextPath.addSegment("systemuser_callbackregistration_modifiedonbehalfby"), Optional.empty());
    }

    public CallbackregistrationRequest systemuser_callbackregistration_modifiedby(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("systemuser_callbackregistration_modifiedby").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public CallbackregistrationCollectionRequest systemuser_callbackregistration_modifiedby() {
        return new CallbackregistrationCollectionRequest(
                        contextPath.addSegment("systemuser_callbackregistration_modifiedby"), Optional.empty());
    }

    public CallbackregistrationRequest systemuser_callbackregistration_createdonbehalfby(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("systemuser_callbackregistration_createdonbehalfby").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public CallbackregistrationCollectionRequest systemuser_callbackregistration_createdonbehalfby() {
        return new CallbackregistrationCollectionRequest(
                        contextPath.addSegment("systemuser_callbackregistration_createdonbehalfby"), Optional.empty());
    }

    public CallbackregistrationRequest systemuser_callbackregistration_createdby(UUID callbackregistrationid) {
        return new CallbackregistrationRequest(contextPath.addSegment("systemuser_callbackregistration_createdby").addKeys(new NameValue(callbackregistrationid, UUID.class)), Optional.empty());
    }

    public CallbackregistrationCollectionRequest systemuser_callbackregistration_createdby() {
        return new CallbackregistrationCollectionRequest(
                        contextPath.addSegment("systemuser_callbackregistration_createdby"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest lk_solutioncomponentattributeconfiguration_createdby(UUID solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("lk_solutioncomponentattributeconfiguration_createdby").addKeys(new NameValue(solutioncomponentattributeconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest lk_solutioncomponentattributeconfiguration_createdby() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentattributeconfiguration_createdby"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest lk_solutioncomponentattributeconfiguration_createdonbehalfby(UUID solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("lk_solutioncomponentattributeconfiguration_createdonbehalfby").addKeys(new NameValue(solutioncomponentattributeconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest lk_solutioncomponentattributeconfiguration_createdonbehalfby() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentattributeconfiguration_createdonbehalfby"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest lk_solutioncomponentattributeconfiguration_modifiedby(UUID solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("lk_solutioncomponentattributeconfiguration_modifiedby").addKeys(new NameValue(solutioncomponentattributeconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest lk_solutioncomponentattributeconfiguration_modifiedby() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentattributeconfiguration_modifiedby"), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationRequest lk_solutioncomponentattributeconfiguration_modifiedonbehalfby(UUID solutioncomponentattributeconfigurationid) {
        return new SolutioncomponentattributeconfigurationRequest(contextPath.addSegment("lk_solutioncomponentattributeconfiguration_modifiedonbehalfby").addKeys(new NameValue(solutioncomponentattributeconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentattributeconfigurationCollectionRequest lk_solutioncomponentattributeconfiguration_modifiedonbehalfby() {
        return new SolutioncomponentattributeconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentattributeconfiguration_modifiedonbehalfby"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest lk_solutioncomponentconfiguration_createdby(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("lk_solutioncomponentconfiguration_createdby").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest lk_solutioncomponentconfiguration_createdby() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentconfiguration_createdby"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest lk_solutioncomponentconfiguration_createdonbehalfby(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("lk_solutioncomponentconfiguration_createdonbehalfby").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest lk_solutioncomponentconfiguration_createdonbehalfby() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentconfiguration_createdonbehalfby"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest lk_solutioncomponentconfiguration_modifiedby(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("lk_solutioncomponentconfiguration_modifiedby").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest lk_solutioncomponentconfiguration_modifiedby() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentconfiguration_modifiedby"), Optional.empty());
    }

    public SolutioncomponentconfigurationRequest lk_solutioncomponentconfiguration_modifiedonbehalfby(UUID solutioncomponentconfigurationid) {
        return new SolutioncomponentconfigurationRequest(contextPath.addSegment("lk_solutioncomponentconfiguration_modifiedonbehalfby").addKeys(new NameValue(solutioncomponentconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentconfigurationCollectionRequest lk_solutioncomponentconfiguration_modifiedonbehalfby() {
        return new SolutioncomponentconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentconfiguration_modifiedonbehalfby"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest lk_solutioncomponentrelationshipconfiguration_createdby(UUID solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_createdby").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest lk_solutioncomponentrelationshipconfiguration_createdby() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_createdby"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest lk_solutioncomponentrelationshipconfiguration_createdonbehalfby(UUID solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_createdonbehalfby").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest lk_solutioncomponentrelationshipconfiguration_createdonbehalfby() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_createdonbehalfby"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest lk_solutioncomponentrelationshipconfiguration_modifiedby(UUID solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_modifiedby").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest lk_solutioncomponentrelationshipconfiguration_modifiedby() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_modifiedby"), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationRequest lk_solutioncomponentrelationshipconfiguration_modifiedonbehalfby(UUID solutioncomponentrelationshipconfigurationid) {
        return new SolutioncomponentrelationshipconfigurationRequest(contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_modifiedonbehalfby").addKeys(new NameValue(solutioncomponentrelationshipconfigurationid, UUID.class)), Optional.empty());
    }

    public SolutioncomponentrelationshipconfigurationCollectionRequest lk_solutioncomponentrelationshipconfiguration_modifiedonbehalfby() {
        return new SolutioncomponentrelationshipconfigurationCollectionRequest(
                        contextPath.addSegment("lk_solutioncomponentrelationshipconfiguration_modifiedonbehalfby"), Optional.empty());
    }

    public StagesolutionuploadRequest lk_stagesolutionupload_createdby(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("lk_stagesolutionupload_createdby").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest lk_stagesolutionupload_createdby() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_stagesolutionupload_createdby"), Optional.empty());
    }

    public StagesolutionuploadRequest lk_stagesolutionupload_createdonbehalfby(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("lk_stagesolutionupload_createdonbehalfby").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest lk_stagesolutionupload_createdonbehalfby() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_stagesolutionupload_createdonbehalfby"), Optional.empty());
    }

    public StagesolutionuploadRequest lk_stagesolutionupload_modifiedby(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("lk_stagesolutionupload_modifiedby").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest lk_stagesolutionupload_modifiedby() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_stagesolutionupload_modifiedby"), Optional.empty());
    }

    public StagesolutionuploadRequest lk_stagesolutionupload_modifiedonbehalfby(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("lk_stagesolutionupload_modifiedonbehalfby").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest lk_stagesolutionupload_modifiedonbehalfby() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_stagesolutionupload_modifiedonbehalfby"), Optional.empty());
    }

    public StagesolutionuploadRequest user_stagesolutionupload(UUID stagesolutionuploadid) {
        return new StagesolutionuploadRequest(contextPath.addSegment("user_stagesolutionupload").addKeys(new NameValue(stagesolutionuploadid, UUID.class)), Optional.empty());
    }

    public StagesolutionuploadCollectionRequest user_stagesolutionupload() {
        return new StagesolutionuploadCollectionRequest(
                        contextPath.addSegment("user_stagesolutionupload"), Optional.empty());
    }

    public ExportsolutionuploadRequest lk_exportsolutionupload_createdby(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("lk_exportsolutionupload_createdby").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest lk_exportsolutionupload_createdby() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_exportsolutionupload_createdby"), Optional.empty());
    }

    public ExportsolutionuploadRequest lk_exportsolutionupload_createdonbehalfby(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("lk_exportsolutionupload_createdonbehalfby").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest lk_exportsolutionupload_createdonbehalfby() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_exportsolutionupload_createdonbehalfby"), Optional.empty());
    }

    public ExportsolutionuploadRequest lk_exportsolutionupload_modifiedby(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("lk_exportsolutionupload_modifiedby").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest lk_exportsolutionupload_modifiedby() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_exportsolutionupload_modifiedby"), Optional.empty());
    }

    public ExportsolutionuploadRequest lk_exportsolutionupload_modifiedonbehalfby(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("lk_exportsolutionupload_modifiedonbehalfby").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest lk_exportsolutionupload_modifiedonbehalfby() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("lk_exportsolutionupload_modifiedonbehalfby"), Optional.empty());
    }

    public ExportsolutionuploadRequest user_exportsolutionupload(UUID exportsolutionuploadid) {
        return new ExportsolutionuploadRequest(contextPath.addSegment("user_exportsolutionupload").addKeys(new NameValue(exportsolutionuploadid, UUID.class)), Optional.empty());
    }

    public ExportsolutionuploadCollectionRequest user_exportsolutionupload() {
        return new ExportsolutionuploadCollectionRequest(
                        contextPath.addSegment("user_exportsolutionupload"), Optional.empty());
    }

    public DatalakeworkspaceRequest lk_datalakeworkspace_createdby(UUID datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("lk_datalakeworkspace_createdby").addKeys(new NameValue(datalakeworkspaceid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspaceCollectionRequest lk_datalakeworkspace_createdby() {
        return new DatalakeworkspaceCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspace_createdby"), Optional.empty());
    }

    public DatalakeworkspaceRequest lk_datalakeworkspace_createdonbehalfby(UUID datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("lk_datalakeworkspace_createdonbehalfby").addKeys(new NameValue(datalakeworkspaceid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspaceCollectionRequest lk_datalakeworkspace_createdonbehalfby() {
        return new DatalakeworkspaceCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspace_createdonbehalfby"), Optional.empty());
    }

    public DatalakeworkspaceRequest lk_datalakeworkspace_modifiedby(UUID datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("lk_datalakeworkspace_modifiedby").addKeys(new NameValue(datalakeworkspaceid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspaceCollectionRequest lk_datalakeworkspace_modifiedby() {
        return new DatalakeworkspaceCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspace_modifiedby"), Optional.empty());
    }

    public DatalakeworkspaceRequest lk_datalakeworkspace_modifiedonbehalfby(UUID datalakeworkspaceid) {
        return new DatalakeworkspaceRequest(contextPath.addSegment("lk_datalakeworkspace_modifiedonbehalfby").addKeys(new NameValue(datalakeworkspaceid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspaceCollectionRequest lk_datalakeworkspace_modifiedonbehalfby() {
        return new DatalakeworkspaceCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspace_modifiedonbehalfby"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest lk_datalakeworkspacepermission_createdby(UUID datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("lk_datalakeworkspacepermission_createdby").addKeys(new NameValue(datalakeworkspacepermissionid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest lk_datalakeworkspacepermission_createdby() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspacepermission_createdby"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest lk_datalakeworkspacepermission_createdonbehalfby(UUID datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("lk_datalakeworkspacepermission_createdonbehalfby").addKeys(new NameValue(datalakeworkspacepermissionid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest lk_datalakeworkspacepermission_createdonbehalfby() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspacepermission_createdonbehalfby"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest lk_datalakeworkspacepermission_modifiedby(UUID datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("lk_datalakeworkspacepermission_modifiedby").addKeys(new NameValue(datalakeworkspacepermissionid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest lk_datalakeworkspacepermission_modifiedby() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspacepermission_modifiedby"), Optional.empty());
    }

    public DatalakeworkspacepermissionRequest lk_datalakeworkspacepermission_modifiedonbehalfby(UUID datalakeworkspacepermissionid) {
        return new DatalakeworkspacepermissionRequest(contextPath.addSegment("lk_datalakeworkspacepermission_modifiedonbehalfby").addKeys(new NameValue(datalakeworkspacepermissionid, UUID.class)), Optional.empty());
    }

    public DatalakeworkspacepermissionCollectionRequest lk_datalakeworkspacepermission_modifiedonbehalfby() {
        return new DatalakeworkspacepermissionCollectionRequest(
                        contextPath.addSegment("lk_datalakeworkspacepermission_modifiedonbehalfby"), Optional.empty());
    }

    public ApplicationuserRequest lk_applicationuser_createdby(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("lk_applicationuser_createdby").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public ApplicationuserCollectionRequest lk_applicationuser_createdby() {
        return new ApplicationuserCollectionRequest(
                        contextPath.addSegment("lk_applicationuser_createdby"), Optional.empty());
    }

    public ApplicationuserRequest lk_applicationuser_createdonbehalfby(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("lk_applicationuser_createdonbehalfby").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public ApplicationuserCollectionRequest lk_applicationuser_createdonbehalfby() {
        return new ApplicationuserCollectionRequest(
                        contextPath.addSegment("lk_applicationuser_createdonbehalfby"), Optional.empty());
    }

    public ApplicationuserRequest lk_applicationuser_modifiedby(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("lk_applicationuser_modifiedby").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public ApplicationuserCollectionRequest lk_applicationuser_modifiedby() {
        return new ApplicationuserCollectionRequest(
                        contextPath.addSegment("lk_applicationuser_modifiedby"), Optional.empty());
    }

    public ApplicationuserRequest lk_applicationuser_modifiedonbehalfby(UUID applicationuserid) {
        return new ApplicationuserRequest(contextPath.addSegment("lk_applicationuser_modifiedonbehalfby").addKeys(new NameValue(applicationuserid, UUID.class)), Optional.empty());
    }

    public ApplicationuserCollectionRequest lk_applicationuser_modifiedonbehalfby() {
        return new ApplicationuserCollectionRequest(
                        contextPath.addSegment("lk_applicationuser_modifiedonbehalfby"), Optional.empty());
    }

    public ServiceplanRequest lk_serviceplan_createdby(UUID serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("lk_serviceplan_createdby").addKeys(new NameValue(serviceplanid, UUID.class)), Optional.empty());
    }

    public ServiceplanCollectionRequest lk_serviceplan_createdby() {
        return new ServiceplanCollectionRequest(
                        contextPath.addSegment("lk_serviceplan_createdby"), Optional.empty());
    }

    public ServiceplanRequest lk_serviceplan_createdonbehalfby(UUID serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("lk_serviceplan_createdonbehalfby").addKeys(new NameValue(serviceplanid, UUID.class)), Optional.empty());
    }

    public ServiceplanCollectionRequest lk_serviceplan_createdonbehalfby() {
        return new ServiceplanCollectionRequest(
                        contextPath.addSegment("lk_serviceplan_createdonbehalfby"), Optional.empty());
    }

    public ServiceplanRequest lk_serviceplan_modifiedby(UUID serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("lk_serviceplan_modifiedby").addKeys(new NameValue(serviceplanid, UUID.class)), Optional.empty());
    }

    public ServiceplanCollectionRequest lk_serviceplan_modifiedby() {
        return new ServiceplanCollectionRequest(
                        contextPath.addSegment("lk_serviceplan_modifiedby"), Optional.empty());
    }

    public ServiceplanRequest lk_serviceplan_modifiedonbehalfby(UUID serviceplanid) {
        return new ServiceplanRequest(contextPath.addSegment("lk_serviceplan_modifiedonbehalfby").addKeys(new NameValue(serviceplanid, UUID.class)), Optional.empty());
    }

    public ServiceplanCollectionRequest lk_serviceplan_modifiedonbehalfby() {
        return new ServiceplanCollectionRequest(
                        contextPath.addSegment("lk_serviceplan_modifiedonbehalfby"), Optional.empty());
    }

    public ConnectorRequest lk_connector_createdby(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("lk_connector_createdby").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest lk_connector_createdby() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("lk_connector_createdby"), Optional.empty());
    }

    public ConnectorRequest lk_connector_createdonbehalfby(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("lk_connector_createdonbehalfby").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest lk_connector_createdonbehalfby() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("lk_connector_createdonbehalfby"), Optional.empty());
    }

    public ConnectorRequest lk_connector_modifiedby(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("lk_connector_modifiedby").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest lk_connector_modifiedby() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("lk_connector_modifiedby"), Optional.empty());
    }

    public ConnectorRequest lk_connector_modifiedonbehalfby(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("lk_connector_modifiedonbehalfby").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest lk_connector_modifiedonbehalfby() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("lk_connector_modifiedonbehalfby"), Optional.empty());
    }

    public ConnectorRequest user_connector(UUID connectorid) {
        return new ConnectorRequest(contextPath.addSegment("user_connector").addKeys(new NameValue(connectorid, UUID.class)), Optional.empty());
    }

    public ConnectorCollectionRequest user_connector() {
        return new ConnectorCollectionRequest(
                        contextPath.addSegment("user_connector"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest lk_environmentvariabledefinition_createdby(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("lk_environmentvariabledefinition_createdby").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest lk_environmentvariabledefinition_createdby() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("lk_environmentvariabledefinition_createdby"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest lk_environmentvariabledefinition_createdonbehalfby(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("lk_environmentvariabledefinition_createdonbehalfby").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest lk_environmentvariabledefinition_createdonbehalfby() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("lk_environmentvariabledefinition_createdonbehalfby"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest lk_environmentvariabledefinition_modifiedby(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("lk_environmentvariabledefinition_modifiedby").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest lk_environmentvariabledefinition_modifiedby() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("lk_environmentvariabledefinition_modifiedby"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest lk_environmentvariabledefinition_modifiedonbehalfby(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("lk_environmentvariabledefinition_modifiedonbehalfby").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest lk_environmentvariabledefinition_modifiedonbehalfby() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("lk_environmentvariabledefinition_modifiedonbehalfby"), Optional.empty());
    }

    public EnvironmentvariabledefinitionRequest user_environmentvariabledefinition(UUID environmentvariabledefinitionid) {
        return new EnvironmentvariabledefinitionRequest(contextPath.addSegment("user_environmentvariabledefinition").addKeys(new NameValue(environmentvariabledefinitionid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariabledefinitionCollectionRequest user_environmentvariabledefinition() {
        return new EnvironmentvariabledefinitionCollectionRequest(
                        contextPath.addSegment("user_environmentvariabledefinition"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest lk_environmentvariablevalue_createdby(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("lk_environmentvariablevalue_createdby").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest lk_environmentvariablevalue_createdby() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("lk_environmentvariablevalue_createdby"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest lk_environmentvariablevalue_createdonbehalfby(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("lk_environmentvariablevalue_createdonbehalfby").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest lk_environmentvariablevalue_createdonbehalfby() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("lk_environmentvariablevalue_createdonbehalfby"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest lk_environmentvariablevalue_modifiedby(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("lk_environmentvariablevalue_modifiedby").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest lk_environmentvariablevalue_modifiedby() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("lk_environmentvariablevalue_modifiedby"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest lk_environmentvariablevalue_modifiedonbehalfby(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("lk_environmentvariablevalue_modifiedonbehalfby").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest lk_environmentvariablevalue_modifiedonbehalfby() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("lk_environmentvariablevalue_modifiedonbehalfby"), Optional.empty());
    }

    public EnvironmentvariablevalueRequest user_environmentvariablevalue(UUID environmentvariablevalueid) {
        return new EnvironmentvariablevalueRequest(contextPath.addSegment("user_environmentvariablevalue").addKeys(new NameValue(environmentvariablevalueid, UUID.class)), Optional.empty());
    }

    public EnvironmentvariablevalueCollectionRequest user_environmentvariablevalue() {
        return new EnvironmentvariablevalueCollectionRequest(
                        contextPath.addSegment("user_environmentvariablevalue"), Optional.empty());
    }

    public ProcessstageparameterRequest lk_processstageparameter_createdby(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("lk_processstageparameter_createdby").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest lk_processstageparameter_createdby() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("lk_processstageparameter_createdby"), Optional.empty());
    }

    public ProcessstageparameterRequest lk_processstageparameter_createdonbehalfby(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("lk_processstageparameter_createdonbehalfby").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest lk_processstageparameter_createdonbehalfby() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("lk_processstageparameter_createdonbehalfby"), Optional.empty());
    }

    public ProcessstageparameterRequest lk_processstageparameter_modifiedby(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("lk_processstageparameter_modifiedby").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest lk_processstageparameter_modifiedby() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("lk_processstageparameter_modifiedby"), Optional.empty());
    }

    public ProcessstageparameterRequest lk_processstageparameter_modifiedonbehalfby(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("lk_processstageparameter_modifiedonbehalfby").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest lk_processstageparameter_modifiedonbehalfby() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("lk_processstageparameter_modifiedonbehalfby"), Optional.empty());
    }

    public ProcessstageparameterRequest user_processstageparameter(UUID processstageparameterid) {
        return new ProcessstageparameterRequest(contextPath.addSegment("user_processstageparameter").addKeys(new NameValue(processstageparameterid, UUID.class)), Optional.empty());
    }

    public ProcessstageparameterCollectionRequest user_processstageparameter() {
        return new ProcessstageparameterCollectionRequest(
                        contextPath.addSegment("user_processstageparameter"), Optional.empty());
    }

    public FlowsessionRequest lk_flowsession_createdby(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("lk_flowsession_createdby").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest lk_flowsession_createdby() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("lk_flowsession_createdby"), Optional.empty());
    }

    public FlowsessionRequest lk_flowsession_createdonbehalfby(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("lk_flowsession_createdonbehalfby").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest lk_flowsession_createdonbehalfby() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("lk_flowsession_createdonbehalfby"), Optional.empty());
    }

    public FlowsessionRequest lk_flowsession_modifiedby(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("lk_flowsession_modifiedby").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest lk_flowsession_modifiedby() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("lk_flowsession_modifiedby"), Optional.empty());
    }

    public FlowsessionRequest lk_flowsession_modifiedonbehalfby(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("lk_flowsession_modifiedonbehalfby").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest lk_flowsession_modifiedonbehalfby() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("lk_flowsession_modifiedonbehalfby"), Optional.empty());
    }

    public FlowsessionRequest user_flowsession(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("user_flowsession").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest user_flowsession() {
        return new FlowsessionCollectionRequest(
                        contextPath.addSegment("user_flowsession"), Optional.empty());
    }

    public WorkflowbinaryRequest lk_workflowbinary_createdby(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("lk_workflowbinary_createdby").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest lk_workflowbinary_createdby() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("lk_workflowbinary_createdby"), Optional.empty());
    }

    public WorkflowbinaryRequest lk_workflowbinary_createdonbehalfby(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("lk_workflowbinary_createdonbehalfby").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest lk_workflowbinary_createdonbehalfby() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("lk_workflowbinary_createdonbehalfby"), Optional.empty());
    }

    public WorkflowbinaryRequest lk_workflowbinary_modifiedby(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("lk_workflowbinary_modifiedby").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest lk_workflowbinary_modifiedby() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("lk_workflowbinary_modifiedby"), Optional.empty());
    }

    public WorkflowbinaryRequest lk_workflowbinary_modifiedonbehalfby(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("lk_workflowbinary_modifiedonbehalfby").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest lk_workflowbinary_modifiedonbehalfby() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("lk_workflowbinary_modifiedonbehalfby"), Optional.empty());
    }

    public WorkflowbinaryRequest user_workflowbinary(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("user_workflowbinary").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest user_workflowbinary() {
        return new WorkflowbinaryCollectionRequest(
                        contextPath.addSegment("user_workflowbinary"), Optional.empty());
    }

    public ConnectionreferenceRequest lk_connectionreference_createdby(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("lk_connectionreference_createdby").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest lk_connectionreference_createdby() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("lk_connectionreference_createdby"), Optional.empty());
    }

    public ConnectionreferenceRequest lk_connectionreference_createdonbehalfby(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("lk_connectionreference_createdonbehalfby").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest lk_connectionreference_createdonbehalfby() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("lk_connectionreference_createdonbehalfby"), Optional.empty());
    }

    public ConnectionreferenceRequest lk_connectionreference_modifiedby(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("lk_connectionreference_modifiedby").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest lk_connectionreference_modifiedby() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("lk_connectionreference_modifiedby"), Optional.empty());
    }

    public ConnectionreferenceRequest lk_connectionreference_modifiedonbehalfby(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("lk_connectionreference_modifiedonbehalfby").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest lk_connectionreference_modifiedonbehalfby() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("lk_connectionreference_modifiedonbehalfby"), Optional.empty());
    }

    public ConnectionreferenceRequest user_connectionreference(UUID connectionreferenceid) {
        return new ConnectionreferenceRequest(contextPath.addSegment("user_connectionreference").addKeys(new NameValue(connectionreferenceid, UUID.class)), Optional.empty());
    }

    public ConnectionreferenceCollectionRequest user_connectionreference() {
        return new ConnectionreferenceCollectionRequest(
                        contextPath.addSegment("user_connectionreference"), Optional.empty());
    }

    public Msdyn_helppageRequest lk_msdyn_helppage_createdby(UUID msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("lk_msdyn_helppage_createdby").addKeys(new NameValue(msdyn_helppageid, UUID.class)), Optional.empty());
    }

    public Msdyn_helppageCollectionRequest lk_msdyn_helppage_createdby() {
        return new Msdyn_helppageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_helppage_createdby"), Optional.empty());
    }

    public Msdyn_helppageRequest lk_msdyn_helppage_createdonbehalfby(UUID msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("lk_msdyn_helppage_createdonbehalfby").addKeys(new NameValue(msdyn_helppageid, UUID.class)), Optional.empty());
    }

    public Msdyn_helppageCollectionRequest lk_msdyn_helppage_createdonbehalfby() {
        return new Msdyn_helppageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_helppage_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_helppageRequest lk_msdyn_helppage_modifiedby(UUID msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("lk_msdyn_helppage_modifiedby").addKeys(new NameValue(msdyn_helppageid, UUID.class)), Optional.empty());
    }

    public Msdyn_helppageCollectionRequest lk_msdyn_helppage_modifiedby() {
        return new Msdyn_helppageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_helppage_modifiedby"), Optional.empty());
    }

    public Msdyn_helppageRequest lk_msdyn_helppage_modifiedonbehalfby(UUID msdyn_helppageid) {
        return new Msdyn_helppageRequest(contextPath.addSegment("lk_msdyn_helppage_modifiedonbehalfby").addKeys(new NameValue(msdyn_helppageid, UUID.class)), Optional.empty());
    }

    public Msdyn_helppageCollectionRequest lk_msdyn_helppage_modifiedonbehalfby() {
        return new Msdyn_helppageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_helppage_modifiedonbehalfby"), Optional.empty());
    }

    public TerritoryRequest lk_territorybase_createdby(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("lk_territorybase_createdby").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest lk_territorybase_createdby() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("lk_territorybase_createdby"), Optional.empty());
    }

    public TerritoryRequest lk_territorybase_createdonbehalfby(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("lk_territorybase_createdonbehalfby").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest lk_territorybase_createdonbehalfby() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("lk_territorybase_createdonbehalfby"), Optional.empty());
    }

    public TerritoryRequest lk_territorybase_modifiedby(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("lk_territorybase_modifiedby").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest lk_territorybase_modifiedby() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("lk_territorybase_modifiedby"), Optional.empty());
    }

    public TerritoryRequest lk_territorybase_modifiedonbehalfby(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("lk_territorybase_modifiedonbehalfby").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest lk_territorybase_modifiedonbehalfby() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("lk_territorybase_modifiedonbehalfby"), Optional.empty());
    }

    public TerritoryRequest system_user_territories(UUID territoryid) {
        return new TerritoryRequest(contextPath.addSegment("system_user_territories").addKeys(new NameValue(territoryid, UUID.class)), Optional.empty());
    }

    public TerritoryCollectionRequest system_user_territories() {
        return new TerritoryCollectionRequest(
                        contextPath.addSegment("system_user_territories"), Optional.empty());
    }

    public TerritoryRequest territoryid() {
        return new TerritoryRequest(contextPath.addSegment("territoryid"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest lk_msdyn_serviceconfiguration_createdby(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("lk_msdyn_serviceconfiguration_createdby").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest lk_msdyn_serviceconfiguration_createdby() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_serviceconfiguration_createdby"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest lk_msdyn_serviceconfiguration_createdonbehalfby(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("lk_msdyn_serviceconfiguration_createdonbehalfby").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest lk_msdyn_serviceconfiguration_createdonbehalfby() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_serviceconfiguration_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest lk_msdyn_serviceconfiguration_modifiedby(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("lk_msdyn_serviceconfiguration_modifiedby").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest lk_msdyn_serviceconfiguration_modifiedby() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_serviceconfiguration_modifiedby"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest lk_msdyn_serviceconfiguration_modifiedonbehalfby(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("lk_msdyn_serviceconfiguration_modifiedonbehalfby").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest lk_msdyn_serviceconfiguration_modifiedonbehalfby() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_serviceconfiguration_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_serviceconfigurationRequest user_msdyn_serviceconfiguration(UUID msdyn_serviceconfigurationid) {
        return new Msdyn_serviceconfigurationRequest(contextPath.addSegment("user_msdyn_serviceconfiguration").addKeys(new NameValue(msdyn_serviceconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_serviceconfigurationCollectionRequest user_msdyn_serviceconfiguration() {
        return new Msdyn_serviceconfigurationCollectionRequest(
                        contextPath.addSegment("user_msdyn_serviceconfiguration"), Optional.empty());
    }

    public Msdyn_slakpiRequest lk_msdyn_slakpi_createdby(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("lk_msdyn_slakpi_createdby").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest lk_msdyn_slakpi_createdby() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("lk_msdyn_slakpi_createdby"), Optional.empty());
    }

    public Msdyn_slakpiRequest lk_msdyn_slakpi_createdonbehalfby(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("lk_msdyn_slakpi_createdonbehalfby").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest lk_msdyn_slakpi_createdonbehalfby() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("lk_msdyn_slakpi_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_slakpiRequest lk_msdyn_slakpi_modifiedby(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("lk_msdyn_slakpi_modifiedby").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest lk_msdyn_slakpi_modifiedby() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("lk_msdyn_slakpi_modifiedby"), Optional.empty());
    }

    public Msdyn_slakpiRequest lk_msdyn_slakpi_modifiedonbehalfby(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("lk_msdyn_slakpi_modifiedonbehalfby").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest lk_msdyn_slakpi_modifiedonbehalfby() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("lk_msdyn_slakpi_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_slakpiRequest user_msdyn_slakpi(UUID msdyn_slakpiid) {
        return new Msdyn_slakpiRequest(contextPath.addSegment("user_msdyn_slakpi").addKeys(new NameValue(msdyn_slakpiid, UUID.class)), Optional.empty());
    }

    public Msdyn_slakpiCollectionRequest user_msdyn_slakpi() {
        return new Msdyn_slakpiCollectionRequest(
                        contextPath.addSegment("user_msdyn_slakpi"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest lk_msdyn_knowledgearticleimage_createdby(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("lk_msdyn_knowledgearticleimage_createdby").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest lk_msdyn_knowledgearticleimage_createdby() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticleimage_createdby"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest lk_msdyn_knowledgearticleimage_createdonbehalfby(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("lk_msdyn_knowledgearticleimage_createdonbehalfby").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest lk_msdyn_knowledgearticleimage_createdonbehalfby() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticleimage_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest lk_msdyn_knowledgearticleimage_modifiedby(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("lk_msdyn_knowledgearticleimage_modifiedby").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest lk_msdyn_knowledgearticleimage_modifiedby() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticleimage_modifiedby"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest lk_msdyn_knowledgearticleimage_modifiedonbehalfby(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("lk_msdyn_knowledgearticleimage_modifiedonbehalfby").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest lk_msdyn_knowledgearticleimage_modifiedonbehalfby() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticleimage_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_knowledgearticleimageRequest user_msdyn_knowledgearticleimage(UUID msdyn_knowledgearticleimageid) {
        return new Msdyn_knowledgearticleimageRequest(contextPath.addSegment("user_msdyn_knowledgearticleimage").addKeys(new NameValue(msdyn_knowledgearticleimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticleimageCollectionRequest user_msdyn_knowledgearticleimage() {
        return new Msdyn_knowledgearticleimageCollectionRequest(
                        contextPath.addSegment("user_msdyn_knowledgearticleimage"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest lk_msdyn_knowledgearticletemplate_createdby(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("lk_msdyn_knowledgearticletemplate_createdby").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest lk_msdyn_knowledgearticletemplate_createdby() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticletemplate_createdby"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest lk_msdyn_knowledgearticletemplate_createdonbehalfby(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("lk_msdyn_knowledgearticletemplate_createdonbehalfby").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest lk_msdyn_knowledgearticletemplate_createdonbehalfby() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticletemplate_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest lk_msdyn_knowledgearticletemplate_modifiedby(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("lk_msdyn_knowledgearticletemplate_modifiedby").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest lk_msdyn_knowledgearticletemplate_modifiedby() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticletemplate_modifiedby"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest lk_msdyn_knowledgearticletemplate_modifiedonbehalfby(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("lk_msdyn_knowledgearticletemplate_modifiedonbehalfby").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest lk_msdyn_knowledgearticletemplate_modifiedonbehalfby() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_knowledgearticletemplate_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateRequest user_msdyn_knowledgearticletemplate(UUID msdyn_knowledgearticletemplateid) {
        return new Msdyn_knowledgearticletemplateRequest(contextPath.addSegment("user_msdyn_knowledgearticletemplate").addKeys(new NameValue(msdyn_knowledgearticletemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_knowledgearticletemplateCollectionRequest user_msdyn_knowledgearticletemplate() {
        return new Msdyn_knowledgearticletemplateCollectionRequest(
                        contextPath.addSegment("user_msdyn_knowledgearticletemplate"), Optional.empty());
    }

    public Msdyn_dataflowRequest lk_msdyn_dataflow_createdby(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("lk_msdyn_dataflow_createdby").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest lk_msdyn_dataflow_createdby() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("lk_msdyn_dataflow_createdby"), Optional.empty());
    }

    public Msdyn_dataflowRequest lk_msdyn_dataflow_createdonbehalfby(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("lk_msdyn_dataflow_createdonbehalfby").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest lk_msdyn_dataflow_createdonbehalfby() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("lk_msdyn_dataflow_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_dataflowRequest lk_msdyn_dataflow_modifiedby(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("lk_msdyn_dataflow_modifiedby").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest lk_msdyn_dataflow_modifiedby() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("lk_msdyn_dataflow_modifiedby"), Optional.empty());
    }

    public Msdyn_dataflowRequest lk_msdyn_dataflow_modifiedonbehalfby(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("lk_msdyn_dataflow_modifiedonbehalfby").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest lk_msdyn_dataflow_modifiedonbehalfby() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("lk_msdyn_dataflow_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_dataflowRequest user_msdyn_dataflow(UUID msdyn_dataflowid) {
        return new Msdyn_dataflowRequest(contextPath.addSegment("user_msdyn_dataflow").addKeys(new NameValue(msdyn_dataflowid, UUID.class)), Optional.empty());
    }

    public Msdyn_dataflowCollectionRequest user_msdyn_dataflow() {
        return new Msdyn_dataflowCollectionRequest(
                        contextPath.addSegment("user_msdyn_dataflow"), Optional.empty());
    }

    public Msdyn_richtextfileRequest lk_msdyn_richtextfile_createdby(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("lk_msdyn_richtextfile_createdby").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest lk_msdyn_richtextfile_createdby() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_richtextfile_createdby"), Optional.empty());
    }

    public Msdyn_richtextfileRequest lk_msdyn_richtextfile_createdonbehalfby(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("lk_msdyn_richtextfile_createdonbehalfby").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest lk_msdyn_richtextfile_createdonbehalfby() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_richtextfile_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_richtextfileRequest lk_msdyn_richtextfile_modifiedby(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("lk_msdyn_richtextfile_modifiedby").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest lk_msdyn_richtextfile_modifiedby() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_richtextfile_modifiedby"), Optional.empty());
    }

    public Msdyn_richtextfileRequest lk_msdyn_richtextfile_modifiedonbehalfby(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("lk_msdyn_richtextfile_modifiedonbehalfby").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest lk_msdyn_richtextfile_modifiedonbehalfby() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_richtextfile_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_richtextfileRequest user_msdyn_richtextfile(UUID msdyn_richtextfileid) {
        return new Msdyn_richtextfileRequest(contextPath.addSegment("user_msdyn_richtextfile").addKeys(new NameValue(msdyn_richtextfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_richtextfileCollectionRequest user_msdyn_richtextfile() {
        return new Msdyn_richtextfileCollectionRequest(
                        contextPath.addSegment("user_msdyn_richtextfile"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest lk_msdyn_aiconfiguration_createdby(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("lk_msdyn_aiconfiguration_createdby").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest lk_msdyn_aiconfiguration_createdby() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiconfiguration_createdby"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest lk_msdyn_aiconfiguration_createdonbehalfby(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("lk_msdyn_aiconfiguration_createdonbehalfby").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest lk_msdyn_aiconfiguration_createdonbehalfby() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiconfiguration_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest lk_msdyn_aiconfiguration_modifiedby(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("lk_msdyn_aiconfiguration_modifiedby").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest lk_msdyn_aiconfiguration_modifiedby() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiconfiguration_modifiedby"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest lk_msdyn_aiconfiguration_modifiedonbehalfby(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("lk_msdyn_aiconfiguration_modifiedonbehalfby").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest lk_msdyn_aiconfiguration_modifiedonbehalfby() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiconfiguration_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aiconfigurationRequest user_msdyn_aiconfiguration(UUID msdyn_aiconfigurationid) {
        return new Msdyn_aiconfigurationRequest(contextPath.addSegment("user_msdyn_aiconfiguration").addKeys(new NameValue(msdyn_aiconfigurationid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiconfigurationCollectionRequest user_msdyn_aiconfiguration() {
        return new Msdyn_aiconfigurationCollectionRequest(
                        contextPath.addSegment("user_msdyn_aiconfiguration"), Optional.empty());
    }

    public Msdyn_aimodelRequest lk_msdyn_aimodel_createdby(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("lk_msdyn_aimodel_createdby").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest lk_msdyn_aimodel_createdby() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aimodel_createdby"), Optional.empty());
    }

    public Msdyn_aimodelRequest lk_msdyn_aimodel_createdonbehalfby(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("lk_msdyn_aimodel_createdonbehalfby").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest lk_msdyn_aimodel_createdonbehalfby() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aimodel_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aimodelRequest lk_msdyn_aimodel_modifiedby(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("lk_msdyn_aimodel_modifiedby").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest lk_msdyn_aimodel_modifiedby() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aimodel_modifiedby"), Optional.empty());
    }

    public Msdyn_aimodelRequest lk_msdyn_aimodel_modifiedonbehalfby(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("lk_msdyn_aimodel_modifiedonbehalfby").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest lk_msdyn_aimodel_modifiedonbehalfby() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aimodel_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aimodelRequest user_msdyn_aimodel(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("user_msdyn_aimodel").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest user_msdyn_aimodel() {
        return new Msdyn_aimodelCollectionRequest(
                        contextPath.addSegment("user_msdyn_aimodel"), Optional.empty());
    }

    public Msdyn_aitemplateRequest lk_msdyn_aitemplate_createdby(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("lk_msdyn_aitemplate_createdby").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest lk_msdyn_aitemplate_createdby() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aitemplate_createdby"), Optional.empty());
    }

    public Msdyn_aitemplateRequest lk_msdyn_aitemplate_createdonbehalfby(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("lk_msdyn_aitemplate_createdonbehalfby").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest lk_msdyn_aitemplate_createdonbehalfby() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aitemplate_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aitemplateRequest lk_msdyn_aitemplate_modifiedby(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("lk_msdyn_aitemplate_modifiedby").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest lk_msdyn_aitemplate_modifiedby() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aitemplate_modifiedby"), Optional.empty());
    }

    public Msdyn_aitemplateRequest lk_msdyn_aitemplate_modifiedonbehalfby(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("lk_msdyn_aitemplate_modifiedonbehalfby").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest lk_msdyn_aitemplate_modifiedonbehalfby() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aitemplate_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aitemplateRequest user_msdyn_aitemplate(UUID msdyn_aitemplateid) {
        return new Msdyn_aitemplateRequest(contextPath.addSegment("user_msdyn_aitemplate").addKeys(new NameValue(msdyn_aitemplateid, UUID.class)), Optional.empty());
    }

    public Msdyn_aitemplateCollectionRequest user_msdyn_aitemplate() {
        return new Msdyn_aitemplateCollectionRequest(
                        contextPath.addSegment("user_msdyn_aitemplate"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest lk_msdyn_aibdataset_createdby(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("lk_msdyn_aibdataset_createdby").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest lk_msdyn_aibdataset_createdby() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdataset_createdby"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest lk_msdyn_aibdataset_createdonbehalfby(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("lk_msdyn_aibdataset_createdonbehalfby").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest lk_msdyn_aibdataset_createdonbehalfby() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdataset_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest lk_msdyn_aibdataset_modifiedby(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("lk_msdyn_aibdataset_modifiedby").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest lk_msdyn_aibdataset_modifiedby() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdataset_modifiedby"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest lk_msdyn_aibdataset_modifiedonbehalfby(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("lk_msdyn_aibdataset_modifiedonbehalfby").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest lk_msdyn_aibdataset_modifiedonbehalfby() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdataset_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetRequest user_msdyn_aibdataset(UUID msdyn_aibdatasetid) {
        return new Msdyn_aibdatasetRequest(contextPath.addSegment("user_msdyn_aibdataset").addKeys(new NameValue(msdyn_aibdatasetid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetCollectionRequest user_msdyn_aibdataset() {
        return new Msdyn_aibdatasetCollectionRequest(
                        contextPath.addSegment("user_msdyn_aibdataset"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest lk_msdyn_aibdatasetfile_createdby(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("lk_msdyn_aibdatasetfile_createdby").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest lk_msdyn_aibdatasetfile_createdby() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetfile_createdby"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest lk_msdyn_aibdatasetfile_createdonbehalfby(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("lk_msdyn_aibdatasetfile_createdonbehalfby").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest lk_msdyn_aibdatasetfile_createdonbehalfby() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetfile_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest lk_msdyn_aibdatasetfile_modifiedby(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("lk_msdyn_aibdatasetfile_modifiedby").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest lk_msdyn_aibdatasetfile_modifiedby() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetfile_modifiedby"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest lk_msdyn_aibdatasetfile_modifiedonbehalfby(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("lk_msdyn_aibdatasetfile_modifiedonbehalfby").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest lk_msdyn_aibdatasetfile_modifiedonbehalfby() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetfile_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetfileRequest user_msdyn_aibdatasetfile(UUID msdyn_aibdatasetfileid) {
        return new Msdyn_aibdatasetfileRequest(contextPath.addSegment("user_msdyn_aibdatasetfile").addKeys(new NameValue(msdyn_aibdatasetfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetfileCollectionRequest user_msdyn_aibdatasetfile() {
        return new Msdyn_aibdatasetfileCollectionRequest(
                        contextPath.addSegment("user_msdyn_aibdatasetfile"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest lk_msdyn_aibdatasetrecord_createdby(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("lk_msdyn_aibdatasetrecord_createdby").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest lk_msdyn_aibdatasetrecord_createdby() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetrecord_createdby"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest lk_msdyn_aibdatasetrecord_createdonbehalfby(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("lk_msdyn_aibdatasetrecord_createdonbehalfby").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest lk_msdyn_aibdatasetrecord_createdonbehalfby() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetrecord_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest lk_msdyn_aibdatasetrecord_modifiedby(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("lk_msdyn_aibdatasetrecord_modifiedby").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest lk_msdyn_aibdatasetrecord_modifiedby() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetrecord_modifiedby"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest lk_msdyn_aibdatasetrecord_modifiedonbehalfby(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("lk_msdyn_aibdatasetrecord_modifiedonbehalfby").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest lk_msdyn_aibdatasetrecord_modifiedonbehalfby() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetrecord_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetrecordRequest user_msdyn_aibdatasetrecord(UUID msdyn_aibdatasetrecordid) {
        return new Msdyn_aibdatasetrecordRequest(contextPath.addSegment("user_msdyn_aibdatasetrecord").addKeys(new NameValue(msdyn_aibdatasetrecordid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetrecordCollectionRequest user_msdyn_aibdatasetrecord() {
        return new Msdyn_aibdatasetrecordCollectionRequest(
                        contextPath.addSegment("user_msdyn_aibdatasetrecord"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest lk_msdyn_aibdatasetscontainer_createdby(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("lk_msdyn_aibdatasetscontainer_createdby").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest lk_msdyn_aibdatasetscontainer_createdby() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetscontainer_createdby"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest lk_msdyn_aibdatasetscontainer_createdonbehalfby(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("lk_msdyn_aibdatasetscontainer_createdonbehalfby").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest lk_msdyn_aibdatasetscontainer_createdonbehalfby() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetscontainer_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest lk_msdyn_aibdatasetscontainer_modifiedby(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("lk_msdyn_aibdatasetscontainer_modifiedby").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest lk_msdyn_aibdatasetscontainer_modifiedby() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetscontainer_modifiedby"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest lk_msdyn_aibdatasetscontainer_modifiedonbehalfby(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("lk_msdyn_aibdatasetscontainer_modifiedonbehalfby").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest lk_msdyn_aibdatasetscontainer_modifiedonbehalfby() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibdatasetscontainer_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerRequest user_msdyn_aibdatasetscontainer(UUID msdyn_aibdatasetscontainerid) {
        return new Msdyn_aibdatasetscontainerRequest(contextPath.addSegment("user_msdyn_aibdatasetscontainer").addKeys(new NameValue(msdyn_aibdatasetscontainerid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibdatasetscontainerCollectionRequest user_msdyn_aibdatasetscontainer() {
        return new Msdyn_aibdatasetscontainerCollectionRequest(
                        contextPath.addSegment("user_msdyn_aibdatasetscontainer"), Optional.empty());
    }

    public Msdyn_aibfileRequest lk_msdyn_aibfile_createdby(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("lk_msdyn_aibfile_createdby").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest lk_msdyn_aibfile_createdby() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfile_createdby"), Optional.empty());
    }

    public Msdyn_aibfileRequest lk_msdyn_aibfile_createdonbehalfby(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("lk_msdyn_aibfile_createdonbehalfby").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest lk_msdyn_aibfile_createdonbehalfby() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfile_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aibfileRequest lk_msdyn_aibfile_modifiedby(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("lk_msdyn_aibfile_modifiedby").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest lk_msdyn_aibfile_modifiedby() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfile_modifiedby"), Optional.empty());
    }

    public Msdyn_aibfileRequest lk_msdyn_aibfile_modifiedonbehalfby(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("lk_msdyn_aibfile_modifiedonbehalfby").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest lk_msdyn_aibfile_modifiedonbehalfby() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfile_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aibfileRequest user_msdyn_aibfile(UUID msdyn_aibfileid) {
        return new Msdyn_aibfileRequest(contextPath.addSegment("user_msdyn_aibfile").addKeys(new NameValue(msdyn_aibfileid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileCollectionRequest user_msdyn_aibfile() {
        return new Msdyn_aibfileCollectionRequest(
                        contextPath.addSegment("user_msdyn_aibfile"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest lk_msdyn_aibfileattacheddata_createdby(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("lk_msdyn_aibfileattacheddata_createdby").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest lk_msdyn_aibfileattacheddata_createdby() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfileattacheddata_createdby"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest lk_msdyn_aibfileattacheddata_createdonbehalfby(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("lk_msdyn_aibfileattacheddata_createdonbehalfby").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest lk_msdyn_aibfileattacheddata_createdonbehalfby() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfileattacheddata_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest lk_msdyn_aibfileattacheddata_modifiedby(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("lk_msdyn_aibfileattacheddata_modifiedby").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest lk_msdyn_aibfileattacheddata_modifiedby() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfileattacheddata_modifiedby"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest lk_msdyn_aibfileattacheddata_modifiedonbehalfby(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("lk_msdyn_aibfileattacheddata_modifiedonbehalfby").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest lk_msdyn_aibfileattacheddata_modifiedonbehalfby() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aibfileattacheddata_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aibfileattacheddataRequest user_msdyn_aibfileattacheddata(UUID msdyn_aibfileattacheddataid) {
        return new Msdyn_aibfileattacheddataRequest(contextPath.addSegment("user_msdyn_aibfileattacheddata").addKeys(new NameValue(msdyn_aibfileattacheddataid, UUID.class)), Optional.empty());
    }

    public Msdyn_aibfileattacheddataCollectionRequest user_msdyn_aibfileattacheddata() {
        return new Msdyn_aibfileattacheddataCollectionRequest(
                        contextPath.addSegment("user_msdyn_aibfileattacheddata"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest lk_msdyn_aifptrainingdocument_createdby(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("lk_msdyn_aifptrainingdocument_createdby").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest lk_msdyn_aifptrainingdocument_createdby() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aifptrainingdocument_createdby"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest lk_msdyn_aifptrainingdocument_createdonbehalfby(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("lk_msdyn_aifptrainingdocument_createdonbehalfby").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest lk_msdyn_aifptrainingdocument_createdonbehalfby() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aifptrainingdocument_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest lk_msdyn_aifptrainingdocument_modifiedby(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("lk_msdyn_aifptrainingdocument_modifiedby").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest lk_msdyn_aifptrainingdocument_modifiedby() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aifptrainingdocument_modifiedby"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest lk_msdyn_aifptrainingdocument_modifiedonbehalfby(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("lk_msdyn_aifptrainingdocument_modifiedonbehalfby").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest lk_msdyn_aifptrainingdocument_modifiedonbehalfby() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aifptrainingdocument_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentRequest user_msdyn_aifptrainingdocument(UUID msdyn_aifptrainingdocumentid) {
        return new Msdyn_aifptrainingdocumentRequest(contextPath.addSegment("user_msdyn_aifptrainingdocument").addKeys(new NameValue(msdyn_aifptrainingdocumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_aifptrainingdocumentCollectionRequest user_msdyn_aifptrainingdocument() {
        return new Msdyn_aifptrainingdocumentCollectionRequest(
                        contextPath.addSegment("user_msdyn_aifptrainingdocument"), Optional.empty());
    }

    public Msdyn_aiodimageRequest lk_msdyn_aiodimage_createdby(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("lk_msdyn_aiodimage_createdby").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest lk_msdyn_aiodimage_createdby() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodimage_createdby"), Optional.empty());
    }

    public Msdyn_aiodimageRequest lk_msdyn_aiodimage_createdonbehalfby(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("lk_msdyn_aiodimage_createdonbehalfby").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest lk_msdyn_aiodimage_createdonbehalfby() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodimage_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodimageRequest lk_msdyn_aiodimage_modifiedby(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("lk_msdyn_aiodimage_modifiedby").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest lk_msdyn_aiodimage_modifiedby() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodimage_modifiedby"), Optional.empty());
    }

    public Msdyn_aiodimageRequest lk_msdyn_aiodimage_modifiedonbehalfby(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("lk_msdyn_aiodimage_modifiedonbehalfby").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest lk_msdyn_aiodimage_modifiedonbehalfby() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodimage_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodimageRequest user_msdyn_aiodimage(UUID msdyn_aiodimageid) {
        return new Msdyn_aiodimageRequest(contextPath.addSegment("user_msdyn_aiodimage").addKeys(new NameValue(msdyn_aiodimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodimageCollectionRequest user_msdyn_aiodimage() {
        return new Msdyn_aiodimageCollectionRequest(
                        contextPath.addSegment("user_msdyn_aiodimage"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest lk_msdyn_aiodlabel_createdby(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("lk_msdyn_aiodlabel_createdby").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest lk_msdyn_aiodlabel_createdby() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodlabel_createdby"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest lk_msdyn_aiodlabel_createdonbehalfby(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("lk_msdyn_aiodlabel_createdonbehalfby").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest lk_msdyn_aiodlabel_createdonbehalfby() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodlabel_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest lk_msdyn_aiodlabel_modifiedby(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("lk_msdyn_aiodlabel_modifiedby").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest lk_msdyn_aiodlabel_modifiedby() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodlabel_modifiedby"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest lk_msdyn_aiodlabel_modifiedonbehalfby(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("lk_msdyn_aiodlabel_modifiedonbehalfby").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest lk_msdyn_aiodlabel_modifiedonbehalfby() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodlabel_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodlabelRequest user_msdyn_aiodlabel(UUID msdyn_aiodlabelid) {
        return new Msdyn_aiodlabelRequest(contextPath.addSegment("user_msdyn_aiodlabel").addKeys(new NameValue(msdyn_aiodlabelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodlabelCollectionRequest user_msdyn_aiodlabel() {
        return new Msdyn_aiodlabelCollectionRequest(
                        contextPath.addSegment("user_msdyn_aiodlabel"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest lk_msdyn_aiodtrainingboundingbox_createdby(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_createdby").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest lk_msdyn_aiodtrainingboundingbox_createdby() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_createdby"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest lk_msdyn_aiodtrainingboundingbox_createdonbehalfby(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_createdonbehalfby").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest lk_msdyn_aiodtrainingboundingbox_createdonbehalfby() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest lk_msdyn_aiodtrainingboundingbox_modifiedby(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_modifiedby").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest lk_msdyn_aiodtrainingboundingbox_modifiedby() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_modifiedby"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest lk_msdyn_aiodtrainingboundingbox_modifiedonbehalfby(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_modifiedonbehalfby").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest lk_msdyn_aiodtrainingboundingbox_modifiedonbehalfby() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingboundingbox_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxRequest user_msdyn_aiodtrainingboundingbox(UUID msdyn_aiodtrainingboundingboxid) {
        return new Msdyn_aiodtrainingboundingboxRequest(contextPath.addSegment("user_msdyn_aiodtrainingboundingbox").addKeys(new NameValue(msdyn_aiodtrainingboundingboxid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingboundingboxCollectionRequest user_msdyn_aiodtrainingboundingbox() {
        return new Msdyn_aiodtrainingboundingboxCollectionRequest(
                        contextPath.addSegment("user_msdyn_aiodtrainingboundingbox"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest lk_msdyn_aiodtrainingimage_createdby(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("lk_msdyn_aiodtrainingimage_createdby").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest lk_msdyn_aiodtrainingimage_createdby() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingimage_createdby"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest lk_msdyn_aiodtrainingimage_createdonbehalfby(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("lk_msdyn_aiodtrainingimage_createdonbehalfby").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest lk_msdyn_aiodtrainingimage_createdonbehalfby() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingimage_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest lk_msdyn_aiodtrainingimage_modifiedby(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("lk_msdyn_aiodtrainingimage_modifiedby").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest lk_msdyn_aiodtrainingimage_modifiedby() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingimage_modifiedby"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest lk_msdyn_aiodtrainingimage_modifiedonbehalfby(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("lk_msdyn_aiodtrainingimage_modifiedonbehalfby").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest lk_msdyn_aiodtrainingimage_modifiedonbehalfby() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("lk_msdyn_aiodtrainingimage_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_aiodtrainingimageRequest user_msdyn_aiodtrainingimage(UUID msdyn_aiodtrainingimageid) {
        return new Msdyn_aiodtrainingimageRequest(contextPath.addSegment("user_msdyn_aiodtrainingimage").addKeys(new NameValue(msdyn_aiodtrainingimageid, UUID.class)), Optional.empty());
    }

    public Msdyn_aiodtrainingimageCollectionRequest user_msdyn_aiodtrainingimage() {
        return new Msdyn_aiodtrainingimageCollectionRequest(
                        contextPath.addSegment("user_msdyn_aiodtrainingimage"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest lk_msdyn_analysiscomponent_createdby(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("lk_msdyn_analysiscomponent_createdby").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest lk_msdyn_analysiscomponent_createdby() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysiscomponent_createdby"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest lk_msdyn_analysiscomponent_createdonbehalfby(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("lk_msdyn_analysiscomponent_createdonbehalfby").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest lk_msdyn_analysiscomponent_createdonbehalfby() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysiscomponent_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest lk_msdyn_analysiscomponent_modifiedby(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("lk_msdyn_analysiscomponent_modifiedby").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest lk_msdyn_analysiscomponent_modifiedby() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysiscomponent_modifiedby"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest lk_msdyn_analysiscomponent_modifiedonbehalfby(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("lk_msdyn_analysiscomponent_modifiedonbehalfby").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest lk_msdyn_analysiscomponent_modifiedonbehalfby() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysiscomponent_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_analysiscomponentRequest user_msdyn_analysiscomponent(UUID msdyn_analysiscomponentid) {
        return new Msdyn_analysiscomponentRequest(contextPath.addSegment("user_msdyn_analysiscomponent").addKeys(new NameValue(msdyn_analysiscomponentid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysiscomponentCollectionRequest user_msdyn_analysiscomponent() {
        return new Msdyn_analysiscomponentCollectionRequest(
                        contextPath.addSegment("user_msdyn_analysiscomponent"), Optional.empty());
    }

    public Msdyn_analysisjobRequest lk_msdyn_analysisjob_createdby(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("lk_msdyn_analysisjob_createdby").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest lk_msdyn_analysisjob_createdby() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisjob_createdby"), Optional.empty());
    }

    public Msdyn_analysisjobRequest lk_msdyn_analysisjob_createdonbehalfby(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("lk_msdyn_analysisjob_createdonbehalfby").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest lk_msdyn_analysisjob_createdonbehalfby() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisjob_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_analysisjobRequest lk_msdyn_analysisjob_modifiedby(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("lk_msdyn_analysisjob_modifiedby").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest lk_msdyn_analysisjob_modifiedby() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisjob_modifiedby"), Optional.empty());
    }

    public Msdyn_analysisjobRequest lk_msdyn_analysisjob_modifiedonbehalfby(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("lk_msdyn_analysisjob_modifiedonbehalfby").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest lk_msdyn_analysisjob_modifiedonbehalfby() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisjob_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_analysisjobRequest user_msdyn_analysisjob(UUID msdyn_analysisjobid) {
        return new Msdyn_analysisjobRequest(contextPath.addSegment("user_msdyn_analysisjob").addKeys(new NameValue(msdyn_analysisjobid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisjobCollectionRequest user_msdyn_analysisjob() {
        return new Msdyn_analysisjobCollectionRequest(
                        contextPath.addSegment("user_msdyn_analysisjob"), Optional.empty());
    }

    public Msdyn_analysisresultRequest lk_msdyn_analysisresult_createdby(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("lk_msdyn_analysisresult_createdby").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest lk_msdyn_analysisresult_createdby() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresult_createdby"), Optional.empty());
    }

    public Msdyn_analysisresultRequest lk_msdyn_analysisresult_createdonbehalfby(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("lk_msdyn_analysisresult_createdonbehalfby").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest lk_msdyn_analysisresult_createdonbehalfby() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresult_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_analysisresultRequest lk_msdyn_analysisresult_modifiedby(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("lk_msdyn_analysisresult_modifiedby").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest lk_msdyn_analysisresult_modifiedby() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresult_modifiedby"), Optional.empty());
    }

    public Msdyn_analysisresultRequest lk_msdyn_analysisresult_modifiedonbehalfby(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("lk_msdyn_analysisresult_modifiedonbehalfby").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest lk_msdyn_analysisresult_modifiedonbehalfby() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresult_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_analysisresultRequest user_msdyn_analysisresult(UUID msdyn_analysisresultid) {
        return new Msdyn_analysisresultRequest(contextPath.addSegment("user_msdyn_analysisresult").addKeys(new NameValue(msdyn_analysisresultid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultCollectionRequest user_msdyn_analysisresult() {
        return new Msdyn_analysisresultCollectionRequest(
                        contextPath.addSegment("user_msdyn_analysisresult"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest lk_msdyn_analysisresultdetail_createdby(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("lk_msdyn_analysisresultdetail_createdby").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest lk_msdyn_analysisresultdetail_createdby() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresultdetail_createdby"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest lk_msdyn_analysisresultdetail_createdonbehalfby(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("lk_msdyn_analysisresultdetail_createdonbehalfby").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest lk_msdyn_analysisresultdetail_createdonbehalfby() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresultdetail_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest lk_msdyn_analysisresultdetail_modifiedby(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("lk_msdyn_analysisresultdetail_modifiedby").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest lk_msdyn_analysisresultdetail_modifiedby() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresultdetail_modifiedby"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest lk_msdyn_analysisresultdetail_modifiedonbehalfby(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("lk_msdyn_analysisresultdetail_modifiedonbehalfby").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest lk_msdyn_analysisresultdetail_modifiedonbehalfby() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("lk_msdyn_analysisresultdetail_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_analysisresultdetailRequest user_msdyn_analysisresultdetail(UUID msdyn_analysisresultdetailid) {
        return new Msdyn_analysisresultdetailRequest(contextPath.addSegment("user_msdyn_analysisresultdetail").addKeys(new NameValue(msdyn_analysisresultdetailid, UUID.class)), Optional.empty());
    }

    public Msdyn_analysisresultdetailCollectionRequest user_msdyn_analysisresultdetail() {
        return new Msdyn_analysisresultdetailCollectionRequest(
                        contextPath.addSegment("user_msdyn_analysisresultdetail"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest lk_msdyn_solutionhealthrule_createdby(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("lk_msdyn_solutionhealthrule_createdby").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest lk_msdyn_solutionhealthrule_createdby() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthrule_createdby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest lk_msdyn_solutionhealthrule_createdonbehalfby(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("lk_msdyn_solutionhealthrule_createdonbehalfby").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest lk_msdyn_solutionhealthrule_createdonbehalfby() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthrule_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest lk_msdyn_solutionhealthrule_modifiedby(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("lk_msdyn_solutionhealthrule_modifiedby").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest lk_msdyn_solutionhealthrule_modifiedby() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthrule_modifiedby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest lk_msdyn_solutionhealthrule_modifiedonbehalfby(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("lk_msdyn_solutionhealthrule_modifiedonbehalfby").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest lk_msdyn_solutionhealthrule_modifiedonbehalfby() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthrule_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest user_msdyn_solutionhealthrule(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("user_msdyn_solutionhealthrule").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest user_msdyn_solutionhealthrule() {
        return new Msdyn_solutionhealthruleCollectionRequest(
                        contextPath.addSegment("user_msdyn_solutionhealthrule"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest lk_msdyn_solutionhealthruleargument_createdby(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleargument_createdby").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest lk_msdyn_solutionhealthruleargument_createdby() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleargument_createdby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest lk_msdyn_solutionhealthruleargument_createdonbehalfby(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleargument_createdonbehalfby").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest lk_msdyn_solutionhealthruleargument_createdonbehalfby() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleargument_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest lk_msdyn_solutionhealthruleargument_modifiedby(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleargument_modifiedby").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest lk_msdyn_solutionhealthruleargument_modifiedby() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleargument_modifiedby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest lk_msdyn_solutionhealthruleargument_modifiedonbehalfby(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleargument_modifiedonbehalfby").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest lk_msdyn_solutionhealthruleargument_modifiedonbehalfby() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleargument_modifiedonbehalfby"), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentRequest user_msdyn_solutionhealthruleargument(UUID msdyn_solutionhealthruleargumentid) {
        return new Msdyn_solutionhealthruleargumentRequest(contextPath.addSegment("user_msdyn_solutionhealthruleargument").addKeys(new NameValue(msdyn_solutionhealthruleargumentid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleargumentCollectionRequest user_msdyn_solutionhealthruleargument() {
        return new Msdyn_solutionhealthruleargumentCollectionRequest(
                        contextPath.addSegment("user_msdyn_solutionhealthruleargument"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest lk_msdyn_solutionhealthruleset_createdby(UUID msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleset_createdby").addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetCollectionRequest lk_msdyn_solutionhealthruleset_createdby() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleset_createdby"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest lk_msdyn_solutionhealthruleset_createdonbehalfby(UUID msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleset_createdonbehalfby").addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetCollectionRequest lk_msdyn_solutionhealthruleset_createdonbehalfby() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleset_createdonbehalfby"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest lk_msdyn_solutionhealthruleset_modifiedby(UUID msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleset_modifiedby").addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetCollectionRequest lk_msdyn_solutionhealthruleset_modifiedby() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleset_modifiedby"), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetRequest lk_msdyn_solutionhealthruleset_modifiedonbehalfby(UUID msdyn_solutionhealthrulesetid) {
        return new Msdyn_solutionhealthrulesetRequest(contextPath.addSegment("lk_msdyn_solutionhealthruleset_modifiedonbehalfby").addKeys(new NameValue(msdyn_solutionhealthrulesetid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthrulesetCollectionRequest lk_msdyn_solutionhealthruleset_modifiedonbehalfby() {
        return new Msdyn_solutionhealthrulesetCollectionRequest(
                        contextPath.addSegment("lk_msdyn_solutionhealthruleset_modifiedonbehalfby"), Optional.empty());
    }

    public Ggw_eventRequest lk_ggw_event_createdby(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("lk_ggw_event_createdby").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest lk_ggw_event_createdby() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("lk_ggw_event_createdby"), Optional.empty());
    }

    public Ggw_eventRequest lk_ggw_event_createdonbehalfby(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("lk_ggw_event_createdonbehalfby").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest lk_ggw_event_createdonbehalfby() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("lk_ggw_event_createdonbehalfby"), Optional.empty());
    }

    public Ggw_eventRequest lk_ggw_event_modifiedby(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("lk_ggw_event_modifiedby").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest lk_ggw_event_modifiedby() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("lk_ggw_event_modifiedby"), Optional.empty());
    }

    public Ggw_eventRequest lk_ggw_event_modifiedonbehalfby(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("lk_ggw_event_modifiedonbehalfby").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest lk_ggw_event_modifiedonbehalfby() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("lk_ggw_event_modifiedonbehalfby"), Optional.empty());
    }

    public Ggw_eventRequest user_ggw_event(UUID ggw_eventid) {
        return new Ggw_eventRequest(contextPath.addSegment("user_ggw_event").addKeys(new NameValue(ggw_eventid, UUID.class)), Optional.empty());
    }

    public Ggw_eventCollectionRequest user_ggw_event() {
        return new Ggw_eventCollectionRequest(
                        contextPath.addSegment("user_ggw_event"), Optional.empty());
    }

    public Ggw_teamRequest lk_ggw_team_createdby(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("lk_ggw_team_createdby").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest lk_ggw_team_createdby() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_createdby"), Optional.empty());
    }

    public Ggw_teamRequest lk_ggw_team_createdonbehalfby(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("lk_ggw_team_createdonbehalfby").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest lk_ggw_team_createdonbehalfby() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_createdonbehalfby"), Optional.empty());
    }

    public Ggw_teamRequest lk_ggw_team_modifiedby(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("lk_ggw_team_modifiedby").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest lk_ggw_team_modifiedby() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_modifiedby"), Optional.empty());
    }

    public Ggw_teamRequest lk_ggw_team_modifiedonbehalfby(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("lk_ggw_team_modifiedonbehalfby").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest lk_ggw_team_modifiedonbehalfby() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_modifiedonbehalfby"), Optional.empty());
    }

    public Ggw_teamRequest user_ggw_team(UUID ggw_teamid) {
        return new Ggw_teamRequest(contextPath.addSegment("user_ggw_team").addKeys(new NameValue(ggw_teamid, UUID.class)), Optional.empty());
    }

    public Ggw_teamCollectionRequest user_ggw_team() {
        return new Ggw_teamCollectionRequest(
                        contextPath.addSegment("user_ggw_team"), Optional.empty());
    }

    public Ggw_crewRequest lk_ggw_crew_createdby(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("lk_ggw_crew_createdby").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest lk_ggw_crew_createdby() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("lk_ggw_crew_createdby"), Optional.empty());
    }

    public Ggw_crewRequest lk_ggw_crew_createdonbehalfby(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("lk_ggw_crew_createdonbehalfby").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest lk_ggw_crew_createdonbehalfby() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("lk_ggw_crew_createdonbehalfby"), Optional.empty());
    }

    public Ggw_crewRequest lk_ggw_crew_modifiedby(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("lk_ggw_crew_modifiedby").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest lk_ggw_crew_modifiedby() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("lk_ggw_crew_modifiedby"), Optional.empty());
    }

    public Ggw_crewRequest lk_ggw_crew_modifiedonbehalfby(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("lk_ggw_crew_modifiedonbehalfby").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest lk_ggw_crew_modifiedonbehalfby() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("lk_ggw_crew_modifiedonbehalfby"), Optional.empty());
    }

    public Ggw_crewRequest user_ggw_crew(UUID ggw_crewid) {
        return new Ggw_crewRequest(contextPath.addSegment("user_ggw_crew").addKeys(new NameValue(ggw_crewid, UUID.class)), Optional.empty());
    }

    public Ggw_crewCollectionRequest user_ggw_crew() {
        return new Ggw_crewCollectionRequest(
                        contextPath.addSegment("user_ggw_crew"), Optional.empty());
    }

    public Ggw_team_applicationRequest lk_ggw_team_application_createdby(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("lk_ggw_team_application_createdby").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest lk_ggw_team_application_createdby() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_application_createdby"), Optional.empty());
    }

    public Ggw_team_applicationRequest lk_ggw_team_application_createdonbehalfby(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("lk_ggw_team_application_createdonbehalfby").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest lk_ggw_team_application_createdonbehalfby() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_application_createdonbehalfby"), Optional.empty());
    }

    public Ggw_team_applicationRequest lk_ggw_team_application_modifiedby(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("lk_ggw_team_application_modifiedby").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest lk_ggw_team_application_modifiedby() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_application_modifiedby"), Optional.empty());
    }

    public Ggw_team_applicationRequest lk_ggw_team_application_modifiedonbehalfby(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("lk_ggw_team_application_modifiedonbehalfby").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest lk_ggw_team_application_modifiedonbehalfby() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("lk_ggw_team_application_modifiedonbehalfby"), Optional.empty());
    }

    public Ggw_team_applicationRequest user_ggw_team_application(UUID ggw_team_applicationid) {
        return new Ggw_team_applicationRequest(contextPath.addSegment("user_ggw_team_application").addKeys(new NameValue(ggw_team_applicationid, UUID.class)), Optional.empty());
    }

    public Ggw_team_applicationCollectionRequest user_ggw_team_application() {
        return new Ggw_team_applicationCollectionRequest(
                        contextPath.addSegment("user_ggw_team_application"), Optional.empty());
    }

    @Action(name = "AddUserToRecordTeam")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AddUserToRecordTeamResponse> addUserToRecordTeam(Crmbaseentity record, Teamtemplate teamTemplate) {
        Preconditions.checkNotNull(record, "record cannot be null");
        Preconditions.checkNotNull(teamTemplate, "teamTemplate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Record", "Microsoft.Dynamics.CRM.crmbaseentity", record)
            .put("TeamTemplate", "Microsoft.Dynamics.CRM.teamtemplate", teamTemplate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<AddUserToRecordTeamResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.AddUserToRecordTeam"), AddUserToRecordTeamResponse.class, _parameters);
    }

    @Action(name = "InstantiateFilters")
    @JsonIgnore
    public ActionRequestNoReturn instantiateFilters(List<Savedquery> templateCollection) {
        Preconditions.checkNotNull(templateCollection, "templateCollection cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("TemplateCollection", "Collection(Microsoft.Dynamics.CRM.savedquery)", templateCollection)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.InstantiateFilters"), _parameters);
    }

    @Action(name = "ReassignObjectsSystemUser")
    @JsonIgnore
    public ActionRequestNoReturn reassignObjectsSystemUser(Crmbaseentity reassignPrincipal) {
        Preconditions.checkNotNull(reassignPrincipal, "reassignPrincipal cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ReassignPrincipal", "Microsoft.Dynamics.CRM.crmbaseentity", reassignPrincipal)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.ReassignObjectsSystemUser"), _parameters);
    }

    @Action(name = "RemoveUserFromRecordTeam")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<RemoveUserFromRecordTeamResponse> removeUserFromRecordTeam(Crmbaseentity record, Teamtemplate teamTemplate) {
        Preconditions.checkNotNull(record, "record cannot be null");
        Preconditions.checkNotNull(teamTemplate, "teamTemplate cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Record", "Microsoft.Dynamics.CRM.crmbaseentity", record)
            .put("TeamTemplate", "Microsoft.Dynamics.CRM.teamtemplate", teamTemplate)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<RemoveUserFromRecordTeamResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RemoveUserFromRecordTeam"), RemoveUserFromRecordTeamResponse.class, _parameters);
    }

    @Action(name = "SetBusinessSystemUser")
    @JsonIgnore
    public ActionRequestNoReturn setBusinessSystemUser(Businessunit businessUnit, Crmbaseentity reassignPrincipal) {
        Preconditions.checkNotNull(businessUnit, "businessUnit cannot be null");
        Preconditions.checkNotNull(reassignPrincipal, "reassignPrincipal cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("BusinessUnit", "Microsoft.Dynamics.CRM.businessunit", businessUnit)
            .put("ReassignPrincipal", "Microsoft.Dynamics.CRM.crmbaseentity", reassignPrincipal)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetBusinessSystemUser"), _parameters);
    }

    @Action(name = "SetParentSystemUser")
    @JsonIgnore
    public ActionRequestNoReturn setParentSystemUser(Systemuser parent, Boolean keepChildUsers) {
        Preconditions.checkNotNull(parent, "parent cannot be null");
        Preconditions.checkNotNull(keepChildUsers, "keepChildUsers cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Parent", "Microsoft.Dynamics.CRM.systemuser", parent)
            .put("KeepChildUsers", "Edm.Boolean", keepChildUsers)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.SetParentSystemUser"), _parameters);
    }

    @Function(name = "RetrieveAllChildUsersSystemUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Systemuser> retrieveAllChildUsersSystemUser() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveAllChildUsersSystemUser"), Systemuser.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAccess")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessResponse> retrievePrincipalAccess(Crmbaseentity target) {
        Preconditions.checkNotNull(target, "target cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("Target", "Microsoft.Dynamics.CRM.crmbaseentity", target)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAccess"), RetrievePrincipalAccessResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAccessInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessInfoResponse> retrievePrincipalAccessInfo(UUID objectId, String entityName) {
        Preconditions.checkNotNull(objectId, "objectId cannot be null");
        Preconditions.checkNotNull(entityName, "entityName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ObjectId", "Edm.Guid", objectId)
            .put("EntityName", "Edm.String", Checks.checkIsAscii(entityName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAccessInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAccessInfo"), RetrievePrincipalAccessInfoResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalAttributePrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAttributePrivilegesResponse> retrievePrincipalAttributePrivileges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalAttributePrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalAttributePrivileges"), RetrievePrincipalAttributePrivilegesResponse.class, _parameters);
    }

    @Function(name = "RetrievePrincipalSyncAttributeMappings")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalSyncAttributeMappingsResponse> retrievePrincipalSyncAttributeMappings() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrievePrincipalSyncAttributeMappingsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrievePrincipalSyncAttributeMappings"), RetrievePrincipalSyncAttributeMappingsResponse.class, _parameters);
    }

    @Function(name = "RetrieveUserLicenseInfo")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserLicenseInfoResponse> retrieveUserLicenseInfo() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserLicenseInfoResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUserLicenseInfo"), RetrieveUserLicenseInfoResponse.class, _parameters);
    }

    @Function(name = "RetrieveUserPrivilegeByPrivilegeId")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserPrivilegeByPrivilegeIdResponse> retrieveUserPrivilegeByPrivilegeId(UUID privilegeId) {
        Preconditions.checkNotNull(privilegeId, "privilegeId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PrivilegeId", "Edm.Guid", privilegeId)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserPrivilegeByPrivilegeIdResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUserPrivilegeByPrivilegeId"), RetrieveUserPrivilegeByPrivilegeIdResponse.class, _parameters);
    }

    @Function(name = "RetrieveUserPrivilegeByPrivilegeName")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserPrivilegeByPrivilegeNameResponse> retrieveUserPrivilegeByPrivilegeName(String privilegeName) {
        Preconditions.checkNotNull(privilegeName, "privilegeName cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("PrivilegeName", "Edm.String", Checks.checkIsAscii(privilegeName))
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserPrivilegeByPrivilegeNameResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUserPrivilegeByPrivilegeName"), RetrieveUserPrivilegeByPrivilegeNameResponse.class, _parameters);
    }

    @Function(name = "RetrieveUserPrivileges")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserPrivilegesResponse> retrieveUserPrivileges() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveUserPrivilegesResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUserPrivileges"), RetrieveUserPrivilegesResponse.class, _parameters);
    }

    @Function(name = "RetrieveUserQueues")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Queue> retrieveUserQueues(Boolean includePublic) {
        Preconditions.checkNotNull(includePublic, "includePublic cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("IncludePublic", "Edm.Boolean", includePublic)
            .build();
        return CollectionPageNonEntityRequest.forFunction(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUserQueues"), Queue.class, _parameters);
    }

    @Function(name = "RetrieveUsersPrivilegesThroughTeams")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<RetrieveUsersPrivilegesThroughTeamsResponse> retrieveUsersPrivilegesThroughTeams(Boolean excludeOrgDisabledPrivileges, Boolean includeSetupUserFiltering) {
        Preconditions.checkNotNull(excludeOrgDisabledPrivileges, "excludeOrgDisabledPrivileges cannot be null");
        Preconditions.checkNotNull(includeSetupUserFiltering, "includeSetupUserFiltering cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("ExcludeOrgDisabledPrivileges", "Edm.Boolean", excludeOrgDisabledPrivileges)
            .put("IncludeSetupUserFiltering", "Edm.Boolean", includeSetupUserFiltering)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<RetrieveUsersPrivilegesThroughTeamsResponse>(this.contextPath.addActionOrFunctionSegment("Microsoft.Dynamics.CRM.RetrieveUsersPrivilegesThroughTeams"), RetrieveUsersPrivilegesThroughTeamsResponse.class, _parameters);
    }

}
