package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Letter;
import microsoft.dynamics.crm.entity.collection.request.ActioncardCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ActivitypartyCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AnnotationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.AsyncoperationCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.BulkdeletefailureCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ConnectionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.DuplicaterecordCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.PrincipalobjectattributeaccessCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.ProcesssessionCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.QueueitemCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SlakpiinstanceCollectionRequest;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class LetterRequest extends EntityRequest<Letter> {

    public LetterRequest(ContextPath contextPath, Optional<Object> value) {
        super(Letter.class, contextPath, value, false);
    }

    public KnowledgebaserecordRequest regardingobjectid_knowledgebaserecord_letter() {
        return new KnowledgebaserecordRequest(contextPath.addSegment("regardingobjectid_knowledgebaserecord_letter"), Optional.empty());
    }

    public ActioncardRequest letter_actioncard(UUID actioncardid) {
        return new ActioncardRequest(contextPath.addSegment("letter_actioncard").addKeys(new NameValue(actioncardid, UUID.class)), Optional.empty());
    }

    public ActioncardCollectionRequest letter_actioncard() {
        return new ActioncardCollectionRequest(
                        contextPath.addSegment("letter_actioncard"), Optional.empty());
    }

    public PrincipalobjectattributeaccessRequest letter_principalobjectattributeaccess(UUID principalobjectattributeaccessid) {
        return new PrincipalobjectattributeaccessRequest(contextPath.addSegment("letter_principalobjectattributeaccess").addKeys(new NameValue(principalobjectattributeaccessid, UUID.class)), Optional.empty());
    }

    public PrincipalobjectattributeaccessCollectionRequest letter_principalobjectattributeaccess() {
        return new PrincipalobjectattributeaccessCollectionRequest(
                        contextPath.addSegment("letter_principalobjectattributeaccess"), Optional.empty());
    }

    public SlakpiinstanceRequest slakpiinstance_letter(UUID slakpiinstanceid) {
        return new SlakpiinstanceRequest(contextPath.addSegment("slakpiinstance_letter").addKeys(new NameValue(slakpiinstanceid, UUID.class)), Optional.empty());
    }

    public SlakpiinstanceCollectionRequest slakpiinstance_letter() {
        return new SlakpiinstanceCollectionRequest(
                        contextPath.addSegment("slakpiinstance_letter"), Optional.empty());
    }

    public ProcesssessionRequest letter_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Letter_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest letter_ProcessSessions() {
        return new ProcesssessionCollectionRequest(
                        contextPath.addSegment("Letter_ProcessSessions"), Optional.empty());
    }

    public ProcessstageRequest stageid_processstage() {
        return new ProcessstageRequest(contextPath.addSegment("stageid_processstage"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby_letter() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby_letter"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby_letter() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby_letter"), Optional.empty());
    }

    public ConnectionRequest letter_connections2(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("letter_connections2").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest letter_connections2() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("letter_connections2"), Optional.empty());
    }

    public BulkdeletefailureRequest letter_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Letter_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest letter_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(
                        contextPath.addSegment("Letter_BulkDeleteFailures"), Optional.empty());
    }

    public KnowledgearticleRequest regardingobjectid_knowledgearticle_letter() {
        return new KnowledgearticleRequest(contextPath.addSegment("regardingobjectid_knowledgearticle_letter"), Optional.empty());
    }

    public SyncerrorRequest letter_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Letter_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest letter_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("Letter_SyncErrors"), Optional.empty());
    }

    public BusinessunitRequest owningbusinessunit_letter() {
        return new BusinessunitRequest(contextPath.addSegment("owningbusinessunit_letter"), Optional.empty());
    }

    public AnnotationRequest letter_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Letter_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest letter_Annotation() {
        return new AnnotationCollectionRequest(
                        contextPath.addSegment("Letter_Annotation"), Optional.empty());
    }

    public SlaRequest slainvokedid_letter_sla() {
        return new SlaRequest(contextPath.addSegment("slainvokedid_letter_sla"), Optional.empty());
    }

    public TeamRequest owningteam_letter() {
        return new TeamRequest(contextPath.addSegment("owningteam_letter"), Optional.empty());
    }

    public ActivitypartyRequest letter_activity_parties(UUID activitypartyid) {
        return new ActivitypartyRequest(contextPath.addSegment("letter_activity_parties").addKeys(new NameValue(activitypartyid, UUID.class)), Optional.empty());
    }

    public ActivitypartyCollectionRequest letter_activity_parties() {
        return new ActivitypartyCollectionRequest(
                        contextPath.addSegment("letter_activity_parties"), Optional.empty());
    }

    public AsyncoperationRequest letter_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Letter_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest letter_AsyncOperations() {
        return new AsyncoperationCollectionRequest(
                        contextPath.addSegment("Letter_AsyncOperations"), Optional.empty());
    }

    public TransactioncurrencyRequest transactioncurrencyid_letter() {
        return new TransactioncurrencyRequest(contextPath.addSegment("transactioncurrencyid_letter"), Optional.empty());
    }

    public ConnectionRequest letter_connections1(UUID connectionid) {
        return new ConnectionRequest(contextPath.addSegment("letter_connections1").addKeys(new NameValue(connectionid, UUID.class)), Optional.empty());
    }

    public ConnectionCollectionRequest letter_connections1() {
        return new ConnectionCollectionRequest(
                        contextPath.addSegment("letter_connections1"), Optional.empty());
    }

    public SystemuserRequest owninguser_letter() {
        return new SystemuserRequest(contextPath.addSegment("owninguser_letter"), Optional.empty());
    }

    public DuplicaterecordRequest letter_DuplicateBaseRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Letter_DuplicateBaseRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest letter_DuplicateBaseRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Letter_DuplicateBaseRecord"), Optional.empty());
    }

    public QueueitemRequest letter_QueueItem(UUID queueitemid) {
        return new QueueitemRequest(contextPath.addSegment("Letter_QueueItem").addKeys(new NameValue(queueitemid, UUID.class)), Optional.empty());
    }

    public QueueitemCollectionRequest letter_QueueItem() {
        return new QueueitemCollectionRequest(
                        contextPath.addSegment("Letter_QueueItem"), Optional.empty());
    }

    public ActivitypointerRequest activityid_activitypointer() {
        return new ActivitypointerRequest(contextPath.addSegment("activityid_activitypointer"), Optional.empty());
    }

    public SystemuserRequest modifiedby_letter() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby_letter"), Optional.empty());
    }

    public SlaRequest sla_letter_sla() {
        return new SlaRequest(contextPath.addSegment("sla_letter_sla"), Optional.empty());
    }

    public SystemuserRequest createdby_letter() {
        return new SystemuserRequest(contextPath.addSegment("createdby_letter"), Optional.empty());
    }

    public DuplicaterecordRequest letter_DuplicateMatchingRecord(UUID duplicateid) {
        return new DuplicaterecordRequest(contextPath.addSegment("Letter_DuplicateMatchingRecord").addKeys(new NameValue(duplicateid, UUID.class)), Optional.empty());
    }

    public DuplicaterecordCollectionRequest letter_DuplicateMatchingRecord() {
        return new DuplicaterecordCollectionRequest(
                        contextPath.addSegment("Letter_DuplicateMatchingRecord"), Optional.empty());
    }

    public AccountRequest regardingobjectid_account_letter() {
        return new AccountRequest(contextPath.addSegment("regardingobjectid_account_letter"), Optional.empty());
    }

    public ContactRequest regardingobjectid_contact_letter() {
        return new ContactRequest(contextPath.addSegment("regardingobjectid_contact_letter"), Optional.empty());
    }

    public PrincipalRequest ownerid_letter() {
        return new PrincipalRequest(contextPath.addSegment("ownerid_letter"), Optional.empty());
    }

}
