package microsoft.dynamics.crm.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Duplicaterulecondition;
import microsoft.dynamics.crm.entity.collection.request.SyncerrorCollectionRequest;

@JsonIgnoreType
public class DuplicateruleconditionRequest extends EntityRequest<Duplicaterulecondition> {

    public DuplicateruleconditionRequest(ContextPath contextPath, Optional<Object> value) {
        super(Duplicaterulecondition.class, contextPath, value, false);
    }

    public SyncerrorRequest duplicateRuleCondition_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("DuplicateRuleCondition_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest duplicateRuleCondition_SyncErrors() {
        return new SyncerrorCollectionRequest(
                        contextPath.addSegment("DuplicateRuleCondition_SyncErrors"), Optional.empty());
    }

    public DuplicateruleRequest regardingobjectid() {
        return new DuplicateruleRequest(contextPath.addSegment("regardingobjectid"), Optional.empty());
    }

    public SystemuserRequest createdonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("createdonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedonbehalfby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedonbehalfby"), Optional.empty());
    }

    public SystemuserRequest modifiedby() {
        return new SystemuserRequest(contextPath.addSegment("modifiedby"), Optional.empty());
    }

    public SystemuserRequest createdby() {
        return new SystemuserRequest(contextPath.addSegment("createdby"), Optional.empty());
    }

}
