package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Workflow;
import microsoft.dynamics.crm.entity.request.AnnotationRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.ExpiredprocessRequest;
import microsoft.dynamics.crm.entity.request.FlowsessionRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_aimodelRequest;
import microsoft.dynamics.crm.entity.request.Msdyn_solutionhealthruleRequest;
import microsoft.dynamics.crm.entity.request.NewprocessRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.ProcessstageRequest;
import microsoft.dynamics.crm.entity.request.ProcesstriggerRequest;
import microsoft.dynamics.crm.entity.request.SlaRequest;
import microsoft.dynamics.crm.entity.request.SlaitemRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TranslationprocessRequest;
import microsoft.dynamics.crm.entity.request.WorkflowRequest;
import microsoft.dynamics.crm.entity.request.WorkflowbinaryRequest;

public class WorkflowCollectionRequest extends CollectionPageEntityRequest<Workflow, WorkflowRequest>{

    protected ContextPath contextPath;

    public WorkflowCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Workflow.class, cp -> new WorkflowRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SlaRequest slabase_workflowid(UUID slaid) {
        return new SlaRequest(contextPath.addSegment("slabase_workflowid").addKeys(new NameValue(slaid, UUID.class)), Optional.empty());
    }

    public SlaCollectionRequest slabase_workflowid() {
        return new SlaCollectionRequest(contextPath.addSegment("slabase_workflowid"), Optional.empty());
    }

    public AsyncoperationRequest lk_asyncoperation_workflowactivationid(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("lk_asyncoperation_workflowactivationid").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest lk_asyncoperation_workflowactivationid() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("lk_asyncoperation_workflowactivationid"), Optional.empty());
    }

    public WorkflowRequest workflow_parent_workflow(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflow_parent_workflow").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest workflow_parent_workflow() {
        return new WorkflowCollectionRequest(contextPath.addSegment("workflow_parent_workflow"), Optional.empty());
    }

    public ExpiredprocessRequest workflow_expiredprocess(UUID businessprocessflowinstanceid) {
        return new ExpiredprocessRequest(contextPath.addSegment("workflow_expiredprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public ExpiredprocessCollectionRequest workflow_expiredprocess() {
        return new ExpiredprocessCollectionRequest(contextPath.addSegment("workflow_expiredprocess"), Optional.empty());
    }

    public SlaitemRequest slaitembase_workflowid(UUID slaitemid) {
        return new SlaitemRequest(contextPath.addSegment("slaitembase_workflowid").addKeys(new NameValue(slaitemid, UUID.class)), Optional.empty());
    }

    public SlaitemCollectionRequest slaitembase_workflowid() {
        return new SlaitemCollectionRequest(contextPath.addSegment("slaitembase_workflowid"), Optional.empty());
    }

    public TranslationprocessRequest workflow_translationprocess(UUID businessprocessflowinstanceid) {
        return new TranslationprocessRequest(contextPath.addSegment("workflow_translationprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public TranslationprocessCollectionRequest workflow_translationprocess() {
        return new TranslationprocessCollectionRequest(contextPath.addSegment("workflow_translationprocess"), Optional.empty());
    }

    public ProcesstriggerRequest process_processtrigger(UUID processtriggerid) {
        return new ProcesstriggerRequest(contextPath.addSegment("process_processtrigger").addKeys(new NameValue(processtriggerid, UUID.class)), Optional.empty());
    }

    public ProcesstriggerCollectionRequest process_processtrigger() {
        return new ProcesstriggerCollectionRequest(contextPath.addSegment("process_processtrigger"), Optional.empty());
    }

    public AnnotationRequest workflow_Annotation(UUID annotationid) {
        return new AnnotationRequest(contextPath.addSegment("Workflow_Annotation").addKeys(new NameValue(annotationid, UUID.class)), Optional.empty());
    }

    public AnnotationCollectionRequest workflow_Annotation() {
        return new AnnotationCollectionRequest(contextPath.addSegment("Workflow_Annotation"), Optional.empty());
    }

    public ProcesssessionRequest lk_processsession_processid(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("lk_processsession_processid").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest lk_processsession_processid() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("lk_processsession_processid"), Optional.empty());
    }

    public ProcessstageRequest process_processstage(UUID processstageid) {
        return new ProcessstageRequest(contextPath.addSegment("process_processstage").addKeys(new NameValue(processstageid, UUID.class)), Optional.empty());
    }

    public ProcessstageCollectionRequest process_processstage() {
        return new ProcessstageCollectionRequest(contextPath.addSegment("process_processstage"), Optional.empty());
    }

    public SyncerrorRequest workflow_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Workflow_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest workflow_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Workflow_SyncErrors"), Optional.empty());
    }

    public NewprocessRequest workflow_newprocess(UUID businessprocessflowinstanceid) {
        return new NewprocessRequest(contextPath.addSegment("workflow_newprocess").addKeys(new NameValue(businessprocessflowinstanceid, UUID.class)), Optional.empty());
    }

    public NewprocessCollectionRequest workflow_newprocess() {
        return new NewprocessCollectionRequest(contextPath.addSegment("workflow_newprocess"), Optional.empty());
    }

    public WorkflowRequest workflow_active_workflow(UUID workflowid) {
        return new WorkflowRequest(contextPath.addSegment("workflow_active_workflow").addKeys(new NameValue(workflowid, UUID.class)), Optional.empty());
    }

    public WorkflowCollectionRequest workflow_active_workflow() {
        return new WorkflowCollectionRequest(contextPath.addSegment("workflow_active_workflow"), Optional.empty());
    }

    public FlowsessionRequest regardingobjectid_process(UUID flowsessionid) {
        return new FlowsessionRequest(contextPath.addSegment("regardingobjectid_process").addKeys(new NameValue(flowsessionid, UUID.class)), Optional.empty());
    }

    public FlowsessionCollectionRequest regardingobjectid_process() {
        return new FlowsessionCollectionRequest(contextPath.addSegment("regardingobjectid_process"), Optional.empty());
    }

    public WorkflowbinaryRequest workflow_workflowbinary_Process(UUID workflowbinaryid) {
        return new WorkflowbinaryRequest(contextPath.addSegment("workflow_workflowbinary_Process").addKeys(new NameValue(workflowbinaryid, UUID.class)), Optional.empty());
    }

    public WorkflowbinaryCollectionRequest workflow_workflowbinary_Process() {
        return new WorkflowbinaryCollectionRequest(contextPath.addSegment("workflow_workflowbinary_Process"), Optional.empty());
    }

    public Msdyn_aimodelRequest msdyn_retrainworkflow_msdyn_toaimodel(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_retrainworkflow_msdyn_toaimodel").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest msdyn_retrainworkflow_msdyn_toaimodel() {
        return new Msdyn_aimodelCollectionRequest(contextPath.addSegment("msdyn_retrainworkflow_msdyn_toaimodel"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest msdyn_workflow_msdyn_solutionhealthrule_Workflow(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("msdyn_workflow_msdyn_solutionhealthrule_Workflow").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest msdyn_workflow_msdyn_solutionhealthrule_Workflow() {
        return new Msdyn_solutionhealthruleCollectionRequest(contextPath.addSegment("msdyn_workflow_msdyn_solutionhealthrule_Workflow"), Optional.empty());
    }

    public Msdyn_solutionhealthruleRequest msdyn_workflow_msdyn_solutionhealthrule_resolutionaction(UUID msdyn_solutionhealthruleid) {
        return new Msdyn_solutionhealthruleRequest(contextPath.addSegment("msdyn_workflow_msdyn_solutionhealthrule_resolutionaction").addKeys(new NameValue(msdyn_solutionhealthruleid, UUID.class)), Optional.empty());
    }

    public Msdyn_solutionhealthruleCollectionRequest msdyn_workflow_msdyn_solutionhealthrule_resolutionaction() {
        return new Msdyn_solutionhealthruleCollectionRequest(contextPath.addSegment("msdyn_workflow_msdyn_solutionhealthrule_resolutionaction"), Optional.empty());
    }

    public Msdyn_aimodelRequest msdyn_scheduleinferenceworkflow_msdyn_toaimodel(UUID msdyn_aimodelid) {
        return new Msdyn_aimodelRequest(contextPath.addSegment("msdyn_scheduleinferenceworkflow_msdyn_toaimodel").addKeys(new NameValue(msdyn_aimodelid, UUID.class)), Optional.empty());
    }

    public Msdyn_aimodelCollectionRequest msdyn_scheduleinferenceworkflow_msdyn_toaimodel() {
        return new Msdyn_aimodelCollectionRequest(contextPath.addSegment("msdyn_scheduleinferenceworkflow_msdyn_toaimodel"), Optional.empty());
    }

}
