package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Userquery;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.UserqueryRequest;

public class UserqueryCollectionRequest extends CollectionPageEntityRequest<Userquery, UserqueryRequest>{

    protected ContextPath contextPath;

    public UserqueryCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Userquery.class, cp -> new UserqueryRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public SyncerrorRequest userQuery_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("UserQuery_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest userQuery_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("UserQuery_SyncErrors"), Optional.empty());
    }

    public BulkdeletefailureRequest userQuery_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("UserQuery_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest userQuery_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("UserQuery_BulkDeleteFailures"), Optional.empty());
    }

    public AsyncoperationRequest userQuery_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("UserQuery_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest userQuery_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("UserQuery_AsyncOperations"), Optional.empty());
    }

}
