package microsoft.dynamics.crm.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import java.lang.Object;
import java.util.Optional;
import java.util.UUID;

import microsoft.dynamics.crm.entity.Template;
import microsoft.dynamics.crm.entity.request.ActivitymimeattachmentRequest;
import microsoft.dynamics.crm.entity.request.AsyncoperationRequest;
import microsoft.dynamics.crm.entity.request.BulkdeletefailureRequest;
import microsoft.dynamics.crm.entity.request.EmailRequest;
import microsoft.dynamics.crm.entity.request.OrganizationRequest;
import microsoft.dynamics.crm.entity.request.ProcesssessionRequest;
import microsoft.dynamics.crm.entity.request.SyncerrorRequest;
import microsoft.dynamics.crm.entity.request.TemplateRequest;

public class TemplateCollectionRequest extends CollectionPageEntityRequest<Template, TemplateRequest>{

    protected ContextPath contextPath;

    public TemplateCollectionRequest(ContextPath contextPath, Optional<Object> value) {
        super(contextPath, Template.class, cp -> new TemplateRequest(cp, Optional.empty()), value);
        this.contextPath = contextPath;
    }

    public AsyncoperationRequest template_AsyncOperations(UUID asyncoperationid) {
        return new AsyncoperationRequest(contextPath.addSegment("Template_AsyncOperations").addKeys(new NameValue(asyncoperationid, UUID.class)), Optional.empty());
    }

    public AsyncoperationCollectionRequest template_AsyncOperations() {
        return new AsyncoperationCollectionRequest(contextPath.addSegment("Template_AsyncOperations"), Optional.empty());
    }

    public BulkdeletefailureRequest template_BulkDeleteFailures(UUID bulkdeletefailureid) {
        return new BulkdeletefailureRequest(contextPath.addSegment("Template_BulkDeleteFailures").addKeys(new NameValue(bulkdeletefailureid, UUID.class)), Optional.empty());
    }

    public BulkdeletefailureCollectionRequest template_BulkDeleteFailures() {
        return new BulkdeletefailureCollectionRequest(contextPath.addSegment("Template_BulkDeleteFailures"), Optional.empty());
    }

    public ActivitymimeattachmentRequest template_activity_mime_attachments(UUID activitymimeattachmentid) {
        return new ActivitymimeattachmentRequest(contextPath.addSegment("template_activity_mime_attachments").addKeys(new NameValue(activitymimeattachmentid, UUID.class)), Optional.empty());
    }

    public ActivitymimeattachmentCollectionRequest template_activity_mime_attachments() {
        return new ActivitymimeattachmentCollectionRequest(contextPath.addSegment("template_activity_mime_attachments"), Optional.empty());
    }

    public ProcesssessionRequest template_ProcessSessions(UUID processsessionid) {
        return new ProcesssessionRequest(contextPath.addSegment("Template_ProcessSessions").addKeys(new NameValue(processsessionid, UUID.class)), Optional.empty());
    }

    public ProcesssessionCollectionRequest template_ProcessSessions() {
        return new ProcesssessionCollectionRequest(contextPath.addSegment("Template_ProcessSessions"), Optional.empty());
    }

    public SyncerrorRequest template_SyncErrors(UUID syncerrorid) {
        return new SyncerrorRequest(contextPath.addSegment("Template_SyncErrors").addKeys(new NameValue(syncerrorid, UUID.class)), Optional.empty());
    }

    public SyncerrorCollectionRequest template_SyncErrors() {
        return new SyncerrorCollectionRequest(contextPath.addSegment("Template_SyncErrors"), Optional.empty());
    }

    public OrganizationRequest template_Organization(UUID organizationid) {
        return new OrganizationRequest(contextPath.addSegment("Template_Organization").addKeys(new NameValue(organizationid, UUID.class)), Optional.empty());
    }

    public OrganizationCollectionRequest template_Organization() {
        return new OrganizationCollectionRequest(contextPath.addSegment("Template_Organization"), Optional.empty());
    }

    public EmailRequest email_EmailTemplate(UUID activityid) {
        return new EmailRequest(contextPath.addSegment("Email_EmailTemplate").addKeys(new NameValue(activityid, UUID.class)), Optional.empty());
    }

    public EmailCollectionRequest email_EmailTemplate() {
        return new EmailCollectionRequest(contextPath.addSegment("Email_EmailTemplate"), Optional.empty());
    }

}
